<?php

namespace CleantalkSP\SpbctWP\AdminBannersModule\AdminBanners;

use CleantalkSP\SpbctWP\AdminBannersModule\AdminBannersHandler;
use CleantalkSP\Variables\Get;

class AdminBannerEmptyKey extends AdminBannerAbstract
{
    /**
     * Simple Banner Name, most be unique
     */
    const NAME = 'empty_key';

    /**
     * @var AdminBannersHandler
     */
    private $banners_handler;

    /**
     * Is the current page is a spbc plugin settings page
     *
     * @var bool
     */
    private $is_settings_page;

    /**
     * @param AdminBannersHandler $banners_handler
     *
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function __construct(AdminBannersHandler $banners_handler)
    {
        $this->banners_handler = $banners_handler;
        $this->banner_id = $this->prefix . $this::NAME . '_' . $this->banners_handler->getUserId();
        $this->is_settings_page = Get::getString('page') === 'spbc';
    }

    /**
     * do I need to show a banner?
     *
     * @return bool
     */
    protected function needToShow()
    {
        if (
            empty($this->banners_handler->spbc->api_key) &&
            ! $this->isDismissed()
        ) {
            return true;
        }

        return false;
    }

    /**
     * Print HTML of banner
     */
    protected function display()
    {
        $link = is_network_admin() ? get_site_option('siteurl') . 'wp-admin/' : '';
        $link .= 'options-general.php?page=spbc&spbc_tab=settings_general';
        $msg = __('Please enter the Access Key in Security by CleanTalk plugin to enable security features!', 'security-malware-firewall');
        $is_dismissible_text = $this->is_settings_page ? '' : 'is-dismissible';
        $div_head =  '<div class="spbc-notice error um-admin-notice notice '
            . $is_dismissible_text
            . '" id="'
            . $this->banner_id
            . '" style="position: relative;">';
        echo $div_head;
        ?>
            <h3>
                <?php echo $msg; ?>
            </h3>
            <p style="margin-bottom: 10px;">
                <a href="<?php echo $link; ?>" class="button" target="_blank" id="spbc_button_notice">Settings</a>
            </p>
        <?php
        echo '</div>';
    }
}
