<?php

namespace CleantalkSP\SpbctWP\AdminBannersModule\AdminBanners;

use CleantalkSP\SpbctWP\AdminBannersModule\AdminBannersHandler;
use CleantalkSP\SpbctWP\UsersPassCheckModule\UsersPassCheckHandler;

class AdminBannerPassLeak extends AdminBannerAbstract
{
    /**
     * Hiding time in days
     */
    const HIDING_TIME = 365;

    /**
     * Simple Banner Name, most be unique
     */
    const NAME = 'passleak';

    /**
     * Data for template
     *
     * @var array $template_data
     */
    private $template_data;

    /**
     * @var AdminBannersHandler
     */
    private $banners_handler;

    /**
     * @param AdminBannersHandler $banners_handler
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function __construct(AdminBannersHandler $banners_handler)
    {
        $this->banners_handler = $banners_handler;
        $this->banner_id       = $this->prefix . $this::NAME . '_' . $this->banners_handler->getUserId();

        $user_profile_link = get_edit_user_link($this->banners_handler->getUserId()) . '#password';
        $this->template_data = array(
            'title'                => esc_html__('Security by Cleantalk: your password has been leaked.', 'security-malware-firewall'),
            'subtitle'             => sprintf(
                esc_html__('Please change password in your %s', 'security-malware-firewall'),
                '<a href="' . $user_profile_link . '">' . esc_html__('profile', 'security-malware-firewall') . '</a>'
            ),
        );
    }

    /**
     * do I need to show a banner?
     *
     * @return bool
     */
    protected function needToShow()
    {
        if (
            !$this->isDismissed() &&
            UsersPassCheckHandler::isUserPassLeaked($this->banners_handler->getUserId())
        ) {
            return true;
        }

        return false;
    }

    /**
     * Print HTML of banner
     */
    protected function display()
    {
        $data = $this->template_data;
        ?>
        <div class="spbc-notice error um-admin-notice notice is-dismissible" id="<?php
        echo $this->banner_id; ?>" style="position: relative;">
            <h3>
                <?php echo $data['title']; ?>
            </h3>
            <p style="color: gray;">
                <?php echo $data['subtitle']; ?>
            </p>
        </div>
        <?php
    }
}
