<?php

namespace CleantalkSP\SpbctWP\AdminBannersModule\AdminBanners;

use CleantalkSP\SpbctWP\AdminBannersModule\AdminBannersHandler;
use CleantalkSP\Variables\Get;

class AdminBannerWrongKey extends AdminBannerAbstract
{
    /**
     * Simple Banner Name, most be unique
     */
    const NAME = 'wrong_key';

    /**
     * @var AdminBannersHandler
     */
    private $banners_handler;

    /**
     * Is the current page is a spbc plugin settings page
     *
     * @var bool
     */
    private $is_settings_page;

    /**
     * Is the current page is a spbc plugin settings page and settings tab is settings_general
     *
     * @var bool
     */
    private $is_settings_page_and_settings_tab;

    public function __construct(AdminBannersHandler $banners_handler)
    {
        $this->banners_handler = $banners_handler;
        $this->banner_id = $this->prefix . $this::NAME . '_' . $this->banners_handler->getUserId();
        $this->is_settings_page = Get::getString('page') === 'spbc';
        $this->is_settings_page_and_settings_tab = Get::getString('page') === 'spbc' && Get::getString('spbc_tab') === 'settings_general';
    }

    /**
     * do I need to show a banner?
     *
     * @return bool
     */
    protected function needToShow()
    {
        global $spbc;

        if (
            ! empty($spbc->api_key) &&
            ! $this->banners_handler->spbc->key_is_ok &&
            $this->is_settings_page_and_settings_tab &&
            (! $this->isDismissed() || $this->is_settings_page)
        ) {
            return true;
        }

        return false;
    }

    /**
     * Print HTML of banner
     */
    protected function display()
    {
        $link = is_network_admin() ? get_site_option('siteurl') . 'wp-admin/' : '';
        $link .= 'options-general.php?page=spbc&spbc_tab=settings_general';
        $msg = __('Access key is not valid. Enter into plugin settings in the main site dashboard to get access key.', 'security-malware-firewall');
        $is_dismissible_text = $this->is_settings_page ? '' : 'is-dismissible';
        $div_head =  '<div class="spbc-notice error um-admin-notice notice '
            . $is_dismissible_text
            . '" id="'
            . $this->banner_id
            . '" style="position: relative;">';
        echo $div_head;
        ?>
            <h3>
                <?php echo $msg; ?>
            </h3>
            <p style="margin-bottom: 10px;">
                <a href="<?php echo $link; ?>" class="button" target="_blank" id="spbc_button_notice">Settings</a>
            </p>
        <?php
        echo '</div>';
    }
}
