<?php

namespace CleantalkSP\SpbctWP\DTO;

use CleantalkSP\Templates\DTO;

class ReactDataDTO extends DTO
{
    /**
     * @var array
     * @psalm-suppress PossiblyUnusedProperty
     */
    public $strings = array();
    /**
     * @var array
     * @psalm-suppress PossiblyUnusedProperty
     */
    public $flags = array();
    /**
     * @var array[]
     * @psalm-suppress PossiblyUnusedProperty
     */
    public $objects = array();

    public $prop_containment_types = [
        'strings' => 'string',
        'flags' => 'boolean',
        'objects' => 'array',
    ];

    public function __construct($data)
    {
        $this->obligatory_properties = array('strings', 'flags', 'objects');
        parent::__construct($data);
        foreach ($this->prop_containment_types as $property => $restricted_type) {
            foreach ($this->$property as $key => $value) {
                if (gettype($value) !== $restricted_type) {
                    throw new \Exception(__CLASS__ . ': Property values type mismatch on key ' . $key . ', got ' . gettype($value) . ', expected ' . $restricted_type);
                }
            }
        }
    }

    public static function getDefaultArray()
    {
        return [
            'strings' => [],
            'flags' => [],
            'objects' => []
        ];
    }
}
