<?php

namespace CleantalkSP\SpbctWP\FSWatcher\View;

use CleantalkSP\SpbctWP\DTO\ReactDataDTO;
use CleantalkSP\SpbctWP\FSWatcher\Logger;
use CleantalkSP\SpbctWP\FSWatcher\Controller;
use CleantalkSP\SpbctWP\State;

class View
{
    public static function getReactData($data)
    {
        /**
         * @var State
         */
        global $spbc;
        /*
         * Preparing
         */
        $desc_days = $spbc->key_is_ok ? __('7 days.', 'security-malware-firewall') : __('1 day.', 'security-malware-firewall');
        $storage = Controller::$storage;
        $dates = $storage::getAvailableJournals();

        $feature_state = $spbc->feature_restrictions->getState($spbc, 'fswatcher')->is_active;
        //todo This check is not needed fro now,
        // however any React tabs should has this check to keep on ride
        // if something changed in business logic.
        // So this behaviour and layout of sanitizedReasonOutput needs to be moved to React components.
//        if (false === $feature_state->is_active) {
//            echo $feature_state->sanitizedReasonOutput();
//            echo '</div>';
//            return;
//        }
        /*
         * Filling
         */
        // Strings
        $data['strings']['innerHeader'] = __('File System Watcher', 'security-malware-firewall');
        $data['strings']['commonDescription'] = __('This feature runs filesystem snapshots on selected period and allows
        you to control which of your site files has been changed between selected dates. Snapshots are stored for ' . $desc_days, 'security-malware-firewall');
        $data['strings']['spbcSettingsRootLink'] = $spbc->settings_link;
        $data['strings']['extendedDescriptionPrefix'] = __('Snapshots frequency can be managed in the plugin settings:', 'security-malware-firewall');
        $data['strings']['extendedDescriptionPostfix'] = __('Also, you can run snapshot immediately by clicking the button below and refreshing this page after.', 'security-malware-firewall');
        $data['strings']['createSnapButtonText'] = __('Create File System snapshot', 'security-malware-firewall');
        // todo implode nexxt two
        $data['strings']['snapshotNotReadyText1'] = __('Snapshots were not ready.', 'security-malware-firewall');
        $data['strings']['snapshotNotReadyText2'] = __('Please wait while FS Journal will be ready to work.', 'security-malware-firewall');
        $data['strings']['compareButtonDescription'] =  __('To run comparison select dates which you want to compare and click the "Compare" button.', 'security-malware-firewall');
        $data['strings']['firstDateLabel'] =  __('First date', 'security-malware-firewall');
        $data['strings']['secondDateLabel'] = __('Second date', 'security-malware-firewall');
        $data['strings']['compareButtonText'] = __('Compare', 'security-malware-firewall');
        $data['strings']['columnHeaderPath'] = __('Path', 'security-malware-firewall');
        $data['strings']['columnHeaderEvent'] = __('Event', 'security-malware-firewall');
        $data['strings']['columnHeaderChangeOn'] = __('Changed on date', 'security-malware-firewall');
        $data['strings']['noLogsText'] = __('No logs compared yet.', 'security-malware-firewall');
        //flags
        $data['flags']['snapshotsAreReady'] = static::snapshotsAreReady($dates);
        $data['flags']['featureRestricted'] = $feature_state;
        //objects
        $data['objects']['selectorOptionsDates'] = static::getSelectorDates($dates);

        /*
         * Make DTO
         */
        $dto = new ReactDataDTO($data);

        return $dto->getArray();
    }

    public static function getFSWatcherDescription()
    {
        global $spbc;

        $desc_days = $spbc->key_is_ok ? __('7 days.', 'security-malware-firewall') : __('1 day.', 'security-malware-firewall');

        return __('This feature runs filesystem snapshots on selected period and allows
        you to control which of your site files has been changed between selected dates. Snapshots are stored for ' . $desc_days, 'security-malware-firewall');
    }

    public static function getFSWatcherSnapshotsPeriodDescription()
    {
        return __('Select how often the snapshots will be collected.', 'security-malware-firewall');
    }

    protected static function getSelectorDates($dates)
    {
        $options = [];
        foreach ($dates as $date) {
            $formated_date = date('Y-m-d H:i:s', $date);
            $options[] = [
                'value' => $date,
                'label' => $formated_date
            ];
        }

        return $options;
    }

    private static function snapshotsAreReady($dates)
    {
        return is_array($dates) && count($dates) > 1;
    }
}
