<?php

namespace CleantalkSP\SpbctWP\Scanner\ScannerActions;

use CleantalkSP\SpbctWP\Scanner\Cure;

class BackupsActions
{
    /**
     * tested
     * Restore file from backup handler
     * @param string $id
     * @return array
     */
    public static function restoreFileFromBackup($id)
    {
        global $wpdb;

        if (is_null($id)) {
            return array('error' => esc_html__('Error: File not found.', 'security-malware-firewall'));
        }

        // Getting file path
        $file_path_sql_prepared = $wpdb->prepare(
            'SELECT path '
            . ' FROM ' . SPBC_TBL_SCAN_FILES
            . ' WHERE fast_hash=%s;',
            $id
        );
        $file_path = $wpdb->get_row($file_path_sql_prepared, ARRAY_A);

        if (is_null($file_path)) {
            return array('error' => esc_html__('Error: File path not found.', 'security-malware-firewall'));
        }

        $file_path = $file_path['path'];
        $full_file_path = ABSPATH . ltrim($file_path, '\\');

        // Getting backup path
        $sql_prepared = $wpdb->prepare(
            'SELECT back_path, backup_prev_results_state '
            . ' FROM ' . SPBC_TBL_BACKUPED_FILES
            . ' WHERE real_path="%s"'
            . ' ORDER BY backup_id DESC LIMIT 1;',
            $file_path
        );
        // prepare backup data
        $backup_data = $wpdb->get_results($sql_prepared, ARRAY_A);
        $backup_path = isset($backup_data[0]['back_path']) ? $backup_data[0]['back_path'] : null;
        // prepare previous state of the file
        $backup_prev_results_state = isset($backup_data[0]['backup_prev_results_state']) ? $backup_data[0]['backup_prev_results_state'] : null;
        $backup_prev_results_state = empty($backup_prev_results_state) || json_decode($backup_prev_results_state, true) === false
            ? null
            : json_decode($backup_prev_results_state, true);
        if (
            !isset(
                $backup_prev_results_state['weak_spots'],
                $backup_prev_results_state['checked_heuristic'],
                $backup_prev_results_state['checked_signatures'],
                $backup_prev_results_state['status'],
                $backup_prev_results_state['severity'],
                $backup_prev_results_state['path']
            )
        ) {
            $backup_prev_results_state = null;
        }

        if (is_null($backup_path)) {
            return array('error' => esc_html__('Error: Backup not found.', 'security-malware-firewall'));
        }

        $full_backup_path = ABSPATH . ltrim($backup_path, '/');

        // Trying to replace backup and original file
        $backup_content = @file_get_contents($full_backup_path);

        if ($backup_content === false) {
            $error = error_get_last();
            return array('error' => esc_html__('Error: File not exists or permissions denied: ', 'security-malware-firewall') . $error['message']);
        }

        if (!file_exists($full_file_path)) {
            return array('error' => esc_html__("The file doesn't exist and will be deleted from the log through next scan.", 'security-malware-firewall'));
        }

        $result = file_put_contents($full_file_path, $backup_content);

        if ($result === false) {
            return array('error' => esc_html__('Error: Permissions denied.', 'security-malware-firewall'));
        }

        // Success: remove all data about backup
        $error_msg = array(
            self::deleteBackupFile($full_backup_path),
            self::removeBackupFromDB($file_path),
            Cure::updateCureLog($file_path),
            ScanResultsTableActions::updateScanResults($file_path, $backup_prev_results_state)
        );

        foreach ($error_msg as $value) {
            if (array_key_exists('error', $value)) {
                return $value;
            }
        }

        return array('success' => true);
    }

    /**
     * tested
     * todo Unused??
     * Deleting a backup file
     * @param string $full_backup_path
     * @return array
     * @psalm-suppress PossiblyUnusedMethod
     */
    public static function deleteBackupFile($full_backup_path)
    {
        if ($full_backup_path) {
            if (!unlink($full_backup_path)) {
                return array('error' => esc_html__('Deleting backup error: Permissions denied.', 'security-malware-firewall'));
            }
        } else {
            return array('error' => esc_html__('Deleting backup error: Incorrect backup file path.', 'security-malware-firewall'));
        }
        return array();
    }

    /**
     * tested
     * Deleting a backup from a database
     * @param string $file_path
     * @return array
     */
    public static function removeBackupFromDB($file_path)
    {
        global $wpdb;

        if ($file_path) {
            $sql_prepared = $wpdb->prepare(
                'DELETE FROM ' . SPBC_TBL_BACKUPED_FILES . ' WHERE real_path = %s;',
                $file_path
            );
            if ($wpdb->query($sql_prepared) === false) {
                return array('error' => esc_html__('Deleting backup error: Something is wrong during deleting backup.', 'security-malware-firewall'));
            }
        } else {
            return array('error' => esc_html__('Deleting backup error: Incorrect backup file path for the database query.', 'security-malware-firewall'));
        }

        return array();
    }
}
