<?php

namespace CleantalkSP\SpbctWP\Scanner\ScanningLog;

use CleantalkSP\SpbctWP\DB;

class Repository
{
    public static function write($content)
    {
        return DB::getInstance()->prepare(
            'INSERT INTO '
            . SPBC_TBL_SCAN_RESULTS_LOG
            . ' (timestamp, content) VALUES'
            . ' (%d, %s);',
            array(time(), spbc_wp_kses($content, '<b>'))
        )->execute();
    }

    public static function getAll($limit = 0, $offset = 0)
    {
        global $wpdb;

        $sql = 'SELECT timestamp, content FROM ' . SPBC_TBL_SCAN_RESULTS_LOG . ' ORDER BY timestamp DESC LIMIT %d OFFSET %d;';

        return DB::getInstance()->fetchAll(
            $wpdb->prepare($sql, $limit, $offset)
        );
    }

    public static function clear()
    {
        return DB::getInstance()->execute(
            'TRUNCATE TABLE '
            . SPBC_TBL_SCAN_RESULTS_LOG
        );
    }
}
