<?php

namespace CleantalkSP\SpbctWP;

use CleantalkSP\Variables\Server;

class SupportUser extends \CleantalkSP\Common\SupportUser
{
    protected $cron_task_handler = 'spbc_cron_remove_support_user';

    /**
     * Updates timestamp of last user creation attempt
     */
    protected function setAjaxLastCall()
    {
        global $spbc;
        $spbc->data[static::LAST_CALL_SIGN] = time();
        $spbc->save('data');
    }

    /**
     * Gets timestamp of last user creation attempt
     * @return int Unix timestamp of last call
     */
    protected function getAjaxLastCall()
    {
        global $spbc;

        return isset($spbc->data[static::LAST_CALL_SIGN]) ? (int)$spbc->data[static::LAST_CALL_SIGN] : 0;
    }

    /**
     * Cron job handler for deleting support users
     * Deletes all support users and removes the cron task
     */
    public function performCronDeleteUser()
    {
        parent::performCronDeleteUser();
        Cron::removeTask(static::CRON_TASK_NAME);
    }

    /**
     * Initializes the cron task for deleting support users.
     * @return void
     */
    public function scheduleCronDeleteUser()
    {
        if ( function_exists($this->cron_task_handler) ) {
            Cron::updateTask(
                parent::CRON_TASK_NAME,
                $this->cron_task_handler,
                parent::CRON_PERIOD_USER_DELETION,
                time() + parent::CRON_PERIOD_USER_DELETION
            );
        }
    }
}
