<?php

namespace CleantalkSP\SpbctWP\UsersPassCheckModule;

class UserPassCheckView
{
    const VULNERABLE_CAPABILITIES = array(
        //default wp editor role caps
        'moderate_comments',
        'manage_categories',
        'manage_links',
        'edit_others_posts',
        'edit_pages',
        'edit_others_pages',
        'edit_published_pages',
        'publish_pages',
        'delete_pages',
        'delete_others_pages',
        'delete_published_pages',
        'delete_others_posts',
        'delete_private_posts',
        'edit_private_posts',
        'read_private_posts',
        'delete_private_pages',
        'edit_private_pages',
        'read_private_pages',
        //custom spbc caps
        'manage_options',
        'activate_plugins'
    );

    public static function getRolesSelect()
    {
        global $spbc, $wp_roles;
        $wp_roles   = new \WP_Roles();
        $roles_name = $wp_roles->get_names();

        $select_size = count($roles_name) - 1 < 6 ? count($roles_name) - 1 : 5;
        $is_disabled = ! $spbc->settings['check_pass__enable'] ? ' disabled="disabled"' : '';

        // Generate options for select
        $options_html = '';
        foreach ( $roles_name as $role => $role_name ) {
            $is_role_enabled = self::isRoleEnabled($role, (array)$spbc->settings['check_pass__roles'], $wp_roles);
            $selected_chunk  = $is_role_enabled ? ' selected="selected"' : '';
            $options_html .= sprintf(
                '<option%s value="%s">%s</option>',
                $selected_chunk,
                esc_attr($role),
                esc_html($role_name)
            );
        }

        // Main template
        $template = '
            <div class="spbc_wrapper_field spbc_sub_setting">
                <span class="spbc_settings-field_title spbc_settings-field_title--field">%s</span><br>
                <div style="margin-bottom: 10px" class="spbc_settings_description">%s</div>
                <select multiple="multiple" id="spbc_setting_check_pass__roles" name="spbc_settings[check_pass__roles][]"%s size="%d">%s</select>
            </div>
        ';

        $out = sprintf(
            $template,
            esc_html__(
                'Roles that use checking the user\'s password for information leaks',
                'security-malware-firewall'
            ),
            esc_html__(
                'Hold CTRL button to select multiple roles. Users with unselected roles keep log in to your website in a standard way with their logins and passwords.',
                'security-malware-firewall'
            ),
            $is_disabled,
            $select_size,
            $options_html
        );

        return $out;
    }

    /**
     * @param string $role
     * @param array $spbc_settings_roles
     * @param \WP_Roles $wp_roles
     *
     * @return bool
     */
    private static function isRoleEnabled($role, $spbc_settings_roles, $wp_roles)
    {
        $enabled_roles = !empty($spbc_settings_roles) ? $spbc_settings_roles : array();
        // First run - show roles with capabilities higher than or equal to editor
        if ( empty($enabled_roles) ) {
            // Get roles that have at least one editor-level capability
            foreach ( $wp_roles->roles as $role_slug => $role_data ) {
                foreach ( static::VULNERABLE_CAPABILITIES as $cap ) {
                    if ( isset($role_data['capabilities'][$cap]) && $role_data['capabilities'][$cap] ) {
                        $enabled_roles[] = $role_slug;
                        break;
                    }
                }
            }
        }

        return in_array($role, $enabled_roles);
    }
}
